/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.apiimpl;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerExtApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.SettleStatusDto;
import com.dtyunxi.yundt.cube.center.shop.api.ISellerExtApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerShopStatusReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerToBReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.StatusReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.enums.SellApplyTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerBusinessScopeService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerShopCommonService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerToBService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopService;
import com.dtyunxi.yundt.module.context.api.IContext;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ISellerExtApiImpl
implements ISellerExtApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISellerToBService sellerToBService;
    @Autowired
    private IShopService shopService;
    @Autowired
    private ISellerService sellerService;
    @Autowired
    IContext context;
    @Autowired
    ISellerBusinessScopeService iSellerBusinessScopeService;
    @Resource
    private ISellerShopCommonService sellerShopCommonService;
    @Resource
    private ICustomerExtApi iCustomerExtApi;

    public RestResponse<Void> changeStatus(StatusReqDto reqDto) {
        SellerShopStatusReqDto bizBasicReqDto = new SellerShopStatusReqDto();
        bizBasicReqDto.setId(reqDto.getId());
        bizBasicReqDto.setBusinessId(reqDto.getId());
        bizBasicReqDto.setBusinessType("SELLER");
        bizBasicReqDto.setStatus(reqDto.getStatus());
        this.sellerShopCommonService.changeStatus(bizBasicReqDto);
        return RestResponse.VOID;
    }

    @Transactional
    public RestResponse<Long> addSeller(SellerReqDto sellerReqDto) {
        String activityCode = "" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMdd") + Math.round((Math.random() + 1.0) * 1000.0);
        sellerReqDto.setCode(activityCode);
        sellerReqDto.setOwnerId(sellerReqDto.getOwnerId());
        SettleStatusDto settleStatusDto = new SettleStatusDto();
        Integer applying = 2;
        settleStatusDto.setSettleStatus(applying);
        settleStatusDto.setOrgInfoId(sellerReqDto.getOrganizationId());
        settleStatusDto.setCustomerId(sellerReqDto.getCustomerId());
        this.iCustomerExtApi.updateSettleStatus(settleStatusDto);
        sellerReqDto.setStatus(!StringUtils.isBlank((String)sellerReqDto.getStatus()) ? sellerReqDto.getStatus() : "PENDING");
        sellerReqDto.setType("ENTERPRISE");
        sellerReqDto.setApplyType(SellApplyTypeEnum.ADD.toCode());
        this.logger.info("\u65b0\u589e\u5546\u5bb6\u4fe1\u606f:{}", (Object)JacksonUtil.toJson((Object)sellerReqDto));
        return RestResponse.createLong((Long)this.sellerService.addSeller(sellerReqDto, true));
    }

    @ApiOperation(value="\u4fee\u6539\u5546\u6237", notes="\u4fee\u6539\u5546\u6237 \t\n sellerReqDto:\u4fee\u6539\u5546\u6237\u4fe1\u606f\u5c01\u88c5\u5bf9\u8c61 \t\n needAudit:\u662f\u5426\u9700\u8981\u5ba1\u6838")
    public RestResponse<Void> modifySeller(SellerToBReqDto sellerReqDto) {
        this.sellerToBService.modifySeller(sellerReqDto);
        return RestResponse.VOID;
    }
}

