/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerExtApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.SettleStatusDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.AuditReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.BizBasicReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerBusinessScopeReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerToBReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopAuditQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.AuditRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerAuditListRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopAuditListRespDto;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IAuditToBService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerBusinessScopeService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerToBService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopToBService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.impl.SellerShopCommonServiceImpl;
import com.dtyunxi.yundt.cube.center.shop.dao.das.AuditToBDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.SellerDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.AuditDataEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerBusinessScopeEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuditToBServiceImpl
implements IAuditToBService {
    @Resource
    private IContext context;
    @Resource
    private AuditToBDas auditToBDas;
    @Resource
    private ShopDas shopDas;
    @Resource
    private SellerDas sellerDas;
    @Resource
    private ICustomerExtApi iCustomerExtApi;
    @Resource
    private ISellerToBService sellerToBService;
    @Resource
    private IShopToBService shopToBService;
    @Autowired
    private ISellerBusinessScopeService sellerBusinessScopeService;
    @Autowired
    private SellerShopCommonServiceImpl sellerShopCommonService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;

    @Override
    public PageInfo<SellerAuditListRespDto> querySellerAuditPage(SellerToBQueryReqDto reqDto) {
        RestResponse response = this.customerExtQueryApi.querySubOrgList(null);
        List orgIdList = (List)RestResponseHelper.extractData((RestResponse)response);
        if (CollectionUtils.isNotEmpty((Collection)orgIdList)) {
            reqDto.setOrganizationIdList(orgIdList);
        }
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        reqDto.setTenantId(this.context.tenantId());
        reqDto.setInstanceId(this.context.instanceId());
        List sellerAuditList = this.auditToBDas.selectSellerList(reqDto);
        return new PageInfo(sellerAuditList);
    }

    @Override
    public PageInfo<ShopAuditListRespDto> queryShopAuditPage(ShopAuditQueryReqDto reqDto) {
        RestResponse response = this.customerExtQueryApi.querySubOrgList(null);
        List orgIdList = (List)RestResponseHelper.extractData((RestResponse)response);
        if (CollectionUtils.isNotEmpty((Collection)orgIdList)) {
            reqDto.setOrganizationIdList(orgIdList);
        }
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        reqDto.setTenantId(this.context.tenantId());
        reqDto.setInstanceId(this.context.instanceId());
        List shopAuditList = this.auditToBDas.selectShopList(reqDto);
        return new PageInfo(shopAuditList);
    }

    @Override
    public void removeAudit(BizBasicReqDto reqDto) {
        AuditDataEo auditDataEo = (AuditDataEo)this.auditToBDas.selectByPrimaryKey(reqDto.getId());
        if (auditDataEo == null) {
            return;
        }
        if (!"DRAFT".equals(auditDataEo.getStatus())) {
            throw new BizException("\u975e\u5f85\u63d0\u4ea4\u72b6\u6001\uff0c\u5ba1\u6838\u5355\u636e\u4e0d\u53ef\u5220\u9664\uff01");
        }
        switch (reqDto.getBusinessType()) {
            case "SHOP": {
                this.shopDas.logicDeleteById(reqDto.getBusinessId());
                break;
            }
            case "SELLER": {
                SellerEo sellerEo = (SellerEo)this.sellerDas.selectByPrimaryKey(reqDto.getBusinessId());
                SettleStatusDto settleStatusDto = new SettleStatusDto();
                settleStatusDto.setSettleStatus(Integer.valueOf(1));
                settleStatusDto.setOrgInfoId(sellerEo.getOrganizationId());
                RestResponse voidRestResponse = this.iCustomerExtApi.updateSettleStatus(settleStatusDto);
                RestResponseHelper.extractData((RestResponse)voidRestResponse);
                this.sellerDas.logicDeleteById(reqDto.getBusinessId());
                ShopEo shopEo = new ShopEo();
                shopEo.setSellerId(reqDto.getBusinessId());
                List shopEos = this.shopDas.selectList((BaseEo)shopEo);
                if (CollectionUtils.isNotEmpty((Collection)shopEos)) {
                    shopEos.forEach(shopEo1 -> {
                        this.shopDas.logicDeleteById(shopEo1.getId());
                        AuditDataEo shopAuditDataEo = new AuditDataEo();
                        shopAuditDataEo.setBusinessId(shopEo1.getId());
                        shopAuditDataEo.setBusinessType("SHOP");
                        this.auditToBDas.deleteByExample((BaseEo)shopAuditDataEo);
                    });
                }
                this.auditToBDas.logicDeleteById(reqDto.getId());
                break;
            }
        }
        this.auditToBDas.logicDeleteById(reqDto.getId());
    }

    @Override
    @Transactional
    public void audit(AuditReqDto reqDto) {
        AuditDataEo auditDataEo = (AuditDataEo)this.auditToBDas.selectByPrimaryKey(reqDto.getId());
        if (auditDataEo == null) {
            return;
        }
        if ("REFUSE".equals(reqDto.getStatus())) {
            auditDataEo.setStatus(reqDto.getStatus());
            auditDataEo.setResult(reqDto.getResult());
            auditDataEo.setAuditPerson(this.context.userName());
            auditDataEo.setAuditTime(new Date());
            this.auditToBDas.updateSelective((BaseEo)auditDataEo);
            switch (reqDto.getBusinessType()) {
                case "SHOP": {
                    break;
                }
                case "SELLER": {
                    SellerEo sellerEo = (SellerEo)this.sellerDas.selectByPrimaryKey(auditDataEo.getBusinessId());
                    if (sellerEo == null) break;
                    sellerEo.setStatus("BANNED");
                    sellerEo.setUpdateTime(new Date());
                    sellerEo.setUpdatePerson(this.context.userName());
                    this.sellerDas.updateSelective((BaseEo)sellerEo);
                    break;
                }
            }
        } else if ("PASS".equals(reqDto.getStatus())) {
            auditDataEo.setStatus(reqDto.getStatus());
            auditDataEo.setResult(reqDto.getResult());
            auditDataEo.setAuditPerson(this.context.userName());
            auditDataEo.setAuditTime(new Date());
            this.auditToBDas.updateSelective((BaseEo)auditDataEo);
            switch (reqDto.getBusinessType()) {
                case "SHOP": {
                    ShopToBDto shopToBDto = (ShopToBDto)JSON.parseObject((String)auditDataEo.getData(), ShopToBDto.class);
                    AuditDataEo selleAuditCondition = new AuditDataEo();
                    selleAuditCondition.setBusinessType("SELLER");
                    selleAuditCondition.setBusinessId(shopToBDto.getSellerId());
                    selleAuditCondition.setStatus("PASS");
                    List selleAuditList = this.auditToBDas.selectList((BaseEo)selleAuditCondition);
                    if (selleAuditList == null || selleAuditList.size() == 0) {
                        throw new BizException("\u8be5\u5546\u5bb6\u8fd8\u672a\u5ba1\u6838\u901a\u8fc7\uff0c\u8bf7\u5148\u5ba1\u6838\u901a\u8fc7\u5546\u5bb6\u4fe1\u606f");
                    }
                    SellerEo sellerStatusCondition = new SellerEo();
                    sellerStatusCondition.setId(shopToBDto.getSellerId());
                    sellerStatusCondition.setStatus("NORMAL");
                    List sellerStatusList = this.sellerDas.select((BaseEo)sellerStatusCondition);
                    if (sellerStatusList == null || sellerStatusList.size() == 0) {
                        throw new BizException("\u8be5\u5546\u5bb6\u6682\u672a\u542f\u7528\uff0c\u8bf7\u5148\u5f00\u542f\u5546\u5bb6");
                    }
                    shopToBDto.setStatus("NORMAL");
                    shopToBDto.setNeedAudit(false);
                    shopToBDto.setId(reqDto.getBusinessId());
                    this.sellerShopCommonService.updateShop(shopToBDto);
                    break;
                }
                case "SELLER": {
                    SellerToBReqDto sellerToBReqDto = (SellerToBReqDto)JSON.parseObject((String)auditDataEo.getData(), SellerToBReqDto.class);
                    SellerEo sellerEo = (SellerEo)BaseEo.newInstance(SellerEo.class, (Map)sellerToBReqDto.getExtFields());
                    DtoHelper.dto2Eo((BaseVo)sellerToBReqDto, (BaseEo)sellerEo);
                    sellerEo.setStatus("NORMAL");
                    sellerEo.setId(reqDto.getBusinessId());
                    this.sellerDas.updateSelective((BaseEo)sellerEo);
                    if (CollectionUtils.isNotEmpty((Collection)sellerToBReqDto.getSellerBusinessScopeReqDtoList())) {
                        List sellerBusinessScopeDtoList = sellerToBReqDto.getSellerBusinessScopeReqDtoList();
                        SellerBusinessScopeEo sellerBusinessScopeEo = (SellerBusinessScopeEo)BaseEo.newInstance(SellerBusinessScopeEo.class);
                        for (SellerBusinessScopeReqDto sellerBusinessScopeReqDto : sellerBusinessScopeDtoList) {
                            DtoHelper.dto2Eo((BaseVo)sellerBusinessScopeReqDto, (BaseEo)sellerBusinessScopeEo);
                            this.sellerBusinessScopeService.modifySellerBusinessScope(sellerBusinessScopeEo);
                        }
                    }
                    SettleStatusDto settleStatusDto = new SettleStatusDto();
                    settleStatusDto.setSettleStatus(Integer.valueOf(3));
                    settleStatusDto.setOrgInfoId(sellerToBReqDto.getOrganizationId());
                    RestResponse voidRestResponse = this.iCustomerExtApi.updateSettleStatus(settleStatusDto);
                    RestResponseHelper.extractData((RestResponse)voidRestResponse);
                    break;
                }
            }
        }
    }

    @Override
    public AuditRespDto<ShopToBDto> getShopAuditDetail(Long id) {
        AuditRespDto auditRespDto = this.auditToBDas.selectRespDtoByPrimaryKey(id);
        if (auditRespDto == null) {
            return null;
        }
        ShopToBDto shopToBDto = (ShopToBDto)JSON.parseObject((String)auditRespDto.getJson(), ShopToBDto.class);
        auditRespDto.setData((Object)shopToBDto);
        return auditRespDto;
    }

    @Override
    public AuditRespDto<SellerToBReqDto> getSellerAuditDetail(Long id) {
        AuditRespDto auditRespDto = this.auditToBDas.selectRespDtoByPrimaryKey(id);
        if (auditRespDto == null) {
            return null;
        }
        SellerToBReqDto sellerToBReqDto = (SellerToBReqDto)JSON.parseObject((String)auditRespDto.getJson(), SellerToBReqDto.class);
        auditRespDto.setData((Object)sellerToBReqDto);
        return auditRespDto;
    }
}

