/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CertificationCountRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaGroupQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerBusinessScopeReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerToBReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.AreaGroupRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerToBListRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.TagRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.enums.SellApplyTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.api.exception.ShopExceptionCode;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IAuditDataService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerBusinessScopeService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerToBService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopToBService;
import com.dtyunxi.yundt.cube.center.shop.dao.das.SellerAreaDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.SellerDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.SellerToBDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.AuditDataEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerBusinessScopeEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerEo;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SellerServiceToBImpl
implements ISellerToBService {
    @Autowired
    private ISellerService iSellerService;
    @Autowired
    ISellerBusinessScopeService sellerBusinessScopeService;
    @Autowired
    IAuditDataService auditDataService;
    @Resource
    private SellerAreaDas sellerAreaDas;
    @Autowired
    IShopToBService ishopToBService;
    @Autowired
    private ISellerService sellerService;
    @Autowired
    IContext iContext;
    @Resource
    private IAreaGroupQueryApi groupQueryApi;
    @Resource
    private SellerDas sellerDas;
    @Resource
    private ShopDas shopDas;
    @Resource
    private IContext context;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private SellerToBDas sellerToBDas;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IShopService iShopService;

    @Override
    public List<AreaGroupRespDto> queryAreaGroupTree(String orgId) {
        ArrayList<String> organizationArea = new ArrayList();
        RestResponse customerResponse = this.customerQueryApi.queryById(Long.valueOf(orgId));
        organizationArea = ((CustomerRespDto)RestResponseHelper.extractData((RestResponse)customerResponse)).getRegionCodeList();
        RestResponse response = this.groupQueryApi.queryForTree();
        List respDtoList = (List)RestResponseHelper.extractData((RestResponse)response);
        ArrayList<AreaGroupRespDto> result = new ArrayList<AreaGroupRespDto>();
        CubeBeanUtils.copyProperties(result, (Object)respDtoList, (String[])new String[0]);
        this.foreachAreaGroup(result, organizationArea);
        return result;
    }

    private void foreachAreaGroup(List<AreaGroupRespDto> result, List<String> organizationArea) {
        result.forEach(areaGroupDto -> {
            if (organizationArea.contains(areaGroupDto.getCode())) {
                TagRespDto tag = new TagRespDto();
                tag.setType("text");
                tag.setValue("\u5ba2");
                areaGroupDto.setTag(tag);
            }
            if (areaGroupDto.getChildren() != null && !areaGroupDto.getChildren().isEmpty()) {
                this.foreachAreaGroup(areaGroupDto.getChildren(), organizationArea);
            }
        });
    }

    @Override
    public PageInfo<SellerToBListRespDto> queryPage(SellerToBQueryReqDto reqDto) {
        List respDtoList;
        RestResponse response = Objects.nonNull(reqDto.getRetailerOrgId()) ? this.customerExtQueryApi.queryUpperOrgIdsByOrgId(reqDto.getRetailerOrgId()) : this.customerExtQueryApi.querySubOrgList(null);
        List orgIdList = (List)RestResponseHelper.extractData((RestResponse)response);
        if (CollectionUtils.isNotEmpty((Collection)orgIdList)) {
            reqDto.setOrganizationIdList(orgIdList);
        }
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        reqDto.setInstanceId(this.context.instanceId());
        reqDto.setTenantId(this.context.tenantId());
        if (reqDto.getCreateTimeStart() != null) {
            reqDto.setCreateTimeStart(DateUtil.getDayBegin((Date)reqDto.getCreateTimeStart()));
        }
        if (reqDto.getCreateTimeEnd() != null) {
            reqDto.setCreateTimeEnd(DateUtil.getDayEnd((Date)reqDto.getCreateTimeEnd()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(respDtoList = this.sellerToBDas.queryPage(reqDto)))) {
            List organizationIds = respDtoList.stream().map(SellerToBListRespDto::getOrganizationId).collect(Collectors.toList());
            CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
            customerSearchReqDto.setListFlag(Boolean.valueOf(true));
            customerSearchReqDto.setChannel(Integer.valueOf(1));
            customerSearchReqDto.setType(Integer.valueOf(3));
            customerSearchReqDto.setMerchantIds(organizationIds);
            customerSearchReqDto.setIfGroupBy(Integer.valueOf(1));
            List certificationCountRespDtos = (List)this.customerExtQueryApi.queryCertificationCountPost(customerSearchReqDto).getData();
            HashMap certificationCountMap = CollectionUtils.isNotEmpty((Collection)certificationCountRespDtos) ? certificationCountRespDtos.stream().collect(Collectors.toMap(e -> e.getMerchantId(), e -> e, (e1, e2) -> e1)) : new HashMap();
            for (SellerToBListRespDto dto : respDtoList) {
                CertificationCountRespDto certificationCountRespDto = (CertificationCountRespDto)certificationCountMap.get(dto.getOrganizationId());
                if (null == certificationCountRespDto) continue;
                dto.setCertificationCount(certificationCountRespDto.getCertificationCount());
                dto.setUnCertificationCount(certificationCountRespDto.getUnCertificationCount());
            }
        }
        return new PageInfo(respDtoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public Long addSeller(SellerToBReqDto sellerDto) {
        SellerEo sellerEo = this.iSellerService.querySellerByOrganizationId(sellerDto.getOrganizationId(), this.iContext.instanceId(), this.iContext.tenantId());
        Assert.isTrue((sellerEo == null ? 1 : 0) != 0, (String)("\u8be5\u673a\u6784\u5df2\u6709\u5546\u5bb6,\u4e0d\u652f\u6301\u91cd\u590d,\u5546\u5bb6\u540d\u79f0:" + sellerEo.getName()), (Object[])new Object[0]);
        this.sellerService.checkSellerName(sellerDto.getName(), sellerDto.getId());
        sellerEo = SellerEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)sellerDto, (BaseEo)sellerEo);
        Assert.isTrue((sellerDto.getOrganizationId() != null ? 1 : 0) != 0, (String)"\u8bf7\u8f93\u5165OrganizationId", (Object[])new Object[0]);
        Assert.isTrue((!StringUtils.isBlank((String)sellerDto.getStatus()) ? 1 : 0) != 0, (String)"\u8bf7\u8f93\u5165Status", (Object[])new Object[0]);
        String activityCode = "" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMdd") + Math.round((Math.random() + 1.0) * 1000.0);
        sellerEo.setCode(activityCode);
        sellerEo.setType("ENTERPRISE");
        sellerEo.setOwnerId(this.iContext.userId());
        Long sellerId = sellerEo.getId();
        sellerEo.setStatus("PENDING");
        this.sellerDas.insert((BaseEo)sellerEo);
        String jsonString = JSONObject.toJSONString((Object)sellerDto);
        AuditDataEo auditDataEo = new AuditDataEo();
        auditDataEo.setBusinessId(sellerId);
        auditDataEo.setData(jsonString);
        auditDataEo.setBusinessType("SELLER");
        auditDataEo.setStatus(sellerDto.getStatus());
        auditDataEo.setInstanceId(sellerEo.getInstanceId());
        auditDataEo.setApplyCode(activityCode);
        auditDataEo.setApplyType(SellApplyTypeEnum.ADD.toCode());
        auditDataEo.setApplyPerson(this.iContext.userName());
        this.auditDataService.saveAuditData(auditDataEo);
        return sellerEo.getId();
    }

    @Override
    public Integer updateState(Long sellerIdm, String state) {
        return this.sellerService.updateState(sellerIdm, state);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public void modifySeller(SellerToBReqDto sellerReqDto) {
        SellerEo sellerEo = (SellerEo)BaseEo.newInstance(SellerEo.class, (Map)sellerReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)sellerReqDto, (BaseEo)sellerEo);
        sellerEo.setId(sellerReqDto.getSellerId());
        this.sellerDas.updateSelective((BaseEo)sellerEo);
        if ("PENDING".equals(sellerReqDto.getStatus())) {
            AuditDataEo auditDataEoForSelect = AuditDataEo.newInstance();
            auditDataEoForSelect.setBusinessType("SELLER");
            auditDataEoForSelect.setBusinessId(sellerReqDto.getSellerId());
            AuditDataEo auditDataEo = this.auditDataService.queryAuditData(auditDataEoForSelect);
            auditDataEo.setStatus("PENDING");
            auditDataEo.setAuditPerson(null);
            auditDataEo.setApplyType(SellApplyTypeEnum.UPDATE.toCode());
            auditDataEo.setAuditTime(null);
            auditDataEo.setResult(null);
            this.auditDataService.modifyAuditData(auditDataEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditSeller(String status, String result, String auditPerson, Long tenantId, Long id) {
        AuditDataEo auditDataEoForSelect = AuditDataEo.newInstance();
        auditDataEoForSelect.setBusinessType("SELLER");
        auditDataEoForSelect.setId(id);
        auditDataEoForSelect.setTenantId(tenantId);
        AuditDataEo auditDataEo = this.auditDataService.queryAuditData(auditDataEoForSelect);
        if (auditDataEo == null) {
            throw new BizException(ShopExceptionCode.AUDITDATA_QUERY_DEFULT.getCode(), ShopExceptionCode.AUDITDATA_QUERY_DEFULT.getMsg());
        }
        auditDataEo.setStatus(status);
        auditDataEo.setAuditPerson(auditPerson);
        auditDataEo.setAuditTime(new Date());
        auditDataEo.setResult(result);
        this.auditDataService.modifyAuditData(auditDataEo);
        SellerEo seller = (SellerEo)this.sellerDas.selectByPrimaryKey(auditDataEo.getBusinessId());
        Assert.notNull((Object)seller, (String)(" \u627e\u4e0d\u5230\u5546\u5bb6id:" + seller), (Object[])new Object[0]);
        seller.setStatus(status);
        if ("PASS".equals(status)) {
            seller.setStatus("NORMAL");
            SellerToBReqDto sellerReqDto = (SellerToBReqDto)JSON.parseObject((String)auditDataEo.getData(), (TypeReference)new TypeReference<SellerToBReqDto>(){}, (Feature[])new Feature[0]);
            List sellerBusinessScopeDtoList = sellerReqDto.getSellerBusinessScopeReqDtoList();
            SellerBusinessScopeEo sellerBusinessScopeEo = (SellerBusinessScopeEo)BaseEo.newInstance(SellerBusinessScopeEo.class);
            for (SellerBusinessScopeReqDto sellerBusinessScopeReqDto : sellerBusinessScopeDtoList) {
                DtoHelper.dto2Eo((BaseVo)sellerBusinessScopeReqDto, (BaseEo)sellerBusinessScopeEo);
                this.sellerBusinessScopeService.modifySellerBusinessScope(sellerBusinessScopeEo);
            }
        }
        this.sellerDas.updateSelective((BaseEo)seller);
    }

    @Override
    public SellerRespDto querySellerByCurrentUser() {
        Long userOrgId = (Long)this.customerExtQueryApi.queryOrgIdByUserId(this.iContext.userId()).getData();
        return this.iShopService.querySellerByOrganizationId(userOrgId);
    }
}

