/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerExtApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.SettleStatusDto;
import com.dtyunxi.yundt.cube.center.shop.api.IShopApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerShopStatusReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopAreaAndRangeReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopBusinessScopeDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBDto;
import com.dtyunxi.yundt.cube.center.shop.api.enums.ShopFreightTypeTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerShopCommonService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerToBService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopService;
import com.dtyunxi.yundt.cube.center.shop.dao.das.AuditToBDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.SellerDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.SellerToBDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopToBDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopWarehouseDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.AuditDataEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopBusinessScopeEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopWarehouseEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SellerShopCommonServiceImpl
implements ISellerShopCommonService {
    @Resource(name="shopApi")
    private IShopApi shopApi;
    @Resource
    private ShopDas shopDas;
    @Resource
    private IShopService shopService;
    @Resource
    private AuditToBDas auditToBDas;
    @Resource
    private ICustomerExtApi iCustomerExtApi;
    @Resource
    private ISellerToBService sellerService;
    @Autowired
    SellerDas sellerDas;
    @Resource
    private ShopWarehouseDas shopWarehouseDas;
    @Resource
    private ShopToBDas shopToBDas;
    @Resource
    private SellerToBDas sellerToBDas;
    @Resource
    private IContext context;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;

    @Override
    public void changeStatus(SellerShopStatusReqDto statusReqDto) {
        switch (statusReqDto.getBusinessType()) {
            case "SHOP": {
                ShopEo shopEo = (ShopEo)this.shopToBDas.selectByPrimaryKey(statusReqDto.getId());
                if (shopEo == null) break;
                shopEo.setStatus(statusReqDto.getStatus());
                shopEo.setUpdateTime(new Date());
                shopEo.setUpdatePerson(this.context.userName());
                this.shopToBDas.updateSelective((BaseEo)shopEo);
                this.shopService.clearShopBaseByShopId(shopEo.getId());
                break;
            }
            case "SELLER": {
                SellerEo sellerEo = (SellerEo)this.sellerToBDas.selectByPrimaryKey(statusReqDto.getId());
                if (sellerEo == null) break;
                sellerEo.setStatus(statusReqDto.getStatus());
                sellerEo.setUpdateTime(new Date());
                sellerEo.setUpdatePerson(this.context.userName());
                this.sellerToBDas.updateSelective((BaseEo)sellerEo);
                if (statusReqDto.getStatus().equals("BANNED")) {
                    SettleStatusDto settleStatusDto = new SettleStatusDto();
                    Integer disable = 4;
                    settleStatusDto.setSettleStatus(disable);
                    settleStatusDto.setOrgInfoId(sellerEo.getOrganizationId());
                    this.iCustomerExtApi.updateSettleStatus(settleStatusDto);
                    break;
                }
                if (!statusReqDto.getStatus().equals("NORMAL")) break;
                SettleStatusDto settleStatusDto = new SettleStatusDto();
                Integer enable = 3;
                settleStatusDto.setSettleStatus(enable);
                settleStatusDto.setOrgInfoId(sellerEo.getOrganizationId());
                this.iCustomerExtApi.updateSettleStatus(settleStatusDto);
                break;
            }
        }
    }

    @Override
    @Transactional
    public Long addShop(ShopToBDto shopToBDto) {
        SellerEo sellerEo = this.getSellerEo(shopToBDto);
        ShopDto shopDto = new ShopDto();
        BeanUtils.copyProperties((Object)shopToBDto, (Object)shopDto);
        shopDto.setCityDelivery(Boolean.valueOf(true));
        shopDto.setShopFreightType(ShopFreightTypeTypeEnum.SHOP_TYPE.getCode());
        if (StringUtils.isBlank((String)shopDto.getOrganizationName()) && shopDto.getOrganizationId() != null) {
            RestResponse response = this.organizationQueryApi.queryOrgAndOrgInfo(shopDto.getOrganizationId());
            OrgAndOrgInfoRespDto orgInfoRespDto = (OrgAndOrgInfoRespDto)RestResponseHelper.extractData((RestResponse)response);
            shopDto.setOrganizationName(orgInfoRespDto.getOrganizationDto().getName());
        }
        shopDto.setType(Long.valueOf(1L));
        Long aLong = this.shopService.addShop(shopDto, true);
        if ("DRAFT".equals(sellerEo.getStatus()) && aLong != null) {
            Integer pending = this.sellerService.updateState(shopToBDto.getSellerId(), "PENDING");
            Assert.isTrue((pending != null ? 1 : 0) != 0, (String)("\u66f4\u65b0\u5546\u5bb6\u72b6\u6001\u5931\u8d25,\u5546\u5bb6Id" + shopToBDto.getSellerId()), (Object[])new Object[0]);
        }
        return aLong;
    }

    private SellerEo getSellerEo(ShopToBDto shopToBDto) {
        Assert.notNull((Object)shopToBDto.getSellerId(), (String)" \u5546\u5bb6id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SellerEo sellerEo = (SellerEo)this.sellerDas.selectByPrimaryKey(shopToBDto.getSellerId());
        Assert.notNull((Object)sellerEo, (String)" \u5546\u5bb6\u627e\u4e0d\u5230", (Object[])new Object[0]);
        List shopEos = this.shopDas.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"seller_id", (Object)shopToBDto.getSellerId())).eq((Object)"dr", (Object)0));
        if (!CollectionUtils.isEmpty((Collection)shopEos) && !"NORMAL".equals(sellerEo.getStatus())) {
            throw new BizException("\u5546\u5bb6\u72b6\u6001\u5f02\u5e38,\u4e0d\u5141\u8bb8\u6dfb\u52a0\u95e8\u5e97");
        }
        return sellerEo;
    }

    @Override
    @Transactional
    public Long updateShop(ShopToBDto shopToBDto) {
        ShopDto shopDto = new ShopDto();
        BeanUtils.copyProperties((Object)shopToBDto, (Object)shopDto);
        shopDto.setCityDelivery(Boolean.valueOf(true));
        shopDto.setShopFreightType(ShopFreightTypeTypeEnum.SHOP_TYPE.getCode());
        this.shopService.modifyShop(shopDto, shopToBDto.getId(), shopToBDto.getNeedAudit());
        if (!CollectionUtils.isEmpty((Collection)shopToBDto.getShopWarehouseIds())) {
            this.shopWarehouseDas.getMapper().delete((Wrapper)new QueryWrapper().eq((Object)"shop_id", (Object)shopToBDto.getId()));
            for (Long aLong1 : shopToBDto.getShopWarehouseIds()) {
                ShopWarehouseEo shopWarehouseEo = new ShopWarehouseEo();
                shopWarehouseEo.setShopId(shopToBDto.getId());
                shopWarehouseEo.setWarehouseId(aLong1);
                this.shopWarehouseDas.insert((BaseEo)shopWarehouseEo);
            }
        }
        return shopToBDto.getId();
    }

    @Override
    @Transactional
    public Long addShopBusinessScope(ShopAreaAndRangeReqDto shopAreaAndRange) {
        AuditDataEo auditDataEoSell;
        ShopEo shopEo = (ShopEo)this.shopDas.getMapper().selectById((Serializable)shopAreaAndRange.getShopId());
        Assert.notNull((Object)shopEo, (String)" \u95e8\u5e97", (Object[])new Object[0]);
        this.shopService.removeShopBusinessScopeById(shopAreaAndRange.getShopId(), null);
        for (ShopBusinessScopeDto shopBusinessScopeDto : shopAreaAndRange.getShopBusinessScopeDtos()) {
            ShopBusinessScopeEo shopBusinessScopeEo = (ShopBusinessScopeEo)BaseEo.newInstance(ShopBusinessScopeEo.class, (Map)shopBusinessScopeDto.getExtFields());
            DtoHelper.dto2Eo((BaseVo)shopBusinessScopeDto, (BaseEo)shopBusinessScopeEo);
            shopBusinessScopeEo.setShopId(shopAreaAndRange.getShopId());
            this.shopService.addShopBusinessScope(shopBusinessScopeEo);
        }
        AuditDataEo auditDataEo = (AuditDataEo)this.auditToBDas.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"business_type", (Object)"SHOP")).eq((Object)"business_Id", (Object)shopAreaAndRange.getShopId()));
        if (auditDataEo.getStatus().equals("DRAFT")) {
            auditDataEo.setStatus("PENDING");
            this.auditToBDas.updateSelective((BaseEo)auditDataEo);
        }
        if ((auditDataEoSell = (AuditDataEo)this.auditToBDas.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"business_type", (Object)"SELLER")).eq((Object)"business_Id", (Object)shopAreaAndRange.getSellerId()))) != null && auditDataEoSell.getStatus().equals("DRAFT")) {
            auditDataEoSell.setStatus("PENDING");
            this.auditToBDas.updateSelective((BaseEo)auditDataEoSell);
        }
        if (shopEo != null && shopEo.getStatus().equals("DRAFT")) {
            shopEo.setStatus("PENDING");
            this.shopDas.updateSelective((BaseEo)shopEo);
        }
        return shopAreaAndRange.getShopId();
    }

    @Override
    @Transactional
    public void submit(Long shopId, Long sellerId) {
        AuditDataEo auditDataEoSell;
        ShopEo shopEo = (ShopEo)this.shopDas.getMapper().selectById((Serializable)shopId);
        Assert.notNull((Object)shopEo, (String)" \u95e8\u5e97\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        AuditDataEo auditDataEo = (AuditDataEo)this.auditToBDas.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"business_type", (Object)"SHOP")).eq((Object)"business_Id", (Object)shopId));
        if (auditDataEo.getStatus().equals("DRAFT")) {
            auditDataEo.setStatus("PENDING");
            this.auditToBDas.updateSelective((BaseEo)auditDataEo);
        }
        if (Objects.isNull(sellerId)) {
            sellerId = shopEo.getSellerId();
        }
        if ((auditDataEoSell = (AuditDataEo)this.auditToBDas.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"business_type", (Object)"SELLER")).eq((Object)"business_Id", (Object)sellerId))) != null && auditDataEoSell.getStatus().equals("DRAFT")) {
            auditDataEoSell.setStatus("PENDING");
            this.auditToBDas.updateSelective((BaseEo)auditDataEoSell);
        }
        if (shopEo != null && shopEo.getStatus().equals("DRAFT")) {
            shopEo.setStatus("PENDING");
            this.shopDas.updateSelective((BaseEo)shopEo);
        }
    }
}

