/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.apiimpl.query;

import cn.hutool.core.collection.CollUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopBusinessScopeDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBBaseRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBDropdownRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBListRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopToBService;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;

@Service
public class IShopExtQueryApiImpl
implements IShopExtQueryApi {
    @Resource
    private IShopToBService shopToBService;
    @Resource
    private IShopService shopService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;

    public RestResponse<PageInfo<ShopToBListRespDto>> queryPage(ShopToBQueryReqDto reqDto) {
        RestResponse response;
        List orgIdList;
        List organizationIdList = reqDto.getOrganizationIdList();
        if (CollUtil.isEmpty((Collection)organizationIdList) && CollectionUtils.isNotEmpty((Collection)(orgIdList = (List)RestResponseHelper.extractData((RestResponse)(response = this.customerExtQueryApi.querySubOrgList(null)))))) {
            reqDto.setOrganizationIdList(orgIdList);
        }
        return new RestResponse(this.shopToBService.queryPage(reqDto));
    }

    public RestResponse<PageInfo<ShopToBListRespDto>> queryOnPostPage(ShopToBQueryReqDto reqDto) {
        return this.queryPage(reqDto);
    }

    public RestResponse<PageInfo<ShopToBListRespDto>> queryMyShopPage(ShopToBQueryReqDto reqDto) {
        return new RestResponse(this.shopToBService.queryMyShopPage(reqDto));
    }

    public RestResponse<ShopDto> queryBaseById(Long shopId) {
        return new RestResponse((Object)this.shopService.queryById(shopId.longValue(), new String[]{"ALL"}));
    }

    public RestResponse<List<ShopBusinessScopeDto>> queryShopBusinessScopeByShopId(@PathVariable(value="shopId") Long shopId) {
        return new RestResponse(this.shopToBService.queryShopBusinessScopeByShopId(shopId));
    }

    public RestResponse<List<ShopToBDropdownRespDto>> queryShopDropdown(Long userId) {
        return new RestResponse(this.shopToBService.queryShopDropdown(userId));
    }

    public RestResponse<List<ShopToBDropdownRespDto>> queryShopDropdownBySellerId(Long sellerId) {
        return new RestResponse(this.shopToBService.queryShopDropdownBySellerId(sellerId));
    }

    public RestResponse<List<ShopBaseDto>> queryShopListByUserId(Long userId) {
        return new RestResponse(this.shopToBService.queryShopListByUserId(userId));
    }

    public RestResponse<List<ShopBaseDto>> queryShopListBySellerOrgId(Long sellerOrgId) {
        return new RestResponse(this.shopToBService.queryShopListBySellerOrgId(sellerOrgId));
    }

    public RestResponse<List<ShopBaseDto>> queryShopListBySellerId(Long sellerId) {
        return new RestResponse(this.shopToBService.queryShopListBySellerId(sellerId));
    }

    public RestResponse<List<ShopToBBaseRespDto>> queryBaseByIdList(List<Long> shopIds) {
        return new RestResponse(this.shopToBService.queryBaseByIdList(shopIds));
    }
}

