/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopBusinessScopeDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBItemReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBBaseRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBDropdownRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBItemRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBListRespDto;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopToBService;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopBusinessScopeDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopToBDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopBusinessScopeEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShopServiceToBImpl
implements IShopToBService {
    @Resource
    private ShopToBDas shopToBDas;
    @Resource
    private IContext context;
    @Autowired
    private ISellerService iSellerService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IShopService shopService;
    @Resource
    private ShopBusinessScopeDas shopBusinessScopeDas;

    @Override
    public PageInfo<ShopToBListRespDto> queryPage(ShopToBQueryReqDto reqDto) {
        reqDto.setTenantId(this.context.tenantId());
        reqDto.setInstanceId(this.context.instanceId());
        if (reqDto.getCreateTimeStart() != null) {
            reqDto.setCreateTimeStart(DateUtil.getDayBegin((Date)reqDto.getCreateTimeStart()));
        }
        if (reqDto.getCreateTimeEnd() != null) {
            reqDto.setCreateTimeEnd(DateUtil.getDayEnd((Date)reqDto.getCreateTimeEnd()));
        }
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        List shopList = this.shopToBDas.queryPage(reqDto);
        return new PageInfo(shopList);
    }

    @Override
    public PageInfo<ShopToBListRespDto> queryMyShopPage(ShopToBQueryReqDto reqDto) {
        Long currentUserOrgId = (Long)this.customerExtQueryApi.queryOrgIdByUserId(reqDto.getUserId() == null ? this.context.userId() : reqDto.getUserId()).getData();
        reqDto.setOrganizationId(currentUserOrgId);
        return this.queryPage(reqDto);
    }

    @Override
    @Deprecated
    public ShopToBItemRespDto checkShopSkuScope(ShopToBItemReqDto shopToBItemReqDto) {
        return null;
    }

    @Override
    public List<ShopToBBaseRespDto> queryBaseByIdList(List<Long> shopIds) {
        return this.shopToBDas.queryBaseByIdList(shopIds);
    }

    @Override
    public List<ShopToBDropdownRespDto> queryShopDropdown(Long userId) {
        ArrayList<ShopToBDropdownRespDto> result = new ArrayList<ShopToBDropdownRespDto>();
        Long currentUserOrgId = (Long)this.customerExtQueryApi.queryOrgIdByUserId(userId == null ? this.context.userId() : userId).getData();
        SellerEo sellerEo = this.iSellerService.querySellerByOrganizationId(currentUserOrgId);
        if (sellerEo != null) {
            ShopToBDropdownRespDto dropdownRespDto = new ShopToBDropdownRespDto();
            dropdownRespDto.setKey(sellerEo.getId());
            dropdownRespDto.setLabel("\u5168\u90e8\u5e97\u94fa");
            result.add(dropdownRespDto);
            List<ShopToBDropdownRespDto> list = this.queryShopDropdownBySellerId(sellerEo.getId());
            result.addAll(list);
        }
        return result;
    }

    @Override
    public List<ShopToBDropdownRespDto> queryShopDropdownBySellerId(Long sellerId) {
        if (sellerId == null) {
            Long currentUserOrgId = (Long)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()).getData();
            SellerEo sellerEo = this.iSellerService.querySellerByOrganizationId(currentUserOrgId);
            if (sellerEo == null) {
                return null;
            }
            sellerId = sellerEo.getId();
        }
        return this.shopToBDas.queryShopDropdownBySellerId(sellerId);
    }

    @Override
    public List<ShopBaseDto> queryShopListByUserId(Long userId) {
        Long currentUserOrgId = (Long)this.customerExtQueryApi.queryOrgIdByUserId(userId == null ? this.context.userId() : userId).getData();
        return this.queryShopListBySellerOrgId(currentUserOrgId);
    }

    @Override
    public List<ShopBaseDto> queryShopListBySellerOrgId(Long sellerOrgId) {
        List<ShopBaseDto> result = new ArrayList<ShopBaseDto>();
        SellerEo sellerEo = this.iSellerService.querySellerByOrganizationId(sellerOrgId);
        if (sellerEo != null) {
            result = this.queryShopListBySellerId(sellerEo.getId());
        }
        return result;
    }

    @Override
    public List<ShopBaseDto> queryShopListBySellerId(Long sellerId) {
        ShopQueryDto shopQueryDto = new ShopQueryDto();
        shopQueryDto.setSellerId(sellerId);
        return this.shopService.queryBaseShopList(shopQueryDto);
    }

    @Override
    public List<ShopBusinessScopeDto> queryShopBusinessScopeByShopId(Long shopId) {
        List shopBusinessScopeEos;
        ShopEo shopEo = (ShopEo)this.shopToBDas.getMapper().selectById((Serializable)shopId);
        Assert.notNull((Object)shopEo, (String)"\u627e\u4e0d\u5230\u95e8\u5e97 ", (Object[])new Object[0]);
        Long sellerId = shopEo.getSellerId();
        List shops = this.shopToBDas.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"seller_id", (Object)sellerId));
        List shopIds = shops.stream().map(BaseEo::getId).collect(Collectors.toList());
        List shopIdsNo = shopIds.stream().filter(data -> !data.equals(shopId)).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(shopIdsNo)) {
            shopIdsNo = shopIds;
        }
        ArrayList list = CollectionUtil.isEmpty((Collection)(shopBusinessScopeEos = this.shopBusinessScopeDas.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"shop_id", shopIdsNo)).eq((Object)"dr", (Object)0)))) ? new ArrayList() : (List)shopBusinessScopeEos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ShopBusinessScopeEo>(Comparator.comparing(data -> data.getBusinessId() + ";" + data.getBusinessType()))), ArrayList::new));
        return list.stream().map(data -> {
            ShopBusinessScopeDto newData = new ShopBusinessScopeDto();
            BeanUtils.copyProperties((Object)data, (Object)newData);
            return newData;
        }).collect(Collectors.toList());
    }
}

