/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.svr.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.IShopExtApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopAreaAndRangeReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopBusinessScopeDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBItemReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.StatusReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBBaseRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBDropdownRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBItemRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBListRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e97\u94fa\u4e2d\u5fc3: \u5e97\u94fa\u7ba1\u7406\uff08F2B2b \u6269\u5c55\uff09"})
@RestController
@RequestMapping(value={"/v2/F2B2b/shop"})
public class ShopExtRest
implements IShopExtQueryApi,
IShopExtApi {
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private IShopExtApi shopExtApi;

    public RestResponse<Void> changeStatus(@RequestBody @Valid StatusReqDto reqDto) {
        return this.shopExtApi.changeStatus(reqDto);
    }

    public RestResponse<Long> addShop(@RequestBody ShopToBDto shopDto) {
        return this.shopExtApi.addShop(shopDto);
    }

    public RestResponse<Long> updateShop(@RequestBody ShopToBDto shopDto) {
        return this.shopExtApi.updateShop(shopDto);
    }

    public RestResponse<Long> addShopBusinessScope(ShopAreaAndRangeReqDto shopAreaAndRange) {
        return this.shopExtApi.addShopBusinessScope(shopAreaAndRange);
    }

    public RestResponse<Void> submit(@RequestParam(value="shopId") Long shopId, @RequestParam(name="sellerId", required=false) Long sellerId) {
        return this.shopExtApi.submit(shopId, sellerId);
    }

    public RestResponse<PageInfo<ShopToBListRespDto>> queryPage(@ModelAttribute ShopToBQueryReqDto reqDto) {
        return this.shopExtQueryApi.queryPage(reqDto);
    }

    public RestResponse<PageInfo<ShopToBListRespDto>> queryOnPostPage(@RequestBody ShopToBQueryReqDto reqDto) {
        return this.shopExtQueryApi.queryOnPostPage(reqDto);
    }

    public RestResponse<PageInfo<ShopToBListRespDto>> queryMyShopPage(@ModelAttribute ShopToBQueryReqDto reqDto) {
        return this.shopExtQueryApi.queryMyShopPage(reqDto);
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5e97\u94fa\u4fe1\u606f", notes="\u6839\u636eID\u67e5\u8be2\u5e97\u94fa\u57fa\u672c\u4fe1\u606f,\u5176\u4ed6\u5b57\u6bb5\u9700\u8981\u8bf7\u67e5\u770bShopBaseDto{\n    \"collectionTypes\": \"SHOP_RECEIVE\",\n    \"name\": \"\u95e8\u5e97\u540d\u79f0\u5566\u5566\u5566\",\n    \"organizationId\": 1,\n    \"organizationName\": \"\u673a\u6784\u54c8\u54c8\",\n    \"sellerId\": \u5546\u6237ID,\n    \"shopIntroduction\": \"\u7b80\u4ecb\u5566\u5566\u5566\",\n    \"shopWarehouseIds\": \"\u4ed3\u5e93ids\",,\n    \"transportPartnerDtoList\": {\n        \"partnerCode\": \"0\",\n        \"partnerName\": \"\u5546\u5bb6\u81ea\u914d\"\n    }\n}")
    public RestResponse<ShopDto> queryBaseById(Long shopId) {
        return this.shopExtQueryApi.queryBaseById(shopId);
    }

    public RestResponse<List<ShopToBDropdownRespDto>> queryShopDropdown(@RequestParam(name="userId", required=false) Long userId) {
        return this.shopExtQueryApi.queryShopDropdown(userId);
    }

    public RestResponse<List<ShopBusinessScopeDto>> queryShopBusinessScopeByShopId(@PathVariable(value="shopId") Long shopId) {
        return this.shopExtQueryApi.queryShopBusinessScopeByShopId(shopId);
    }

    public RestResponse<List<ShopToBDropdownRespDto>> queryShopDropdownBySellerId(@RequestParam(name="sellerId", required=false) Long sellerId) {
        return this.shopExtQueryApi.queryShopDropdownBySellerId(sellerId);
    }

    public RestResponse<List<ShopBaseDto>> queryShopListByUserId(Long userId) {
        return this.shopExtQueryApi.queryShopListByUserId(userId);
    }

    public RestResponse<List<ShopBaseDto>> queryShopListBySellerOrgId(Long sellerOrgId) {
        return this.shopExtQueryApi.queryShopListBySellerOrgId(sellerOrgId);
    }

    public RestResponse<List<ShopBaseDto>> queryShopListBySellerId(Long sellerId) {
        return this.shopExtQueryApi.queryShopListBySellerId(sellerId);
    }

    public RestResponse<ShopToBItemRespDto> checkShopSkuScope(@RequestBody ShopToBItemReqDto shopToBItemReqDto) {
        return this.shopExtApi.checkShopSkuScope(shopToBItemReqDto);
    }

    public RestResponse<List<ShopToBBaseRespDto>> queryBaseByIdList(@RequestParam(name="shopIdList", required=true) List<Long> shopIds) {
        return this.shopExtQueryApi.queryBaseByIdList(shopIds);
    }
}

