/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.item.biz.base.mq.vo.StorageChangeLogMessageVo;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemStorageService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemBundleRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemStorageDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.StorageChangeLogDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemStorageEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemBundleRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StorageChangeLogEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(tag="ITEM_STORAGE_CHANGE_LOG")
public class StorageChangeLogProcess
implements IMessageProcessor {
    private Logger logger = LoggerFactory.getLogger(StorageChangeLogProcess.class);
    @Resource
    private StorageChangeLogDas storageChangeLogDas;
    @Resource
    private ItemStorageDas itemStorageDas;
    @Resource
    private ShelfDas shelfDas;
    @Resource
    private ItemBundleRelationDas itemBundleRelationDas;
    @Resource
    private IItemStorageService itemStorageService;
    private String done = "done";

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(Object messageObj) {
        try {
            String messageStr = (String)messageObj;
            this.logger.info("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u8bb0\u5f55\u540c\u6b65\u5230\u5546\u54c1\u5e93\u5b58\u8868\u63a5\u6536\u5230me\u6d88\u606f:{}", (Object)messageStr);
            StorageChangeLogMessageVo storageChangeLogMessageVo = (StorageChangeLogMessageVo)JSON.parseObject((String)messageStr, StorageChangeLogMessageVo.class);
            if (storageChangeLogMessageVo == null || CollectionUtils.isEmpty(storageChangeLogMessageVo.getChangeLogIdList())) {
                this.logger.info("\u65e0\u6cd5\u89e3\u6790\u51famq\u6d88\u606f\u5185\u5bb9");
                return MessageResponse.SUCCESS;
            }
            String date = null;
            for (Long changeLogId : storageChangeLogMessageVo.getChangeLogIdList()) {
                StorageChangeLogEo storageChangeLogEo = (StorageChangeLogEo)this.storageChangeLogDas.selectByPrimaryKey(changeLogId);
                date = storageChangeLogMessageVo.getParams().get(changeLogId);
                if (storageChangeLogEo == null) {
                    this.logger.error("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u8bb0\u5f55id:{}\u4e0d\u5b58\u5728", (Object)changeLogId);
                    continue;
                }
                if (storageChangeLogEo.getExtension().indexOf(this.done) > 0) continue;
                ItemStorageEo itemStorageEo = new ItemStorageEo();
                itemStorageEo.setShelfId(storageChangeLogEo.getShelfId());
                itemStorageEo.setItemId(storageChangeLogEo.getItemId());
                itemStorageEo.setSkuId(storageChangeLogEo.getSkuId());
                itemStorageEo.setShopId(storageChangeLogEo.getShopId());
                if (StringUtils.isNotBlank((CharSequence)date)) {
                    ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
                    sqlFilterList.add(SqlFilter.eq((String)"inventory_effective_date", (Object)date));
                    itemStorageEo.setSqlFilters(sqlFilterList);
                }
                Long balance = 0L;
                for (int count = 5; count > 1; --count) {
                    JSONObject jsonObject;
                    if ((itemStorageEo = (ItemStorageEo)this.itemStorageDas.selectOne((BaseEo)itemStorageEo)) == null) {
                        this.logger.error("\u5546\u54c1\u4e2d\u5fc3\u6570\u636e\u95ee\u9898\uff0c\u6263\u51cf\u5e93\u5b58\u65f6\u672a\u68c0\u6d4b\u662f\u5426\u5b58\u5728\u5546\u54c1\u5e93\u5b58\u4fe1\u606f");
                        return MessageResponse.SUCCESS;
                    }
                    ItemStorageEo storageUpdateEo = new ItemStorageEo();
                    storageUpdateEo.setId(itemStorageEo.getId());
                    if (storageChangeLogEo.getAppending() != null) {
                        if (itemStorageEo.getAppending() == null) {
                            itemStorageEo.setAppending(Long.valueOf(0L));
                        }
                        storageUpdateEo.setAppending(Long.valueOf(itemStorageEo.getAppending() + storageChangeLogEo.getAppending()));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)storageChangeLogEo.getExtension()) && (balance = Long.valueOf((jsonObject = JSON.parseObject((String)storageChangeLogEo.getExtension())).getLongValue("balance"))) != null) {
                        if (itemStorageEo.getBalance() == null) {
                            itemStorageEo.setBalance(Long.valueOf(0L));
                        }
                        this.logger.info("\u53d8\u66f4\u5e93\u5b58itemId={},skuId={},storeId={},balance={}", new Object[]{storageChangeLogEo.getSkuId(), storageChangeLogEo.getItemId(), storageUpdateEo.getId(), Long.valueOf(balance.toString())});
                        storageUpdateEo.setBalance(Long.valueOf(itemStorageEo.getBalance() + balance));
                    }
                    ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                    sqlFilters.add(SqlFilter.eq((String)"id", (Object)itemStorageEo.getId()));
                    sqlFilters.add(SqlFilter.eq((String)"balance", (Object)itemStorageEo.getBalance()));
                    sqlFilters.add(SqlFilter.eq((String)"appending", (Object)itemStorageEo.getAppending()));
                    storageUpdateEo.setSqlFilters(sqlFilters);
                    if (this.itemStorageDas.updateSelectiveSqlFilter((BaseEo)storageUpdateEo) <= 1) {
                        continue;
                    }
                    StorageChangeLogEo updateStorageChangeLogEo = new StorageChangeLogEo();
                    updateStorageChangeLogEo.setId(changeLogId);
                    if (StringUtils.isNotEmpty((CharSequence)storageChangeLogEo.getExtension())) {
                        JSONObject map = JSON.parseObject((String)storageChangeLogEo.getExtension());
                        map.put("stage", this.done);
                        updateStorageChangeLogEo.setExtension(JSON.toJSONString((Object)map));
                    } else {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("stage", this.done);
                        updateStorageChangeLogEo.setExtension(JSON.toJSONString(map));
                    }
                    this.storageChangeLogDas.updateSelective((BaseEo)updateStorageChangeLogEo);
                    return MessageResponse.SUCCESS;
                }
                this.updateBundleItemVirStorage(itemStorageEo.getId(), storageChangeLogEo.getShopId(), storageChangeLogEo.getItemId(), storageChangeLogEo.getSkuId(), balance);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return MessageResponse.ERROR;
        }
        return MessageResponse.ERROR;
    }

    public void updateBundleItemVirStorage(Long subItemStorageId, Long shopId, Long itemId, Long skuId, Long balance) {
        this.logger.info("\u66f4\u65b0\u5b50\u5546\u54c1\u5bf9\u5e94\u7ec4\u5408\u5546\u54c1\u7684\u5e93\u5b58: shopId={}, itemId={}, skuId={}", new Object[]{shopId, itemId, skuId});
        try {
            List bundleItemStorageEoList;
            List bundleShelfEoList;
            List itemBundleRelationEoList = this.itemBundleRelationDas.getBundleItemBySubItem(itemId, skuId);
            if (CollectionUtils.isNotEmpty((Collection)itemBundleRelationEoList) && CollectionUtils.isNotEmpty((Collection)(bundleShelfEoList = this.shelfDas.selectByParam((List)Lists.newArrayList((Object[])new Long[]{shopId}), itemBundleRelationEoList.stream().map(StdItemBundleRelationEo::getItemId).distinct().collect(Collectors.toList()), itemBundleRelationEoList.stream().map(StdItemBundleRelationEo::getSkuId).distinct().collect(Collectors.toList()), null))) && CollectionUtils.isNotEmpty((Collection)(bundleItemStorageEoList = this.itemStorageDas.selectByParam((List)Lists.newArrayList((Object[])new Long[]{shopId}), bundleShelfEoList.stream().map(StdShelfEo::getItemId).distinct().collect(Collectors.toList()), bundleShelfEoList.stream().map(StdShelfEo::getSkuId).distinct().collect(Collectors.toList()))))) {
                if (balance < 0L) {
                    ItemStorageEo subItemStorageEo = (ItemStorageEo)this.itemStorageDas.selectByPrimaryKey(subItemStorageId);
                    long subItemBalance = subItemStorageEo.getBalance();
                    Map<String, Long> itemBundleNumMap = itemBundleRelationEoList.stream().filter(eo -> eo.getNum() != null && eo.getNum() > 0).collect(Collectors.toMap(eo -> eo.getItemId() + eo.getSkuId() + "", eo -> subItemBalance / (long)eo.getNum().intValue()));
                    bundleItemStorageEoList.forEach(bundleItemStorageEo -> {
                        Long oldBalance = bundleItemStorageEo.getBalance();
                        Long itemBundleNum = (Long)itemBundleNumMap.get(bundleItemStorageEo.getItemId() + bundleItemStorageEo.getSkuId() + "");
                        if (oldBalance > 0L && itemBundleNum != null && itemBundleNum < oldBalance) {
                            this.logger.info("\u7ec4\u5408\u5546\u54c1\u7684\u5e93\u5b58\u51cf\u5c11: shopId={}, bundleItemId={}, bundleSkuId={}", new Object[]{shopId, bundleItemStorageEo.getItemId(), bundleItemStorageEo.getSkuId()});
                            bundleItemStorageEo.setBalance(itemBundleNum);
                            this.itemStorageDas.updateSelective((BaseEo)bundleItemStorageEo);
                        }
                    });
                } else {
                    bundleItemStorageEoList.forEach(bundleItemStorageEo -> {
                        this.logger.info("\u7ec4\u5408\u5546\u54c1\u7684\u5e93\u5b58\u589e\u52a0: shopId={}, bundleItemId={}, bundleSkuId={}", new Object[]{shopId, bundleItemStorageEo.getItemId(), bundleItemStorageEo.getSkuId()});
                        Long newBalance = this.itemStorageService.getBundleItemSkuStorage(bundleItemStorageEo.getShopId(), bundleItemStorageEo.getSkuId());
                        bundleItemStorageEo.setBalance(newBalance);
                        this.itemStorageDas.updateSelective((BaseEo)bundleItemStorageEo);
                    });
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5b50\u5546\u54c1\u5bf9\u5e94\u7ec4\u5408\u5546\u54c1\u7684\u5e93\u5b58\u65f6\u5931\u8d25: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

