/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBizTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemPriceEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.PropInputTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ShelfTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BranchQueryItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BundleItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirItemRelativeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemAllowOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemAuditReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemDetailReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemDirQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemMediasReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemModifyStatusReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPropGroupDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPropRelationReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPublishReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSearchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSkuReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStatReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageBranchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfTaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.AllowOrderTimeRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BranchItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BundleItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirItemRelativeQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirsItemsRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemAllowOrderDetailQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemAllowOrderQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemAttributesRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailBaseInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDirQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemOnShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPropRelationRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSearchRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuExtRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuListRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRelRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStatRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfIntegralRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfTaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfTaskRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.constants.ItemType;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IBundleItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirItemRelationService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemAttributesService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemAuditService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemCycleBuyService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemMediasService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemPriceService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSearchService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSkuService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemStorageService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemTagService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IPropService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfIntegralService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IUnitService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.BrandDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemAttributesDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemBundleRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPropRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemTagRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfTaskDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.StatDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.doc.ItemDoc;
import com.dtyunxi.yundt.cube.center.item.dao.base.doc.ItemSkuDoc;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ItemSearchVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ItemSkuConditionVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ShelfItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.BrandEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemAttributesEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemBundleRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemPriceEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemPropRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemTagRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfTaskEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StatEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdBrandEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdDirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdDirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemBundleRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemPriceEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="itemService")
public class ItemServiceImpl
implements IItemService {
    private static Logger logger = LoggerFactory.getLogger(ItemServiceImpl.class);
    @Resource
    private ItemDas itemDas;
    @Resource
    private IItemPriceService itemPriceService;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private IItemAttributesService itemAttributesService;
    @Resource
    private IItemMediasService itemMediasService;
    @Resource
    private IBundleItemService bundleItemService;
    @Resource
    private IItemTagService itemTagService;
    @Resource
    private IItemSkuService itemSkuService;
    @Resource
    private ItemAttributesDas itemAttributesDas;
    @Resource
    private ItemMediasDas itemMediasDas;
    @Resource
    private DirDas dirDas;
    @Resource
    private ItemPriceDas itemPriceDas;
    @Resource
    private DirItemRelationDas dirItemRelationDas;
    @Resource
    private ItemBundleRelationDas itemBundleRelationDas;
    @Resource
    private ItemTagRelationDas itemTagRelationDas;
    @Resource
    private ShelfTaskDas shelfTaskDas;
    @Resource
    private IPropService propService;
    @Resource
    private ItemPropRelationDas itemPropRelationDas;
    @Autowired(required=false)
    private IItemSearchService itemSearchService;
    @Resource
    private StatDas statDas;
    @Resource
    private IItemAuditService iItemAuditService;
    @Resource
    private IItemShelfService iItemShelfService;
    @Resource
    private ShelfDas shelfDas;
    @Resource
    private BrandDas brandDas;
    @Resource
    private IItemCycleBuyService itemCycleBuyService;
    @Resource
    private IShelfIntegralService shelfIntegralService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IDirService dirService;
    @Resource
    private IItemStorageService itemStorageService;
    @Resource
    private IShelfService shelfService;
    @Resource
    private IUnitService unitService;
    @Value(value="${item.dir.page.limit:50}")
    private Integer limit;
    @Resource
    private IDirItemRelationService dirItemRelationService;
    public static final String CACHE_ITEM_SHELF_PREFIX = "center_item_shelf";
    public static final String CACHE_ITEM_PRODUCT_DETAIL_PREFIX = "center_item_product_detail";
    @Value(value="${huieryun.searchindexbuilder.item.usrdata:true}")
    private boolean usrData;

    @Override
    public PageInfo<ItemSkuExtRespDto> queryItemLibSkuByPage(ItemReqDto itemReqDto, Integer pageNum, Integer pageSize) {
        ItemSkuConditionVo itemSkuConditionVo = new ItemSkuConditionVo();
        CubeBeanUtils.copyProperties((Object)itemSkuConditionVo, (Object)itemReqDto, (String[])new String[0]);
        itemSkuConditionVo.setItemCode(itemReqDto.getCode());
        itemSkuConditionVo.setItemName(itemReqDto.getName());
        if (null != itemReqDto.getBizType() && ItemBizTypeEnum.ITEM_LIB.getType().equals(itemReqDto.getBizType())) {
            itemSkuConditionVo.setSellerId(Long.valueOf(0L));
        }
        PageInfo itemSkuPageInfo = this.itemSkuDas.queryItemSkuPageByCondition(itemSkuConditionVo, pageNum, pageSize);
        ArrayList itemSkuDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemSkuDtoList, (Collection)itemSkuPageInfo.getList(), ItemSkuExtRespDto.class);
        PageInfo dtoPageInfo = new PageInfo((List)itemSkuDtoList);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)itemSkuPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        HashSet itemIds = Sets.newHashSet();
        HashSet brandIds = Sets.newHashSet();
        HashSet dirIds = Sets.newHashSet();
        HashSet unitIds = Sets.newHashSet();
        ArrayList skuIdList = Lists.newArrayList();
        for (ItemSkuExtRespDto sku : itemSkuDtoList) {
            sku.setId(sku.getSkuId());
            sku.setCode(sku.getSkuCode());
            sku.setSkuDesc(sku.getAttr());
            itemIds.add(sku.getItemId());
            skuIdList.add(sku.getSkuId());
            if (Objects.nonNull(sku.getBrandId())) {
                brandIds.add(sku.getBrandId());
            }
            if (Objects.nonNull(sku.getUnit())) {
                unitIds.add(sku.getUnit());
            }
            dirIds.add(sku.getDirId());
        }
        Map<Long, List<ItemPriceRespDto>> itemSkuPriceMap = this.itemSkuService.getItemSkuPriceMapBySkuIds(skuIdList);
        Map<Long, List<String>> itemImgPathsMap = this.getItemImgPathsMapByItemIds(Lists.newArrayList((Iterable)itemIds));
        Map<Long, String> brandMap = this.getBrandMapByBrandIds(Lists.newArrayList((Iterable)brandIds));
        Map<Long, String> dirMap = this.getDirMapByDirIds(Lists.newArrayList((Iterable)dirIds));
        Map<String, String> unitMap = this.getUnitMapByUnitIds(Lists.newArrayList((Iterable)unitIds));
        for (ItemSkuExtRespDto itemSkuDto : itemSkuDtoList) {
            itemSkuDto.setItemPriceList(itemSkuPriceMap.get(itemSkuDto.getId()));
            BigDecimal itemPrice = this.getItemSkuPrice(itemSkuPriceMap.get(itemSkuDto.getId()));
            itemSkuDto.setItemPrice(itemPrice);
            if (Objects.nonNull(itemSkuDto.getBrandId())) {
                itemSkuDto.setBrandName(brandMap.get(itemSkuDto.getBrandId()));
            }
            if (Objects.nonNull(itemSkuDto.getUnit())) {
                itemSkuDto.setUnitName(unitMap.get(itemSkuDto.getUnit()));
            }
            itemSkuDto.setDirName(dirMap.get(itemSkuDto.getDirId()));
            List<String> imgPathsList = itemImgPathsMap.get(itemSkuDto.getItemId());
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(imgPathsList)) continue;
            itemSkuDto.setImgPath(imgPathsList.get(0));
        }
        return dtoPageInfo;
    }

    private BigDecimal getItemSkuPrice(List<ItemPriceRespDto> itemPriceRespDtos) {
        BigDecimal itemPrice = BigDecimal.ZERO;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemPriceRespDtos)) {
            for (ItemPriceRespDto priceRespDto : itemPriceRespDtos) {
                if (!"RETAIL_PRICE".equalsIgnoreCase(priceRespDto.getPriceType())) continue;
                itemPrice = priceRespDto.getPrice();
                break;
            }
        }
        return itemPrice;
    }

    private Map<String, String> getUnitMapByUnitIds(ArrayList<String> unitIds) {
        List<Long> ids;
        List<UnitRespDto> respDtoList;
        HashedMap unitMap = new HashedMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(unitIds) && org.apache.commons.collections.CollectionUtils.isNotEmpty(respDtoList = this.unitService.queryByIds(ids = unitIds.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e)).map(e -> Long.valueOf(e)).collect(Collectors.toList())))) {
            for (UnitRespDto unitDto : respDtoList) {
                unitMap.put("" + unitDto.getId(), unitDto.getName());
            }
        }
        return unitMap;
    }

    @Override
    public Map<Long, String> getBrandMapByBrandIds(List<Long> brandIds) {
        Object brandMap = new HashedMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(brandIds)) {
            BrandEo brandEo = BrandEo.newInstance();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"id", brandIds));
            brandEo.setSqlFilters(sqlFilterList);
            List brands = this.brandDas.select((BaseEo)brandEo, Integer.valueOf(1), Integer.valueOf(brandIds.size()));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)brands)) {
                brandMap = brands.stream().collect(Collectors.toMap(BaseEo::getId, StdBrandEo::getName));
            }
        }
        return brandMap;
    }

    @Override
    public Map<Long, String> getDirMapByDirIds(List<Long> dirIds) {
        Object dirMap = new HashedMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(dirIds)) {
            DirEo dirEo = DirEo.newInstance();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"id", dirIds));
            dirEo.setSqlFilters(sqlFilterList);
            List dirs = this.dirDas.select((BaseEo)dirEo, Integer.valueOf(1), Integer.valueOf(dirIds.size()));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirs)) {
                dirMap = dirs.stream().collect(Collectors.toMap(BaseEo::getId, StdDirEo::getName));
            }
        }
        return dirMap;
    }

    private Map<Long, List<String>> getItemImgPathsMapByItemIds(List<Long> itemIds) {
        List itemMediasEoList = this.itemMediasDas.selectByItemIds(itemIds);
        HashMap imgPathsMap = Maps.newHashMap();
        for (ItemMediasEo itemMediasEo : itemMediasEoList) {
            List imgPathsList = (List)imgPathsMap.get(itemMediasEo.getItemId());
            imgPathsList = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)imgPathsList) ? Lists.newArrayList() : imgPathsList;
            imgPathsList.add(itemMediasEo.getPath1());
            imgPathsMap.put(itemMediasEo.getItemId(), imgPathsList);
        }
        return imgPathsMap;
    }

    @Override
    public PageInfo<ItemOnShelfRespDto> findItemOnSelf(String filter, Integer pageNum, Integer pageSize) {
        List<Long> dirIdList;
        ItemSearchVo itemSearchVo = (ItemSearchVo)JSONObject.parseObject((String)filter, ItemSearchVo.class);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSearchVo.getDirIds())) {
            dirIdList = this.dirService.getLinkAndChildDirIdList(itemSearchVo.getDirIds(), itemSearchVo.getInstanceId(), itemSearchVo.getTenantId());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(dirIdList)) {
                return null;
            }
            itemSearchVo.setDirIds(dirIdList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSearchVo.getBackDirIds())) {
            dirIdList = this.dirService.getLinkAndChildDirIdList(itemSearchVo.getBackDirIds(), itemSearchVo.getInstanceId(), itemSearchVo.getTenantId());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(dirIdList)) {
                return null;
            }
            itemSearchVo.setBackDirIds(dirIdList);
        }
        List<ItemVo> itemEoList = this.pageItemOnSelf(itemSearchVo);
        ArrayList<ItemOnShelfRespDto> managementBlockRespDtos = new ArrayList<ItemOnShelfRespDto>();
        Set itemIds = itemEoList.stream().map(ItemVo::getItemId).collect(Collectors.toSet());
        List dirItemRelationEos = this.dirItemRelationDas.selectByItemIdsAndDirType((List)Lists.newArrayList(itemIds), "front");
        Map groupDirItemEo = dirItemRelationEos.stream().collect(Collectors.groupingBy(StdDirItemRelationEo::getItemId, Collectors.toList()));
        HashSet allFrontDirIdSet = Sets.newHashSet();
        HashMap<Long, ArrayList> frontDirIdsMap = new HashMap<Long, ArrayList>();
        for (Map.Entry groupDirItemEntry : groupDirItemEo.entrySet()) {
            Long key = groupDirItemEntry.getKey();
            List value = groupDirItemEntry.getValue();
            HashSet frontDirIdSet = Sets.newHashSet();
            for (DirItemRelationEo dirItemRelationEo : value) {
                frontDirIdSet.add(dirItemRelationEo.getDirId());
            }
            allFrontDirIdSet.addAll(frontDirIdSet);
            frontDirIdsMap.put(key, Lists.newArrayList((Iterable)frontDirIdSet));
        }
        List frontDirEos = this.dirDas.selectByIds((List)Lists.newArrayList((Iterable)allFrontDirIdSet));
        Map<Long, String> frontDirNameMap = frontDirEos.stream().collect(Collectors.toMap(BaseEo::getId, StdDirEo::getName, (e1, e2) -> e1));
        List skuIds = itemEoList.stream().filter(bean -> null != bean.getSkuId()).map(ItemVo::getSkuId).collect(Collectors.toList());
        List itemPriceEos = this.itemPriceDas.selectBySkuIds(skuIds);
        Map group = itemPriceEos.stream().collect(Collectors.groupingBy(StdItemPriceEo::getSkuId, Collectors.toList()));
        List collectDirId = itemEoList.stream().filter(bean -> null != bean.getDirId()).map(ItemVo::getDirId).collect(Collectors.toList());
        List dirEos = this.dirDas.selectByIds(collectDirId);
        Map groupDirEo = dirEos.stream().collect(Collectors.groupingBy(BaseEo::getId, Collectors.toList()));
        for (ItemVo itemVo : itemEoList) {
            List frontDirIds;
            ItemOnShelfRespDto newOne = new ItemOnShelfRespDto();
            BeanUtils.copyProperties((Object)itemVo, (Object)newOne);
            newOne.setPath(this.getMainPic(itemVo.getItemId()));
            newOne.setShopId(itemVo.getShopId());
            newOne.setItemSubType(itemVo.getItemSubType());
            managementBlockRespDtos.add(newOne);
            List itemPriceEos1 = group.get(itemVo.getSkuId());
            List selectDirEo = groupDirEo.get(itemVo.getDirId());
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(itemPriceEos1)) {
                Map collect = itemPriceEos1.stream().collect(Collectors.groupingBy(StdItemPriceEo::getPriceType, Collectors.toList()));
                ShelfEo selectItem = new ShelfEo();
                selectItem.setOrderByDesc("updateTime");
                selectItem.setSkuId(itemVo.getSkuId());
                selectItem.setStatus(Integer.valueOf(1));
                selectItem.setShopId(itemSearchVo.getShopId());
                selectItem.setDr(0);
                List shelfEos = this.shelfDas.selectList((BaseEo)selectItem);
                List price = collect.get("PRICE");
                newOne.setRetailPrice(org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shelfEos) ? null : ((ShelfEo)shelfEos.get(0)).getPrice());
                newOne.setSellPrice(org.apache.commons.collections.CollectionUtils.isEmpty(price) ? null : ((ItemPriceEo)price.get(0)).getPrice());
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(selectDirEo)) {
                newOne.setDirName(((DirEo)selectDirEo.get(0)).getName());
            }
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(frontDirIds = (List)frontDirIdsMap.get(itemVo.getItemId())))) continue;
            newOne.setFrontDirIds(frontDirIds);
            ArrayList frontDirNames = Lists.newArrayList();
            for (Long frontDirId : frontDirIds) {
                String frontDirName = frontDirNameMap.get(frontDirId);
                frontDirNames.add(frontDirName);
            }
            newOne.setFrontDirNames((List)frontDirNames);
        }
        PageInfo result = new PageInfo();
        CubeBeanUtils.copyProperties((Object)result, (Object)new PageInfo(itemEoList), (String[])new String[]{"list", "navigatepageNums"});
        result.setList(managementBlockRespDtos);
        return result;
    }

    private String getMainPic(Long itemId) {
        List itemMediasEoList = this.itemMediasDas.selectByItemId(itemId);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemMediasEoList)) {
            return ((ItemMediasEo)itemMediasEoList.get(0)).getPath1();
        }
        return null;
    }

    private List<ItemVo> pageItemOnSelf(ItemSearchVo searchVo) {
        PageHelper.startPage((int)(searchVo.getPageNum() == null ? 1 : searchVo.getPageNum()), (int)(searchVo.getPageSize() == null ? 10 : searchVo.getPageSize()));
        return this.itemDas.pageItemOnSelf(searchVo);
    }

    @Override
    public Long addItem(ItemChangeApplyDto changeApply) {
        ItemEo itemEo;
        if (StringUtils.isNotBlank((CharSequence)changeApply.getItemCode()) && (itemEo = this.itemDas.selectByItemCode(changeApply.getItemCode())) != null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.ITEM_CODE_EXISTS.getCode(), ItemExceptionCode.ITEM_CODE_EXISTS.getMsg());
        }
        this.validSkuCode(changeApply, changeApply.getTenantId());
        itemEo = ItemEo.newInstance();
        Integer type = changeApply.getType();
        this.initItemEo(changeApply, itemEo);
        itemEo.setInstanceId(changeApply.getInstanceId());
        itemEo.setTenantId(changeApply.getTenantId());
        this.dealChangeExtension(changeApply, itemEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)changeApply.getPropGroupDtoList())) {
            itemEo.setPropGroupInfo(JSON.toJSONString((Object)changeApply.getPropGroupDtoList()));
        }
        this.itemDas.insert((BaseEo)itemEo);
        Long itemId = itemEo.getId();
        if (null != itemId) {
            this.addItemAssociateAttr(type, changeApply, itemId, changeApply.getInstanceId(), changeApply.getTenantId());
            this.addItemPropRelation(changeApply, itemId, changeApply.getInstanceId(), changeApply.getTenantId());
        }
        return itemId;
    }

    @Override
    public void audit(ItemAuditReqDto itemAuditReqDto) {
        this.iItemAuditService.saveAuditItem(itemAuditReqDto);
        ItemEo item = (ItemEo)this.itemDas.selectByPrimaryKey(itemAuditReqDto.getItemId());
        if (Objects.isNull(item)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_ITEM.getCode(), ItemExceptionCode.NON_EXIST_ITEM.getMsg());
        }
        ItemEo itemEo = ItemEo.newInstance();
        itemEo.setStatus(itemAuditReqDto.getStatus());
        itemEo.setId(itemAuditReqDto.getItemId());
        itemEo.setName(item.getName());
        itemEo.setDisplayName(item.getDisplayName());
        itemEo.setReturnType(item.getReturnType());
        itemEo.setInstanceId(item.getInstanceId());
        itemEo.setType(item.getType());
        this.itemDas.updateSelective((BaseEo)itemEo);
    }

    @Override
    public Long updateItem(ItemChangeApplyDto changeApply) {
        logger.info("\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)changeApply));
        ItemEo itemEo = ItemEo.newInstance();
        ItemEo exist = (ItemEo)this.itemDas.selectByPrimaryKey(changeApply.getItemId());
        if (null == exist) {
            throw new BizException("\u627e\u4e0d\u5546\u54c1\u4fe1\u606f");
        }
        ItemEo itemByCode = this.itemDas.selectByItemCode(changeApply.getItemCode());
        if (itemByCode != null && itemByCode.getId().longValue() != exist.getId().longValue()) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.ITEM_CODE_EXISTS.getCode(), ItemExceptionCode.ITEM_CODE_EXISTS.getMsg());
        }
        logger.info("ItemEo exist info:{}", (Object)JSON.toJSONString((Object)exist));
        Integer type = changeApply.getType();
        this.initItemEo(changeApply, itemEo);
        itemEo.setInstanceId(changeApply.getInstanceId());
        itemEo.setId(changeApply.getItemId());
        itemEo.setTenantId(changeApply.getTenantId());
        this.dealChangeExtension(changeApply, itemEo);
        List itemPropGroupDtoList = changeApply.getPropGroupDtoList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemPropGroupDtoList)) {
            itemEo.setPropGroupInfo(JSON.toJSONString((Object)itemPropGroupDtoList));
        }
        itemEo.setVersion(Long.valueOf(exist.getVersion() + 1L));
        this.itemDas.updateSelective((BaseEo)itemEo);
        Long itemId = exist.getId();
        this.removeItemAssociateAttr(itemId, type);
        this.addItemAssociateAttr(type, changeApply, itemId, exist.getInstanceId(), exist.getTenantId());
        this.addItemPropRelation(changeApply, itemId, exist.getInstanceId(), exist.getTenantId());
        Map attachments = ServiceContext.getContext().getAttachments();
        CompletableFuture.runAsync(() -> {
            attachments.forEach((k, v) -> ServiceContext.getContext().setAttachment(k, v));
            this.iItemShelfService.updateIndex(itemId);
        });
        return itemId;
    }

    private void dealChangeExtension(ItemChangeApplyDto changeApply, ItemEo itemEo) {
        if (StringUtils.isNotBlank((CharSequence)changeApply.getExtension())) {
            if (StringUtils.isBlank((CharSequence)itemEo.getExtension())) {
                itemEo.setExtension(changeApply.getExtension());
            } else {
                try {
                    JSONObject itemMap = JSON.parseObject((String)itemEo.getExtension());
                    JSONObject versionMap = JSON.parseObject((String)changeApply.getExtension());
                    itemMap.putAll(versionMap);
                    itemEo.setExtension(JSON.toJSONString((Object)itemMap));
                }
                catch (Exception e) {
                    logger.error("\u65b0\u589e\u5546\u54c1\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public ItemEo queryById(Long id) {
        return (ItemEo)this.itemDas.selectByPrimaryKey(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatusBatch(List<Long> itemIds, Integer status) {
        this.itemDas.updateStatusByIds(itemIds, status);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItem(ItemEo itemEo) {
        List list = this.itemDas.select((BaseEo)itemEo);
        for (ItemEo item : list) {
            this.removeItem(item.getId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItem(Long id) {
        ItemEo eo = (ItemEo)this.itemDas.selectByPrimaryKey(id);
        if (null != eo) {
            if (eo.getStatus() == 1) {
                throw new ItemBusinessRuntimeException(id + "\u5bf9\u5e94\u7684\u5546\u54c1\u8bf7\u5148\u4e0b\u67b6");
            }
            if (ItemType.BUNDLE.getIndex().equals(eo.getType())) {
                ItemBundleRelationEo bundleItemEo = ItemBundleRelationEo.newInstance();
                bundleItemEo.setItemId(id);
                this.itemBundleRelationDas.logicDeleteByExample((BaseEo)bundleItemEo);
            }
            ItemMediasEo itemMediasEo = ItemMediasEo.newInstance();
            itemMediasEo.setItemId(id);
            this.itemMediasDas.logicDeleteByExample((BaseEo)itemMediasEo);
            ItemPriceEo priceEo = ItemPriceEo.newInstance();
            priceEo.setItemId(id);
            this.itemPriceDas.logicDeleteByExample((BaseEo)priceEo);
            ItemAttributesEo itemAttributesEo = ItemAttributesEo.newInstance();
            itemAttributesEo.setItemId(id);
            this.itemAttributesDas.logicDeleteByExample((BaseEo)itemAttributesEo);
            ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
            itemSkuEo.setItemId(id);
            this.itemSkuDas.logicDeleteByExample((BaseEo)itemSkuEo);
            this.itemDas.logicDeleteByExample((BaseEo)eo);
            ItemTagRelationEo itemTagEo = new ItemTagRelationEo();
            itemTagEo.setItemId(id);
            this.itemTagRelationDas.logicDeleteByExample((BaseEo)itemTagEo);
            ItemPropRelationEo itemPropRelationEo = ItemPropRelationEo.newInstance();
            itemPropRelationEo.setItemId(id);
            this.itemPropRelationDas.logicDeleteByExample((BaseEo)itemPropRelationEo);
        }
    }

    @Override
    @Transactional
    public void updateItem(ItemEo itemEo) {
        this.itemDas.updateSelective((BaseEo)itemEo);
    }

    @Override
    public void publish(ItemPublishReqDto itemPublishReqDto) {
        if (Objects.isNull(itemPublishReqDto)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
        }
        if (Objects.isNull(itemPublishReqDto.getItemId())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
        }
        ItemEo item = this.queryById(itemPublishReqDto.getItemId());
        if (item == null) {
            return;
        }
        ItemEo itemEo = new ItemEo();
        itemEo.setId(itemPublishReqDto.getItemId());
        if (item.getType().equals(ItemType.GENERAL.getIndex())) {
            itemEo.setStatus(ItemStatus.ITEM_AUDITING.getStatus());
        } else if (item.getType().equals(ItemType.PRODUCT.getIndex())) {
            itemEo.setStatus(ItemStatus.PRODUCT_PUBLISHED.getStatus());
        } else {
            itemEo.setStatus(ItemStatus.ITEM_AUDITING.getStatus());
        }
        this.itemDas.updateSelective((BaseEo)itemEo);
    }

    @Override
    public List<ItemEo> queryItems(ItemEo itemEo) {
        if (itemEo != null) {
            return this.itemDas.select((BaseEo)itemEo);
        }
        return new ArrayList<ItemEo>();
    }

    @Override
    public PageInfo<ItemRespDto> queryByPage(ItemEo itemEo, Integer pageNum, Integer pageSize) {
        PageInfo eoPageInfo = this.itemDas.selectPage((BaseEo)itemEo, pageNum, pageSize);
        ArrayList itemRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), (Collection)itemRespDtoList, ItemRespDto.class);
        PageInfo dtoPageInfo = new PageInfo((List)itemRespDtoList);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList itemIds = Lists.newArrayList();
        for (ItemRespDto item : itemRespDtoList) {
            itemIds.add(item.getId());
        }
        this.setItemSkuByItemIds(itemRespDtoList, itemIds);
        this.setItemMediasByItemIds(itemRespDtoList, itemIds);
        this.setDirsItemsByItemIds(itemRespDtoList, itemIds);
        this.setShelfTasksByItemId(itemRespDtoList, itemIds);
        this.setItemBrandAndDir(itemRespDtoList);
        this.setBackDirList(itemRespDtoList, itemIds);
        return dtoPageInfo;
    }

    private void setBackDirList(List<ItemRespDto> itemRespDtoList, List<Long> itemIds) {
        List<ItemAttributesRespDto> itemAttributesRespDtos = this.itemAttributesService.queryItemAttrByItemIdList(itemIds);
        HashMap<Long, List> dirListMap = new HashMap<Long, List>();
        HashSet dirList = Sets.newHashSet();
        for (ItemAttributesRespDto itemAttributesRespDto : itemAttributesRespDtos) {
            JSONObject jsonObject = JSON.parseObject((String)itemAttributesRespDto.getAttrs());
            JSONArray backDirListJson = jsonObject.getJSONArray("backDirList");
            List backDirList = backDirListJson.toJavaList(Long.class);
            dirListMap.put(itemAttributesRespDto.getItemId(), backDirList);
            dirList.addAll(backDirList);
        }
        Map<Object, Object> dirMap = new HashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirList)) {
            DirEo dirEo = DirEo.newInstance();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"id", (Object)dirList));
            dirEo.setSqlFilters(sqlFilterList);
            List dirs = this.dirDas.select((BaseEo)dirEo, Integer.valueOf(1), Integer.valueOf(dirList.size()));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirs)) {
                dirMap = dirs.stream().collect(Collectors.toMap(BaseEo::getId, StdDirEo::getName));
            }
        }
        for (ItemRespDto itemRespDto : itemRespDtoList) {
            List dirIdList = (List)dirListMap.get(itemRespDto.getId());
            itemRespDto.setDirIdList(dirIdList);
            ArrayList<String> dirNameList = new ArrayList<String>();
            itemRespDto.setDirNameList(dirNameList);
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirIdList)) continue;
            for (Long dirId : dirIdList) {
                String dirName = (String)dirMap.get(dirId);
                dirNameList.add(dirName);
            }
        }
    }

    private void setItemBrandAndDir(List<ItemRespDto> itemRespDtos) {
        ArrayList<SqlFilter> sqlFilterList;
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemRespDtos)) {
            return;
        }
        ArrayList<Long> brandIds = new ArrayList<Long>();
        ArrayList<Long> dirIds = new ArrayList<Long>();
        for (ItemRespDto itemRespDto : itemRespDtos) {
            if (null != itemRespDto.getBrandId()) {
                brandIds.add(itemRespDto.getBrandId());
            }
            if (null == itemRespDto.getDirId()) continue;
            dirIds.add(itemRespDto.getDirId());
        }
        Object brandMap = new HashedMap();
        Object dirMap = new HashedMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(brandIds)) {
            BrandEo brandEo = BrandEo.newInstance();
            sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"id", brandIds));
            brandEo.setSqlFilters(sqlFilterList);
            List brands = this.brandDas.select((BaseEo)brandEo, Integer.valueOf(1), Integer.valueOf(brandIds.size()));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)brands)) {
                brandMap = brands.stream().collect(Collectors.toMap(brand -> brand.getId(), brand -> brand));
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(dirIds)) {
            DirEo dirEo = DirEo.newInstance();
            sqlFilterList = new ArrayList();
            sqlFilterList.add(SqlFilter.in((String)"id", dirIds));
            dirEo.setSqlFilters(sqlFilterList);
            List dirs = this.dirDas.select((BaseEo)dirEo, Integer.valueOf(1), Integer.valueOf(dirIds.size()));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirs)) {
                dirMap = dirs.stream().collect(Collectors.toMap(dir -> dir.getId(), dir -> dir));
            }
        }
        for (ItemRespDto itemRespDto : itemRespDtos) {
            DirEo dir2;
            BrandEo brand2;
            if (null != itemRespDto.getBrandId() && null != (brand2 = (BrandEo)brandMap.get(itemRespDto.getBrandId()))) {
                itemRespDto.setBrand(brand2.getName());
            }
            if (null == itemRespDto.getDirId() || null == (dir2 = (DirEo)dirMap.get(itemRespDto.getDirId()))) continue;
            itemRespDto.setDirName(dir2.getName());
        }
    }

    public void setDirsItemsByItemIds(List<ItemRespDto> itemRespDtoList, List<Long> itemIds) {
        List dirsItemsEoList = this.dirItemRelationDas.selectByItemIds(itemIds);
        ArrayList dirsItemsRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)dirsItemsEoList, (Collection)dirsItemsRespDtoList, DirsItemsRespDto.class);
        HashMap dirsItemsMap = Maps.newHashMap();
        for (DirsItemsRespDto dirsItemsRespDto : dirsItemsRespDtoList) {
            List mapDirsItemsList = (List)dirsItemsMap.get(dirsItemsRespDto.getItemId());
            mapDirsItemsList = org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)mapDirsItemsList) ? mapDirsItemsList : Lists.newArrayList();
            mapDirsItemsList.add(dirsItemsRespDto);
            dirsItemsMap.put(dirsItemsRespDto.getItemId(), mapDirsItemsList);
        }
        for (ItemRespDto itemRespDto : itemRespDtoList) {
            itemRespDto.setDirsItemsList((List)dirsItemsMap.get(itemRespDto.getId()));
        }
    }

    public void setShelfTasksByItemId(List<ItemRespDto> itemRespDtoList, List<Long> itemIds) {
        List shelfTaskEoList = this.shelfTaskDas.selectByItemIds(itemIds);
        ArrayList shelfTaskDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)shelfTaskEoList, (Collection)shelfTaskDtoList, ShelfTaskRespDto.class);
        HashMap shelfTasksMap = Maps.newHashMap();
        for (ShelfTaskRespDto shelfTaskDto : shelfTaskDtoList) {
            List map = (List)shelfTasksMap.get(shelfTaskDto.getItemId());
            map = org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)map) ? map : Lists.newArrayList();
            map.add(shelfTaskDto);
            shelfTasksMap.put(shelfTaskDto.getItemId(), map);
        }
        for (ItemRespDto dto : itemRespDtoList) {
            dto.setShelfTaskRespDtoList((List)shelfTasksMap.get(dto.getId()));
        }
    }

    @Override
    public ItemDetailRespDto queryItemDetail(Long itemId, String field, Long dirId) {
        List shopDirIdList;
        ItemDetailRespDto itemDetailDto = new ItemDetailRespDto();
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemId);
        if (itemEo == null) {
            return itemDetailDto;
        }
        List<ItemPropRelationRespDto> itemPropRelationRespDtos = this.propService.queryByItemId(itemId);
        itemDetailDto.setItemPropRelationRespDtos(itemPropRelationRespDtos);
        String propGroupInfo = itemEo.getPropGroupInfo();
        if (StringUtils.isNotBlank((CharSequence)propGroupInfo)) {
            List propGroupDtoList = JSON.parseArray((String)propGroupInfo, ItemPropGroupDto.class);
            itemDetailDto.setPropGroupDtoList(propGroupDtoList);
        }
        ItemRespDto itemDto = new ItemRespDto();
        DtoHelper.eo2Dto((BaseEo)itemEo, (BaseVo)itemDto);
        if (StringUtils.isBlank((CharSequence)field)) {
            itemDetailDto.setItem(itemDto);
            return itemDetailDto;
        }
        if (field.contains("sku")) {
            this.setItemSkuByItemIds(Lists.newArrayList((Object[])new ItemRespDto[]{itemDto}), Lists.newArrayList((Object[])new Long[]{itemEo.getId()}));
            itemDetailDto.setItemSkuList(itemDto.getItemSkuList());
            itemDto.setItemSkuList(null);
        }
        if (field.contains("attributes")) {
            List<ItemAttributesRespDto> itemAttributesDtoList = this.itemAttributesService.queryByItemId(itemId);
            itemDetailDto.setItemAttributesList(itemAttributesDtoList);
        }
        if (field.contains("medias")) {
            List<ItemMediasRespDto> itemMediasDtoList = this.itemMediasService.queryByItemId(itemId);
            itemDetailDto.setItemMediasList(itemMediasDtoList);
        }
        DirItemRelationEo eo = DirItemRelationEo.newInstance();
        eo.setItemId(itemId);
        if (dirId != null) {
            eo.setOrderBy("id");
            eo.setDirId(dirId);
        }
        List<DirsItemsRespDto> dirsItemsRespDtos = this.dirItemRelationService.queryList(itemId, null);
        itemDetailDto.setDirsItemsList(dirsItemsRespDtos);
        itemDetailDto.setItem(itemDto);
        if (StringUtils.isNotBlank((CharSequence)itemEo.getSaleChannel())) {
            itemDetailDto.setSaleChannels(Arrays.asList(itemEo.getSaleChannel().split("-")));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(shopDirIdList = dirsItemsRespDtos.stream().filter(dirsItemsRespDto -> Objects.equals("shop", dirsItemsRespDto.getDirType())).map(DirsItemsRespDto::getDirId).collect(Collectors.toList()))) {
            DirEo dirEo = DirEo.newInstance();
            dirEo.setId((Long)shopDirIdList.get(0));
            dirEo = (DirEo)this.dirDas.selectOne((BaseEo)dirEo);
            itemDetailDto.setShopDirId(dirEo.getId());
            itemDetailDto.setShopDirName(dirEo.getName());
        }
        return itemDetailDto;
    }

    @Override
    public ItemDoc queryItemDoc(Long id) {
        ItemDoc itemDoc = new ItemDoc();
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(id);
        CubeBeanUtils.copyProperties((Object)itemDoc, (Object)itemEo, (String[])new String[0]);
        ItemAttributesEo attributesEo = ItemAttributesEo.newInstance();
        attributesEo.setItemId(id);
        List attributesEos = this.itemAttributesDas.select((BaseEo)attributesEo);
        itemDoc.setAttributesEos(attributesEos);
        List<ItemSkuDoc> itemSkuDto = this.itemSkuService.queryItemSku(id);
        itemDoc.setItemSkuDtos(itemSkuDto);
        return itemDoc;
    }

    @Override
    public ItemSearchRespDto queryByKeyword(ItemSearchQueryReqDto itemSearchQueryReqDto, Integer pageNum, Integer pageSize) {
        logger.info("\u67e5\u8be2\u5546\u54c1ES\u7684\u8bf7\u6c42\u53c2\u6570: {}", (Object)itemSearchQueryReqDto);
        ItemSearchRespDto itemSearchDto = this.itemSearchService.query(itemSearchQueryReqDto, pageNum, pageSize);
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5546\u54c1ES\u7684\u54cd\u5e94\u7ed3\u679c: {}", (Object)itemSearchDto);
        }
        if (itemSearchQueryReqDto.getSearch().booleanValue()) {
            this.fillAttributeAndDirItem(itemSearchDto);
        }
        return itemSearchDto;
    }

    @Override
    public ItemSearchRespDto queryByKeywordNew(ItemSearchQueryReqDto itemSearchQueryReqDto, Integer pageNum, Integer pageSize) {
        if (this.usrData) {
            if (pageSize > this.limit) {
                pageSize = this.limit;
            }
            return this.queryByKeyword(itemSearchQueryReqDto, pageNum, pageSize);
        }
        return this.searchShelfDataByDb(itemSearchQueryReqDto, pageNum, pageSize);
    }

    private ItemSearchRespDto searchShelfDataByDb(ItemSearchQueryReqDto itemSearchQueryReqDto, Integer pageNum, Integer pageSize) {
        logger.info("\u67e5\u8be2\u6570\u636e\u5e93\u4e2d\u7684\u5546\u54c1\u4e0a\u67b6\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)itemSearchQueryReqDto));
        ItemSearchRespDto itemSearchDto = new ItemSearchRespDto();
        PageInfo pageInfo = this.itemDas.selectByKeyword(itemSearchQueryReqDto.getKeyword(), itemSearchQueryReqDto.getItemType(), itemSearchQueryReqDto.getDirIds(), itemSearchQueryReqDto.getBrandId(), itemSearchQueryReqDto.getItemIds(), null, itemSearchQueryReqDto.getSellerId(), itemSearchQueryReqDto.getShopId(), itemSearchQueryReqDto.getShopIds(), null, null, pageNum, pageSize, itemSearchQueryReqDto.getInstanceId(), itemSearchQueryReqDto.getTenantId(), itemSearchQueryReqDto.getSubType(), itemSearchQueryReqDto.getSubTypeList(), itemSearchQueryReqDto.getBusType(), itemSearchQueryReqDto.getStatus());
        List shelfItemVoList = pageInfo.getList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shelfItemVoList)) {
            return itemSearchDto;
        }
        List<ItemRespDto> itemRespDtoList = this.transferItemRespDto(shelfItemVoList, null);
        Map<Long, List<ItemShelfRespDto>> shelfMap = shelfItemVoList.stream().map(vo -> {
            ItemShelfRespDto itemShelfRespDto = new ItemShelfRespDto();
            itemShelfRespDto.setItemId(vo.getItemId());
            itemShelfRespDto.setSkuId(vo.getSkuId());
            itemShelfRespDto.setShopId(vo.getShopId());
            itemShelfRespDto.setPrice(vo.getPrice());
            itemShelfRespDto.setStatus(vo.getStatus());
            itemShelfRespDto.setSellerId(vo.getSellerId());
            itemShelfRespDto.setBusType(vo.getBusType());
            itemShelfRespDto.setDistribution(vo.getDistribution());
            return itemShelfRespDto;
        }).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(ItemShelfRespDto::getItemId));
        for (ItemRespDto itemRespDto : itemRespDtoList) {
            itemRespDto.setItemShelfInfoList(shelfMap.get(itemRespDto.getItemId()));
            itemRespDto.setShopId(itemSearchQueryReqDto.getShopId());
        }
        PageInfo rePageInfo = itemSearchDto.getPageInfo();
        if (rePageInfo == null || rePageInfo.getList() == null || rePageInfo.getList().size() == 0) {
            logger.debug("\u67e5\u8be2\u4e0b\u67b6\u5546\u54c1\u54cd\u5e94\u7ed3\u679c: {}", (Object)JSON.toJSONString(itemRespDtoList));
            PageInfo itemRespDtoPageInfo = new PageInfo();
            itemRespDtoPageInfo.setTotal((long)itemRespDtoList.size());
            itemRespDtoPageInfo.setList(itemRespDtoList);
            itemSearchDto.setPageInfo(itemRespDtoPageInfo);
        } else {
            rePageInfo.setTotal(rePageInfo.getTotal() + (long)itemRespDtoList.size());
            rePageInfo.getList().addAll(itemRespDtoList);
            itemSearchDto.setPageInfo(rePageInfo);
        }
        logger.debug("\u67e5\u8be2\u5546\u54c1\u54cd\u5e94\u7ed3\u679c: {}", (Object)JSON.toJSONString((Object)itemSearchDto));
        return itemSearchDto;
    }

    public List<ItemRespDto> transferItemRespDto(List<ShelfItemVo> shelfItemVoList, Long sellerId) {
        List<ItemRespDto> itemRespDtoList = shelfItemVoList.stream().map(vo -> {
            ItemRespDto itemRespDto = new ItemRespDto();
            BeanUtils.copyProperties((Object)vo, (Object)itemRespDto);
            itemRespDto.setName(vo.getItemName());
            itemRespDto.setCode(vo.getItemCode());
            return itemRespDto;
        }).collect(Collectors.toList());
        List<Long> itemIdList = shelfItemVoList.stream().map(ShelfItemVo::getItemId).collect(Collectors.toList());
        this.setItemSkuByItemIds(itemRespDtoList, itemIdList);
        this.setItemMediasByItemIds(itemRespDtoList, itemIdList);
        DirItemRelationEo dirItemRelationEo = new DirItemRelationEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        dirItemRelationEo.setSellerId(sellerId);
        sqlFilterList.add(SqlFilter.in((String)"item_id", (Object)StringUtils.join(itemIdList, (String)",")));
        dirItemRelationEo.setSqlFilters(sqlFilterList);
        List dirItemRelationEoList = this.dirItemRelationDas.select((BaseEo)dirItemRelationEo);
        ArrayList dirsItemsList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)dirItemRelationEoList, dirsItemsList, DirsItemsRespDto.class);
        Map<Long, List<DirsItemsRespDto>> group = dirsItemsList.stream().collect(Collectors.groupingBy(DirsItemsRespDto::getItemId));
        itemRespDtoList.forEach(itemRespDto -> {
            if (group.containsKey(itemRespDto.getId())) {
                itemRespDto.setDirsItemsList((List)group.get(itemRespDto.getItemId()));
            }
        });
        return itemRespDtoList;
    }

    @Override
    public List<ItemRespDto> queryItemRespDto(List<ItemEo> itemEoList, Long sellerId) {
        ArrayList<ItemRespDto> itemRespDtoList = new ArrayList<ItemRespDto>();
        DtoHelper.eoList2DtoList(itemEoList, itemRespDtoList, ItemRespDto.class);
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        for (ItemEo itemEo : itemEoList) {
            itemIdList.add(itemEo.getId());
        }
        this.setItemSkuByItemIds(itemRespDtoList, itemIdList);
        this.setItemMediasByItemIds(itemRespDtoList, itemIdList);
        DirItemRelationEo dirItemRelationEo = new DirItemRelationEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        dirItemRelationEo.setSellerId(sellerId);
        sqlFilterList.add(SqlFilter.in((String)"item_id", (Object)StringUtils.join(itemIdList, (String)",")));
        dirItemRelationEo.setSqlFilters(sqlFilterList);
        List dirItemRelationEoList = this.dirItemRelationDas.select((BaseEo)dirItemRelationEo);
        ArrayList dirsItemsList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)dirItemRelationEoList, dirsItemsList, DirsItemsRespDto.class);
        Map<Long, List<DirsItemsRespDto>> group = dirsItemsList.stream().collect(Collectors.groupingBy(DirsItemsRespDto::getItemId));
        itemRespDtoList.forEach(itemRespDto -> {
            if (group.containsKey(itemRespDto.getId())) {
                itemRespDto.setDirsItemsList((List)group.get(itemRespDto.getId()));
                itemRespDto.setShopId(itemRespDto.getShopId());
            }
        });
        return itemRespDtoList;
    }

    @Override
    public void addOrModifyItemSalesCount(ItemStatReqDto itemStatReqDto) {
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemStatReqDto.getItemId());
        if (itemEo == null) {
            throw new BizException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        StatEo statEo = new StatEo();
        statEo.setItemId(itemStatReqDto.getItemId());
        statEo.setInstanceId(itemStatReqDto.getInstanceId());
        statEo.setTenantId(itemStatReqDto.getTenantId());
        StatEo selectEo = (StatEo)this.statDas.selectOne((BaseEo)statEo);
        if (selectEo == null) {
            statEo.setSalesCount(itemStatReqDto.getSalesCount());
            this.statDas.insert((BaseEo)statEo);
        } else {
            Long oldCount = Optional.ofNullable(selectEo.getSalesCount()).orElse(0L);
            Long addCount = Optional.ofNullable(itemStatReqDto.getSalesCount()).orElse(0L);
            statEo = new StatEo();
            statEo.setId(selectEo.getId());
            statEo.setSalesCount(Long.valueOf(oldCount + addCount));
            this.statDas.updateSelective((BaseEo)statEo);
        }
    }

    @Override
    public ItemStatRespDto queryItemSalesCountByItemId(Long itemId, String filter) {
        RequestDto baseReqDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        StatEo statEo = new StatEo();
        statEo.setItemId(itemId);
        if (baseReqDto != null) {
            statEo.setInstanceId(baseReqDto.getInstanceId());
            statEo.setTenantId(baseReqDto.getTenantId());
        }
        statEo = (StatEo)this.statDas.selectOne((BaseEo)statEo);
        ItemStatRespDto itemStatRespDto = new ItemStatRespDto();
        if (statEo == null) {
            return itemStatRespDto;
        }
        DtoHelper.eo2Dto((BaseEo)statEo, (BaseVo)itemStatRespDto);
        return itemStatRespDto;
    }

    private void fillAttributeAndDirItem(ItemSearchRespDto itemSearchRespDto) {
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        if (null == itemSearchRespDto.getPageInfo()) {
            return;
        }
        List itemRespDtoList = itemSearchRespDto.getPageInfo().getList();
        for (ItemRespDto itemRespDto2 : itemRespDtoList) {
            itemIdList.add(itemRespDto2.getId());
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemIdList)) {
            return;
        }
        ItemSkuEo query = ItemSkuEo.newInstance();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.in((String)"item_id", itemIdList));
        query.setSqlFilters(filters);
        List itemSkuEos = this.itemSkuDas.select((BaseEo)query);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSkuEos)) {
            Map<Long, ItemSkuEo> skuEoMap = itemSkuEos.stream().collect(Collectors.toMap(BaseEo::getId, itemSkuEo -> itemSkuEo));
            itemRespDtoList.forEach(itemRespDto -> itemRespDto.getItemSkuList().forEach(itemSkuRespDto -> {
                if (skuEoMap.containsKey(itemSkuRespDto.getId())) {
                    ItemSkuEo skuEo = (ItemSkuEo)skuEoMap.get(itemSkuRespDto.getId());
                    itemSkuRespDto.setAddPriceMax(skuEo.getAddPriceMax());
                    itemSkuRespDto.setAddPriceMin(skuEo.getAddPriceMin());
                    itemSkuRespDto.setAddPriceMode(skuEo.getAddPriceMode());
                    itemSkuRespDto.setAddPriceStatus(skuEo.getAddPriceStatus());
                }
            }));
        }
        List itemAttributesEoList = this.itemAttributesDas.selectByItemIds(itemIdList);
        ArrayList<Long> dirIdList = new ArrayList<Long>();
        HashMap<Long, Long> itemIdDirIdMap = new HashMap<Long, Long>();
        List dirItemRelationEoList = this.dirItemRelationDas.selectByItemIds(itemIdList);
        for (DirItemRelationEo dirItemRelationEo : dirItemRelationEoList) {
            if (dirItemRelationEo.getDirId() == null || dirIdList.contains(dirItemRelationEo.getDirId())) continue;
            dirIdList.add(dirItemRelationEo.getDirId());
            if (!Objects.nonNull(dirItemRelationEo.getShopId())) continue;
            itemIdDirIdMap.put(dirItemRelationEo.getItemId(), dirItemRelationEo.getDirId());
        }
        List dirEoList = this.dirDas.selectByIds(dirIdList);
        ArrayList itemAttributesRespDtoList = new ArrayList();
        ArrayList directoryItemRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)itemAttributesEoList, itemAttributesRespDtoList, ItemAttributesRespDto.class);
        DtoHelper.eoList2DtoList((Collection)dirEoList, directoryItemRespDtoList, DirectoryItemRespDto.class);
        itemSearchRespDto.setAttributesList(itemAttributesRespDtoList);
        itemSearchRespDto.setDirectoryItemList(directoryItemRespDtoList);
        Map<Long, String> dirIdNameMap = null;
        try {
            dirIdNameMap = directoryItemRespDtoList.stream().collect(Collectors.toMap(DirectoryItemRespDto::getId, DirectoryItemRespDto::getName));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (CollectionUtils.isEmpty(dirIdNameMap)) {
            return;
        }
        Map<Long, String> dirIdNameMap2 = dirIdNameMap;
        itemSearchRespDto.getPageInfo().getList().forEach(itemRespDto -> {
            Long dirId;
            if (itemIdDirIdMap.containsKey(itemRespDto.getId()) && Objects.nonNull(dirId = (Long)itemIdDirIdMap.get(itemRespDto.getId()))) {
                itemRespDto.setShopDirId(dirId);
                String shopDirName = (String)dirIdNameMap2.get(dirId);
                itemRespDto.setShopDirName(shopDirName);
            }
        });
    }

    public void setItemMediasByItemIds(List<ItemRespDto> itemDtoList, List<Long> itemIds) {
        List itemMediasEoList = this.itemMediasDas.selectByItemIds(itemIds);
        ArrayList mediasDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemMediasEoList, (Collection)mediasDtoList, ItemMediasRespDto.class);
        Map<Long, List<ItemMediasRespDto>> itemMediasMap = this.getItemMediasMapByItemIds(mediasDtoList);
        for (ItemRespDto itemDto : itemDtoList) {
            itemDto.setItemMediasList(itemMediasMap.get(itemDto.getId()));
        }
    }

    private Map<Long, List<ItemMediasRespDto>> getItemMediasMapByItemIds(List<ItemMediasRespDto> mediasDtoList) {
        HashMap itemMediasMap = Maps.newHashMap();
        for (ItemMediasRespDto itemMediasDto : mediasDtoList) {
            List mapItemMediasList = (List)itemMediasMap.get(itemMediasDto.getItemId());
            mapItemMediasList = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)mapItemMediasList) ? Lists.newArrayList() : mapItemMediasList;
            mapItemMediasList.add(itemMediasDto);
            itemMediasMap.put(itemMediasDto.getItemId(), mapItemMediasList);
        }
        return itemMediasMap;
    }

    public void setItemSkuByItemIds(List<ItemRespDto> itemDtoList, List<Long> itemIds) {
        Map<Long, List<ItemSkuRespDto>> skuMap = this.getItemSkuDtoMap(this.itemSkuService.queryDetailsByItemIds(itemIds));
        for (ItemRespDto itemDto : itemDtoList) {
            itemDto.setItemSkuList(skuMap.get(itemDto.getId()));
        }
    }

    public Map<Long, List<ItemSkuRespDto>> getItemSkuDtoMap(List<ItemSkuRespDto> skuDtoList) {
        return skuDtoList.stream().collect(Collectors.groupingBy(ItemSkuRespDto::getItemId));
    }

    @Override
    public List<ItemEo> queryItemByIds(List<Long> ids) {
        return this.itemDas.selectByIds(ids);
    }

    @Override
    public ItemSkuListRespDto queryItemBySkuId(List<Long> skuIds) {
        ItemSkuListRespDto dto = new ItemSkuListRespDto();
        List<ItemSkuEo> itemSkuEoList = this.getItemSkuRepDtoList(skuIds, dto);
        this.getItemRespDtoList(dto, itemSkuEoList);
        return dto;
    }

    @Override
    public List<ItemRespDto> queryItemStatus(List<Long> itemIdList) {
        List itemEos = this.itemDas.selectByIds(itemIdList);
        ArrayList<ItemEo> itemsInvalidEos = new ArrayList<ItemEo>();
        for (ItemEo eo : itemEos) {
            Integer intStatus = eo.getStatus();
            if (intStatus != 2) continue;
            itemsInvalidEos.add(eo);
        }
        ArrayList<ItemRespDto> itemRespDtoList = new ArrayList<ItemRespDto>();
        DtoHelper.eoList2DtoList(itemsInvalidEos, itemRespDtoList, ItemRespDto.class);
        return itemRespDtoList;
    }

    @Override
    public List<DirItemRelativeQueryRespDto> queryItemDirRelative(DirItemRelativeReqDto dirItemReqDto) {
        List list;
        DirItemRelationEo dirItemRelationEo = DirItemRelationEo.newInstance();
        BeanUtils.copyProperties((Object)dirItemReqDto, (Object)dirItemRelationEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirItemReqDto.getDirIds())) {
            ArrayList sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.in((String)"dirId", (Object)dirItemReqDto.getDirIds()));
            dirItemRelationEo.setSqlFilters((List)sqlFilters);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(list = this.dirItemRelationDas.select((BaseEo)dirItemRelationEo)))) {
            List dirIdList = list.stream().map(StdDirItemRelationEo::getDirId).distinct().collect(Collectors.toList());
            Map<Object, Object> dirMap = Maps.newHashMap();
            List dirEoList = this.dirDas.selectByIds(dirIdList);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirEoList)) {
                dirMap = dirEoList.stream().collect(Collectors.toMap(BaseEo::getId, StdDirEo::getName));
            }
            HashMap finalDirMap = dirMap;
            return list.stream().map(dirItemRelation -> {
                DirItemRelativeQueryRespDto itemDirQueryRespDto = new DirItemRelativeQueryRespDto();
                BeanUtils.copyProperties((Object)dirItemRelation, (Object)itemDirQueryRespDto);
                if (finalDirMap.get(dirItemRelation.getDirId()) != null) {
                    itemDirQueryRespDto.setDirName((String)finalDirMap.get(dirItemRelation.getDirId()));
                }
                return itemDirQueryRespDto;
            }).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<DirItemRelativeQueryRespDto> queryItemDirRelativeBatch(DirItemRelativeReqDto dirItemReqDto) {
        List list;
        DirItemRelationEo dirItemRelationEo = DirItemRelationEo.newInstance();
        BeanUtils.copyProperties((Object)dirItemReqDto, (Object)dirItemRelationEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirItemReqDto.getDirIds())) {
            ArrayList sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.in((String)"dirId", (Object)dirItemReqDto.getDirIds()));
            dirItemRelationEo.setSqlFilters((List)sqlFilters);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(list = this.dirItemRelationDas.select((BaseEo)dirItemRelationEo)))) {
            List dirIdList = list.stream().map(StdDirItemRelationEo::getDirId).distinct().collect(Collectors.toList());
            Map<Object, Object> dirMap = Maps.newHashMap();
            List dirEoList = this.dirDas.selectByIds(dirIdList);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirEoList)) {
                dirMap = dirEoList.stream().collect(Collectors.toMap(BaseEo::getId, StdDirEo::getName));
            }
            HashMap finalDirMap = dirMap;
            return list.stream().map(dirItemRelation -> {
                DirItemRelativeQueryRespDto itemDirQueryRespDto = new DirItemRelativeQueryRespDto();
                BeanUtils.copyProperties((Object)dirItemRelation, (Object)itemDirQueryRespDto);
                if (finalDirMap.get(dirItemRelation.getDirId()) != null) {
                    itemDirQueryRespDto.setDirName((String)finalDirMap.get(dirItemRelation.getDirId()));
                }
                return itemDirQueryRespDto;
            }).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<ItemDirQueryRespDto> queryItemDir(ItemDirQueryReqDto itemDirQueryReqDto) {
        ArrayList<Long> dirIdList;
        if (itemDirQueryReqDto == null || itemDirQueryReqDto.getInstanceId() == null || itemDirQueryReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ArrayList<ItemDirQueryRespDto> list = new ArrayList<ItemDirQueryRespDto>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemDirQueryReqDto.getItemIdList())) {
            return list;
        }
        for (Long itemId : itemDirQueryReqDto.getItemIdList()) {
            ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemId);
            if (itemEo == null || !itemDirQueryReqDto.getInstanceId().equals(itemEo.getInstanceId()) || !itemDirQueryReqDto.getTenantId().equals(itemEo.getTenantId())) continue;
            ItemDirQueryRespDto itemDirQueryRespDto = new ItemDirQueryRespDto();
            itemDirQueryRespDto.setItemId(itemId);
            dirIdList = this.queryParentDataList(itemEo.getDirId());
            itemDirQueryRespDto.setDirList(dirIdList);
            list.add(itemDirQueryRespDto);
        }
        for (ItemDirQueryRespDto itemDirQueryRespDto : list) {
            DirItemRelationEo dirItemRelationEo = new DirItemRelationEo();
            dirItemRelationEo.setItemId(itemDirQueryRespDto.getItemId());
            dirItemRelationEo.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
            dirItemRelationEo.setInstanceId(itemDirQueryReqDto.getInstanceId());
            dirItemRelationEo.setTenantId(itemDirQueryReqDto.getTenantId());
            List dirItemRelationEoList = this.dirItemRelationDas.select((BaseEo)dirItemRelationEo);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dirItemRelationEoList)) continue;
            dirIdList = itemDirQueryRespDto.getDirList();
            if (dirIdList == null) {
                dirIdList = new ArrayList<Long>();
            }
            for (DirItemRelationEo relationEo : dirItemRelationEoList) {
                dirIdList.addAll(this.queryParentDataList(relationEo.getDirId()));
            }
            LinkedHashSet repeat = new LinkedHashSet(dirIdList);
            dirIdList.clear();
            dirIdList.addAll(repeat);
            itemDirQueryRespDto.setDirList(dirIdList);
        }
        return list;
    }

    @Override
    public ItemSearchRespDto queryItemByDirIdDepth(ItemSearchQueryReqDto itemSearchReqDto, Integer pageNum, Integer pageSize) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSearchReqDto.getDirIds())) {
            List<Long> dirIdList = this.dirService.getLinkAndChildDirIdList(itemSearchReqDto.getDirIds(), itemSearchReqDto.getInstanceId(), itemSearchReqDto.getTenantId());
            if (org.apache.commons.collections.CollectionUtils.isEmpty(dirIdList)) {
                return null;
            }
            itemSearchReqDto.setDirIds(dirIdList);
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchReqDto.getKeyword())) {
            List itemIds = this.itemDas.queryItemIdByKeywordAndItemIds(itemSearchReqDto.getKeyword(), itemSearchReqDto.getItemIds());
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemIds)) {
                return new ItemSearchRespDto();
            }
            itemSearchReqDto.setItemIds(itemIds);
            itemSearchReqDto.setKeyword(null);
        }
        return this.queryByKeywordNew(itemSearchReqDto, pageNum, pageSize);
    }

    @Override
    public PageInfo<ShelfTaskQueryRespDto> queryShelfTask(ShelfTaskQueryReqDto shelfTaskQueryReqDto, Integer pageNum, Integer pageSize) {
        List<SqlFilter> sqlFilterList;
        if (shelfTaskQueryReqDto == null || shelfTaskQueryReqDto.getInstanceId() == null || shelfTaskQueryReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ShelfTaskEo shelfTaskEo = new ShelfTaskEo();
        DtoHelper.dto2Eo((BaseVo)shelfTaskQueryReqDto, (BaseEo)shelfTaskEo);
        if (StringUtils.isNotBlank((CharSequence)shelfTaskQueryReqDto.getStartTime())) {
            sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.ge((String)"shelf_time", (Object)shelfTaskQueryReqDto.getStartTime()));
            shelfTaskEo.setSqlFilters(sqlFilterList);
        }
        if (StringUtils.isNotBlank((CharSequence)shelfTaskQueryReqDto.getEndTime())) {
            sqlFilterList = shelfTaskEo.getSqlFilters();
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList();
            }
            sqlFilterList.add(SqlFilter.le((String)"shelf_time", (Object)shelfTaskQueryReqDto.getEndTime()));
            shelfTaskEo.setSqlFilters(sqlFilterList);
        }
        PageInfo itemTimingRespDtoPageInfo = new PageInfo();
        PageInfo shelfTaskEoPageInfo = this.shelfTaskDas.selectPage((BaseEo)shelfTaskEo, pageNum, pageSize);
        List shelfTaskEoList = shelfTaskEoPageInfo.getList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shelfTaskEoList)) {
            itemTimingRespDtoPageInfo.setPageNum(pageNum.intValue());
            itemTimingRespDtoPageInfo.setPageSize(pageSize.intValue());
            return itemTimingRespDtoPageInfo;
        }
        ArrayList<Long> itemIdList = new ArrayList<Long>();
        ArrayList<ShelfTaskQueryRespDto> itemTimingRespDtoList = new ArrayList<ShelfTaskQueryRespDto>();
        for (ShelfTaskEo taskEo : shelfTaskEoList) {
            itemIdList.add(taskEo.getItemId());
            ShelfTaskQueryRespDto itemTimingRespDto = new ShelfTaskQueryRespDto();
            DtoHelper.eo2Dto((BaseEo)taskEo, (BaseVo)itemTimingRespDto);
            itemTimingRespDtoList.add(itemTimingRespDto);
        }
        ItemEo itemEo = new ItemEo();
        ArrayList<SqlFilter> sqlFilterList2 = new ArrayList<SqlFilter>();
        sqlFilterList2.add(SqlFilter.in((String)"id", (Object)StringUtils.join(itemIdList, (String)",")));
        itemEo.setSqlFilters(sqlFilterList2);
        List itemEoList = this.itemDas.select((BaseEo)itemEo);
        block1: for (ItemEo eo : itemEoList) {
            for (ShelfTaskQueryRespDto dto : itemTimingRespDtoList) {
                if (!eo.getId().equals(dto.getItemId())) continue;
                dto.setItemName(eo.getName());
                continue block1;
            }
        }
        CubeBeanUtils.copyProperties((Object)itemTimingRespDtoPageInfo, (Object)shelfTaskEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        itemTimingRespDtoPageInfo.setList(itemTimingRespDtoList);
        return itemTimingRespDtoPageInfo;
    }

    @Override
    public ItemAllowOrderQueryRespDto checkItemAllowOrder(List<ItemAllowOrderQueryReqDto> itemAllowOrderReqDtoList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemAllowOrderReqDtoList)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        itemAllowOrderReqDtoList.stream().forEach(dto -> {
            if (dto.getInstanceId() == null || dto.getTenantId() == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
            }
        });
        ArrayList<ItemAllowOrderDetailQueryRespDto> itemAllowOrderDetailRespDtoList = new ArrayList<ItemAllowOrderDetailQueryRespDto>();
        for (ItemAllowOrderQueryReqDto itemAllowOrderReqDto : itemAllowOrderReqDtoList) {
            itemAllowOrderDetailRespDtoList.addAll(this.checkItemAllowOrder(itemAllowOrderReqDto));
        }
        ItemAllowOrderQueryRespDto itemAllowOrderRespDto = new ItemAllowOrderQueryRespDto();
        itemAllowOrderRespDto.setAllAllowOrder(Boolean.valueOf(true));
        for (ItemAllowOrderDetailQueryRespDto itemAllowOrderDetailRespDto : itemAllowOrderDetailRespDtoList) {
            if (itemAllowOrderDetailRespDto.getAllowOrder().booleanValue()) continue;
            itemAllowOrderRespDto.setAllAllowOrder(Boolean.valueOf(false));
            break;
        }
        return itemAllowOrderRespDto;
    }

    private List<ItemAllowOrderDetailQueryRespDto> checkItemAllowOrder(ItemAllowOrderQueryReqDto itemAllowOrderReqDto) {
        ArrayList<ItemAllowOrderDetailQueryRespDto> itemAllowOrderDetailRespDtoList = new ArrayList<ItemAllowOrderDetailQueryRespDto>();
        DirItemRelationEo dirItemRelationEo = new DirItemRelationEo();
        DtoHelper.dto2Eo((BaseVo)itemAllowOrderReqDto, (BaseEo)dirItemRelationEo);
        List dirItemRelationEoList = this.dirItemRelationDas.select((BaseEo)dirItemRelationEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirItemRelationEoList)) {
            Date now = new Date();
            for (DirItemRelationEo relationEo : dirItemRelationEoList) {
                List allowOrderTimeDtoList;
                ItemAllowOrderDetailQueryRespDto itemAllowOrderDetailRespDto = new ItemAllowOrderDetailQueryRespDto();
                DtoHelper.eo2Dto((BaseEo)relationEo, (BaseVo)itemAllowOrderDetailRespDto);
                itemAllowOrderDetailRespDto.setAllowOrder(Boolean.valueOf(true));
                if (StringUtils.isNotBlank((CharSequence)relationEo.getAllowOrderTime()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(allowOrderTimeDtoList = JSON.parseArray((String)relationEo.getAllowOrderTime(), AllowOrderTimeRespDto.class)))) {
                    itemAllowOrderDetailRespDto.setAllowOrderTimeRespDtoList(allowOrderTimeDtoList);
                    Boolean allowOrder = false;
                    for (AllowOrderTimeRespDto allowOrderTimeDto : allowOrderTimeDtoList) {
                        if (!now.after(allowOrderTimeDto.getStartTime()) || !now.before(allowOrderTimeDto.getEndTime())) continue;
                        allowOrder = true;
                        break;
                    }
                    itemAllowOrderDetailRespDto.setAllowOrder(allowOrder);
                }
                itemAllowOrderDetailRespDtoList.add(itemAllowOrderDetailRespDto);
            }
        }
        return itemAllowOrderDetailRespDtoList;
    }

    private List<Long> queryParentDataList(Long dirId) {
        ArrayList<Long> dirIdList;
        block2: {
            dirIdList = new ArrayList<Long>();
            if (dirId == null) {
                return dirIdList;
            }
            DirEo dirEo = (DirEo)this.dirDas.selectByPrimaryKey(dirId);
            if (dirEo == null) break block2;
            do {
                dirIdList.add(dirEo.getId());
            } while (!dirEo.getParentId().equals(0L) && (dirEo = (DirEo)this.dirDas.selectByPrimaryKey(dirEo.getParentId())) != null);
        }
        return dirIdList;
    }

    private List<ItemSkuEo> getItemSkuRepDtoList(List<Long> skuIds, ItemSkuListRespDto dto) {
        ArrayList skuRepDtos = Lists.newArrayList();
        List<ItemSkuEo> itemSkuEoList = this.itemSkuService.queryItemSkuByIds(skuIds);
        DtoHelper.eoList2DtoList(itemSkuEoList, (Collection)skuRepDtos, ItemSkuRespDto.class);
        dto.setItemSkuRespDtos((List)skuRepDtos);
        return itemSkuEoList;
    }

    private void getItemRespDtoList(ItemSkuListRespDto dto, List<ItemSkuEo> itemSkuEoList) {
        List<Object> itemEos = null;
        ArrayList itemIds = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemSkuEoList)) {
            for (ItemSkuEo skuEo : itemSkuEoList) {
                itemIds.add(skuEo.getItemId());
            }
        }
        itemEos = org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemIds) ? this.queryItemByIds(itemIds) : Lists.newArrayList();
        ArrayList itemRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemEos, (Collection)itemRespDtos, ItemRespDto.class);
        dto.setItemRespDtos((List)itemRespDtos);
    }

    private void addItemAssociateAttr(Integer type, ItemChangeApplyDto publishItemDto, Long itemId, Long instanceId, Long tenantId) {
        List skus = publishItemDto.getSkus();
        HashMap<Long, Long> skuIds = new HashMap<Long, Long>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)skus)) {
            boolean isMulti = skus.size() > 1;
            for (ItemBundleReqDto itemBundleDto : skus) {
                ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
                this.addItemSku(itemId, itemBundleDto, itemSkuEo, instanceId, tenantId, isMulti);
                skuIds.put(itemSkuEo.getId(), itemBundleDto.getShelfAmount());
                this.addItemBundle(itemId, type, itemBundleDto, itemSkuEo, instanceId, tenantId);
                this.addItemPrice(itemBundleDto, itemSkuEo, instanceId, tenantId);
                List medias = itemBundleDto.getMedias();
                this.addItemMedias(itemId, medias, itemSkuEo, instanceId, tenantId);
                this.addItemTags(itemId, itemBundleDto.getTags(), itemSkuEo, instanceId, tenantId);
            }
        }
        List medias = publishItemDto.getMedias();
        this.addItemMedias(itemId, medias, null, instanceId, tenantId);
        this.addItemAttr(publishItemDto, itemId, instanceId, tenantId);
        this.addItemTags(itemId, publishItemDto.getTags(), null, instanceId, tenantId);
        List itemPropGroupDtoList = publishItemDto.getPropGroupDtoList();
        this.saveItemProp(itemId, itemPropGroupDtoList);
    }

    private void saveItemProp(Long itemId, List<ItemPropGroupDto> itemPropGroupDtoList) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemPropGroupDtoList)) {
            ArrayList itemPropRelationEoList = Lists.newArrayList();
            itemPropGroupDtoList.forEach(itemPropGroupDto -> {
                List itemPropNameDtoList;
                List existItemPropRelationEoList = this.itemPropRelationDas.selectByParam(itemId, itemPropGroupDto.getId());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)existItemPropRelationEoList)) {
                    existItemPropRelationEoList.forEach(existEo -> this.itemPropRelationDas.deleteById(existEo.getId()));
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(itemPropNameDtoList = itemPropGroupDto.getPropNameDtoList()))) {
                    itemPropNameDtoList.forEach(itemPropNameDto -> {
                        ItemPropRelationEo itemPropRelationEo = ItemPropRelationEo.newInstance();
                        itemPropRelationEo.setItemId(itemId);
                        itemPropRelationEo.setPropGroupId(itemPropGroupDto.getId());
                        itemPropRelationEo.setPropNameId(itemPropNameDto.getId());
                        List choose = itemPropNameDto.getChoose();
                        List propValueList = itemPropNameDto.getPropValueList();
                        if (PropInputTypeEnum.SELECT.getCode() == itemPropNameDto.getInputType().intValue() && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)choose) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)propValueList) && propValueList.size() >= choose.size()) {
                            String choosePropValue = choose.stream().map(propValueList::get).collect(Collectors.joining(","));
                            itemPropRelationEo.setPropValue(choosePropValue);
                        }
                        if (PropInputTypeEnum.INPUT.getCode() == itemPropNameDto.getInputType().intValue()) {
                            itemPropRelationEo.setPropValue(itemPropNameDto.getInputValue());
                        }
                        if (StringUtils.isNotBlank((CharSequence)itemPropRelationEo.getPropValue())) {
                            itemPropRelationEoList.add(itemPropRelationEo);
                        }
                    });
                }
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemPropRelationEoList)) {
                this.itemPropRelationDas.insertBatch((List)itemPropRelationEoList);
            }
        }
    }

    private void addItemSku(Long itemId, ItemBundleReqDto itemBundleDto, ItemSkuEo itemSkuEo, Long instanceId, Long tenantId, boolean isMulti) {
        DtoHelper.dto2Eo((BaseVo)itemBundleDto, (BaseEo)itemSkuEo);
        itemSkuEo.setItemId(itemId);
        itemSkuEo.setInstanceId(instanceId);
        itemSkuEo.setTenantId(tenantId);
        if (StringUtils.isEmpty((CharSequence)itemSkuEo.getCode()) && !isMulti) {
            ItemEo itemEo = ItemEo.newInstance();
            itemEo.setId(itemId);
            ItemEo item = (ItemEo)this.itemDas.selectOne((BaseEo)itemEo);
            if (item != null) {
                itemSkuEo.setCode(item.getCode());
            }
        }
        logger.info("\u6253\u5370\u63d2\u5165it_item_sku\u8868\u6570\u636e:{}", (Object)JSON.toJSONString((Object)itemSkuEo));
        this.itemSkuService.saveSku(itemSkuEo);
    }

    private void addItemAttr(ItemChangeApplyDto publishItemDto, Long itemId, Long instanceId, Long tenantId) {
        ItemAttributesEo itemAttributesEo = ItemAttributesEo.newInstance();
        itemAttributesEo.setItemId(itemId);
        String attrs = publishItemDto.getAttrs();
        itemAttributesEo.setAttrs(attrs);
        itemAttributesEo.setSearchAttrs(publishItemDto.getSearchAttrs());
        itemAttributesEo.setInstanceId(instanceId);
        itemAttributesEo.setTenantId(tenantId);
        this.itemAttributesService.addProp(itemAttributesEo);
    }

    private void addItemPrice(ItemBundleReqDto itemBundleDto, ItemSkuEo itemSkuEo, Long instanceId, Long tenantId) {
        List itemPriceDtoList = itemBundleDto.getPrices();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemPriceDtoList)) {
            ArrayList itemPriceEos = Lists.newArrayList();
            for (ItemPriceReqDto dto : itemPriceDtoList) {
                ItemPriceEo itemPriceEo = ItemPriceEo.newInstance();
                DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)itemPriceEo);
                itemPriceEo.setId(null);
                itemPriceEo.setSkuId(itemSkuEo.getId());
                itemPriceEo.setItemId(itemSkuEo.getItemId());
                itemPriceEo.setInstanceId(instanceId);
                itemPriceEo.setTenantId(tenantId);
                itemPriceEos.add(itemPriceEo);
            }
            this.itemPriceService.addBatchItemPrice(itemPriceEos);
        }
    }

    private void addItemBundle(Long itemId, Integer type, ItemBundleReqDto itemBundleDto, ItemSkuEo itemSkuEo, Long instanceId, Long tenantId) {
        List bundleItemDtos;
        if (ItemType.BUNDLE.getIndex().equals(type) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(bundleItemDtos = itemBundleDto.getBundleItemDtos()))) {
            logger.info("\u589e\u52a0\u7ec4\u5408\u5546\u54c1\u7684\u5b50\u5546\u54c1\uff1a {}", (Object)JSON.toJSONString((Object)itemBundleDto.getBundleItemDtos()));
            ArrayList bundleItemEos = Lists.newArrayList();
            for (BundleItemReqDto bundleItemDto : bundleItemDtos) {
                ItemBundleRelationEo bundleItemEo = ItemBundleRelationEo.newInstance((Map)bundleItemDto.getExtFields());
                DtoHelper.dto2Eo((BaseVo)bundleItemDto, (BaseEo)bundleItemEo);
                bundleItemEo.setId(null);
                bundleItemEo.setItemId(itemId);
                bundleItemEo.setSkuId(itemSkuEo.getId());
                bundleItemEo.setInstanceId(instanceId);
                bundleItemEo.setTenantId(tenantId);
                bundleItemEos.add(bundleItemEo);
            }
            this.bundleItemService.addBundleItemBatch(bundleItemEos);
        }
    }

    private void addItemMedias(Long itemId, List<ItemMediasReqDto> medias, ItemSkuEo itemSkuEo, Long instanceId, Long tenantId) {
        ArrayList mediasEos = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(medias)) {
            for (ItemMediasReqDto itemMediasDto : medias) {
                ItemMediasEo itemMediasEo = ItemMediasEo.newInstance((Map)itemMediasDto.getExtFields());
                DtoHelper.dto2Eo((BaseVo)itemMediasDto, (BaseEo)itemMediasEo);
                itemMediasEo.setId(null);
                itemMediasEo.setItemId(itemId);
                if (null != itemSkuEo && null != itemSkuEo.getId()) {
                    itemMediasEo.setSkuId(itemSkuEo.getId());
                }
                itemMediasEo.setInstanceId(instanceId);
                itemMediasEo.setTenantId(tenantId);
                mediasEos.add(itemMediasEo);
            }
        }
        this.itemMediasService.addBatchItemMedias(mediasEos);
    }

    private void addItemTags(Long itemId, List<Long> tags, ItemSkuEo itemSkuEo, Long instanceId, Long tenantId) {
        ArrayList itemTagEos = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(tags)) {
            for (Long tag : tags) {
                ItemTagRelationEo itemTagEo = ItemTagRelationEo.newInstance();
                itemTagEo.setTagId(tag);
                itemTagEo.setItemId(itemId);
                if (null != itemSkuEo && null != itemSkuEo.getId()) {
                    itemTagEo.setSkuId(itemSkuEo.getId());
                }
                itemTagEo.setInstanceId(instanceId);
                itemTagEo.setTenantId(tenantId);
                itemTagEos.add(itemTagEo);
            }
        }
        this.itemTagService.relateToItem(itemTagEos);
    }

    private void addItemPropRelation(ItemChangeApplyDto publishItemDto, Long itemId, Long instanceId, Long tenantId) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)publishItemDto.getItemPropRelationReqDtos())) {
            ArrayList<ItemPropRelationReqDto> dtos = new ArrayList<ItemPropRelationReqDto>();
            for (ItemPropRelationReqDto dto : publishItemDto.getItemPropRelationReqDtos()) {
                if (this.propService.queryPropGroupById(dto.getPropGroupId()) == null) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPGROUP.getCode(), ItemExceptionCode.NON_EXIST_PROPGROUP.getMsg());
                }
                dto.setItemId(itemId);
                dto.setTenantId(tenantId);
                dto.setInstanceId(instanceId);
                dto.setSellerId(publishItemDto.getSellerId());
                dtos.add(dto);
            }
            this.propService.addItemPropRelation(dtos);
        }
    }

    private void initItemEo(ItemChangeApplyDto changeApply, ItemEo itemEo) {
        DtoHelper.dto2Eo((BaseVo)changeApply, (BaseEo)itemEo);
        itemEo.setName(changeApply.getItemName());
        itemEo.setStatus(changeApply.getItemStatus());
        itemEo.setCode(changeApply.getItemCode());
        itemEo.setDisplayName(changeApply.getDisplayName());
        itemEo.setBrandId(changeApply.getBrandId());
        itemEo.setDetail(changeApply.getDetail());
        itemEo.setBrand(changeApply.getBrand());
        itemEo.setDirId(changeApply.getDirId());
        itemEo.setType(changeApply.getType());
        itemEo.setIsAfterSale(changeApply.getIsAfterSale());
        itemEo.setDirName(changeApply.getDirName());
        itemEo.setVitrual(changeApply.getVirtual());
        itemEo.setSellerId(changeApply.getSellerId());
        itemEo.setShopId(changeApply.getShopId());
        itemEo.setLongCode(changeApply.getLongCode());
        itemEo.setInstanceId(changeApply.getInstanceId());
        itemEo.setTenantId(changeApply.getTenantId());
        itemEo.setGiftBox(changeApply.getGiftBox());
        itemEo.setVersion(Long.valueOf(1L));
    }

    private void removeItemAssociateAttr(Long itemId, Integer type) {
        ItemMediasEo itemMediasEo = ItemMediasEo.newInstance();
        itemMediasEo.setItemId(itemId);
        this.itemMediasService.removeItemMedias(itemMediasEo);
        this.itemAttributesService.removeByItemId(itemId);
        if (ItemType.BUNDLE.getIndex().equals(type)) {
            this.bundleItemService.removeByItemId(itemId);
        }
        ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
        itemSkuEo.setItemId(itemId);
        List<ItemSkuEo> itemSkuEos = this.itemSkuService.queryItemSku(itemSkuEo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemSkuEos)) {
            return;
        }
        ArrayList skuIds = Lists.newArrayList();
        for (ItemSkuEo sku : itemSkuEos) {
            Long skuId = sku.getId();
            ItemPriceEo itemPriceEo = ItemPriceEo.newInstance();
            itemPriceEo.setSkuId(skuId);
            skuIds.add(skuId);
        }
        this.itemPriceService.removeBatchItemPrice(skuIds);
        this.itemSkuService.removeItemSku(skuIds);
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemId);
        if (Objects.isNull(itemEo)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_ITEM.getCode(), ItemExceptionCode.NON_EXIST_ITEM.getMsg());
        }
    }

    @Override
    public void validSkuCode(ItemChangeApplyDto itemChangeApplyDto, Long tenantId) {
        Set skuCodeSet;
        if (itemChangeApplyDto != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemChangeApplyDto.getSkus()) && org.apache.commons.collections.CollectionUtils.isNotEmpty(skuCodeSet = itemChangeApplyDto.getSkus().stream().filter(itemBundleReqDto -> StringUtils.isNotBlank((CharSequence)itemBundleReqDto.getCode())).map(ItemSkuReqDto::getCode).collect(Collectors.toSet()))) {
            if (skuCodeSet.size() != itemChangeApplyDto.getSkus().size()) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.SKU_CODE_EXISTS.getCode(), ItemExceptionCode.SKU_CODE_EXISTS.getMsg());
            }
            for (ItemBundleReqDto itemBundleReqDto2 : itemChangeApplyDto.getSkus()) {
                if (!StringUtils.isNotBlank((CharSequence)itemBundleReqDto2.getCode())) continue;
                ItemSkuEo itemSkuEo = ItemSkuEo.newInstance();
                itemSkuEo.setTenantId(tenantId);
                itemSkuEo.setCode(itemBundleReqDto2.getCode());
                if ((itemSkuEo = (ItemSkuEo)this.itemSkuDas.selectOne((BaseEo)itemSkuEo)) == null) continue;
                if (itemBundleReqDto2.getId() == null) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.SKU_CODE_EXISTS.getCode(), ItemExceptionCode.SKU_CODE_EXISTS.getMsg() + itemBundleReqDto2.getCode());
                }
                if (itemBundleReqDto2.getId() == null || itemSkuEo.getId().equals(itemBundleReqDto2.getId())) continue;
                throw new ItemBusinessRuntimeException(ItemExceptionCode.SKU_CODE_EXISTS.getCode(), ItemExceptionCode.SKU_CODE_EXISTS.getMsg() + itemBundleReqDto2.getCode());
            }
        }
    }

    @Override
    public List<ItemRespDto> queryItems(List<Long> ids) {
        List itemEoList = this.itemDas.selectByIds(ids);
        ArrayList itemRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemEoList, (Collection)itemRespDtoList, ItemRespDto.class);
        return itemRespDtoList;
    }

    @Override
    public PageInfo<Long> querySaleOut(ItemReqDto itemReq, int page, int size) {
        ItemEo query = ItemEo.newInstance();
        CubeBeanUtils.copyProperties((Object)query, (Object)itemReq, (String[])new String[0]);
        List<Object> dirIdList = new ArrayList();
        if (Objects.nonNull(query.getDirId())) {
            dirIdList = this.dirService.getChildDirIdList(Lists.newArrayList((Object[])new Long[]{query.getDirId()}), null, null);
        }
        return this.itemDas.querySaleOut(query, page, size, dirIdList);
    }

    @Override
    public void modifyItemStatus(ItemModifyStatusReqDto modifyStatusReqDto) {
        if (Objects.isNull(modifyStatusReqDto)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
        }
        ItemEo itemEo = new ItemEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)modifyStatusReqDto.getIds()));
        itemEo.setStatus(modifyStatusReqDto.getStatus());
        itemEo.setSqlFilters(sqlFilters);
        this.itemDas.updateSelectiveSqlFilter((BaseEo)itemEo);
    }

    @Override
    public Long queryCount(ItemReqDto itemDto) {
        ItemEo itemEo = new ItemEo();
        DtoHelper.dto2Eo((BaseVo)itemDto, (BaseEo)itemEo);
        return this.itemDas.count((BaseEo)itemEo);
    }

    @Override
    public PageInfo<ItemShelfRespDto> queryItemShelf(ShelfReqDto shelfReqDto, Integer pageNum, Integer pageSize) {
        IShelfIntegralService shelfIntegralService;
        ShelfEo shelfEo = ShelfEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfReqDto, (BaseEo)shelfEo);
        ArrayList sqlFilters = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shelfReqDto.getSkuIds())) {
            sqlFilters.add(SqlFilter.in((String)"skuId", (Object)shelfReqDto.getSkuIds()));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shelfReqDto.getShopIds())) {
            sqlFilters.add(SqlFilter.in((String)"shopId", (Object)shelfReqDto.getShopIds()));
        }
        PageInfo pageInfo = this.shelfDas.selectPage((BaseEo)shelfEo, pageNum, pageSize);
        ArrayList shelfRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), (Collection)shelfRespDtoList, ItemShelfRespDto.class);
        PageInfo resultPage = new PageInfo((List)shelfRespDtoList);
        CubeBeanUtils.copyProperties((Object)resultPage, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList()) && shelfReqDto.getBusType() != null && shelfReqDto.getBusType().equals(ItemBusTypeEnum.INTEGRAL.getType()) && null != (shelfIntegralService = (IShelfIntegralService)SpringBeanUtil.getBean(IShelfIntegralService.class))) {
            for (ItemShelfRespDto itemShelfRespDto : shelfRespDtoList) {
                ShelfIntegralRespDto shelfIntegralRespDto = shelfIntegralService.queryByShelfId(itemShelfRespDto.getId());
                itemShelfRespDto.setShelfIntegral(shelfIntegralRespDto);
            }
        }
        return resultPage;
    }

    private ItemShelfRespDto queryOneItemShelfCache(ShelfReqDto shelfReqDto) {
        String key = "ItemShelf:" + shelfReqDto.getItemId() + shelfReqDto.getShopId() + shelfReqDto.getSkuId() + shelfReqDto.getBusType() + shelfReqDto.getItemType();
        return (ItemShelfRespDto)this.cacheService.getCache(key, ItemShelfRespDto.class);
    }

    private void addOneItemShelfCache(ShelfReqDto shelfReqDto, ItemShelfRespDto itemShelfRespDto) {
        String key = "ItemShelf:" + shelfReqDto.getItemId() + shelfReqDto.getShopId() + shelfReqDto.getSkuId() + shelfReqDto.getBusType() + shelfReqDto.getItemType();
        this.cacheService.add(key, (Object)itemShelfRespDto, 60);
    }

    @Override
    public ItemShelfRespDto queryOneItemShelf(ShelfReqDto shelfReqDto) {
        ItemShelfRespDto itemShelfRespDto1 = this.queryOneItemShelfCache(shelfReqDto);
        if (itemShelfRespDto1 != null) {
            return itemShelfRespDto1;
        }
        ShelfEo shelfEo = ShelfEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfReqDto, (BaseEo)shelfEo);
        ShelfEo result = (ShelfEo)this.shelfDas.selectOne((BaseEo)shelfEo);
        if (result == null) {
            return null;
        }
        ItemShelfRespDto itemShelfRespDto = new ItemShelfRespDto();
        BeanUtils.copyProperties((Object)result, (Object)itemShelfRespDto);
        if (shelfReqDto.getBusType() != null && shelfReqDto.getBusType().equals(ItemBusTypeEnum.INTEGRAL.getType())) {
            ShelfIntegralRespDto shelfIntegralRespDto = this.shelfIntegralService.queryByShelfId(result.getId());
            itemShelfRespDto.setShelfIntegral(shelfIntegralRespDto);
        }
        this.addOneItemShelfCache(shelfReqDto, itemShelfRespDto);
        return itemShelfRespDto;
    }

    @Override
    @CacheEvict(value={"center_item_shelf"}, key="#itemId+'_'+#shopId+'_'+skuId+'_'+#busType+'_'+#itemType")
    public void clearOneItemShelf(ShelfReqDto shelfReqDto) {
    }

    @Override
    public List<ItemShelfRespDto> queryItemShelfList(ShelfReqDto shelfReqDto) {
        ShelfEo shelfEo = ShelfEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfReqDto, (BaseEo)shelfEo);
        List list = this.shelfDas.select((BaseEo)shelfEo);
        return this.getItemShelfRespDto(list);
    }

    @Override
    public List<Long> queryItemIds(ItemReqDto itemReqDto) {
        ArrayList itemIds = Lists.newArrayList();
        ItemEo itemEo = new ItemEo();
        DtoHelper.dto2Eo((BaseVo)itemReqDto, (BaseEo)itemEo);
        PageInfo pageInfo = this.itemDas.selectPage((BaseEo)itemEo, Integer.valueOf(1), Integer.valueOf(1000));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return itemIds;
        }
        itemIds.addAll(pageInfo.getList().stream().map(BaseEo::getId).collect(Collectors.toList()));
        for (int pageNum = 2; pageNum <= pageInfo.getPages(); ++pageNum) {
            pageInfo = this.itemDas.selectPage((BaseEo)itemEo, Integer.valueOf(pageNum), Integer.valueOf(1000));
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) continue;
            itemIds.addAll(pageInfo.getList().stream().map(BaseEo::getId).collect(Collectors.toList()));
        }
        return itemIds;
    }

    @Override
    public ItemRespDto queryItemAndSku(Long itemId, Long skuId) {
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemId);
        if (null == itemEo) {
            return null;
        }
        ItemRespDto itemRespDto = new ItemRespDto();
        DtoHelper.eo2Dto((BaseEo)itemEo, (BaseVo)itemRespDto);
        ItemSkuEo itemSkuEo = (ItemSkuEo)this.itemSkuDas.selectByPrimaryKey(skuId);
        if (null == itemSkuEo) {
            return itemRespDto;
        }
        ItemSkuRespDto itemSkuRespDto = new ItemSkuRespDto();
        DtoHelper.eo2Dto((BaseEo)itemSkuEo, (BaseVo)itemSkuRespDto);
        itemRespDto.setItemSkuList((List)Lists.newArrayList((Object[])new ItemSkuRespDto[]{itemSkuRespDto}));
        return itemRespDto;
    }

    @Override
    public BranchItemRespDto branchQueryItem(BranchQueryItemReqDto branchQueryItemReqDto) {
        BranchItemRespDto branchItemRespDto = new BranchItemRespDto();
        ArrayList<ItemDetailRespDto> itemDetailRespDtos = new ArrayList<ItemDetailRespDto>();
        ArrayList<ItemShelfRespDto> itemShelfRespDtos = new ArrayList<ItemShelfRespDto>();
        for (ShelfReqDto shelfReqDto : branchQueryItemReqDto.getShelfItemList()) {
            ItemDetailRespDto itemDetailRespDto = this.queryItemDetail(shelfReqDto.getItemId(), "attributes,sku,medias", null);
            itemDetailRespDtos.add(itemDetailRespDto);
            ItemShelfRespDto itemShelfRespDto = this.shelfService.queryItemShelf(shelfReqDto);
            if (null == itemShelfRespDto) continue;
            itemShelfRespDtos.add(itemShelfRespDto);
        }
        branchItemRespDto.setItemShelfList(itemShelfRespDtos);
        branchItemRespDto.setItemDetailList(itemDetailRespDtos);
        return branchItemRespDto;
    }

    @Override
    public ItemDetailBaseInfoRespDto queryItemDetail(long itemId, long shopId) {
        ItemSearchQueryReqDto queryReqDto = new ItemSearchQueryReqDto();
        queryReqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        queryReqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        queryReqDto.setItemIds((List)Lists.newArrayList((Object[])new Long[]{itemId}));
        ItemSearchRespDto searchRespDto = this.queryByKeyword(queryReqDto, 1, 1);
        if (null == searchRespDto || null == searchRespDto.getPageInfo() || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)searchRespDto.getPageInfo().getList())) {
            return null;
        }
        ItemRespDto itemRespDto = (ItemRespDto)searchRespDto.getPageInfo().getList().get(0);
        ItemDetailBaseInfoRespDto itemBaseInfo = new ItemDetailBaseInfoRespDto();
        CubeBeanUtils.copyProperties((Object)itemBaseInfo, (Object)itemRespDto, (String[])new String[0]);
        itemBaseInfo.setItemMediasList(itemRespDto.getItemMediasList());
        itemBaseInfo.setSaleCount(itemRespDto.getSalesCount());
        itemBaseInfo.setAttrs(((ItemAttributesRespDto)searchRespDto.getAttributesList().get(0)).getAttrs());
        this.filterOnSelfSkuAndModify(itemBaseInfo, itemRespDto, shopId);
        return itemBaseInfo;
    }

    private void filterOnSelfSkuAndModify(ItemDetailBaseInfoRespDto itemBaseInfo, ItemRespDto itemRespDto, long shopId) {
        IItemCycleBuyService itemCycleBuyService;
        long itemId = itemBaseInfo.getId();
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setItemId(Long.valueOf(itemId));
        if (shopId > 0L) {
            shelfReqDto.setShopId(Long.valueOf(shopId));
        }
        shelfReqDto.setStatus(Integer.valueOf(1));
        List<ItemShelfRespDto> itemShelfRespDtos = this.queryItemShelfList(shelfReqDto);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemShelfRespDtos)) {
            logger.error("\u65e0\u4e0a\u67b6\u4fe1\u606f{}\uff0c{}", (Object)itemId, (Object)shopId);
            return;
        }
        ArrayList itemSkuList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemSkuList, (Collection)itemRespDto.getItemSkuList(), ItemSkuInfoRespDto.class);
        boolean hasCycleBuy = itemShelfRespDtos.parallelStream().anyMatch(t -> Objects.equals(t.getType(), ShelfTypeEnum.PERIOD.getType()));
        if (hasCycleBuy && null != (itemCycleBuyService = (IItemCycleBuyService)SpringBeanUtil.getBean(IItemCycleBuyService.class))) {
            itemBaseInfo.setCycleBuyByShopItem(itemCycleBuyService.getCycleBuyByShopItem(shopId, itemId));
        }
        Map<Long, ItemShelfRespDto> itemShelfRespDtoMap = itemShelfRespDtos.stream().collect(Collectors.toMap(ItemShelfRespDto::getSkuId, itemShelfRespDto -> itemShelfRespDto, (e1, e2) -> e1));
        itemBaseInfo.setItemSkuList(itemSkuList.stream().filter(itemSkuInfoRespDto -> itemShelfRespDtoMap.get(itemSkuInfoRespDto.getId()) != null).peek(itemSkuInfoRespDto -> {
            ItemShelfRespDto itemShelfRespDto = (ItemShelfRespDto)itemShelfRespDtoMap.get(itemSkuInfoRespDto.getId());
            itemSkuInfoRespDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemSkuInfoRespDto.getItemPriceList())) {
                for (ItemPriceRespDto itemPriceRespDto : itemSkuInfoRespDto.getItemPriceList()) {
                    if (!ItemPriceEnum.SALE_PRICE.getType().equals(itemPriceRespDto.getPriceType())) continue;
                    itemPriceRespDto.setPrice(itemShelfRespDto.getPrice());
                }
            }
        }).collect(Collectors.toList()));
    }

    @Override
    public List<DirsItemsRespDto> queryDirsItems(Long shopId, Long itemId) {
        DirItemRelationEo dirItemRelationEo = DirItemRelationEo.newInstance();
        dirItemRelationEo.setShopId(shopId);
        dirItemRelationEo.setItemId(itemId);
        List dirsItemsEoList = this.dirItemRelationDas.select((BaseEo)dirItemRelationEo);
        ArrayList list = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)dirsItemsEoList, (Collection)list, DirsItemsRespDto.class);
        return list;
    }

    @Override
    public PageInfo<ItemShelfRespDto> queryItemShelfByPage(ShelfReqDto shelfReqDto, Integer pageNum, Integer pageSize) {
        ShelfEo shelfEo = ShelfEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfReqDto, (BaseEo)shelfEo);
        PageInfo pageInfo = this.shelfDas.selectPage((BaseEo)shelfEo, pageNum, pageSize);
        List<ItemShelfRespDto> shelfRespDtoList = this.getItemShelfRespDto(pageInfo.getList());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(shelfRespDtoList);
        return dtoPageInfo;
    }

    private List<ItemShelfRespDto> getItemShelfRespDto(List<ShelfEo> shelfEos) {
        ArrayList shelfRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList(shelfEos, (Collection)shelfRespDtoList, ItemShelfRespDto.class);
        Map<Integer, List<ItemShelfRespDto>> group = shelfRespDtoList.stream().collect(Collectors.groupingBy(ItemShelfRespDto::getBusType));
        if (group.containsKey(ItemBusTypeEnum.INTEGRAL.getType())) {
            List<Long> shelfIds = group.get(ItemBusTypeEnum.INTEGRAL.getType()).stream().map(ItemShelfRespDto::getId).collect(Collectors.toList());
            IShelfIntegralService shelfIntegralService = (IShelfIntegralService)SpringBeanUtil.getBean(IShelfIntegralService.class);
            List<ShelfIntegralRespDto> shelfIntegralRespDtos = shelfIntegralService.queryByShelfId(shelfIds);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(shelfIntegralRespDtos)) {
                Map<Long, List<ShelfIntegralRespDto>> map = shelfIntegralRespDtos.stream().collect(Collectors.groupingBy(ShelfIntegralRespDto::getShelfId));
                for (ItemShelfRespDto itemShelfRespDto : shelfRespDtoList) {
                    if (!map.containsKey(itemShelfRespDto.getId())) continue;
                    itemShelfRespDto.setShelfIntegral(map.get(itemShelfRespDto.getId()).get(0));
                }
            }
        }
        return shelfRespDtoList;
    }

    @Override
    public void refresh(ShelfReqDto shelfReqDto) {
        if (null == shelfReqDto.getItemId() && null == shelfReqDto.getShopId()) {
            logger.info("\u5546\u54c1id\u548c\u5e97\u94faid\u4e0d\u540c\u65f6\u4e3a\u7a7a,\u4e0d\u66f4\u5546\u54c1es\u6570\u636e");
        }
        int itemTotalNum = 0;
        int pageNum = 1;
        int pageSize = 1000;
        shelfReqDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        PageInfo<ItemShelfRespDto> pageInfo = this.queryItemShelfByPage(shelfReqDto, pageNum, pageSize);
        while (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            Map<String, List<ItemShelfRespDto>> group = pageInfo.getList().stream().collect(Collectors.groupingBy(shelfRespDto -> "" + shelfRespDto.getSellerId() + shelfRespDto.getItemId() + shelfRespDto.getBusType()));
            for (List<ItemShelfRespDto> shelfRespDtos : group.values()) {
                ItemShelfRespDto shelfRespDto2 = shelfRespDtos.get(0);
                this.itemSearchService.index(shelfRespDto2.getSellerId(), shelfRespDto2.getItemId(), shelfRespDto2.getBusType(), "ON_SHELF");
                ++itemTotalNum;
            }
            pageInfo = this.queryItemShelfByPage(shelfReqDto, ++pageNum, pageSize);
        }
        logger.info("\u66f4\u65b0\u5546\u54c1ES\u6570\u636e\uff0c\u53c2\u6570shelfReqDto={},\u5546\u54c1\u4e0a\u67b6\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)shelfReqDto), (Object)itemTotalNum);
    }

    @Override
    public void refreshSyn(ShelfReqDto shelfReqDto) {
        if (null == shelfReqDto.getItemId() && null == shelfReqDto.getShopId()) {
            logger.info("\u5546\u54c1id\u548c\u5e97\u94faid\u4e0d\u540c\u65f6\u4e3a\u7a7a,\u4e0d\u66f4\u5546\u54c1es\u6570\u636e");
            return;
        }
        int itemTotalNum = 0;
        int pageNum = 1;
        int pageSize = 1000;
        shelfReqDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        PageInfo<ItemShelfRespDto> pageInfo = this.queryItemShelfByPage(shelfReqDto, pageNum, pageSize);
        while (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List itemShelfRespDtos = pageInfo.getList();
            Map<Integer, Map<Long, List<ItemShelfRespDto>>> dataMap = itemShelfRespDtos.stream().collect(Collectors.groupingBy(ItemShelfRespDto::getBusType, Collectors.mapping(o -> o, Collectors.groupingBy(ItemShelfRespDto::getSellerId))));
            dataMap.forEach((k, v) -> v.forEach((key, val) -> this.itemSearchService.refreshIndexBatch(this.transferDto(itemShelfRespDtos), (Integer)k, "ON_SHELF")));
            itemTotalNum += itemShelfRespDtos.size();
            pageInfo = this.queryItemShelfByPage(shelfReqDto, ++pageNum, pageSize);
        }
        logger.info("\u66f4\u65b0\u5546\u54c1ES\u6570\u636e\uff0c\u53c2\u6570shelfReqDto={},\u5546\u54c1\u4e0a\u67b6\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)shelfReqDto), (Object)itemTotalNum);
    }

    private List<DirItemRelationEo> transferDto(List<ItemShelfRespDto> itemShelfRespDtos) {
        return itemShelfRespDtos.stream().map(shelf -> {
            DirItemRelationEo relationEo = new DirItemRelationEo();
            relationEo.setSellerId(shelf.getSellerId());
            relationEo.setShopId(shelf.getShopId());
            relationEo.setItemId(shelf.getItemId());
            relationEo.setBusType(shelf.getBusType());
            return relationEo;
        }).collect(Collectors.toList());
    }

    @Override
    public void refreshES(ShelfReqDto shelfReqDto) {
        if (null == shelfReqDto.getItemId() && null == shelfReqDto.getShopId()) {
            logger.info("\u5546\u54c1id\u548c\u5e97\u94faid\u4e0d\u540c\u65f6\u4e3a\u7a7a,\u4e0d\u66f4\u5546\u54c1es\u6570\u636e");
        }
        int itemTotalNum = 0;
        int pageNum = 1;
        int pageSize = 1000;
        PageInfo<ItemShelfRespDto> pageInfo = this.queryItemShelfByPage(shelfReqDto, pageNum, pageSize);
        while (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            Map<String, List<ItemShelfRespDto>> group = pageInfo.getList().stream().collect(Collectors.groupingBy(shelfRespDto -> shelfRespDto.getShopId().toString() + shelfRespDto.getItemId() + shelfRespDto.getBusType()));
            for (List<ItemShelfRespDto> shelfRespDtos : group.values()) {
                ItemShelfRespDto shelfRespDto2 = shelfRespDtos.get(0);
                this.itemSearchService.index(shelfRespDto2.getSellerId(), shelfRespDto2.getItemId(), shelfRespDto2.getBusType(), "ON_SHELF");
                ++itemTotalNum;
            }
            pageInfo = this.queryItemShelfByPage(shelfReqDto, ++pageNum, pageSize);
        }
        logger.info("\u66f4\u65b0\u5546\u54c1ES\u6570\u636e\uff0c\u53c2\u6570shelfReqDto={},\u5546\u54c1\u4e0a\u67b6\u6570\u91cf\uff1a{}", (Object)JSON.toJSONString((Object)shelfReqDto), (Object)itemTotalNum);
    }

    @Override
    public List<ItemBundleRelationEo> queryBundleItemList(Long shopId, Long skuId) {
        ItemBundleRelationEo param = new ItemBundleRelationEo();
        param.setSkuId(skuId);
        return this.itemBundleRelationDas.select((BaseEo)param);
    }

    @Override
    public List<BundleItemRespDto> queryBundleItemDetail(Long shopId, Long itemId, Integer itemBusType) {
        ItemBundleRelationEo param = new ItemBundleRelationEo();
        param.setItemId(itemId);
        List bundleRelationEos = this.itemBundleRelationDas.select((BaseEo)param);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)bundleRelationEos)) {
            return Collections.emptyList();
        }
        List<Long> subItemIds = bundleRelationEos.stream().map(StdItemBundleRelationEo::getSubItemId).collect(Collectors.toList());
        List subSkuIds = bundleRelationEos.stream().map(StdItemBundleRelationEo::getSubSkuId).collect(Collectors.toList());
        ShelfQueryReqDto queryReqDto = new ShelfQueryReqDto();
        queryReqDto.setItemIds(subItemIds);
        queryReqDto.setShopId(shopId);
        queryReqDto.setBusType(itemBusType);
        List<ShelfQueryRespDto> shelfQueryRespDtos = this.shelfService.queryShelfList(queryReqDto);
        Map<String, ShelfQueryRespDto> shelfMap = shelfQueryRespDtos.stream().collect(Collectors.toMap(shelf -> shelf.getShopId() + shelf.getSkuId().toString(), e -> e, (e1, e2) -> e1));
        List shelfReqDtos = subSkuIds.stream().map(skuId -> {
            ShelfReqDto shelfReqDto = new ShelfReqDto();
            shelfReqDto.setShopId(shopId);
            shelfReqDto.setSkuId(skuId);
            return shelfReqDto;
        }).collect(Collectors.toList());
        ItemStorageBranchQueryReqDto batchReqDto = new ItemStorageBranchQueryReqDto();
        batchReqDto.setShelfList(shelfReqDtos);
        List<ItemStorageQueryRespDto> storageRespDtos = this.itemStorageService.queryBranchItemStorage(batchReqDto);
        Map<String, ItemStorageQueryRespDto> storageMap = storageRespDtos.stream().collect(Collectors.toMap(storage -> storage.getShopId() + storage.getSkuId().toString(), e -> e, (e1, e2) -> e1));
        ArrayList bundleItems = Lists.newArrayList();
        List<ItemSkuRespDto> itemSkuList = this.itemSkuService.queryByItemId(itemId);
        Map<Long, ItemSkuRespDto> skuEoMap = itemSkuList.stream().collect(Collectors.toMap(ItemSkuRespDto::getId, e -> e, (e1, e2) -> e1));
        List<ItemEo> subItemEos = this.queryItemByIds(subItemIds);
        Map<Long, ItemEo> itemEoMap = subItemEos.stream().collect(Collectors.toMap(BaseEo::getId, e -> e, (e1, e2) -> e1));
        for (ItemBundleRelationEo bundleItem : bundleRelationEos) {
            String subShopItem = shopId + bundleItem.getSubSkuId().toString();
            BundleItemRespDto bundleItemRespDto = new BundleItemRespDto();
            CubeBeanUtils.copyProperties((Object)bundleItemRespDto, (Object)bundleItem, (String[])new String[0]);
            if (itemEoMap.containsKey(bundleItem.getSubItemId())) {
                bundleItemRespDto.setSubItemName(itemEoMap.get(bundleItem.getSubItemId()).getName());
            }
            if (shelfMap.containsKey(subShopItem)) {
                ShelfQueryRespDto shelfQueryRespDto = shelfMap.get(subShopItem);
                bundleItemRespDto.setRetailPrice(shelfQueryRespDto.getPrice());
                bundleItemRespDto.setShelfStatus(shelfQueryRespDto.getStatus());
            }
            if (storageMap.containsKey(subShopItem)) {
                bundleItemRespDto.setStorage(storageMap.get(subShopItem).getAvaNum());
            }
            if (skuEoMap.containsKey(bundleItem.getSubSkuId())) {
                ItemSkuRespDto sku = skuEoMap.get(bundleItem.getSubSkuId());
                bundleItemRespDto.setAttr(sku.getAttr());
                bundleItemRespDto.setBarCode(sku.getBarCode());
                bundleItemRespDto.setCargoCode(sku.getCargoCode());
                bundleItemRespDto.setSubSkuCode(sku.getCode());
                BigDecimal price = sku.getItemPriceList().stream().filter(priceDto -> "PRICE".equals(priceDto.getPriceType())).map(ItemPriceRespDto::getPrice).findFirst().orElse(BigDecimal.ZERO);
                bundleItemRespDto.setPrice(price);
            }
            bundleItems.add(bundleItemRespDto);
        }
        return bundleItems;
    }

    @Override
    public List<BundleItemRespDto> queryBundleItem(Long itemId) {
        ItemBundleRelationEo param = new ItemBundleRelationEo();
        param.setItemId(itemId);
        List itemBundleRelationEos = this.itemBundleRelationDas.select((BaseEo)param);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)itemBundleRelationEos, BundleItemRespDto.class);
        return list;
    }

    @Override
    public List<BundleItemRespDto> queryBundleItem(BundleItemReqDto bundleItemReqDto) {
        ItemBundleRelationEo param = ItemBundleRelationEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)bundleItemReqDto, (BaseEo)param);
        List itemBundleRelationEos = this.itemBundleRelationDas.select((BaseEo)param);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)itemBundleRelationEos, BundleItemRespDto.class);
        return list;
    }

    @Override
    public ItemRespDto queryByItemCode(String itemCode) {
        ItemEo itemEoSelect = new ItemEo();
        itemEoSelect.setCode(itemCode);
        ItemEo itemEo = (ItemEo)this.itemDas.selectOne((BaseEo)itemEoSelect);
        ItemRespDto itemRespDto = new ItemRespDto();
        DtoHelper.eo2Dto((BaseEo)itemEo, (BaseVo)itemRespDto);
        return itemRespDto;
    }

    @Override
    public List<ItemRespDto> queryByItemLongCodes(List<String> itemCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemCodes)) {
            return null;
        }
        return this.itemDas.queryByItemLongCodes(itemCodes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyItem(ItemReqDto itemReqDto) {
        if (itemReqDto.getId() == null) {
            logger.info("\u5546\u54c1id\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u66f4\u65b0");
            return;
        }
        ItemEo itemEo = new ItemEo();
        DtoHelper.dto2Eo((BaseVo)itemReqDto, (BaseEo)itemEo);
        itemEo.setId(itemReqDto.getId());
        itemEo.setOrganizationId(itemReqDto.getOrganizationId());
        this.itemDas.updateSelective((BaseEo)itemEo);
        if (StringUtils.isNotEmpty((CharSequence)itemReqDto.getAttrs())) {
            this.itemAttributesService.removeByItemId(itemReqDto.getId());
            String attrs = itemReqDto.getAttrs();
            ItemAttributesEo itemAttributesEo = new ItemAttributesEo();
            itemAttributesEo.setItemId(itemReqDto.getId());
            itemAttributesEo.setAttrs(attrs);
            this.itemAttributesService.addProp(itemAttributesEo);
        }
    }

    @Override
    public List<DirItemRelativeQueryRespDto> queryItemDirRelativeBatch(List<Long> itemIds, List<Long> shopIds, List<Integer> busTypes) {
        List list = this.dirItemRelationDas.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(StdDirItemRelationEo::getItemId, itemIds)).in(StdDirItemRelationEo::getShopId, shopIds)).in(StdDirItemRelationEo::getBusType, busTypes)).eq(BaseEo::getDr, (Object)0)).eq(StdDirItemRelationEo::getDirType, (Object)"front"));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            List dirIdList = list.stream().map(StdDirItemRelationEo::getDirId).distinct().collect(Collectors.toList());
            Map<Object, Object> dirMap = Maps.newHashMap();
            List dirEoList = this.dirDas.selectByIds(dirIdList);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dirEoList)) {
                dirMap = dirEoList.stream().collect(Collectors.toMap(BaseEo::getId, StdDirEo::getName));
            }
            HashMap finalDirMap = dirMap;
            return list.stream().map(dirItemRelation -> {
                DirItemRelativeQueryRespDto itemDirQueryRespDto = new DirItemRelativeQueryRespDto();
                BeanUtils.copyProperties((Object)dirItemRelation, (Object)itemDirQueryRespDto);
                if (finalDirMap.get(dirItemRelation.getDirId()) != null) {
                    itemDirQueryRespDto.setDirName((String)finalDirMap.get(dirItemRelation.getDirId()));
                }
                return itemDirQueryRespDto;
            }).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ItemSkuRelRespDto> queryItemSkuRelByCodes(List<String> itemCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemCodes)) {
            throw new BizException("\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.itemDas.queryItemSkuRelByCodes(itemCodes);
    }

    @Override
    public List<ItemSkuRelRespDto> queryItemSkuByItemCodes(List<String> itemCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemCodes)) {
            throw new BizException("\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.itemDas.queryItemSkuByItemCodes(itemCodes);
    }

    @Override
    public List<ItemSkuRelRespDto> queryItemSkuBySkuCodes(List<String> skuCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(skuCodes)) {
            throw new BizException("sku\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.itemDas.queryItemSkuBySkuCodes(skuCodes);
    }

    @Override
    public List<ItemDetailRespDto> listItemDetail(ItemDetailReqDto itemDetailReqDto) {
        logger.info("\u67e5\u8be2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u5217\u8868 itemDetailReqDto : {}", (Object)itemDetailReqDto);
        List itemList = this.itemDas.selectByIds(itemDetailReqDto.getItemIds());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemList)) {
            return Collections.emptyList();
        }
        ArrayList itemDetailList = Lists.newArrayList();
        ItemRespDto itemDto = null;
        for (ItemEo itemEo : itemList) {
            ItemDetailRespDto itemDetailDto = new ItemDetailRespDto();
            List<ItemPropRelationRespDto> itemPropRelationRespDtos = this.propService.queryByItemId(itemEo.getId());
            itemDetailDto.setItemPropRelationRespDtos(itemPropRelationRespDtos);
            String propGroupInfo = itemEo.getPropGroupInfo();
            if (StringUtils.isNotBlank((CharSequence)propGroupInfo)) {
                List propGroupDtoList = JSON.parseArray((String)propGroupInfo, ItemPropGroupDto.class);
                itemDetailDto.setPropGroupDtoList(propGroupDtoList);
            }
            itemDto = new ItemRespDto();
            BeanUtil.copyProperties((Object)itemEo, (Object)itemDto, (String[])new String[0]);
            itemDto.setItemId(itemEo.getId());
            itemDetailDto = new ItemDetailRespDto();
            itemDetailDto.setItem(itemDto);
            itemDetailList.add(itemDetailDto);
            itemDetailDto = null;
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemDetailReqDto.getFields())) {
            return itemDetailList;
        }
        for (String field : itemDetailReqDto.getFields()) {
            if (field.contains("sku")) {
                this.setItemSku(itemDetailList, itemDetailReqDto.getItemIds());
            }
            if (field.contains("attributes")) {
                this.setItemAttributes(itemDetailList, itemDetailReqDto.getItemIds());
            }
            if (!field.contains("medias")) continue;
            this.setItemMedias(itemDetailList, itemDetailReqDto.getItemIds());
        }
        for (ItemDetailRespDto itemDetailDto : itemDetailList) {
            List shopDirIdList;
            List<DirsItemsRespDto> dirsItemsRespDtos = this.dirItemRelationService.queryList(itemDetailDto.getItem().getItemId(), itemDetailReqDto.getShopId());
            itemDetailDto.setDirsItemsList(dirsItemsRespDtos);
            if (StringUtils.isNotBlank((CharSequence)itemDetailDto.getItem().getSaleChannel())) {
                itemDetailDto.setSaleChannels(Arrays.asList(itemDetailDto.getItem().getSaleChannel().split("-")));
            }
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(shopDirIdList = dirsItemsRespDtos.stream().filter(dirsItemsRespDto -> Objects.equals("shop", dirsItemsRespDto.getDirType())).map(DirsItemsRespDto::getDirId).collect(Collectors.toList()))) continue;
            DirEo dirEo = DirEo.newInstance();
            dirEo.setId((Long)shopDirIdList.get(0));
            dirEo = (DirEo)this.dirDas.selectOne((BaseEo)dirEo);
            itemDetailDto.setShopDirId(dirEo.getId());
            itemDetailDto.setShopDirName(dirEo.getName());
        }
        logger.info("\u67e5\u8be2\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u8fd4\u56de ItemDetailRespDto : {}", (Object)itemDetailList);
        return itemDetailList;
    }

    private void setItemSku(List<ItemDetailRespDto> itemDetailList, List<Long> itemIds) {
        Map<Long, List<ItemSkuRespDto>> skuMap = this.getItemSkuDtoMap(this.itemSkuService.queryDetailsByItemIds(itemIds));
        for (ItemDetailRespDto itemDetail : itemDetailList) {
            itemDetail.setItemSkuList(skuMap.get(itemDetail.getItem().getId()));
        }
    }

    private void setItemAttributes(List<ItemDetailRespDto> itemDetailList, List<Long> itemIds) {
        List<ItemAttributesEo> itemAttributesList = this.itemAttributesService.queryByItemIds(itemIds);
        ItemAttributesRespDto itemAttributesRespDto = null;
        for (ItemDetailRespDto itemDetail : itemDetailList) {
            itemDetail.setItemAttributesList((List)Lists.newArrayList());
            for (ItemAttributesEo itemAttribute : itemAttributesList) {
                if (!Objects.equals(itemDetail.getItem().getId(), itemAttribute.getItemId())) continue;
                itemAttributesRespDto = new ItemAttributesRespDto();
                BeanUtil.copyProperties((Object)itemAttribute, (Object)itemAttributesRespDto, (String[])new String[0]);
                itemDetail.getItemAttributesList().add(itemAttributesRespDto);
            }
        }
    }

    private void setItemMedias(List<ItemDetailRespDto> itemDetailList, List<Long> itemIds) {
        List<ItemMediasRespDto> itemMediasList = this.itemMediasService.queryByItemIds(itemIds);
        for (ItemDetailRespDto itemDetail : itemDetailList) {
            itemDetail.setItemMediasList((List)Lists.newArrayList());
            for (ItemMediasRespDto itemMedia : itemMediasList) {
                if (!Objects.equals(itemDetail.getItem().getId(), itemMedia.getItemId())) continue;
                itemDetail.getItemMediasList().add(itemMedia);
            }
        }
    }
}

