/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.opensearch.api.IIndicesAdminService;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.ShapeType;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.utils.CustomBeanUtils;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.GeoShapeFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocContentVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocumentVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.QueryFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ShelfStatusEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.DistributionFeeDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.ItemMessage;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSearchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.CoordinateDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSearchRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShopRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.LocationDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.TemplateRegionRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.mq.ItemShelfProducer;
import com.dtyunxi.yundt.cube.center.item.biz.base.mq.vo.ItemSearchIndexMessageVo;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDistributionSetService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSearchService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.ConvertUtil;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemAttributesDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.StatDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemAttributesEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StatEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdDirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemAttributesEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdStatEo;
import com.dtyunxi.yundt.cube.center.shop.api.IShopApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDeliveryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.GeoDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ResourceUtils;

@Component
@MQDesc(tag="ITEM_SEARCH_INDEX")
public class ItemSearchServiceImpl
implements IItemSearchService,
IMessageProcessor {
    private Logger logger = LoggerFactory.getLogger(ItemSearchServiceImpl.class);
    @Value(value="${huieryun.searchindexbuilder.indexname.prefix}")
    private String INDEX_ITEM;
    @Value(value="${cube.global.profile:dev}")
    private String globalProfile;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ItemDas itemDas;
    @Resource
    private IItemService itemService;
    @Resource
    private StatDas statDas;
    @Resource
    private ShelfDas shelfDas;
    @Resource
    private ItemAttributesDas itemAttributesDas;
    @Resource
    private DirItemRelationDas dirItemRelationDas;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource(name="restSearchExtService")
    private IOpenSearchService openSearchService;
    @Resource
    private ISearchIndexService searchIndexService;
    @Resource
    private IIndicesAdminService indicesAdminService;
    @Resource
    private IShopApi shopApi;
    @Resource
    private ItemShelfProducer itemShelfProducer;
    @Value(value="${huieryun.searchindexbuilder.item.indexname:item_search}")
    private String indexName;
    @Value(value="${huieryun.searchindexbuilder.item.indextype:item_search}")
    private String indexType;

    @Deprecated
    public void initIndex() {
        if (this.indicesAdminService.existsIndex(new String[]{this.getIndexName()})) {
            this.logger.info("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15{}\u5df2\u5b58\u5728\uff0c\u4e0d\u518d\u8fdb\u884c\u81ea\u52a8\u521b\u5efa=====", (Object)this.getIndexName());
        }
        String mapping = null;
        try {
            File jsonFile = ResourceUtils.getFile((String)"classpath:item_index_mapping.json");
            mapping = FileUtils.readFileToString((File)jsonFile, (String)"utf-8");
        }
        catch (Exception e) {
            this.logger.info("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
        }
        this.logger.info("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15\u6587\u4ef6\u5185\u5bb9 {}", (Object)mapping);
        if (StringUtils.isBlank((CharSequence)mapping)) {
            this.logger.info("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15mapping\u4e3a\u7a7a\uff0c\u81ea\u52a8\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u521d\u59cb\u5316es\u76f8\u5173\u64cd\u4f5c=====", (Object)this.getIndexName());
            return;
        }
        try {
            this.logger.info("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15{}\u81ea\u52a8\u521b\u5efa\u6210\u529f=====", (Object)this.getIndexName());
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15{}\u81ea\u52a8\u521b\u5efa\u5931\u8d25", (Throwable)e);
        }
        try {
            this.indicesAdminService.putMapping(this.getIndexName() + "ws", "item_search", mapping.toString());
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15mapping\u8bbe\u7f6e\u5931\u8d25", (Throwable)e);
        }
    }

    private String getIndexName() {
        return this.INDEX_ITEM + "_" + "item_search";
    }

    @Override
    public void index(long sellerId, long itemId, int busType, String operation) {
        this.logger.info("\u540c\u6b65\u5546\u54c1\u4fe1\u606f\u5230ES,sellerId:{},itemId:{},busType:{},operation:{}", new Object[]{sellerId, itemId, busType, operation});
        this.index(sellerId, itemId, busType, operation, 0);
    }

    @Override
    public void indexSyn(long sellerId, long itemId, int busType, String operation) {
        this.logger.info("\u540c\u6b65\u5546\u54c1\u4fe1\u606f\u5230ES,sellerId:{},itemId:{},busType:{},operation:{}", new Object[]{sellerId, itemId, busType, operation});
        this.indexSyn(sellerId, itemId, busType, operation, 0);
    }

    private void index(Long sellerId, Long itemId, Integer busType, String operation, int retry) {
        if (retry > 3) {
            this.logger.error("\u7d22\u5f15\u91cd\u590d\u6784\u5efa\u8d85\u8fc73\u6b21\uff0c\u5546\u54c1ID\u4e3a:{}\u8bf7\u68c0\u67e5", (Object)itemId);
            return;
        }
        ItemSearchIndexMessageVo itemSearchIndexMessageVo = new ItemSearchIndexMessageVo(sellerId, itemId, busType, operation, retry);
        itemSearchIndexMessageVo.setMessageId(this.generateId());
        this.refreshIndex(itemSearchIndexMessageVo);
        this.logger.info("\u5f00\u59cb\u53d1\u9001es\u540c\u6b65\u6d88\u606f\uff0cmessage:{}", (Object)JSON.toJSONString((Object)itemSearchIndexMessageVo));
        this.commonsMqService.sendSingleMessage("ITEM_SEARCH_INDEX", (Object)JSON.toJSONString((Object)itemSearchIndexMessageVo));
    }

    private void indexSyn(Long sellerId, Long itemId, Integer busType, String operation, int retry) {
        if (retry > 3) {
            this.logger.error("\u7d22\u5f15\u91cd\u590d\u6784\u5efa\u8d85\u8fc73\u6b21\uff0c\u5546\u54c1ID\u4e3a:{}\u8bf7\u68c0\u67e5", (Object)itemId);
            return;
        }
        ItemSearchIndexMessageVo itemSearchIndexMessageVo = new ItemSearchIndexMessageVo(sellerId, itemId, busType, operation, retry);
        this.refreshIndex(itemSearchIndexMessageVo);
    }

    @Override
    public ItemSearchRespDto query(ItemSearchQueryReqDto itemSearchQueryReqDto, Integer pageNum, Integer pageSize) {
        if (itemSearchQueryReqDto.getType() == null) {
            itemSearchQueryReqDto.setType(itemSearchQueryReqDto.getItemType());
        }
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.setPage(pageNum.intValue());
        osSearchVo.setPageSize(pageSize.intValue());
        if (itemSearchQueryReqDto.getTenantId() != null) {
            osSearchVo.addEqualFilter("tenantId", String.valueOf(itemSearchQueryReqDto.getTenantId()));
        }
        if (itemSearchQueryReqDto.getInstanceId() != null) {
            osSearchVo.addEqualFilter("instanceId", String.valueOf(itemSearchQueryReqDto.getInstanceId()));
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getKeyword())) {
            QueryFieldVo queryFieldVo = QueryFieldVo.query((String)itemSearchQueryReqDto.getKeyword(), (String[])new String[]{"name", "displayName", "brand", "code"});
            queryFieldVo.setEscape(true);
            osSearchVo.addQueries(new QueryFieldVo[]{queryFieldVo});
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getItemCode())) {
            osSearchVo.addEqualFilter("code", itemSearchQueryReqDto.getItemCode());
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getItemSkuCode())) {
            osSearchVo.addEqualFilter("itemSkuList.code", itemSearchQueryReqDto.getItemSkuCode());
        }
        if (itemSearchQueryReqDto.getBackDirId() != null) {
            osSearchVo.addEqualFilter("dirId", String.valueOf(itemSearchQueryReqDto.getBackDirId()));
        }
        if (itemSearchQueryReqDto.getType() != null) {
            osSearchVo.addEqualFilter("type", String.valueOf(itemSearchQueryReqDto.getType()));
        }
        if (Objects.nonNull(itemSearchQueryReqDto.getSubType())) {
            osSearchVo.addEqualFilter("subType", String.valueOf(itemSearchQueryReqDto.getSubType()));
        }
        if (CollUtil.isNotEmpty((Collection)itemSearchQueryReqDto.getSubTypeList())) {
            osSearchVo.addInFilter("subType", ConvertUtil.convert2Array(itemSearchQueryReqDto.getSubTypeList()));
        }
        if (itemSearchQueryReqDto.getType() == null && itemSearchQueryReqDto.getNeType() != null) {
            osSearchVo.addNonEqualFilter("type", String.valueOf(itemSearchQueryReqDto.getType()));
        }
        if (CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getBusTypeList())) {
            if (itemSearchQueryReqDto.getBusType() != null) {
                osSearchVo.addEqualFilter("busType", String.valueOf(itemSearchQueryReqDto.getBusType()));
            }
        } else {
            String[] buyTypes = ConvertUtil.convert2Array(itemSearchQueryReqDto.getBusTypeList());
            osSearchVo.addInFilter("busType", buyTypes);
        }
        if (itemSearchQueryReqDto.getBrandId() != null) {
            osSearchVo.addEqualFilter("brandId", String.valueOf(itemSearchQueryReqDto.getBrandId()));
        }
        if (itemSearchQueryReqDto.getStatus() != null) {
            osSearchVo.addInFilter("itemShelfInfoList.status", new String[]{String.valueOf(itemSearchQueryReqDto.getStatus())});
        }
        if (itemSearchQueryReqDto.getStatus() == null && BooleanUtils.isTrue((Boolean)itemSearchQueryReqDto.getIsOffShelf())) {
            osSearchVo.addInFilter("itemShelfInfoList.status", new String[]{String.valueOf(ShelfStatusEnum.ON_SHELF.getCode())});
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getInBrandIds())) {
            String[] inBrandIds = ConvertUtil.convert2Array(itemSearchQueryReqDto.getInBrandIds());
            String[] compound = FilterFieldVo.compound((LogicalSymbol)LogicalSymbol.AND);
            FilterFieldVo in = FilterFieldVo.in((String)"brandId", (String[])inBrandIds);
            in.setLogicalSymbol(LogicalSymbol.OR);
            FilterFieldVo equal = FilterFieldVo.equal((String)"brandId", (String)"0");
            equal.setLogicalSymbol(LogicalSymbol.OR);
            compound.addSubFilterFieldVos(new FilterFieldVo[]{in, equal});
            osSearchVo.addFilters(new FilterFieldVo[]{compound});
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getItemIds())) {
            String[] itemIds = ConvertUtil.convert2Array(itemSearchQueryReqDto.getItemIds());
            osSearchVo.addInFilter("item_id", itemIds);
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getInItemIds())) {
            String[] inItemIds = ConvertUtil.convert2Array(itemSearchQueryReqDto.getInItemIds());
            osSearchVo.addInFilter("item_id", inItemIds);
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getOutItemIds())) {
            String[] outInItemIds = ConvertUtil.convert2Array(itemSearchQueryReqDto.getOutItemIds());
            osSearchVo.addNonInFilter("item_id", outInItemIds);
        }
        if (itemSearchQueryReqDto.getSellerId() != null) {
            String sellerId = String.valueOf(itemSearchQueryReqDto.getSellerId());
            osSearchVo.addEqualFilter("dirsItemsList.sellerId", sellerId);
        }
        if (itemSearchQueryReqDto.getShopId() != null) {
            String shopId = String.valueOf(itemSearchQueryReqDto.getShopId());
            osSearchVo.addEqualFilter("itemShopList.shopId", shopId);
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getShopIds())) {
            String[] shopIds = ConvertUtil.convert2Array(itemSearchQueryReqDto.getShopIds());
            osSearchVo.addInFilter("itemShopList.shopId", shopIds);
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getDirIds())) {
            String[] dirIds = ConvertUtil.convert2Array(itemSearchQueryReqDto.getDirIds());
            osSearchVo.addInFilter("dirsItemsList.dirId", dirIds);
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getProp())) {
            String[] props;
            for (String prop : props = itemSearchQueryReqDto.getProp().split(";")) {
                String[] searchData = prop.split(":");
                osSearchVo.addInFilter("searchAttr.searchAttr.name", searchData);
            }
        }
        if (itemSearchQueryReqDto.getLat() != null && itemSearchQueryReqDto.getLon() != null) {
            GeoShapeFieldVo.PointType pointType = new GeoShapeFieldVo.PointType(itemSearchQueryReqDto.getLat().doubleValue(), itemSearchQueryReqDto.getLon().doubleValue());
            GeoShapeFieldVo geoShapeFieldVo = new GeoShapeFieldVo("itemShopList.templateRegionList", ShapeType.POINT, pointType);
            osSearchVo.addGeoShapeQuery(new GeoShapeFieldVo[]{geoShapeFieldVo});
        }
        if (itemSearchQueryReqDto.getMinPrice() != null || itemSearchQueryReqDto.getMaxPrice() != null) {
            if (itemSearchQueryReqDto.getMinPrice() != null && itemSearchQueryReqDto.getMaxPrice() != null) {
                osSearchVo.addRangeFilter("minPrice", String.valueOf(itemSearchQueryReqDto.getMinPrice()), String.valueOf(itemSearchQueryReqDto.getMaxPrice()));
            } else {
                osSearchVo.addRangeFilter("minPrice", String.valueOf(itemSearchQueryReqDto.getMinPrice()), String.valueOf(itemSearchQueryReqDto.getMaxPrice()), LogicalSymbol.OR);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getOrderByDesc())) {
            if ("sales".equalsIgnoreCase(itemSearchQueryReqDto.getOrderByDesc())) {
                osSearchVo.addSort("salesCount");
            } else if ("price".equalsIgnoreCase(itemSearchQueryReqDto.getOrderByDesc())) {
                osSearchVo.addSort("minPrice");
            } else if ("shelfTime".equalsIgnoreCase(itemSearchQueryReqDto.getOrderByDesc())) {
                osSearchVo.addSort("itemShelfInfoList.shelfTime");
            } else if ("code".equalsIgnoreCase(itemSearchQueryReqDto.getOrderByDesc())) {
                osSearchVo.addSort("code");
            }
        } else if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getOrderBy())) {
            if ("sales".equalsIgnoreCase(itemSearchQueryReqDto.getOrderBy())) {
                osSearchVo.addSort("salesCount", SortOrder.ASC);
            } else if ("price".equalsIgnoreCase(itemSearchQueryReqDto.getOrderBy())) {
                osSearchVo.addSort("minPrice", SortOrder.ASC);
            } else if ("shelfTime".equalsIgnoreCase(itemSearchQueryReqDto.getOrderBy())) {
                osSearchVo.addSort("itemShelfInfoList.shelfTime", SortOrder.ASC);
            } else if ("code".equalsIgnoreCase(itemSearchQueryReqDto.getOrderBy())) {
                osSearchVo.addSort("code", SortOrder.ASC);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getUpdateBeginTime()) && StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getUpdateEndTime())) {
            osSearchVo.addRangeFilter("updateTime", itemSearchQueryReqDto.getUpdateBeginTime(), itemSearchQueryReqDto.getUpdateEndTime());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u5546\u54c1\u641c\u7d22\u53c2\u6570osSearchVo={}", (Object)JSON.toJSONString((Object)osSearchVo));
        }
        SearchResultVo searchResultVo = this.search(osSearchVo);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u5546\u54c1\u641c\u7d22\u7ed3\u679csearchResultVo={}", (Object)JSON.toJSONString((Object)searchResultVo));
        }
        ItemSearchRespDto itemSearchRespDto = new ItemSearchRespDto();
        if (searchResultVo == null) {
            return itemSearchRespDto;
        }
        List itemRespDtoList = searchResultVo.getDocValues(docValue -> (ItemRespDto)BeanUtil.mapToBean((Map)docValue, ItemRespDto.class, (boolean)true));
        this.handleItemShop(itemRespDtoList, itemSearchRespDto, itemSearchQueryReqDto);
        itemRespDtoList = itemRespDtoList.stream().filter(itemRespDto -> null != itemRespDto.getShopId()).peek(itemRespDto -> {
            try {
                this.setShelfType((ItemRespDto)itemRespDto);
                this.setMinDistributionInfo((ItemRespDto)itemRespDto, itemSearchQueryReqDto.getDistribType());
            }
            catch (Exception e) {
                this.logger.info("\u8bbe\u7f6e\u5f02\u5e38", (Throwable)e);
            }
        }).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(pageNum.intValue());
        pageInfo.setPageSize(pageSize.intValue());
        pageInfo.setSize(itemRespDtoList.size());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setList(itemRespDtoList);
        itemSearchRespDto.setPageInfo(pageInfo);
        return itemSearchRespDto;
    }

    private void handleItemShop(List<ItemRespDto> itemRespDtoList, ItemSearchRespDto searchRespDto, ItemSearchQueryReqDto searchQueryReqDto) {
        if (null != searchQueryReqDto.getShopId()) {
            itemRespDtoList.forEach(itemRespDto -> itemRespDto.setShopId(searchQueryReqDto.getShopId()));
            return;
        }
        if (searchQueryReqDto.getLat() != null && searchQueryReqDto.getLon() != null) {
            List<ItemShopRespDto> rangeShopList = this.getRangeShopList(searchQueryReqDto.getLon(), searchQueryReqDto.getLat());
            if (!CollectionUtils.isEmpty(rangeShopList)) {
                searchRespDto.setRangeShopList(rangeShopList.stream().map(ItemShopRespDto::getShopId).collect(Collectors.toList()));
            }
            itemRespDtoList.forEach(itemRespDto -> this.setMiniDistantShop((ItemRespDto)itemRespDto, rangeShopList));
        } else {
            itemRespDtoList.forEach(itemRespDto -> itemRespDto.setShopId(((ItemShopRespDto)itemRespDto.getItemShopList().get(0)).getShopId()));
        }
    }

    private void setMinDistributionInfo(ItemRespDto itemRespDto, Integer distribType) {
        if (!CollectionUtils.isEmpty((Collection)itemRespDto.getItemShelfInfoList())) {
            List shelfRespDtos = itemRespDto.getItemShelfInfoList().stream().filter(shelfDto -> shelfDto.getShopId().equals(itemRespDto.getShopId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(shelfRespDtos)) {
                if (Integer.valueOf(1).equals(((ItemShelfRespDto)shelfRespDtos.get(0)).getDistribution())) {
                    itemRespDto.setDistribution(Integer.valueOf(1));
                    if (!CollectionUtils.isEmpty((Collection)itemRespDto.getDistributionFeeList())) {
                        if (distribType != null) {
                            ArrayList targetDistributionFeeDtos = Lists.newArrayList();
                            for (DistributionFeeDto distributionFeeDto : itemRespDto.getDistributionFeeList()) {
                                if (!distribType.equals(distributionFeeDto.getDistribType())) continue;
                                targetDistributionFeeDtos.add(distributionFeeDto);
                            }
                            if (distribType.equals(2) && CollectionUtils.isEmpty((Collection)targetDistributionFeeDtos)) {
                                this.logger.info("\u5f53\u524d\u67e5\u8be2\u7528\u6237\u4e3a\u52a0\u4ef7\u5206\u9500\u5458\uff0c\u5f53\u524d\u5546\u54c1\u52a0\u4ef7\u9884\u4f30\u4f63\u91d1\u4e3a\u7a7a\uff0citemId={}, shopId={},distribType: {}", new Object[]{itemRespDto.getItemId(), itemRespDto.getShopId(), distribType});
                                return;
                            }
                        }
                        BigDecimal min = itemRespDto.getDistributionFeeList().stream().filter(feeDto -> feeDto.getShopId() != null && feeDto.getShopId().equals(itemRespDto.getShopId())).map(DistributionFeeDto::getAmount).sorted().findFirst().orElse(BigDecimal.ZERO);
                        itemRespDto.setDistributionFee(min);
                    } else {
                        this.logger.info("\u5546\u54c1\u5206\u9500\u4f63\u91d1\u4e3a\u7a7a\uff0citemId={}, shopId={}", (Object)itemRespDto.getItemId(), (Object)itemRespDto.getShopId());
                    }
                }
            } else {
                this.logger.info("\u5546\u54c1\u4e0a\u67b6\u8bb0\u5f55\u4e3a\u7a7a\uff0citemId={}, shopId={}", (Object)itemRespDto.getItemId(), (Object)itemRespDto.getShopId());
            }
        }
    }

    private Long getMiniDistanceShopId(Map<Long, List<ItemShopRespDto>> shopRespDtoMap, List<ItemShopRespDto> sortShopList) {
        for (ItemShopRespDto itemShopRespDto : sortShopList) {
            if (shopRespDtoMap.get(itemShopRespDto.getShopId()) == null) continue;
            return itemShopRespDto.getShopId();
        }
        return null;
    }

    private Long getShippingShopId(List<ItemShopRespDto> itemShopList) {
        for (ItemShopRespDto itemShopRespDto : itemShopList) {
            if (itemShopRespDto.getBusinessType() == null || !itemShopRespDto.getBusinessType().equals(1)) continue;
            return itemShopRespDto.getShopId();
        }
        return null;
    }

    private List<ItemShopRespDto> getRangeShopList(Double lon, Double lat) {
        List shopEsDtos = (List)this.shopApi.queryRangeShopListByGeo(String.valueOf(lat), String.valueOf(lon), Boolean.valueOf(true)).getData();
        if (CollectionUtils.isEmpty((Collection)shopEsDtos)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList shopRespDtos = Lists.newArrayList();
        shopEsDtos.forEach(shopEsDto -> {
            ItemShopRespDto itemShopRespDto = new ItemShopRespDto();
            CubeBeanUtils.copyProperties((Object)itemShopRespDto, (Object)shopEsDto, (String[])new String[]{"location", "templateRegionList"});
            if (!CollectionUtils.isEmpty((Collection)shopEsDto.getLocation())) {
                ArrayList location = Lists.newArrayList();
                shopEsDto.getLocation().forEach(locationDto -> {
                    LocationDto respDto = new LocationDto();
                    respDto.setLat(locationDto.getLat());
                    respDto.setLon(locationDto.getLon());
                });
                itemShopRespDto.setLocation((List)location);
            }
            if (!CollectionUtils.isEmpty((Collection)shopEsDto.getTemplateRegionList())) {
                ArrayList templateRegionList = Lists.newArrayList();
                shopEsDto.getTemplateRegionList().forEach(templateRegionRespDto -> {
                    TemplateRegionRespDto regionRespDto = new TemplateRegionRespDto();
                    regionRespDto.setCoordinates(templateRegionRespDto.getCoordinates());
                    regionRespDto.setType(templateRegionRespDto.getType());
                    regionRespDto.setWarehouseId(templateRegionRespDto.getWarehouseId());
                    templateRegionList.add(regionRespDto);
                });
                itemShopRespDto.setTemplateRegionList((List)templateRegionList);
            }
            shopRespDtos.add(itemShopRespDto);
        });
        return shopRespDtos;
    }

    private Long getShopId(List<ItemShopRespDto> itemShopList, Map<Long, List<ItemShopRespDto>> shopRespDtoMap, List<ItemShopRespDto> sortShop) {
        Long miniDistanceShopId = null;
        if (!CollectionUtils.isEmpty(sortShop)) {
            miniDistanceShopId = this.getMiniDistanceShopId(shopRespDtoMap, sortShop);
        }
        if (miniDistanceShopId == null) {
            return this.getShippingShopId(itemShopList);
        }
        return miniDistanceShopId;
    }

    private void setMiniDistantShop(ItemRespDto itemRespDto, List<ItemShopRespDto> sortShopList) {
        List itemShopList = itemRespDto.getItemShopList();
        Map<Long, List<ItemShopRespDto>> shopRespDtoMap = itemShopList.stream().collect(Collectors.groupingBy(ItemShopRespDto::getShopId));
        itemRespDto.setShopId(this.getShopId(itemShopList, shopRespDtoMap, sortShopList));
    }

    private void setShelfType(ItemRespDto itemRespDto) {
        List<ItemShopRespDto> itemShopRespDtos;
        Map<Long, List<ItemShopRespDto>> shopRespDtoMap = itemRespDto.getItemShopList().stream().collect(Collectors.groupingBy(ItemShopRespDto::getShopId));
        if (itemRespDto.getShopId() != null && !CollectionUtils.isEmpty(itemShopRespDtos = shopRespDtoMap.get(itemRespDto.getShopId()))) {
            itemRespDto.setShelfType(itemShopRespDtos.get(0).getShelfType());
        }
    }

    @Override
    public void sync() {
        this.logger.info("\u5546\u54c1\u6570\u636e\u5168\u91cf\u540c\u6b65\u8d5e\u672a\u5b9e\u73b0=====");
    }

    @Override
    public MessageResponse process(Object object) {
        if (object == null) {
            this.logger.error("\u63a5\u53d7\u5230\u7a7a\u7684MQ\u6d88\u606f");
            return MessageResponse.SUCCESS;
        }
        try {
            ItemSearchIndexMessageVo itemSearchIndexMessageVo = (ItemSearchIndexMessageVo)JSON.parseObject((String)object.toString(), ItemSearchIndexMessageVo.class);
            this.logger.info("\u5f00\u59cb\u5904\u7406es\u540c\u6b65\u6d88\u606f\uff0cmessageId\uff1a{}", (Object)itemSearchIndexMessageVo.getMessageId());
            switch (itemSearchIndexMessageVo.getOperation()) {
                case "ON_SHELF": {
                    this.refreshIndex(itemSearchIndexMessageVo);
                    break;
                }
                case "OFF_SHELF": {
                    this.refreshIndex(itemSearchIndexMessageVo);
                    break;
                }
                case "SALES_COUNT": {
                    this.refreshIndex(itemSearchIndexMessageVo);
                    break;
                }
                default: {
                    this.logger.error("\u672a\u77e5\u7684\u6d88\u606f\u5904\u7406\u7c7b\u578b:{}", (Object)JSON.toJSONString((Object)itemSearchIndexMessageVo));
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u540c\u6b65\u5230es\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }

    private List<ItemShopRespDto> getShopList(Set<Long> shopIds, List<ItemShelfRespDto> itemShelfRespDtos) {
        Map<Long, List<ItemShelfRespDto>> shopItemShelfMap = itemShelfRespDtos.stream().collect(Collectors.groupingBy(ItemShelfRespDto::getShopId));
        ArrayList<ItemShopRespDto> itemShopList = new ArrayList<ItemShopRespDto>();
        for (Long shopId : shopIds) {
            GeoDto geoDto;
            ShopDto shopDto = (ShopDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryById(shopId.longValue(), new String[0]));
            ItemShopRespDto itemShopRespDto = new ItemShopRespDto();
            itemShopRespDto.setShopId(shopId);
            itemShopRespDto.setBusinessType(shopDto.getBusinessType());
            List<ItemShelfRespDto> shopItemSelfList = shopItemShelfMap.get(shopId);
            if (!CollectionUtils.isEmpty(shopItemSelfList)) {
                Integer type = shopItemSelfList.get(0).getType();
                itemShopRespDto.setShelfType(type);
            }
            if (itemShopRespDto.getBusinessType() == null) {
                itemShopRespDto.setBusinessType(Integer.valueOf(shopDto.getType().intValue()));
            }
            ArrayList<LocationDto> locationDtos = new ArrayList<LocationDto>();
            if (2 == itemShopRespDto.getBusinessType()) {
                geoDto = this.getShopDeliveryGeo(shopDto);
            } else {
                geoDto = new GeoDto();
                geoDto.setLongitude("-99.140625");
                geoDto.setLatitude("-40.044438");
            }
            if (null != geoDto) {
                LocationDto locationDto = new LocationDto();
                locationDto.setLon(Double.valueOf(geoDto.getLongitude()));
                locationDto.setLat(Double.valueOf(geoDto.getLatitude()));
                locationDtos.add(locationDto);
            }
            itemShopRespDto.setLocation(locationDtos);
            List<TemplateRegionRespDto> templateRegionList = 2 == itemShopRespDto.getBusinessType() ? this.getTemplateRegionRespDtoList(shopDto) : this.getRegionShippingList();
            itemShopRespDto.setTemplateRegionList(templateRegionList);
            itemShopList.add(itemShopRespDto);
        }
        return itemShopList;
    }

    private void createOrUpdateIndexGroupBySeller(ItemSearchIndexMessageVo itemSearchIndexMessageVo, ItemEo itemEo, List<ItemShelfRespDto> itemShelfRespDtos) {
        Long sellerId = itemSearchIndexMessageVo.getSellerId();
        this.logger.info("\u5546\u5bb6-\u5546\u54c1-\u4e1a\u52a1\u7c7b\u578b\u7ef4\u5ea6\u6784\u5efaES\u5546\u54c1\u6570\u636esellerId:{}\uff0citemId:{}, busType:{}", new Object[]{sellerId, itemSearchIndexMessageVo.getItemId(), itemSearchIndexMessageVo.getBusType()});
        List<ItemRespDto> itemRespDtoList = this.itemService.queryItemRespDto(Lists.newArrayList((Object[])new ItemEo[]{itemEo}), sellerId);
        if (CollectionUtils.isEmpty(itemRespDtoList)) {
            this.logger.error("\u6784\u5efa\u5546\u54c1\u6570\u636e\u5931\u8d25\uff0c\u5546\u54c1ID:{}\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)itemSearchIndexMessageVo.getItemId());
            return;
        }
        ItemRespDto itemRespDto = itemRespDtoList.get(0);
        itemRespDto.setItemShelfInfoList(itemShelfRespDtos);
        this.buildSaleCount(itemRespDto);
        this.buildSearchAttr(itemRespDto);
        this.buildPrice(itemRespDto, itemShelfRespDtos);
        Set<Long> itemShopIdSet = itemShelfRespDtos.stream().map(ItemShelfRespDto::getShopId).collect(Collectors.toSet());
        itemRespDto.setItemShopList(this.getShopList(itemShopIdSet, itemShelfRespDtos));
        itemRespDto.setType(itemShelfRespDtos.get(0).getItemType());
        itemRespDto.setBusType(itemShelfRespDtos.get(0).getBusType());
        itemRespDto.setItemId(itemRespDto.getId());
        String groupKey = this.getIndexDocId(itemSearchIndexMessageVo.getSellerId(), itemSearchIndexMessageVo.getItemId(), itemSearchIndexMessageVo.getBusType());
        itemRespDto.setGroupKey(groupKey);
        IDistributionSetService distributionSetService = (IDistributionSetService)SpringBeanUtil.getBean(IDistributionSetService.class);
        if (null != distributionSetService) {
            List<DistributionFeeDto> feeDtos = distributionSetService.calculateFee(itemShelfRespDtos);
            itemRespDto.setDistributionFeeList(feeDtos);
        }
        this.logger.info("\u6784\u9020\u5546\u54c1es\u53c2\u6570itemRespDto={}", JSON.toJSON((Object)itemRespDto));
        try {
            long totalSize;
            OSSearchVo osSearchVo = new OSSearchVo();
            osSearchVo.addEqualFilter("id", itemRespDto.getGroupKey());
            SearchResultVo searchResultVo = this.search(osSearchVo);
            long l = totalSize = searchResultVo == null ? 0L : searchResultVo.getTotalSize();
            if (totalSize == 0L) {
                this.create(itemRespDto);
            } else {
                this.update(itemRespDto);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u540c\u6b65\u5230ES\u51fa\u73b0\u5f02\u5e38,\u5e76\u4e14\u91cd\u65b0\u53d1\u9001MQ", (Throwable)e);
            this.index(itemSearchIndexMessageVo.getSellerId(), itemSearchIndexMessageVo.getItemId(), itemSearchIndexMessageVo.getBusType(), itemSearchIndexMessageVo.getOperation(), itemSearchIndexMessageVo.getRetry() + 1);
        }
    }

    private SearchResultVo search(OSSearchVo osSearchVo) {
        osSearchVo.setIndexName(this.INDEX_ITEM + "_" + this.indexName);
        osSearchVo.setTypeName(this.indexType);
        return this.openSearchService.search(osSearchVo);
    }

    private void buildPrice(ItemRespDto itemRespDto, List<ItemShelfRespDto> itemShelfDtos) {
        BigDecimal max = BigDecimal.ZERO;
        BigDecimal min = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(itemShelfDtos)) {
            List priceList = itemShelfDtos.stream().map(ItemShelfRespDto::getPrice).collect(Collectors.toList());
            max = (BigDecimal)priceList.stream().max(BigDecimal::compareTo).get();
            min = (BigDecimal)priceList.stream().min(BigDecimal::compareTo).get();
        }
        itemRespDto.setMinPrice(Double.valueOf(min.doubleValue()));
        itemRespDto.setMaxPrice(Double.valueOf(max.doubleValue()));
    }

    private void buildSaleCount(ItemRespDto itemRespDto) {
        StatEo statEo = new StatEo();
        statEo.setItemId(itemRespDto.getId());
        List statEoList = this.statDas.select((BaseEo)statEo);
        long salesCount = 0L;
        if (!CollectionUtils.isEmpty((Collection)statEoList)) {
            salesCount = statEoList.stream().mapToLong(StdStatEo::getSalesCount).sum();
        }
        itemRespDto.setSalesCount(Long.valueOf(salesCount));
    }

    private void buildSearchAttr(ItemRespDto itemRespDto) {
        String searchAttr;
        ItemAttributesEo itemAttributesEo = new ItemAttributesEo();
        itemAttributesEo.setItemId(itemRespDto.getId());
        itemAttributesEo = (ItemAttributesEo)this.itemAttributesDas.selectOne((BaseEo)itemAttributesEo);
        if (itemAttributesEo != null && StringUtils.isNotBlank((CharSequence)(searchAttr = itemAttributesEo.getSearchAttrs())) && searchAttr.startsWith("{")) {
            JSONObject jsonObject = JSON.parseObject((String)searchAttr);
            ArrayList searchAttrList = new ArrayList();
            for (String name : jsonObject.keySet()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", name);
                map.put("value", String.valueOf(jsonObject.get((Object)name)));
                searchAttrList.add(map);
            }
            itemRespDto.setSearchAttr(searchAttrList);
        }
    }

    @Override
    public String getIndexDocId(Long sellerId, Long itemId, Integer busType) {
        return String.valueOf(sellerId) + itemId + busType;
    }

    private void refreshIndex(ItemSearchIndexMessageVo itemSearchIndexMessageVo) {
        this.logger.info("\u6839\u636e\u6d88\u606f\u5237\u65b0\u5546\u54c1\u7d22\u5f15ItemSearchIndexMessageVo\uff1a{}", JSON.toJSON((Object)itemSearchIndexMessageVo));
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemSearchIndexMessageVo.getItemId());
        if (null == itemEo) {
            this.logger.info("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728itemId\uff1a{}", (Object)itemSearchIndexMessageVo.getItemId());
            return;
        }
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setItemId(itemSearchIndexMessageVo.getItemId());
        shelfReqDto.setSellerId(itemSearchIndexMessageVo.getSellerId());
        shelfReqDto.setBusType(Integer.valueOf(itemSearchIndexMessageVo.getBusType()));
        List<ItemShelfRespDto> itemShelfRespDtos = this.itemService.queryItemShelfList(shelfReqDto);
        if (!CollectionUtils.isEmpty(itemShelfRespDtos)) {
            this.logger.info("\u67e5\u8be2\u5230\u5546\u54c1\u4e0a\u67b6\u6570\u91cf\uff1a{}", (Object)itemShelfRespDtos.size());
            Map<Long, List<ItemShelfRespDto>> sellerMap = itemShelfRespDtos.stream().collect(Collectors.groupingBy(ItemShelfRespDto::getSellerId));
            for (Long sellerId : sellerMap.keySet()) {
                List<ItemShelfRespDto> itemShelfList = sellerMap.get(sellerId);
                Map<Integer, List<ItemShelfRespDto>> bizTypeMap = itemShelfList.stream().collect(Collectors.groupingBy(ItemShelfRespDto::getBusType));
                for (Integer bizType : bizTypeMap.keySet()) {
                    this.createOrUpdateIndexGroupBySeller(itemSearchIndexMessageVo, itemEo, bizTypeMap.get(bizType));
                }
            }
        } else {
            this.logger.info("\u67e5\u8be2\u4e0d\u5230\u5546\u54c1\u4e0a\u67b6\u8bb0\u5f55");
            this.deleteByIndexId(this.getIndexDocId(itemSearchIndexMessageVo.getSellerId(), itemSearchIndexMessageVo.getItemId(), itemSearchIndexMessageVo.getBusType()));
        }
    }

    private List<TemplateRegionRespDto> getRegionShippingList() {
        List coordinateDtoList;
        ArrayList<TemplateRegionRespDto> templateRegionList = new ArrayList<TemplateRegionRespDto>();
        TemplateRegionRespDto templateRegionRespDto = new TemplateRegionRespDto();
        templateRegionRespDto.setWarehouseId(Long.valueOf(0L));
        templateRegionRespDto.setType("polygon");
        String geo = "[{\"lng\":62.929688,\"lat\":55.279115},{\"lng\":137.812500,\"lat\":57.704147},{\"lng\":136.582031,\"lat\":17.978733},{\"lng\":62.578125,\"lat\":19.145168},{\"lng\":62.929688,\"lat\":55.279115}]";
        if (StringUtils.isNotBlank((CharSequence)geo) && !CollectionUtils.isEmpty((Collection)(coordinateDtoList = JSON.parseArray((String)geo, CoordinateDto.class)))) {
            ArrayList list1 = new ArrayList();
            ArrayList list2 = new ArrayList();
            for (CoordinateDto coordinateDto : coordinateDtoList) {
                ArrayList<Double> list3 = new ArrayList<Double>();
                list3.add(coordinateDto.getLng());
                list3.add(coordinateDto.getLat());
                list2.add(list3);
            }
            list1.add(list2);
            templateRegionRespDto.setCoordinates(list1);
        }
        templateRegionList.add(templateRegionRespDto);
        return templateRegionList;
    }

    private GeoDto getShopDeliveryGeo(ShopDto shopDto) {
        ShopDeliveryDto shopDeliveryDto = shopDto.getShopDeliveryDto();
        GeoDto geoDto = null;
        if (shopDeliveryDto != null) {
            String[] geo = StringUtils.split((String)shopDeliveryDto.getGeo(), (String)",");
            geoDto = new GeoDto();
            geoDto.setLongitude(geo[0]);
            geoDto.setLatitude(geo[1]);
        }
        return geoDto;
    }

    private List<TemplateRegionRespDto> getTemplateRegionRespDtoList(ShopDto shopDto) {
        List geoList;
        String geoFence;
        ArrayList templateRegionRespDtoList = Lists.newArrayList();
        ShopDeliveryDto shopDeliveryDto = shopDto.getShopDeliveryDto();
        if (shopDeliveryDto != null && StringUtils.isNotBlank((CharSequence)(geoFence = shopDeliveryDto.getGeoFence())) && org.apache.commons.collections.CollectionUtils.isNotEmpty(geoList = Stream.of(StringUtils.split((String)geoFence, (String)";")).map(geo -> {
            String[] geoPoints = StringUtils.split((String)geo, (String)",");
            if (geoPoints != null && geoPoints.length > 1) {
                return new CoordinateDto(Double.valueOf(Double.parseDouble(geoPoints[0])), Double.valueOf(Double.parseDouble(geoPoints[1])));
            }
            return null;
        }).collect(Collectors.toList()))) {
            CoordinateDto startPoint = (CoordinateDto)geoList.get(0);
            CoordinateDto endPoint = (CoordinateDto)geoList.get(geoList.size() - 1);
            if (startPoint.getLng().compareTo(endPoint.getLng()) != 0 || startPoint.getLat().compareTo(endPoint.getLat()) != 0) {
                geoList.add(startPoint);
            }
            ArrayList geoFenceList = new ArrayList();
            for (CoordinateDto coordinateDto : geoList) {
                ArrayList<Double> pointsList = new ArrayList<Double>();
                pointsList.add(coordinateDto.getLng());
                pointsList.add(coordinateDto.getLat());
                geoFenceList.add(pointsList);
            }
            ArrayList coordinates = new ArrayList();
            coordinates.add(geoFenceList);
            templateRegionRespDtoList.add(new TemplateRegionRespDto(coordinates));
        }
        return templateRegionRespDtoList;
    }

    private void create(ItemRespDto itemRespDto) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
        indexDocContentVo.setIndexId(String.valueOf(itemRespDto.getGroupKey()));
        Map describe = CustomBeanUtils.describe((Object)itemRespDto);
        indexDocContentVo.setDocValueMap(describe);
        contents.add(indexDocContentVo);
        indexDocumentVo.setContents((List)contents);
        this.logger.info("\u65b0\u589e\u7d22\u5f15\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.addData(indexDocumentVo);
    }

    private void createBatch(List<ItemRespDto> itemRespDtos) {
        if (CollectionUtils.isEmpty(itemRespDtos)) {
            return;
        }
        IndexDocumentVo indexDocumentVo = this.buildIndexData(itemRespDtos);
        this.logger.info("\u65b0\u589e\u7d22\u5f15\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.addData(indexDocumentVo);
    }

    private void updateBatch(List<ItemRespDto> itemRespDtos) {
        if (CollectionUtils.isEmpty(itemRespDtos)) {
            return;
        }
        IndexDocumentVo indexDocumentVo = this.buildIndexData(itemRespDtos);
        this.logger.info("\u66f4\u65b0\u7d22\u5f15\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.updateData(indexDocumentVo);
    }

    private IndexDocumentVo buildIndexData(List<ItemRespDto> itemRespDtos) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        indexDocumentVo.setContents(itemRespDtos.stream().map(itemRespDto -> {
            IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
            indexDocContentVo.setIndexId(String.valueOf(itemRespDto.getGroupKey()));
            Map describe = CustomBeanUtils.describe((Object)itemRespDto);
            indexDocContentVo.setDocValueMap(describe);
            return indexDocContentVo;
        }).collect(Collectors.toList()));
        return indexDocumentVo;
    }

    private void update(ItemRespDto itemRespDto) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
        indexDocContentVo.setIndexId(String.valueOf(itemRespDto.getGroupKey()));
        Map describe = CustomBeanUtils.describe((Object)itemRespDto);
        indexDocContentVo.setDocValueMap(describe);
        contents.add(indexDocContentVo);
        indexDocumentVo.setContents((List)contents);
        this.logger.info("\u66f4\u65b0\u7d22\u5f15\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.updateData(indexDocumentVo);
    }

    private void deleteByIndexId(String indexId) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
        indexDocContentVo.setIndexId(indexId);
        contents.add(indexDocContentVo);
        indexDocumentVo.setContents((List)contents);
        this.logger.info("\u6839\u636eindexId\u5220\u9664\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.deleteData(indexDocumentVo);
    }

    private Long generateId() {
        Long tenantCode = ServiceContext.getContext().getRequestTenantCode();
        Long workerId = IdGenrator.getWorkerId();
        return IdGenrator.nextId((long)workerId, (long)tenantCode);
    }

    private IndexDocumentVo newInstance() {
        return new IndexDocumentVo(this.INDEX_ITEM + "_" + this.indexName, this.indexType);
    }

    @Override
    @Async
    public void asyncSendMqForOff(Integer busType, List<DirItemRelationEo> offDirItems) {
        Map<String, DirItemRelationEo> offDirItemMap = offDirItems.stream().collect(Collectors.toMap(dirItem -> dirItem.getItemId().toString() + dirItem.getShopId(), e -> e, (e1, e2) -> e1));
        offDirItemMap.forEach((k, dirItem) -> {
            ItemMessage itemMessage = new ItemMessage(dirItem.getItemId(), dirItem.getShopId(), Integer.valueOf(0));
            this.itemShelfProducer.sendMqMessage(itemMessage);
            this.index(dirItem.getSellerId(), dirItem.getItemId(), busType, "OFF_SHELF");
        });
    }

    @Override
    @Async
    public void asyncSendMqForOn(Integer busType, List<DirItemRelationEo> shelfDirItems) {
        shelfDirItems.forEach(dirItem -> {
            this.index(dirItem.getSellerId(), dirItem.getItemId(), busType, "ON_SHELF");
            ItemMessage message = new ItemMessage(dirItem.getItemId(), dirItem.getShopId(), Integer.valueOf(1));
            this.itemShelfProducer.sendMqMessage(message);
        });
    }

    @Override
    @Async
    public void asyncSendMqForOnTob(Integer busType, List<DirItemRelationEo> onDirItems) {
        Map<String, DirItemRelationEo> onDirItemMap = onDirItems.stream().collect(Collectors.toMap(dirItem -> dirItem.getItemId().toString() + dirItem.getShopId(), e -> e, (e1, e2) -> e1));
        onDirItemMap.forEach((k, dirItem) -> {
            ItemMessage itemMessage = new ItemMessage(dirItem.getItemId(), dirItem.getShopId(), Integer.valueOf(1));
            this.itemShelfProducer.sendMqMessage(itemMessage);
            this.index(dirItem.getSellerId(), dirItem.getItemId(), busType, "ON_SHELF");
        });
    }

    @Override
    public void asyncItemIndex(Integer busType, List<DirItemRelationEo> shelfDirItems) {
        this.refreshIndexBatch(shelfDirItems, busType, "ON_SHELF");
    }

    @Override
    public void syncEsOff(Integer busType, List<DirItemRelationEo> offDirItems) {
        this.refreshIndexBatch(offDirItems, busType, "OFF_SHELF");
    }

    @Override
    public void refreshIndexBatch(final List<DirItemRelationEo> shelfDirItems, Integer busType, String onShelf) {
        final Map attachments = ServiceContext.getContext().getAttachments();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    attachments.forEach((k, v) -> ServiceContext.getContext().set(k, v));
                    ItemSearchServiceImpl.this.refreshIndexBatchCommitAfter(shelfDirItems);
                }
            });
        } else {
            this.refreshIndexBatchCommitAfter(shelfDirItems);
        }
    }

    private void refreshIndexBatchCommitAfter(List<DirItemRelationEo> shelfDirItems) {
        List itemIds = shelfDirItems.stream().map(StdDirItemRelationEo::getItemId).collect(Collectors.toList());
        this.logger.info("\u6839\u636e\u5237\u65b0\u5546\u54c1\u7d22\u5f15ItemSearchIndexMessageVo\uff1a{}", (Object)JSON.toJSONString(itemIds));
        List itemEos = this.itemDas.selectByIds(itemIds);
        if (CollectionUtils.isEmpty((Collection)itemEos)) {
            return;
        }
        this.sellerIdHandler(shelfDirItems);
        List itemShelfRespDtos = this.shelfDas.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(StdShelfEo::getItemId, itemIds)).in(StdShelfEo::getSellerId, (Collection)shelfDirItems.stream().map(StdDirItemRelationEo::getSellerId).distinct().collect(Collectors.toList()))).eq(BaseEo::getDr, (Object)0)).in(StdShelfEo::getBusType, (Collection)itemEos.stream().map(StdItemEo::getBusType).distinct().collect(Collectors.toList())));
        Set containIds = itemShelfRespDtos.stream().map(shelf -> this.getIndexDocId(shelf.getSellerId(), shelf.getItemId(), shelf.getBusType())).collect(Collectors.toSet());
        List<String> deleteIndexIds = shelfDirItems.stream().map(dirItem -> this.getIndexDocId(dirItem.getSellerId(), dirItem.getItemId(), dirItem.getBusType())).filter(key -> !containIds.contains(key)).distinct().collect(Collectors.toList());
        this.refreshIndexBatchHandler(deleteIndexIds, itemEos, itemShelfRespDtos);
    }

    @Override
    public void refreshIndexBatchHandler(List<String> deleteIndexIds, List<ItemEo> itemEos, List<ShelfEo> itemShelfRespDtos) {
        if (!CollectionUtils.isEmpty(itemShelfRespDtos)) {
            this.logger.info("\u67e5\u8be2\u5230\u5546\u54c1\u4e0a\u67b6\u6570\u91cf\uff1a{}", (Object)itemShelfRespDtos.size());
            this.createOrUpdateIndexSyn(itemShelfRespDtos, itemEos);
        }
    }

    private void sellerIdHandler(List<DirItemRelationEo> shelfDirItems) {
        Set complementShopIds = shelfDirItems.stream().filter(d -> Objects.isNull(d.getSellerId())).map(StdDirItemRelationEo::getShopId).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(complementShopIds)) {
            Map<Long, Long> shopMap = ((List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBaseListByIds(complementShopIds))).stream().collect(Collectors.toMap(ShopBaseDto::getId, ShopBaseDto::getSellerId));
            shelfDirItems.stream().filter(d -> Objects.isNull(d.getSellerId())).forEach(d -> d.setSellerId(Optional.ofNullable(shopMap.get(d.getShopId())).orElse(d.getShopId())));
        }
    }

    private void deleteByIndexIds(List<String> indexIds) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        indexDocumentVo.setContents(indexIds.stream().map(indexId -> {
            IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
            indexDocContentVo.setIndexId(indexId);
            return indexDocContentVo;
        }).collect(Collectors.toList()));
        this.logger.info("\u6839\u636eindexId\u5220\u9664\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.deleteData(indexDocumentVo);
    }

    private void createOrUpdateIndexSyn(List<ShelfEo> shelfEos, List<ItemEo> itemEos) {
        if (CollectionUtils.isEmpty(shelfEos) || CollectionUtils.isEmpty(itemEos)) {
            return;
        }
        Map itemMap = itemEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        Map<Long, List<ItemShelfRespDto>> sellerMap = shelfEos.stream().map(shelf -> {
            ItemShelfRespDto itemShelfRespDto = new ItemShelfRespDto();
            BeanUtils.copyProperties((Object)shelf, (Object)itemShelfRespDto);
            return itemShelfRespDto;
        }).collect(Collectors.groupingBy(ItemShelfRespDto::getSellerId));
        sellerMap.forEach((sellerId, itemShelfRespDtos) -> {
            List<ItemEo> sellerItems = itemShelfRespDtos.stream().map(shelf -> (ItemEo)itemMap.get(shelf.getItemId())).distinct().collect(Collectors.toList());
            List<ItemRespDto> itemRespList = this.itemService.queryItemRespDto(sellerItems, (Long)sellerId);
            if (CollectionUtils.isEmpty(itemRespList)) {
                this.logger.error("\u6784\u5efa\u5546\u54c1\u6570\u636e\u5931\u8d25\uff0c\u5546\u54c1ID:{}\u4fe1\u606f\u4e0d\u5b58\u5728", itemRespList.stream().map(ItemRespDto::getItemId).collect(Collectors.toList()));
                return;
            }
            Map<Long, List<ItemShelfRespDto>> shelfMap = itemShelfRespDtos.stream().collect(Collectors.groupingBy(ItemShelfRespDto::getItemId));
            for (ItemRespDto itemRespDto2 : itemRespList) {
                itemRespDto2.setItemShelfInfoList(shelfMap.get(itemRespDto2.getId()));
            }
            List<Long> itemIds = itemRespList.stream().map(ItemRespDto::getId).collect(Collectors.toList());
            this.buildSaleCounts(itemRespList);
            this.buildSearchAttrs(itemRespList, itemIds);
            this.buildPrices(itemRespList, shelfMap);
            Set itemShopIdSet = itemShelfRespDtos.stream().map(ItemShelfRespDto::getShopId).collect(Collectors.toSet());
            Map shopMap = ((List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIds(itemShopIdSet))).stream().collect(Collectors.toMap(ShopDto::getId, Function.identity()));
            itemRespList.forEach(itemRespDto -> {
                List inlineItemShelfRespDtos = (List)shelfMap.get(itemRespDto.getId());
                List<ShopDto> shopDtos = inlineItemShelfRespDtos.stream().map(itemShelfRespDto -> (ShopDto)shopMap.get(itemShelfRespDto.getShopId())).filter(Objects::nonNull).collect(Collectors.toList());
                itemRespDto.setItemShopList(this.getShopListNew(shopDtos, inlineItemShelfRespDtos));
                itemRespDto.setType(((ItemShelfRespDto)inlineItemShelfRespDtos.get(0)).getItemType());
                itemRespDto.setBusType(((ItemShelfRespDto)inlineItemShelfRespDtos.get(0)).getBusType());
                itemRespDto.setItemId(itemRespDto.getId());
                String groupKey = this.getIndexDocId((Long)sellerId, itemRespDto.getId(), ((ItemShelfRespDto)inlineItemShelfRespDtos.get(0)).getBusType());
                itemRespDto.setGroupKey(groupKey);
            });
            try {
                this.deleteByIndexIds(itemRespList.stream().map(ItemRespDto::getGroupKey).distinct().collect(Collectors.toList()));
                this.createBatch(itemRespList);
                this.logger.info("\u66f4\u65b0\u7d22\u5f15, \u65b0\u589e\u6570\u91cf{}", (Object)itemRespList.size());
            }
            catch (Exception e) {
                this.logger.error("\u5546\u54c1\u540c\u6b65\u5230ES\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        });
    }

    private void buildSearchAttrs(List<ItemRespDto> itemRespList, List<Long> itemIds) {
        Map dataMap = this.itemAttributesDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().in(StdItemAttributesEo::getItemId, itemIds)).stream().collect(Collectors.toMap(StdItemAttributesEo::getItemId, Function.identity(), (o, o1) -> o));
        itemRespList.forEach(item -> {
            String searchAttr;
            ItemAttributesEo itemAttributesEo = (ItemAttributesEo)dataMap.get(item.getId());
            if (itemAttributesEo != null && StringUtils.isNotBlank((CharSequence)(searchAttr = itemAttributesEo.getSearchAttrs())) && searchAttr.startsWith("{")) {
                JSONObject jsonObject = JSON.parseObject((String)searchAttr);
                ArrayList searchAttrList = new ArrayList();
                for (String name : jsonObject.keySet()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("name", name);
                    map.put("value", String.valueOf(jsonObject.get((Object)name)));
                    searchAttrList.add(map);
                }
                item.setSearchAttr(searchAttrList);
            }
        });
    }

    private void buildPrices(List<ItemRespDto> itemRespDtos, Map<Long, List<ItemShelfRespDto>> shelfMap) {
        itemRespDtos.forEach(itemRespDto -> {
            BigDecimal max = BigDecimal.ZERO;
            BigDecimal min = BigDecimal.ZERO;
            List itemShelfDtos = (List)shelfMap.get(itemRespDto.getId());
            if (!CollectionUtils.isEmpty((Collection)itemShelfDtos)) {
                List priceList = itemShelfDtos.stream().map(ItemShelfRespDto::getPrice).collect(Collectors.toList());
                max = (BigDecimal)priceList.stream().max(BigDecimal::compareTo).get();
                min = (BigDecimal)priceList.stream().min(BigDecimal::compareTo).get();
            }
            itemRespDto.setMinPrice(Double.valueOf(min.doubleValue()));
            itemRespDto.setMaxPrice(Double.valueOf(max.doubleValue()));
        });
    }

    private void buildSaleCounts(List<ItemRespDto> itemRespDtos) {
        List statEoList = this.statDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().in(StdStatEo::getItemId, (Collection)itemRespDtos.stream().map(ItemRespDto::getId).collect(Collectors.toList())));
        Map<Long, List<StatEo>> map = statEoList.stream().collect(Collectors.groupingBy(StdStatEo::getItemId));
        itemRespDtos.forEach(resp -> {
            List statEos = (List)map.get(resp.getId());
            if (!CollectionUtils.isEmpty((Collection)statEos)) {
                resp.setSalesCount(Long.valueOf(statEoList.stream().mapToLong(StdStatEo::getSalesCount).sum()));
            }
        });
    }

    private List<ItemShopRespDto> getShopListNew(List<ShopDto> shops, List<ItemShelfRespDto> itemShelfRespDtos) {
        Map<Long, List<ItemShelfRespDto>> shopItemShelfMap = itemShelfRespDtos.stream().collect(Collectors.groupingBy(ItemShelfRespDto::getShopId));
        ArrayList<ItemShopRespDto> itemShopList = new ArrayList<ItemShopRespDto>();
        for (ShopDto shop : shops) {
            ItemShopRespDto itemShopRespDto = new ItemShopRespDto();
            itemShopRespDto.setShopId(shop.getId());
            itemShopRespDto.setBusinessType(shop.getBusinessType());
            List<ItemShelfRespDto> shopItemSelfList = shopItemShelfMap.get(shop.getId());
            if (!CollectionUtils.isEmpty(shopItemSelfList)) {
                Integer type = shopItemSelfList.get(0).getType();
                itemShopRespDto.setShelfType(type);
            }
            if (itemShopRespDto.getBusinessType() == null) {
                itemShopRespDto.setBusinessType(Integer.valueOf(shop.getType().intValue()));
            }
            itemShopList.add(itemShopRespDto);
        }
        return itemShopList;
    }
}

