/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.dtyunxi.cube.commons.constants.OptStatus;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IBrandService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.BrandDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.BrandEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="brandService")
public class BrandServiceImpl
implements IBrandService {
    @Resource
    private BrandDas brandDas;
    @Resource
    private ItemDas itemDas;

    @Override
    public BrandEo selectById(Long id) {
        return (BrandEo)this.brandDas.selectByPrimaryKey(id);
    }

    @Override
    public Long addBrand(BrandEo brand) {
        this.checkBrandCode(brand.getCode(), brand.getInstanceId(), brand.getTenantId());
        this.checkBrandName(brand.getName(), brand.getInstanceId(), brand.getTenantId());
        if (null == brand.getStatus()) {
            brand.setStatus(OptStatus.ENABLED.getStatus());
        }
        this.brandDas.insert((BaseEo)brand);
        return brand.getId();
    }

    @Override
    public void removeBrand(Long brandId) {
        List itemEoList = this.itemDas.selectByBrandId(brandId);
        if (CollectionUtils.isNotEmpty((Collection)itemEoList)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.BRAND_REFERENCED_BY_ITEM);
        }
        this.brandDas.logicDeleteById(brandId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateStatus(BrandEo brand) {
        if (brand.getId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        BrandEo brandEo = (BrandEo)this.brandDas.selectByPrimaryKey(brand.getId());
        if (brandEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_BRAND);
        }
        this.brandDas.updateSelective((BaseEo)brand);
        return brand.getId();
    }

    @Override
    public PageInfo<BrandEo> queryBrandByPage(BrandEo brandEo, Integer pageNum, Integer pageSize) {
        return this.brandDas.selectPage((BaseEo)brandEo, pageNum, pageSize);
    }

    @Override
    public List<BrandEo> queryAllBrandByCondition(BrandEo brandEo) {
        return this.brandDas.select((BaseEo)brandEo);
    }

    @Override
    public void removeByCode(String brandCode) {
        BrandEo eo = BrandEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        Object[] brandCodes = StringUtils.split((String)brandCode, (String)",");
        if (ArrayUtils.isNotEmpty((Object[])brandCodes)) {
            sqlFilters.add(SqlFilter.in((String)"code", (Object)Lists.newArrayList((Object[])brandCodes)));
            eo.setSqlFilters(sqlFilters);
            this.brandDas.logicDelete((BaseEo)eo);
        }
    }

    @Override
    public void removeById(String[] ids) {
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByIds(String[] ids) {
        for (String id : ids) {
            this.removeBrand(Long.valueOf(id));
        }
    }

    @Override
    public void modifyBrand(BrandEo brandEo) {
        BrandEo recordEo = (BrandEo)this.brandDas.selectByPrimaryKey(brandEo.getId());
        if (recordEo == null || !recordEo.getInstanceId().equals(brandEo.getInstanceId()) || !recordEo.getTenantId().equals(brandEo.getTenantId())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST);
        }
        if (!brandEo.getCode().equals(recordEo.getCode())) {
            throw new BizException("\u54c1\u724c\u7f16\u7801\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        if (!recordEo.getName().equals(brandEo.getName())) {
            this.checkBrandName(brandEo.getName(), brandEo.getInstanceId(), brandEo.getTenantId());
        }
        recordEo.setName(brandEo.getName());
        recordEo.setLogoUrl(brandEo.getLogoUrl());
        this.brandDas.update((BaseEo)recordEo);
    }

    private void checkBrandCode(String code, Long instanceId, Long tenantId) {
        BrandEo brandEo = new BrandEo();
        brandEo.setCode(code);
        brandEo.setInstanceId(instanceId);
        brandEo.setTenantId(tenantId);
        if (this.brandDas.count((BaseEo)brandEo) > 0) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.BRAND_CODE_EXISTS);
        }
    }

    private void checkBrandName(String name, Long instanceId, Long tenantId) {
        BrandEo brandEo = new BrandEo();
        brandEo.setName(name);
        brandEo.setInstanceId(instanceId);
        brandEo.setTenantId(tenantId);
        if (this.brandDas.count((BaseEo)brandEo) > 0) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EXIST_BRAND);
        }
    }

    @Override
    public List<BrandRespDto> queryByIds(List<Long> ids) {
        BrandEo brandEo = BrandEo.newInstance();
        brandEo.setOrderBy("id");
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        brandEo.setSqlFilters((List)sqlFilters);
        List brandEoList = this.brandDas.select((BaseEo)brandEo);
        ArrayList brandRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)brandEoList, (Collection)brandRespDtoList, BrandRespDto.class);
        return brandRespDtoList;
    }

    @Override
    public BrandRespDto queryCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        BrandEo brandEo = new BrandEo();
        brandEo.setCode(code);
        brandEo = (BrandEo)this.brandDas.selectOne((BaseEo)brandEo);
        if (brandEo == null) {
            return null;
        }
        BrandRespDto brandRespDto = new BrandRespDto();
        BeanUtils.copyProperties((Object)brandEo, (Object)brandRespDto);
        return brandRespDto;
    }
}

