/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.apiimpl;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemChangeApplyApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ChangeApplyAuditReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.AuditResultRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemChangeApplyService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.cache.IItemCacheClearService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="iItemChangeApplyApi")
public class ItemChangeApplyApiImpl
implements IItemChangeApplyApi {
    @Resource
    private IItemChangeApplyService itemChangeApplyService;
    @Autowired
    List<IItemCacheClearService> itemCacheClearServiceList;

    public RestResponse<Long> add(ItemChangeApplyReqDto itemChangeApplyReqDto) {
        return new RestResponse((Object)this.itemChangeApplyService.add(itemChangeApplyReqDto));
    }

    public RestResponse<Void> commit(Long id) {
        this.itemChangeApplyService.commit(id);
        return RestResponse.VOID;
    }

    public RestResponse<Long> updateItemChangeApply(ItemChangeApplyReqDto itemChangeApplyReqDto) {
        return new RestResponse((Object)this.itemChangeApplyService.update(itemChangeApplyReqDto));
    }

    public RestResponse<AuditResultRespDto> audit(ChangeApplyAuditReqDto changeApplyAuditReqDto) {
        AuditResultRespDto audit = this.itemChangeApplyService.audit(changeApplyAuditReqDto);
        if (audit != null) {
            this.cleanCache(audit.getItemId());
        }
        return new RestResponse((Object)audit);
    }

    private void cleanCache(Long itemId) {
        if (itemId == null) {
            return;
        }
        if (CollectionUtils.isEmpty(this.itemCacheClearServiceList)) {
            return;
        }
        this.itemCacheClearServiceList.forEach(itemChangeApplyService -> itemChangeApplyService.clear(itemId));
    }
}

