/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemTagService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemTagRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.TagDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemTagRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemTagRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.TagEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemTagServiceImpl
implements IItemTagService {
    private static Logger logger = LoggerFactory.getLogger(ItemTagServiceImpl.class);
    @Resource
    private ItemTagRelationDas itemTagRelationDas;
    @Resource
    private TagDas tagDas;
    @Resource
    private ItemDas itemDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int addTagBatch(List<TagEo> tagEos) {
        return this.tagDas.insertBatch(tagEos);
    }

    @Override
    public Long addTag(TagEo tagEo) {
        this.tagDas.insert((BaseEo)tagEo);
        return tagEo.getId();
    }

    @Override
    public void modifyTag(TagEo tagEo) {
        if (null == tagEo.getId()) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        TagEo exists = (TagEo)this.tagDas.selectByPrimaryKey(tagEo.getId());
        if (exists == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_TAG);
        }
        this.tagDas.updateSelective((BaseEo)tagEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTag(Long id) {
        this.tagDas.logicDeleteById(id);
        ItemTagRelationEo exam = ItemTagRelationEo.newInstance();
        exam.setTagId(id);
        List itemTagEos = this.itemTagRelationDas.select((BaseEo)exam);
        for (ItemTagRelationEo itemTagEo : itemTagEos) {
            this.itemTagRelationDas.logicDeleteById(itemTagEo.getId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByIds(String ids) {
        String[] idList;
        for (String id : idList = StringUtils.split((String)ids, (String)",")) {
            this.removeTag(Long.valueOf(id));
        }
    }

    @Override
    public PageInfo<TagEo> queryByPage(TagEo tagEo, Integer pageNumber, Integer pageSize) {
        return this.tagDas.selectPage((BaseEo)tagEo, pageNumber, pageSize);
    }

    @Override
    public TagEo queryById(Long id) {
        return (TagEo)this.tagDas.selectByPrimaryKey(id);
    }

    @Override
    public List<TagEo> queryItemTagByItemId(Long itemId) {
        ItemTagRelationEo itemTagEo = ItemTagRelationEo.newInstance();
        itemTagEo.setItemId(itemId);
        List itemTagEos = this.itemTagRelationDas.select((BaseEo)itemTagEo);
        if (CollectionUtils.isEmpty((Collection)itemTagEos)) {
            return Lists.newArrayList();
        }
        List tagIds = itemTagEos.stream().map(StdItemTagRelationEo::getTagId).collect(Collectors.toList());
        TagEo example = TagEo.newInstance();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(tagIds, (String)",")));
        example.setSqlFilters(sqlFilters);
        return this.tagDas.select((BaseEo)example);
    }

    @Override
    public List<ItemTagRelationEo> queryItemTag(String tagIds, Long tenantId, Long instanceId) {
        ItemTagRelationEo itemTagEo = ItemTagRelationEo.newInstance();
        itemTagEo.setOrderBy("id");
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.in((String)"tag_id", (Object)tagIds));
        itemTagEo.setSqlFilters(filters);
        itemTagEo.setInstanceId(instanceId);
        itemTagEo.setTenantId(tenantId);
        return this.itemTagRelationDas.select((BaseEo)itemTagEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void relateToItem(List<ItemTagRelationEo> itemTagEos) {
        ArrayList<ItemTagRelationEo> insertList = new ArrayList<ItemTagRelationEo>();
        for (ItemTagRelationEo itemTagEo : itemTagEos) {
            List tagEos = this.itemTagRelationDas.select((BaseEo)itemTagEo);
            if (CollectionUtils.isNotEmpty((Collection)tagEos)) continue;
            ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemTagEo.getItemId());
            if (null == itemEo) {
                logger.info(ItemExceptionCode.NON_EXIST_ITEM.getCode() + "\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)ItemExceptionCode.NON_EXIST_ITEM.getMsg());
                continue;
            }
            TagEo tagEo = (TagEo)this.tagDas.selectByPrimaryKey(itemTagEo.getTagId());
            if (null == tagEo) {
                logger.info(ItemExceptionCode.NON_EXIST_TAG.getCode() + "\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)ItemExceptionCode.NON_EXIST_TAG.getMsg());
                continue;
            }
            insertList.add(itemTagEo);
        }
        this.itemTagRelationDas.insertBatch(insertList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRelation(List<ItemTagRelationEo> itemTagEos) {
        for (ItemTagRelationEo itemTagEo : itemTagEos) {
            this.itemTagRelationDas.deleteByExample((BaseEo)itemTagEo);
        }
    }
}

