/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.plugin.EnableCachePlugin;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryItemService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdDirEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dirService")
public class DirServiceImpl
implements IDirService {
    private static Logger logger = LoggerFactory.getLogger(DirServiceImpl.class);
    @Autowired
    private DirDas dirDas;
    @Autowired
    private IDirectoryItemService directoryItemService;

    @Override
    public List<Long> getChildDirIdList(List<Long> dirIdList, Long instanceId, Long tenantId) {
        List<Long> childDirIdList = this.queryChildDirIdList(dirIdList, instanceId, tenantId);
        while (CollectionUtils.isNotEmpty(childDirIdList)) {
            dirIdList.addAll(childDirIdList);
            childDirIdList = this.queryChildDirIdList(childDirIdList, instanceId, tenantId);
        }
        return dirIdList;
    }

    @Override
    @EnableCachePlugin(expireTime=15)
    public List<Long> getLinkAndChildDirIdList(List<Long> dirIdList, Long instanceId, Long tenantId) {
        logger.info("\u67e5\u8be2link\u76ee\u5f55\u53ca\u5b50\u76ee\u5f55ID\u96c6\u5408...");
        dirIdList = this.directoryItemService.convertLinkDir(dirIdList, instanceId, tenantId);
        dirIdList = this.getChildDirIdList(dirIdList, instanceId, tenantId);
        return dirIdList;
    }

    @Override
    @EnableCachePlugin(expireTime=15)
    public List<Long> queryLinkAndChildDirIdListByDirId(DirectoryReqDto directoryReqDto) {
        ArrayList<Long> dirIds = new ArrayList<Long>();
        List<Long> dirIdList = this.directoryItemService.convertLinkDir(directoryReqDto.getIds(), directoryReqDto.getInstanceId(), directoryReqDto.getTenantId());
        dirIds.addAll(dirIdList);
        this.setSubDirIdList(dirIds, dirIdList, directoryReqDto);
        return dirIds;
    }

    private void setSubDirIdList(List<Long> dirIds, List<Long> dirIdList, DirectoryReqDto directoryReqDto) {
        DirEo dirEo = new DirEo();
        dirEo.setDr(0);
        dirEo.setInstanceId(directoryReqDto.getInstanceId());
        dirEo.setTenantId(directoryReqDto.getTenantId());
        dirEo.setStatus(directoryReqDto.getStatus());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)dirEo);
        queryWrapper.in(StdDirEo::getParentId, dirIdList);
        List dirEos = this.dirDas.getMapper().selectList((Wrapper)queryWrapper);
        if (CollUtil.isEmpty((Collection)dirEos)) {
            return;
        }
        List<Long> subIds = dirEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        dirIds.addAll(subIds);
        this.setSubDirIdList(dirIds, subIds, directoryReqDto);
    }

    private List<Long> queryChildDirIdList(List<Long> dirIdList, Long instanceId, Long tenantId) {
        ArrayList<Long> childDirIdList = new ArrayList<Long>();
        if (CollectionUtils.isEmpty(dirIdList)) {
            return childDirIdList;
        }
        for (Long dirId : dirIdList) {
            DirEo dirEo = new DirEo();
            dirEo.setParentId(dirId);
            dirEo.setInstanceId(instanceId);
            dirEo.setTenantId(tenantId);
            List dirEoList = this.dirDas.select((BaseEo)dirEo);
            if (CollectionUtils.isEmpty((Collection)dirEoList)) continue;
            for (DirEo eo : dirEoList) {
                childDirIdList.add(eo.getId());
            }
        }
        return childDirIdList;
    }
}

