/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.controller;

import com.dtyunxi.yundt.cube.center.payment.constant.enums.TradeIdType;
import com.dtyunxi.yundt.cube.center.payment.service.trade.check.CheckOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u652f\u4ed8\u4e2d\u5fc3\uff1a\u6e20\u9053\u6838\u5bf9"})
@RestController
@RequestMapping(value={"/v1/check"})
public class CheckOrderMakeUpController {
    private Logger logger = LoggerFactory.getLogger(CheckOrderMakeUpController.class);
    @Resource
    private CheckOrderService checkPayOrderService;
    @Resource
    private CheckOrderService checkPayRefundOrderService;
    @Resource
    private CheckOrderService checkPayEnterOrderService;

    @ApiOperation(value="\u8fdb\u884c\u6e20\u9053\u8ba2\u5355\u6838\u5bf9")
    @RequestMapping(value={"/order/{tradeId}"}, method={RequestMethod.GET})
    public String order(@PathVariable String tradeId) {
        try {
            if (TradeIdType.verifyIdType((String)tradeId, (TradeIdType)TradeIdType.PAY)) {
                this.checkPayOrderService.checkOrder(tradeId);
            } else if (TradeIdType.verifyIdType((String)tradeId, (TradeIdType)TradeIdType.REFUND)) {
                this.checkPayRefundOrderService.checkOrder(tradeId);
            } else if (TradeIdType.verifyIdType((String)tradeId, (TradeIdType)TradeIdType.ENTERTRADE)) {
                this.checkPayEnterOrderService.checkOrder(tradeId);
            } else {
                this.logger.error("\u8ba2\u5355\u4e0d\u5408\u6cd5\uff0c\u65e0\u6cd5\u901a\u77e5");
                return "FAIL";
            }
            return "SUCC";
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return "FAIL";
        }
    }
}

