/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.controller;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.yundt.cube.center.payment.api.config.IPayPartnerConfigApi;
import com.dtyunxi.yundt.cube.center.payment.api.config.IWxCertificateConfigApi;
import com.dtyunxi.yundt.cube.center.payment.dto.config.AliPayPartnerConfigRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.WxPayPartnerConfigRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.query.WxCertificateRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.response.WxCertificateRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.annotation.Resource;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u652f\u4ed8\u4e2d\u5fc3\uff1a\u652f\u4ed8\u914d\u7f6e\u76f8\u5173"})
@RestController
@RequestMapping(value={"/v1/pay/config"})
public class PayPartnerConfigController
implements IPayPartnerConfigApi {
    @Resource
    private IPayPartnerConfigApi payPartnerConfigApi;
    @Resource
    private IWxCertificateConfigApi wxCertificateConfigApi;

    public RestResponse<Void> updateWxConfig(@RequestBody WxPayPartnerConfigRequest wxPayPartnerConfigRequest) {
        return this.payPartnerConfigApi.updateWxConfig(wxPayPartnerConfigRequest);
    }

    public RestResponse<Void> updateAliConfig(@RequestBody AliPayPartnerConfigRequest aliPayPartnerConfigRequest) {
        return this.payPartnerConfigApi.updateAliConfig(aliPayPartnerConfigRequest);
    }

    public RestResponse<Void> updateConfig(@PathVariable(value="id") String id, @PathVariable(value="status") String status) {
        return this.payPartnerConfigApi.updateConfig(id, status);
    }

    @ApiOperation(value="\u4e0a\u4f20\u5fae\u4fe1\u652f\u4ed8\u8bc1\u4e66", notes="\u4e0a\u4f20\u5fae\u4fe1\u652f\u4ed8\u8bc1\u4e66")
    @PostMapping(value={"/upload"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="configId", required=true, value="\u652f\u4ed8\u914d\u7f6eID", dataType="Long", paramType="query"), @ApiImplicitParam(name="uploadFile", required=true, value="\u6587\u4ef6\u5185\u5bb9", dataType="File", paramType="context")})
    public RestResponse<WxCertificateRespDto> updateAliConfig(@RequestParam(value="configId") Long configId, @RequestParam(value="uploadFile") MultipartFile multipartFile) throws IOException {
        String fileName = multipartFile.getOriginalFilename();
        byte[] data = multipartFile.getBytes();
        String content = Base64Utils.encodeToString((byte[])data);
        WxCertificateRequest request = new WxCertificateRequest();
        request.setContent(content);
        request.setFileName(fileName);
        request.setMd5(MD5Util.getMd5ByString((String)content));
        request.setPartnerConfigId(configId);
        WxCertificateRespDto wxCertificateRespDto = this.wxCertificateConfigApi.addOrUpdate(request);
        return new RestResponse((Object)wxCertificateRespDto);
    }
}

