/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.OperandActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpressionParser {
    private static final Pattern PATTERN_EXPRESSION = Pattern.compile("([0-9]+)");

    public static boolean isOperation(char c) {
        return c == '(' || c == ')' || c == '|' || c == '&' || c == '=';
    }

    public static List<String> splitWords(String expression) {
        ArrayList<String> words = new ArrayList<String>();
        char[] chars = expression.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (ExpressionParser.isOperation(c)) {
                if (stringBuilder.length() > 0) {
                    words.add(stringBuilder.toString());
                }
                words.add(String.valueOf(c));
                stringBuilder.delete(0, stringBuilder.length());
                continue;
            }
            stringBuilder.append(c);
            if (i != chars.length - 1 || stringBuilder.length() <= 0) continue;
            words.add(stringBuilder.toString());
        }
        return words;
    }

    public static boolean isBoolean(String str) {
        return "true".equals(str) || "false".equals(str);
    }

    public static List<Long> extractCondition(String expression) {
        Matcher matcher = PATTERN_EXPRESSION.matcher(expression);
        ArrayList<Long> result = new ArrayList<Long>();
        while (matcher.find()) {
            String conditionCode = matcher.group(0);
            Long conditionId = Long.parseLong(conditionCode);
            result.add(conditionId);
        }
        return result;
    }

    public static boolean execute(String expression, OperandActionEvent operandActionEvent) {
        List<String> words = ExpressionParser.splitWords(expression);
        Stack<String> operatorStack = new Stack<String>();
        Stack<String> operandStack = new Stack<String>();
        for (String word : words) {
            boolean result;
            String operand1;
            String operand2;
            String operator;
            if (!ExpressionParser.isOperation(word.charAt(0))) {
                operandStack.push(word);
                continue;
            }
            if ("(".equals(word)) {
                operatorStack.push(word);
                continue;
            }
            if (")".equals(word)) {
                while (!"(".equals(operatorStack.peek())) {
                    operator = (String)operatorStack.pop();
                    operand2 = (String)operandStack.pop();
                    operand1 = (String)operandStack.pop();
                    result = false;
                    if ("|".equals(operator)) {
                        result = (!ExpressionParser.isBoolean(operand1) ? operandActionEvent.execute(operand1) : Boolean.valueOf(operand1) != false) || (ExpressionParser.isBoolean(operand2) ? Boolean.valueOf(operand2) != false : operandActionEvent.execute(operand2));
                    } else if ("&".equals(operator)) {
                        result = (ExpressionParser.isBoolean(operand1) ? Boolean.valueOf(operand1) != false : operandActionEvent.execute(operand1)) && (ExpressionParser.isBoolean(operand2) ? Boolean.valueOf(operand2) != false : operandActionEvent.execute(operand2));
                    }
                    operandStack.push(String.valueOf(result));
                }
                operatorStack.pop();
                continue;
            }
            if (operatorStack.isEmpty() || ((String)operatorStack.peek()).equals("(")) {
                operatorStack.push(word);
                continue;
            }
            if (((String)operatorStack.peek()).equals("=")) {
                operatorStack.push(word);
                continue;
            }
            operator = (String)operatorStack.pop();
            operand2 = (String)operandStack.pop();
            operand1 = (String)operandStack.pop();
            result = false;
            if ("|".equals(operator)) {
                result = (!ExpressionParser.isBoolean(operand1) ? operandActionEvent.execute(operand1) : Boolean.valueOf(operand1) != false) || (ExpressionParser.isBoolean(operand2) ? Boolean.valueOf(operand2) != false : operandActionEvent.execute(operand2));
            } else if ("&".equals(operator)) {
                result = (ExpressionParser.isBoolean(operand1) ? Boolean.valueOf(operand1) != false : operandActionEvent.execute(operand1)) && (ExpressionParser.isBoolean(operand2) ? Boolean.valueOf(operand2) != false : operandActionEvent.execute(operand2));
            }
            operandStack.push(String.valueOf(result));
            operatorStack.push(word);
        }
        int size = operatorStack.size();
        boolean result = false;
        for (int i = 0; i < size; ++i) {
            String operator = (String)operatorStack.pop();
            if ("=".equals(operator)) {
                String operand = (String)operandStack.pop();
                return ExpressionParser.isBoolean(operand) ? Boolean.valueOf(operand).booleanValue() : operandActionEvent.execute(operand);
            }
            String operand2 = (String)operandStack.pop();
            String operand1 = (String)operandStack.pop();
            if ("|".equals(operator)) {
                result = (!ExpressionParser.isBoolean(operand1) ? operandActionEvent.execute(operand1) : Boolean.valueOf(operand1) != false) || (ExpressionParser.isBoolean(operand2) ? Boolean.valueOf(operand2) != false : operandActionEvent.execute(operand2));
            } else if ("&".equals(operator)) {
                result = (ExpressionParser.isBoolean(operand1) ? Boolean.valueOf(operand1) != false : operandActionEvent.execute(operand1)) && (ExpressionParser.isBoolean(operand2) ? Boolean.valueOf(operand2) != false : operandActionEvent.execute(operand2));
            }
            operandStack.push(String.valueOf(result));
        }
        return result;
    }
}

