/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.vo.SearchConditionVo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityTaskRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityTaskTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.constants.SingleItemConstants;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityTaskService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemRuleService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.DateUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@MQDesc(tag="MODIFY_ACTIVITY_TAG")
public class ActivityModifyProcessor
implements IMessageProcessor<MessageVo> {
    private static Logger logger = LoggerFactory.getLogger(ActivityModifyProcessor.class);
    private static Set<Long> SUPPORT_ACTIVITY_TYPE = Sets.newHashSet();
    private static Set<String> SUPPORT_ACTIVITY_STATUS = Sets.newHashSet();
    private static final String INDEX_ITEM_ACTIVITY_TAG = "item_activity_tag_";
    private static final String INDEX_TYPE_NAME = "item";
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Value(value="${scheduler.client.app_code}")
    private String appCode;
    @Resource
    private IActivityService activityService;
    @Resource
    private ISearchIndexService searchIndexService;
    @Autowired
    private IActivityTaskService activityTaskService;
    @Autowired
    private ITaskApi taskApi;
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Autowired
    private IItemActivityTagService itemActivityTagService;
    @Autowired
    private IActivityItemRuleService activityItemRuleService;

    public MessageResponse process(MessageVo message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("[\u4fee\u6539\u6d3b\u52a8mq\u6d88\u606f]\uff1a{}", (Object)JSON.toJSONString((Object)message));
        Long activityId = (Long)message.getData();
        ActivityRespDto activityRespDto = this.activityService.queryById(activityId);
        logger.info("[\u4fee\u6539\u6d3b\u52a8mq\u6d88\u606f],\u6d3b\u52a8\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)activityRespDto));
        if (activityRespDto == null || !SUPPORT_ACTIVITY_STATUS.contains(activityRespDto.getActivityStatus())) {
            logger.info("\u975e\u6d3b\u52a8\u4e2d\u72b6\u6001\u4e0d\u5904\u7406");
            return MessageResponse.SUCCESS;
        }
        if (!SUPPORT_ACTIVITY_TYPE.contains(activityRespDto.getActivityTemplateId())) {
            logger.info("\u5f53\u524d\u6d3b\u52a8\u7c7b\u578b\u4e0d\u652f\u6301\u4fee\u6539\u6d3b\u52a8\u4e2d\u4fe1\u606f\uff0c\u4e0d\u5904\u7406");
            return MessageResponse.SUCCESS;
        }
        try {
            this.resetTask(activityId, activityRespDto);
            this.updateEsTag(activityId, activityRespDto);
            this.activityService.reloadTobActivity(activityId);
            ActivityEo activityEo = new ActivityEo();
            DtoHelper.dto2Eo((BaseVo)activityRespDto, (BaseEo)activityEo);
            this.activityItemRuleService.load(activityEo);
            if (SingleItemConstants.SUPPORT_ACTIVITY_TYPE.contains(activityRespDto.getActivityTemplateId())) {
                this.exchangeActivityHandle(activityId);
            }
        }
        catch (Exception e) {
            logger.error("[\u4fee\u6539\u6d3b\u52a8mq\u6d88\u606f],\u62a5\u9519\u4fe1\u606f\uff1a{}", (Throwable)e);
            return MessageResponse.SUCCESS;
        }
        return MessageResponse.SUCCESS;
    }

    private void exchangeActivityHandle(Long activityId) {
        this.itemActivityTagService.saveSingleItemByActivity(activityId);
    }

    private void resetTask(Long activityId, ActivityRespDto activityRespDto) {
        try {
            ActivityTaskRespDto activityTaskRespDto = this.activityTaskService.queryByActivityIdAndTaskType(activityId, ActivityTaskTypeEnum.END_TASK.getType());
            if (activityTaskRespDto != null) {
                RestResponseHelper.extractData((RestResponse)this.taskApi.disableById(activityTaskRespDto.getTaskId(), "{}"));
                RestResponseHelper.extractData((RestResponse)this.taskApi.removeById(activityTaskRespDto.getTaskId(), "{}"));
                this.activityTaskService.removeActivityTask(String.valueOf(activityTaskRespDto.getId()));
            } else {
                this.deleteActivityTask(activityId);
            }
            this.createActivityTask(activityRespDto, "\u8425\u9500\u4e2d\u5fc3\uff1a\u6d3b\u52a8\u7ed3\u675f", "activityFinishTask", activityRespDto.getEndTime(), ActivityTaskTypeEnum.END_TASK);
        }
        catch (Error | Exception e) {
            e.printStackTrace();
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    private void updateEsTag(Long activityId, ActivityRespDto activityRespDto) {
        SearchConditionVo searchConditionVo = new SearchConditionVo(INDEX_ITEM_ACTIVITY_TAG + this.globalProfile, INDEX_TYPE_NAME);
        searchConditionVo.addEqualFilter("activityId", String.valueOf(activityId));
        HashMap update = Maps.newHashMap();
        update.put("activityTag", activityRespDto.getTag());
        update.put("endTime", activityRespDto.getEndTime());
        update.put("preheatStartTime", activityRespDto.getPreheatStartTime() == null ? activityRespDto.getBeginTime() : activityRespDto.getPreheatStartTime());
        this.searchIndexService.updateDataByCondition(searchConditionVo, (Map)update);
    }

    private void createActivityTask(ActivityRespDto activityRespDto, String bizName, String bizCode, Date date, ActivityTaskTypeEnum activityTaskTypeEnum) {
        TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
        dto.setAppCode(this.appCode);
        dto.setBizCode(bizCode);
        dto.setBizName(bizName);
        dto.setParams("" + activityRespDto.getId());
        dto.setScheduleExpression(DateUtil.date2Cron(date));
        dto.setShardType("SINGLE");
        dto.setTaskBatchId(null);
        dto.setTaskDesc("");
        dto.setTaskName(bizName + "(" + activityRespDto.getId() + ")");
        dto.setInstanceId(activityRespDto.getInstanceId());
        dto.setTenantId(activityRespDto.getTenantId());
        RestResponse addResult = this.taskApi.addWithBiz(dto);
        this.taskApi.enableById((Long)addResult.getData(), "{}");
        this.activityTaskService.addActivityTask(activityRespDto.getId(), (Long)addResult.getData(), activityTaskTypeEnum);
    }

    private void deleteActivityTask(Long activityId) {
        if (activityId == null) {
            return;
        }
        String startName = "\u8425\u9500\u4e2d\u5fc3\uff1a\u6d3b\u52a8\u5f00\u59cb(" + activityId + ")";
        String finishName = "\u8425\u9500\u4e2d\u5fc3\uff1a\u6d3b\u52a8\u7ed3\u675f(" + activityId + ")";
        ArrayList taskNames = Lists.newArrayList((Object[])new String[]{startName, finishName});
        ArrayList delTasks = Lists.newArrayList();
        taskNames.forEach(taskName -> {
            TaskQueryReqDto forQuery = new TaskQueryReqDto();
            forQuery.setTaskName(taskName);
            List taskList = ((PageInfo)this.taskQueryApi.queryByPage(JSON.toJSONString((Object)forQuery), Integer.valueOf(1), Integer.valueOf(10)).getData()).getList();
            if (!CollectionUtils.isEmpty((Collection)taskList)) {
                delTasks.addAll(taskList);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)delTasks)) {
            delTasks.forEach(task -> {
                if (Objects.equals(task.getStatus(), TaskStatusEnum.ENABLE.getCode())) {
                    this.taskApi.disableById(task.getId(), "{}");
                }
                this.taskApi.removeById(task.getId(), "{}");
            });
        }
    }

    static {
        SUPPORT_ACTIVITY_TYPE.add(ActivityType.EXCHANGE_ACTIVITY.getId());
        SUPPORT_ACTIVITY_TYPE.add(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId());
        SUPPORT_ACTIVITY_STATUS.add(ActivityStatusEnum.ACTIVATE.getKey());
    }
}

