/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.condition;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.ActivityGiftNum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.GiftItem;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.ReturnGiftContent;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.ReturnGiftRule;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.ProportionUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.enums.DiscountRule;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.enums.PromotionMethod;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.enums.UnitEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ReturnGiftCondition
extends ConditionTemplate {
    private static final String PARAMS_NAME = "ReturnGiftCondition.rule";
    private static final Integer GIFT_TYPE = 1;
    private static final Integer RETURN_TYPE = 2;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T params, Map<String, ?> activityParams) {
        boolean meetThreshold;
        Param param = define.getParam(PARAMS_NAME);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u6ee1\u8d60\u6ee1\u8fd4\u6761\u4ef6\u672a\u914d\u7f6e"}));
        }
        ReturnGiftRule returnGiftRule = (ReturnGiftRule)ConditionTemplate.converter(activityParams.get(PARAMS_NAME), param, define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)returnGiftRule.getPromotionContents())) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u4fc3\u9500\u6761\u4ef6\u5185\u5bb9\u672a\u914d\u7f6e"}));
        }
        if (CollectionUtils.isNotEmpty((Collection)params.getGifts())) {
            for (ItemVo itemVo : params.getGifts()) {
                boolean contain = false;
                if (CollectionUtils.isNotEmpty((Collection)((ReturnGiftContent)returnGiftRule.getPromotionContents().get(0)).getGiftItems())) {
                    for (GiftItem giftItem : ((ReturnGiftContent)returnGiftRule.getPromotionContents().get(0)).getGiftItems()) {
                        if (!itemVo.getShopId().equals(giftItem.getShopId().toString()) || !itemVo.getItemId().equals(giftItem.getItemId().toString()) || !itemVo.getSkuId().equals(giftItem.getSkuId().toString())) continue;
                        contain = true;
                    }
                }
                if (contain) continue;
            }
        }
        if (returnGiftRule.getPromotionCondition().equals(DiscountRule.STAIR.getType())) {
            returnGiftRule.getPromotionContents().sort(Comparator.comparing(ReturnGiftContent::getThreshold, BigDecimal::compareTo));
        }
        if (!(meetThreshold = this.isMeetThreshold(params, returnGiftRule))) {
            return false;
        }
        if (returnGiftRule.getPromotionCondition().equals(DiscountRule.STAIR.getType())) {
            returnGiftRule.getPromotionContents().sort(Comparator.comparing(ReturnGiftContent::getThreshold, (a, b) -> b.compareTo((BigDecimal)a)));
        }
        ActivityGiftNum activityGiftNum = new ActivityGiftNum();
        activityGiftNum.setActivityId(Long.valueOf(params.getActivityId()));
        HashMap activityGiftNumRelationMap = Maps.newHashMap();
        activityGiftNum.setActivityGiftNumRelationMap((Map)activityGiftNumRelationMap);
        if (returnGiftRule.getPromotionMethod().equals(PromotionMethod.ORDER.getType())) {
            this.calculate(params.getItems(), returnGiftRule, params, activityGiftNumRelationMap);
        } else {
            for (ItemVo item : params.getItems()) {
                this.calculate(Lists.newArrayList((Object[])new ItemVo[]{item}), returnGiftRule, params, activityGiftNumRelationMap);
            }
        }
        params.getActivityGiftNumList().add(activityGiftNum);
        return true;
    }

    public <T extends EngineParams> void calculate(List<ItemVo> items, ReturnGiftRule returnGiftRule, T params, Map<String, Integer> activityGiftNumRelationMap) {
        BigDecimal totalAmount = items.stream().map(itemVo -> itemVo.getPrice().multiply(BigDecimal.valueOf(itemVo.getNum()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalItemNum = BigDecimal.valueOf(items.stream().mapToInt(ItemVo::getNum).sum());
        BigDecimal discountAmount = BigDecimal.ZERO;
        Integer logic = ((ReturnGiftContent)returnGiftRule.getPromotionContents().get(0)).getLogic();
        for (ReturnGiftContent promotionContent : returnGiftRule.getPromotionContents()) {
            BigDecimal targetValue = promotionContent.getUnit().equals(UnitEnum.MONEY.getType()) ? totalAmount : totalItemNum;
            if (targetValue.compareTo(promotionContent.getThreshold()) <= -1) continue;
            if (DiscountRule.STAIR.getType().equals(returnGiftRule.getPromotionCondition())) {
                if (GIFT_TYPE.equals(returnGiftRule.getPresentType())) {
                    List giftItems = promotionContent.getGiftItems();
                    if (promotionContent.getSelfItem().booleanValue()) {
                        this.addSelfAndGiftItems(params, giftItems, items, promotionContent.getGiftNum(), activityGiftNumRelationMap);
                    } else {
                        this.addGiftItems(params, giftItems, items, activityGiftNumRelationMap);
                    }
                } else if (RETURN_TYPE.equals(returnGiftRule.getPresentType())) {
                    BigDecimal returnPoints = promotionContent.getPoints();
                    ProportionUtil.setPoint2Context(params, returnPoints);
                    ProportionUtil.avgDisPoints(params, totalAmount, returnPoints);
                }
            } else if (DiscountRule.EACH_FULL.getType().equals(returnGiftRule.getPromotionCondition())) {
                int length = targetValue.divide(promotionContent.getThreshold(), 2, 1).intValue();
                if (GIFT_TYPE.equals(returnGiftRule.getPresentType())) {
                    List srcGiftItems = promotionContent.getGiftItems();
                    ArrayList giftItems = Lists.newArrayList();
                    CubeBeanUtils.copyCollection((Collection)giftItems, (Collection)srcGiftItems, GiftItem.class);
                    if (CollectionUtils.isNotEmpty((Collection)giftItems)) {
                        giftItems.forEach(giftItem -> {
                            if (Objects.nonNull(giftItem.getTotalGiftNum()) && giftItem.getNum() * (long)length > giftItem.getTotalGiftNum()) {
                                giftItem.setNum(giftItem.getTotalGiftNum());
                            } else {
                                giftItem.setNum(Long.valueOf(giftItem.getNum() * (long)length));
                            }
                        });
                    }
                    if (promotionContent.getSelfItem().booleanValue()) {
                        Long selfNum = Objects.nonNull(promotionContent.getTotalGiftNum()) && promotionContent.getGiftNum() * (long)length > promotionContent.getTotalGiftNum() ? promotionContent.getTotalGiftNum() : Long.valueOf(promotionContent.getGiftNum() * (long)length);
                        this.addSelfAndGiftItems(params, giftItems, items, selfNum, activityGiftNumRelationMap);
                    } else {
                        this.addGiftItems(params, giftItems, items, activityGiftNumRelationMap);
                    }
                } else if (RETURN_TYPE.equals(returnGiftRule.getPresentType())) {
                    BigDecimal returnPoints = promotionContent.getPoints().multiply(BigDecimal.valueOf(length));
                    ProportionUtil.setPoint2Context(params, returnPoints);
                    ProportionUtil.avgDisPoints(params, totalAmount, returnPoints);
                }
            }
            if (logic != 2) continue;
            break;
        }
    }

    private <T extends EngineParams> void addSelfAndGiftItems(T params, List<GiftItem> giftItems, List<ItemVo> items, Long selfNum, Map<String, Integer> activityGiftNumRelationMap) {
        Integer itemNum;
        ItemVo vo;
        List giftItemVos = params.getGifts();
        if (null == giftItemVos) {
            giftItemVos = Lists.newArrayList();
        }
        Map<String, ItemVo> itemVoMap = giftItemVos.stream().collect(Collectors.toMap(itemVo -> itemVo.getShopId() + itemVo.getSkuId(), e -> e, (e1, e2) -> e1));
        if (CollectionUtils.isNotEmpty(giftItems)) {
            for (GiftItem giftItem : giftItems) {
                vo = itemVoMap.get(giftItem.getShopId() + giftItem.getSkuId().toString());
                if (null == vo) {
                    vo = new ItemVo();
                    vo.setItemId(giftItem.getItemId().toString());
                    vo.setNum(giftItem.getNum().intValue());
                    vo.setShopId(giftItem.getShopId().toString());
                    vo.setSkuId(giftItem.getSkuId().toString());
                    giftItemVos.add(vo);
                } else {
                    vo.setNum(vo.getNum() + giftItem.getNum().intValue());
                }
                vo.getGiftSkuList().addAll(items.stream().map(ItemVo::getSkuId).collect(Collectors.toList()));
                itemNum = activityGiftNumRelationMap.get(giftItem.getShopId() + giftItem.getSkuId().toString());
                itemNum = Optional.ofNullable(itemNum).orElse(0) + giftItem.getNum().intValue();
                activityGiftNumRelationMap.put(giftItem.getShopId() + giftItem.getSkuId().toString(), itemNum);
            }
        }
        for (ItemVo item : items) {
            vo = itemVoMap.get(item.getShopId() + item.getSkuId());
            if (null == vo) {
                vo = new ItemVo();
                vo.setItemId(item.getItemId());
                vo.setNum(selfNum.intValue());
                vo.setShopId(item.getShopId());
                vo.setSkuId(item.getSkuId());
                giftItemVos.add(vo);
            } else {
                vo.setNum(vo.getNum() + selfNum.intValue());
            }
            vo.getGiftSkuList().add(vo.getSkuId());
            itemNum = activityGiftNumRelationMap.get(item.getShopId() + item.getSkuId());
            itemNum = Optional.ofNullable(itemNum).orElse(0) + selfNum.intValue();
            activityGiftNumRelationMap.put(item.getShopId() + item.getSkuId(), itemNum);
        }
        params.setGifts(giftItemVos);
    }

    private <T extends EngineParams> void addGiftItems(T params, List<GiftItem> giftItems, List<ItemVo> items, Map<String, Integer> activityGiftNumRelationMap) {
        List giftItemVos = params.getGifts();
        if (null == giftItemVos) {
            giftItemVos = Lists.newArrayList();
        }
        Map<String, ItemVo> itemVoMap = giftItemVos.stream().collect(Collectors.toMap(itemVo -> itemVo.getShopId() + itemVo.getSkuId(), e -> e, (e1, e2) -> e1));
        if (CollectionUtils.isNotEmpty(giftItems)) {
            for (GiftItem giftItem : giftItems) {
                ItemVo vo = itemVoMap.get(giftItem.getShopId() + giftItem.getSkuId().toString());
                if (null == vo) {
                    vo = new ItemVo();
                    vo.setItemId(giftItem.getItemId().toString());
                    vo.setNum(giftItem.getNum().intValue());
                    vo.setShopId(giftItem.getShopId().toString());
                    vo.setSkuId(giftItem.getSkuId().toString());
                    giftItemVos.add(vo);
                } else {
                    vo.setNum(vo.getNum() + giftItem.getNum().intValue());
                }
                vo.getGiftSkuList().addAll(items.stream().map(ItemVo::getSkuId).collect(Collectors.toList()));
                Integer itemNum = activityGiftNumRelationMap.get(giftItem.getShopId() + giftItem.getSkuId().toString());
                itemNum = Optional.ofNullable(itemNum).orElse(0) + giftItem.getNum().intValue();
                activityGiftNumRelationMap.put(giftItem.getShopId() + giftItem.getSkuId().toString(), itemNum);
            }
        }
        params.setGifts(giftItemVos);
    }

    private <T extends EngineParams> boolean isMeetThreshold(T params, ReturnGiftRule returnGiftRule) {
        ReturnGiftContent content = (ReturnGiftContent)returnGiftRule.getPromotionContents().get(0);
        BigDecimal targetValue = BigDecimal.ZERO;
        Map<Object, Object> itemMap = Maps.newHashMap();
        if (PromotionMethod.ORDER.getType().equals(returnGiftRule.getPromotionMethod())) {
            itemMap.put(null, params.getItems());
        } else {
            itemMap = params.getItems().stream().collect(Collectors.groupingBy(itemVo -> {
                String key = itemVo.getItemId() + itemVo.getSkuId() + itemVo.getShopId();
                return key;
            }));
        }
        boolean meet = false;
        ArrayList removeItems = Lists.newArrayList();
        for (Map.Entry<Object, Object> entry : itemMap.entrySet()) {
            List itemVos = (List)itemMap.get(entry.getKey());
            if (UnitEnum.MONEY.getType().equals(content.getUnit())) {
                BigDecimal totalAmount;
                targetValue = totalAmount = itemVos.stream().map(itemVo -> {
                    BigDecimal itemAmount = itemVo.getPrice().multiply(BigDecimal.valueOf(itemVo.getNum()));
                    return itemAmount;
                }).reduce(BigDecimal.ZERO, BigDecimal::add);
            } else {
                Integer totalItemNum = itemVos.stream().mapToInt(ItemVo::getNum).sum();
                targetValue = BigDecimal.valueOf(totalItemNum.intValue());
            }
            if (targetValue.compareTo(content.getThreshold()) > -1) {
                meet = true;
                continue;
            }
            removeItems.addAll(itemVos);
        }
        if (meet) {
            params.getItems().removeIf(itemVo -> removeItems.stream().anyMatch(removeItem -> {
                String removeKey = removeItem.getItemId() + removeItem.getSkuId() + removeItem.getShopId();
                String itemKey = itemVo.getItemId() + itemVo.getSkuId() + itemVo.getShopId();
                return removeKey.equals(itemKey);
            }));
        }
        return meet;
    }
}

