/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConstantsStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityCoupon;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.DiscountAmount;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.MapUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityJoinLogExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityJoinLogDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityJoinLogEo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="activityJoinLogExtService")
public class ActivityJoinLogExtServiceImpl
implements IActivityJoinLogExtService {
    @Resource
    private ActivityJoinLogDas activityJoinLogDas;

    private void _joinInActivity(EngineParams params, boolean isEnable) {
        LinkedList logs = Lists.newLinkedList();
        if (CollectionUtils.isEmpty((Collection)params.getItems())) {
            this.fillEo(params, null, 0L, logs, isEnable);
        } else {
            boolean hasCoupon;
            ActivityCoupon activityCoupon = params.getCouponByActivityId(Long.valueOf(params.getActivityId()));
            List couponIds = null;
            if (activityCoupon != null) {
                couponIds = activityCoupon.getCouponIds();
            }
            boolean bl = hasCoupon = !CollectionUtils.isEmpty(couponIds) || params.getItems().stream().anyMatch(item -> item.getCouponId() > 0L);
            if (hasCoupon) {
                for (ItemVo itemVo : params.getItems()) {
                    if (itemVo.getPrice().equals(itemVo.getDiscountPrice()) || itemVo.getCouponId() <= 0L) continue;
                    this.fillEo(params, itemVo, itemVo.getCouponId(), logs, isEnable);
                }
                if (!CollectionUtils.isEmpty((Collection)couponIds)) {
                    Iterator iterator = couponIds.iterator();
                    while (iterator.hasNext()) {
                        long couponId = (Long)iterator.next();
                        for (ItemVo itemVo : params.getItems()) {
                            if (itemVo.getPrice().equals(itemVo.getDiscountPrice()) || couponId <= 0L) continue;
                            this.fillEo(params, itemVo, couponId, logs, isEnable);
                        }
                    }
                }
            } else {
                for (ItemVo itemVo : params.getItems()) {
                    this.fillEo(params, itemVo, 0L, logs, isEnable);
                }
            }
        }
        this.insertBatch(logs);
    }

    @Override
    public void joinInActivity(EngineParams params) {
        this._joinInActivity(params, false);
    }

    @Override
    public void joinInActivityEnable(EngineParams params) {
        this._joinInActivity(params, true);
    }

    @Transactional(rollbackFor={Exception.class})
    public void insertBatch(List<ActivityJoinLogEo> tempEos) {
        this.activityJoinLogDas.insertBatch(tempEos);
    }

    @Override
    public void disable(Collection<Long> ids) {
        ActivityJoinLogEo forUpdate = ActivityJoinLogEo.newInstance();
        forUpdate.setStatus(EnableStatusEnum.DISABLE.getKey());
        forUpdate.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("id", ids).get());
        this.activityJoinLogDas.updateSelectiveSqlFilter((BaseEo)forUpdate);
    }

    @Override
    public void cancel(Collection<Long> ids) {
        ActivityJoinLogEo forUpdate = ActivityJoinLogEo.newInstance();
        forUpdate.setStatus(ConstantsStatusEnum.CANCEL.getStatus());
        forUpdate.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("id", ids).get());
        this.activityJoinLogDas.updateSelectiveSqlFilter((BaseEo)forUpdate);
    }

    @Override
    public List<ActivityJoinLogEo> getByOrderCode(String orderCode) {
        ActivityJoinLogEo forQuery = ActivityJoinLogEo.newInstance();
        forQuery.setOrderCode(orderCode);
        return this.activityJoinLogDas.select((BaseEo)forQuery);
    }

    @Override
    public List<ActivityJoinLogEo> getByOrderCodeAndActivityId(String orderCode, Long activityId) {
        ActivityJoinLogEo forQuery = ActivityJoinLogEo.newInstance();
        forQuery.setOrderCode(orderCode);
        forQuery.setActivityId(activityId);
        return this.activityJoinLogDas.select((BaseEo)forQuery);
    }

    private void fillEo(EngineParams params, ItemVo itemVo, long couponId, List<ActivityJoinLogEo> logs, boolean isEnable) {
        ActivityJoinLogEo tempEo = ActivityJoinLogEo.newInstance();
        if (null != itemVo) {
            if (StringUtils.isEmpty((Object)itemVo.getShopId())) {
                itemVo.addExtendsAttribute("shopCode", (Object)params.getShopId());
            } else {
                itemVo.addExtendsAttribute("shopCode", (Object)itemVo.getShopId());
            }
            String platCode = MapUtils.getString((Map)params.getExtendsAttribute(), (Object)"platCode");
            itemVo.addExtendsAttribute("platCode", (Object)platCode);
            tempEo.setItemId(itemVo.getItemId());
            tempEo.setItemNum(Integer.valueOf(itemVo.getNum()));
            tempEo.setSkuId(itemVo.getSkuId());
            tempEo.setShopId(itemVo.getShopId());
            DiscountAmount discountAmount = itemVo.getDiscountAmountByActivityId(Long.valueOf(params.getActivityId()));
            tempEo.setSourcePrice(itemVo.getPrice());
            tempEo.setTargetPrice(discountAmount == null ? BigDecimal.ZERO : discountAmount.getAmount());
        } else {
            tempEo.setItemId("");
            tempEo.setItemNum(Integer.valueOf(0));
            tempEo.setSkuId("");
            tempEo.setSourcePrice(BigDecimal.ZERO);
            tempEo.setTargetPrice(BigDecimal.ZERO);
        }
        tempEo.setActivityId(Long.valueOf(params.getActivityId()));
        tempEo.setCouponId(Long.valueOf(couponId));
        tempEo.setProgramSrc(params.getProgramSrc());
        tempEo.setSerialNumber(params.getSerialNumber());
        if (isEnable) {
            tempEo.setStatus(EnableStatusEnum.ENABLE.getKey());
        } else {
            tempEo.setStatus(EnableStatusEnum.DISABLE.getKey());
        }
        tempEo.setOrderCode(params.getOrderCode());
        tempEo.setUserId(Long.valueOf(params.getUserId()));
        tempEo.setCreateTime(new Date());
        tempEo.setInstanceId(params.getInstanceId());
        tempEo.setTenantId(params.getTenantId());
        if (itemVo != null) {
            tempEo.setExtension(JSON.toJSONString((Object)itemVo.getExtendsAttribute()));
        } else {
            tempEo.setExtension(JSON.toJSONString((Object)params.getExtendsAttribute()));
        }
        logs.add(tempEo);
    }
}

