/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponFailRecordService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponFailRecordDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponFailRecordEo;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class CouponFailRecordServiceImpl
implements ICouponFailRecordService {
    private final Logger logger = LoggerFactory.getLogger(CouponFailRecordServiceImpl.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Autowired
    private CouponFailRecordDas couponFailRecordDas;

    @Override
    public void sendFailRecordMq(CouponTemplateExtRespDto couponTemplate, ProBizException error, Long memberId, Integer sendType) {
        try {
            CouponFailRecordEo failRecord = new CouponFailRecordEo();
            failRecord.setCouponTemplateId(couponTemplate.getId());
            failRecord.setCouponTemplateCode(couponTemplate.getCouponCode());
            failRecord.setUserId(memberId);
            failRecord.setCouponName(couponTemplate.getCouponName());
            failRecord.setActivityId(couponTemplate.getActivityId());
            failRecord.setErrorCode(error.getCode());
            failRecord.setErrorDesc(error.getMessage());
            failRecord.setCouponType(couponTemplate.getCouponType());
            failRecord.setCouponValue(couponTemplate.getCouponValue());
            failRecord.setAmount(couponTemplate.getAmount());
            failRecord.setSendType(sendType);
            this.commonsMqService.sendSingleMessageAsync("BIZ-MARKETING-COUPON-SEND-FAIL", (Object)JSON.toJSONString((Object)failRecord));
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u5238\u5931\u8d25\u8bb0\u5f55\u53d1MQ\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    @Override
    public void saveCouponFailRecord(CouponFailRecordEo couponFailRecordEo) {
        this.couponFailRecordDas.insert((BaseEo)couponFailRecordEo);
    }
}

