/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.mq;

import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityResultMessage;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponCacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponEventService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityPreviewService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponService;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@MQDesc(tag="JOIN_IN_ACTIVITY_RESULT")
public class ActivityResultProcessor
implements IMessageProcessor<ActivityResultMessage> {
    public static final Logger logger = LoggerFactory.getLogger(ActivityResultProcessor.class);
    @Autowired
    private ICouponService couponService;
    @Autowired
    private IActivityService activityService;
    @Autowired
    private ICouponCacheService couponCacheService;
    @Autowired
    private ICouponEventService couponEventService;
    @Autowired
    private ICouponExtQueryService couponExtQueryService;
    @Resource
    private IActivityPreviewService activityPreviewService;

    public MessageResponse process(ActivityResultMessage message) {
        if (null == message.getSuccess()) {
            logger.info("\u6d3b\u52a8\u53c2\u4e0e\u7ed3\u679c\u6d88\u606f.\u53d1\u73b0\u65e0\u6548\u6d88\u606f\uff0c\u672a\u544a\u77e5\u6267\u884c\u7ed3\u679c\uff0c\u8be5\u6761\u6d88\u606f\u88ab\u5ffd\u7565\u3002\u6d88\u606f\u5185\u5bb9:{}", (Object)message);
            return MessageResponse.SUCCESS;
        }
        if (null == message.getParams()) {
            logger.info("\u6d3b\u52a8\u53c2\u4e0e\u7ed3\u679c\u6d88\u606f,\u53d1\u73b0\u65e0\u6548\u6d88\u606f.\uff0c\u8be5\u6761\u6d88\u606f\u88ab\u5ffd\u7565\u3002\u6d88\u606f\u5185\u5bb9:{}", (Object)message);
        }
        LinkedList<Long> couponIds = new LinkedList<Long>();
        if (!CollectionUtils.isEmpty((Collection)message.getParams().getCouponIds())) {
            couponIds.addAll(message.getParams().getCouponIds());
        }
        if (!CollectionUtils.isEmpty((Collection)message.getParams().getItems())) {
            message.getParams().getItems().stream().mapToLong(ItemVo::getCouponId).forEach(l -> {
                if (l > 0L) {
                    couponIds.add(l);
                }
            });
        }
        Long userId = message.getParams().getUserId();
        if (message.getParams().getActivityFlag().booleanValue()) {
            userId = this.activityPreviewService.getCurrentCustomerOrgId(userId);
        }
        if (message.getSuccess().booleanValue()) {
            if (!CollectionUtils.isEmpty(couponIds)) {
                this.couponService.deductCouponSuccess(userId, message.getOrderCode(), CouponStatusEnum.STOP.getStatus(), couponIds, message.getParams().getUserId());
                List<CouponExtRespDto> couponExtRespDtos = this.couponExtQueryService.listByIds(couponIds);
                if (couponExtRespDtos != null) {
                    logger.info("\u4f18\u60e0\u5238\u6838\u9500\u6210\u529f\uff0c\u5904\u7406\u4f18\u60e0\u5238\u6838\u9500\u8425\u9500\u4e8b\u4ef6\uff0c\u4f18\u60e0\u5238id\u4e3a\uff1a{}", (Object)JacksonUtil.toJson(couponIds));
                    Long finalUserId = userId;
                    couponExtRespDtos.forEach(couponExtRespDto -> this.couponEventService.asyncProcessUseEvent(finalUserId, couponExtRespDto.getCouponTemplateId(), (CouponExtRespDto)couponExtRespDto));
                }
                this.couponCacheService.deleteMemberCouponCache(userId, CouponStatusEnum.CREATE.getStatus());
                this.couponCacheService.deleteMemberCouponCache(userId, CouponStatusEnum.FREEZE.getStatus());
                this.couponCacheService.deleteMemberCouponCache(userId, CouponStatusEnum.STOP.getStatus());
            } else {
                this.activityService.joinSuccess(message.getParams().getUserId(), message.getParams().getActivityId(), message.getOrderCode());
            }
        }
        if (!message.getSuccess().booleanValue()) {
            if (!CollectionUtils.isEmpty(couponIds)) {
                logger.info("\u4f18\u60e0\u5238\u6838\u9500\u5931\u8d25\uff0c\u4f18\u60e0\u5238id\uff1a{}, \u56de\u6eda\u4f18\u60e0\u5238\u72b6\u6001\u3002", (Object)JacksonUtil.toJson(couponIds));
                this.couponService.deductCouponFailure(userId, message.getOrderCode(), CouponStatusEnum.CREATE.getStatus(), couponIds, message.getParams().getUserId());
                this.couponCacheService.deleteMemberCouponCache(userId, CouponStatusEnum.CREATE.getStatus());
                this.couponCacheService.deleteMemberCouponCache(userId, CouponStatusEnum.FREEZE.getStatus());
                this.couponCacheService.deleteMemberCouponCache(userId, CouponStatusEnum.STOP.getStatus());
            } else {
                this.activityService.joinFailure(message.getParams().getUserId(), message.getParams().getActivityId());
            }
        }
        return MessageResponse.SUCCESS;
    }
}

