/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.enums.BestoreShopChannel;
import com.dtyunxi.yundt.cube.biz.member.api.point.enums.PointEventEnum;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.request.PointsTradeInfoReqDto;
import com.dtyunxi.yundt.cube.center.member.api.point.IPointsTradeApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.MapUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.IMarketingPointService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.promotion.InstallmentDetailEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.promotion.InstallmentEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="marketingPointService")
public class MarketingPointServiceImpl
implements IMarketingPointService {
    @Resource
    private IPointsTradeApi pointsTradeApi;

    @Override
    public String sendPointByEngineParams(EngineParams params, BigDecimal points) {
        PointsTradeInfoReqDto pointsReq = new PointsTradeInfoReqDto();
        Object outerTradeCodeObj = params.getExtendsAttribute().get("outerTradeCode");
        String outerTradeCode = null;
        if (outerTradeCodeObj != null) {
            outerTradeCode = outerTradeCodeObj.toString();
        }
        pointsReq.setMemberId(Long.valueOf(params.getUserId()));
        pointsReq.setOrderNo(outerTradeCode);
        pointsReq.setPoints(points.setScale(0, 4).intValue());
        pointsReq.setChannel(BestoreShopChannel.getByShopCode((String)params.getShopId()).getName());
        pointsReq.setChannelNo(params.getShopId());
        pointsReq.setTradeSource(PointEventEnum.Z_PT_PRA.getEventCode() + "|" + params.getOrderCode() + "|" + params.getActivityId());
        pointsReq.setRemark(PointEventEnum.Z_PT_PRA.getEventName());
        HashMap exMap = Maps.newHashMap();
        exMap.put("channelSource", MapUtils.getString((Map)params.getExtendsAttribute(), (Object)"channelSource"));
        this.fillPointInfo2Ext(params.getItems(), exMap);
        this.fillReq(pointsReq, exMap);
        return (String)this.pointsTradeApi.increase(pointsReq).getData();
    }

    private void fillPointInfo2Ext(List<ItemVo> items, Map<String, Object> exMap) {
        if (CollectionUtils.isNotEmpty(items)) {
            ArrayList pointInfoList = Lists.newArrayList();
            HashMap hasCaMap = Maps.newHashMap();
            items.forEach(itemVo -> {
                String skuId = MapUtils.getString((Map)itemVo.getExtendsAttribute(), (Object)"skuId", (String)itemVo.getItemId());
                BigDecimal point = MapUtils.getBigDecimal((Map)itemVo.getExtendsAttribute(), (Object)"returnPoints");
                BigDecimal itemQuantity = MapUtils.getBigDecimal((Map)itemVo.getExtendsAttribute(), (Object)"itemQuantity");
                if (MapUtils.isNotEmpty((Map)((Map)hasCaMap.get(skuId)))) {
                    ((BigDecimal)((Map)hasCaMap.get(skuId)).get("points")).add(point);
                    ((BigDecimal)((Map)hasCaMap.get(skuId)).get("quantity")).add(itemQuantity);
                } else {
                    HashMap infoMap = Maps.newHashMap();
                    infoMap.put("points", point);
                    infoMap.put("quantity", itemQuantity);
                    infoMap.put("skuId", MapUtils.getString((Map)itemVo.getExtendsAttribute(), (Object)"skuId", (String)itemVo.getItemId()));
                    hasCaMap.put(skuId, infoMap);
                }
            });
            if (MapUtils.isNotEmpty((Map)hasCaMap)) {
                hasCaMap.forEach((key, value) -> pointInfoList.add(value));
            }
            exMap.put("skuPoints", pointInfoList);
        }
    }

    @Override
    public String sendPointByInstallment(InstallmentEo installment, InstallmentDetailEo detailEo, Date expiredDate) {
        PointsTradeInfoReqDto pointsReq = new PointsTradeInfoReqDto();
        if (expiredDate != null) {
            pointsReq.setExpiredDate(expiredDate);
        }
        pointsReq.setMemberId(installment.getUserId());
        pointsReq.setOrderNo(installment.getBusinessNo());
        pointsReq.setPoints(detailEo.getNum().setScale(0, 4).intValue());
        HashMap exMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)installment.getExtension())) {
            JSONObject obj = JSON.parseObject((String)installment.getExtension());
            pointsReq.setChannel(BestoreShopChannel.getByShopCode((String)obj.getString("channel")).getName());
            pointsReq.setChannelNo(obj.getString("shopCode"));
            exMap.put("channelSource", MapUtils.getString((Map)obj, (Object)"channelSource"));
        }
        pointsReq.setTradeSource("Z_PT_PRA|" + installment.getActivityId() + "|" + detailEo.getId());
        pointsReq.setRemark("\u6d3b\u52a8[" + installment.getActivityId() + "]\u5206\u671f\u8d60\u9001\u79ef\u5206");
        this.fillReq(pointsReq, exMap);
        return (String)this.pointsTradeApi.increase(pointsReq).getData();
    }

    private void fillReq(PointsTradeInfoReqDto pointsReq, Map<String, Object> exMap) {
        HashMap pointMap = Maps.newHashMap();
        pointMap.put("pointType", "POINT_CONSUME");
        pointMap.put("orderNo", pointsReq.getOrderNo());
        pointsReq.setExtFields((Map)pointMap);
        HashMap extensionMap = Maps.newHashMap();
        extensionMap.put("eventCode", "Z_PT_PRA");
        if (MapUtils.isNotEmpty(exMap)) {
            extensionMap.putAll(exMap);
        }
        pointsReq.setExtension(JSONObject.toJSONString((Object)extensionMap));
    }
}

