/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.biz.member.api.basis.dto.request.TradeInfoReqDto;
import com.dtyunxi.yundt.cube.biz.member.api.common.dto.ShopInfoDto;
import com.dtyunxi.yundt.cube.biz.member.api.common.service.IShopInfoQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.ITradeSyncProcessService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.ITradeSyncService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityJoinLogDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityJoinLogEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class TradeSyncProcessServiceImpl
implements ITradeSyncProcessService {
    private static final Logger logger = LoggerFactory.getLogger(TradeSyncProcessServiceImpl.class);
    @Resource
    private ITradeSyncService tradeSyncService;
    @Resource
    private ActivityJoinLogDas activityJoinLogDas;
    @Resource
    private IShopInfoQueryApi shopInfoQueryApi;

    @Override
    public Map<String, Object> processTradeInfo(String tradeInfoJson) {
        logger.info("\u6536\u5230\u8ba2\u5355\u540c\u6b65\u4fe1\u606f\uff1a{}", (Object)tradeInfoJson);
        if (StringUtils.isNotEmpty((CharSequence)tradeInfoJson)) {
            TradeInfoReqDto tradeInfo = (TradeInfoReqDto)ObjectHelper.Json2Bean((String)tradeInfoJson, TradeInfoReqDto.class);
            if (CollectionUtils.isNotEmpty((Collection)tradeInfo.getRefundInfos())) {
                logger.info("\u8ba2\u5355\u4e3a\u9000\u6b3e\u8ba2\u5355\uff0c\u4e0d\u5904\u7406");
                return Maps.newHashMap();
            }
            this.validate(tradeInfo);
            List promotionIds = tradeInfo.getPromotionIds();
            List tradeItems = tradeInfo.getTradeItems();
            if (CollectionUtils.isNotEmpty((Collection)tradeItems)) {
                for (TradeInfoReqDto.TradeItem item : tradeItems) {
                    List activityIds = item.getPromotionIds();
                    if (CollectionUtils.isNotEmpty((Collection)promotionIds)) {
                        if (CollectionUtils.isEmpty((Collection)activityIds)) {
                            activityIds = Lists.newArrayList((Iterable)promotionIds);
                        } else {
                            activityIds.addAll(promotionIds);
                        }
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)activityIds)) continue;
                    activityIds.forEach(activityId -> {
                        TradeInfoReqDto forInsertLog = new TradeInfoReqDto();
                        BeanUtils.copyProperties((Object)tradeInfo, (Object)forInsertLog, (String[])new String[]{"tradeItems", "tradeItems"});
                        TradeInfoReqDto.TradeItem newItem = new TradeInfoReqDto.TradeItem();
                        BeanUtils.copyProperties((Object)item, (Object)newItem);
                        forInsertLog.setTradeItems((List)Lists.newArrayList((Object[])new TradeInfoReqDto.TradeItem[]{newItem}));
                        logger.info("\u540c\u6b65\u8ba2\u5355\u6709\u6d3b\u52a8id[{}]\uff0c\u6784\u9020\u8bb0\u5f55\u65e5\u5fd7Dto:{}", activityId, (Object)JSON.toJSONString((Object)forInsertLog));
                        this.tradeSyncService.commonJoinInActivityLog(forInsertLog, Long.valueOf(activityId));
                    });
                }
            }
            logger.info("\u8ba2\u5355[{}]\u51c6\u5907\u53c2\u4e0e\u6ee1\u8fd4\u6d3b\u52a8", (Object)tradeInfo.getTradeCode());
            return this.tradeSyncService.specialJoinInActivity(tradeInfo);
        }
        return Maps.newHashMap();
    }

    private void validate(TradeInfoReqDto tradeInfo) {
        if (StringUtils.isEmpty((CharSequence)tradeInfo.getMemberNo())) {
            logger.info("\u4f1a\u5458\u7f16\u53f7\u4e0d\u5b58\u5728\uff0c\u4e0d\u5904\u7406");
            throw new BizException("\u4f1a\u5458\u7f16\u53f7\u4e0d\u5b58\u5728\uff0c\u4e0d\u5904\u7406");
        }
        if (StringUtils.isEmpty((CharSequence)tradeInfo.getTradeCode())) {
            logger.info("\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728\uff0c\u4e0d\u5904\u7406");
            throw new BizException("\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728\uff0c\u4e0d\u5904\u7406");
        }
        if (StringUtils.isEmpty((CharSequence)tradeInfo.getShopCode())) {
            logger.info("\u5e97\u94fa\u4e3a\u7a7a\uff0c\u4e0d\u5904\u7406");
            throw new BizException("\u5e97\u94fa\u4e3a\u7a7a\uff0c\u4e0d\u5904\u7406");
        }
        ShopInfoDto shopData = (ShopInfoDto)this.shopInfoQueryApi.get(tradeInfo.getShopCode()).getData();
        if (shopData == null) {
            logger.info("\u5e97\u94fa{}\u4e0d\u5b58\u5728\uff0c\u4e0d\u5904\u7406", (Object)tradeInfo.getShopCode());
            throw new BizException("\u5e97\u94fa\u4e0d\u5b58\u5728\uff0c\u4e0d\u5904\u7406");
        }
        ActivityJoinLogEo forQuery = new ActivityJoinLogEo();
        forQuery.setOrderCode(tradeInfo.getInnerTradeCode());
        if (CollectionUtils.isNotEmpty((Collection)this.activityJoinLogDas.select((BaseEo)forQuery))) {
            logger.info("\u8ba2\u5355{}\u5df2\u8bb0\u5f55\uff0c\u4e0d\u91cd\u590d\u8bb0\u5f55", (Object)tradeInfo.getTradeCode());
            throw new BizException("\u8ba2\u5355\u5df2\u8bb0\u5f55\uff0c\u4e0d\u91cd\u590d\u8bb0\u5f55");
        }
    }
}

