/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.member.api.common.condition.Criteria;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.TargetCustomerSimpleDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ExcActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ExcItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PreviewActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PromotionActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PromotionCouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityDimensionEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.BizActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.TargetCustomerType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.TargetMallType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IEngineApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponCategoryEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.PreviewCouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.SimpleCouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityCoupon;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.UnuesdActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.SrcTypeUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.utils.SerializableCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityPreviewService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.seckill.util.SeckillKeyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityPreviewServiceImpl
implements IActivityPreviewService {
    private static Logger logger = LoggerFactory.getLogger(ActivityPreviewServiceImpl.class);
    @Resource
    private IItemActivityTagService itemActivityTagService;
    @Resource
    private ICouponExtQueryService couponExtQueryService;
    @Resource
    private IEngineApi engineApi;
    @Resource
    private IActivityService activityService;
    @Resource
    private ICacheService commonCacheService;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Autowired
    private ActivityDas activityDas;

    @Override
    public PreviewActivityRespDto previewActivity(EngineParams engineParams) {
        Long current = System.currentTimeMillis();
        PreviewActivityRespDto previewActivityRespDto = new PreviewActivityRespDto();
        Map<Integer, List<ItemActivityTagDto>> tagMap = this.queryActivityTags(engineParams.getItems(), engineParams.getActivityFlag(), engineParams.getUserId(), engineParams.getSrcType());
        logger.info("tagMap:{}", tagMap);
        ArrayList unusedActivityList = Lists.newArrayList();
        List<Object> coupons = Lists.newArrayList();
        if (tagMap.containsKey(ActivityDimensionEnum.COUPON.getKey()) && CollectionUtils.isNotEmpty((Collection)(coupons = engineParams.getActivityFlag() != false ? this.getCouponList(this.getCurrentCustomerOrgId(engineParams.getUserId()), tagMap.get(ActivityDimensionEnum.COUPON.getKey())) : this.getCouponList(engineParams.getUserId(), tagMap.get(ActivityDimensionEnum.COUPON.getKey()))))) {
            List couponActivityList = coupons.stream().map(couponDto -> new UnuesdActivityDto(couponDto.getActivityId(), couponDto.getId())).collect(Collectors.toList());
            unusedActivityList.addAll(couponActivityList);
        }
        List<Object> activityIds = Lists.newArrayList();
        if (tagMap.containsKey(ActivityDimensionEnum.ITEM.getKey())) {
            logger.info("\u9650\u65f6\u7279\u4ef7\u6807\u7b7e\u4fe1\u606f\uff1a{}", tagMap.get(ActivityDimensionEnum.ITEM.getKey()));
            List itemActivityIds = tagMap.get(ActivityDimensionEnum.ITEM.getKey()).stream().map(ItemActivityTagDto::getActivityId).distinct().collect(Collectors.toList());
            List couponActivityList = itemActivityIds.stream().map(e -> new UnuesdActivityDto(e, null)).collect(Collectors.toList());
            unusedActivityList.addAll(couponActivityList);
            activityIds.addAll(itemActivityIds);
        }
        if (tagMap.containsKey(ActivityDimensionEnum.ORDER.getKey())) {
            List orderActivityIds = tagMap.get(ActivityDimensionEnum.ORDER.getKey()).stream().map(ItemActivityTagDto::getActivityId).distinct().collect(Collectors.toList());
            List orderActivityList = orderActivityIds.stream().map(activityId -> new UnuesdActivityDto(activityId, null)).collect(Collectors.toList());
            unusedActivityList.addAll(orderActivityList);
            activityIds.addAll(orderActivityIds);
        }
        logger.info("activityIds:{}\uff0cunusedActivityList:{}", (Object)activityIds, (Object)unusedActivityList);
        if (CollectionUtils.isNotEmpty((Collection)unusedActivityList)) {
            engineParams.setUnusedActivityList((List)unusedActivityList);
            if (CollectionUtils.isNotEmpty((Collection)engineParams.getActivityIds())) {
                logger.info("\u9884\u89c8\u63a5\u53e3\u6267\u884c\u524d:{}", (Object)engineParams);
                engineParams = this.preview(engineParams, null, null);
                logger.info("\u9884\u89c8\u63a5\u53e3\u6267\u884c\u540e:{}", (Object)engineParams);
            }
            logger.info("engineParams:{}", (Object)engineParams);
            List<UnuesdActivityDto> unusedActivityDos = engineParams.getUnusedActivityList().parallelStream().map(UnuesdActivityDto::clone).collect(Collectors.toList());
            engineParams.setActivityIds((List)Lists.newArrayList());
            engineParams.setUnusedActivityList((List)Lists.newArrayList());
            engineParams.getExtendsAttribute().put("validateJoinNum", false);
            if (CollectionUtils.isNotEmpty(coupons)) {
                List<PreviewCouponRespDto> couponList = this.handleCoupon(engineParams, coupons, unusedActivityDos);
                previewActivityRespDto.setCouponList(couponList);
            }
            if (CollectionUtils.isNotEmpty((Collection)activityIds) && CollectionUtils.isNotEmpty((Collection)(activityIds = this.clearCombinationActivity(engineParams, activityIds)))) {
                ArrayList excActivityRespDtos = Lists.newArrayList();
                List<PromotionActivityRespDto> activityList = this.handleActivity(engineParams, activityIds, unusedActivityDos, excActivityRespDtos);
                previewActivityRespDto.setActivityList(activityList);
                previewActivityRespDto.setExcActivityList((List)excActivityRespDtos);
            }
        } else {
            logger.info("\u8ba2\u5355\u6ca1\u6709\u53ef\u9884\u89c8\u7684\u4f18\u60e0\u5238\u548c\u4fc3\u9500\u6d3b\u52a8");
        }
        logger.info("\u8017\u65f6{}", (Object)(System.currentTimeMillis() - current));
        return previewActivityRespDto;
    }

    public List<Long> clearCombinationActivity(EngineParams engineParams, List<Long> activityIds) {
        List<ActivityRespDto> activitys = this.activityService.queryActivityListByIds(activityIds);
        List allCombinationIds = activitys.stream().filter(activity -> activity.getActivityTemplateId().equals(ActivityType.COMBINATION_ACTIVITY.getId())).map(ActivityRespDto::getId).collect(Collectors.toList());
        List itemCombinationIds = engineParams.getItems().stream().map(ItemVo::getCombinedPackageActivityId).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList newActivityIds = Lists.newArrayList();
        for (ActivityRespDto activity2 : activitys) {
            if (allCombinationIds.contains(activity2.getId()) && !itemCombinationIds.contains(activity2.getId())) continue;
            newActivityIds.add(activity2.getId());
        }
        logger.info("\u8fc7\u6ee4\u6389\u5355\u4e70\u7684\u4f18\u60e0\u5957\u88c5\u5546\u54c1\uff1a{}", (Object)newActivityIds);
        return newActivityIds;
    }

    @Override
    public PromotionCouponRespDto queryActivityByItem(ItemActivityTagQueryReqDto itemActivityTagQueryReqDto) {
        ActivityRespDto activityRespDto;
        ActivityEo eo;
        Map<Long, ActivityEo> activityMap;
        List eos;
        ArrayList sqlFilters;
        ActivityEo activityEo;
        logger.info("queryActivityByItem\u6267\u884c\u53c2\u6570:{}", (Object)itemActivityTagQueryReqDto);
        PromotionCouponRespDto promotionCouponRespDto = new PromotionCouponRespDto();
        if (Objects.isNull(itemActivityTagQueryReqDto.getCustomerId())) {
            throw new ProBizException("\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList tags = this.itemActivityTagService.queryList(itemActivityTagQueryReqDto);
        logger.info("es\u67e5\u8be2\u6d3b\u52a8\u6807\u7b7e\u7ed3\u679c:{}", tags);
        HashSet<Long> set = new HashSet<Long>();
        ArrayList newTags = Lists.newArrayList();
        CustomerRespDto customerInfo = (CustomerRespDto)this.customerQueryApi.queryById(itemActivityTagQueryReqDto.getCustomerId()).getData();
        logger.info("\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)customerInfo));
        for (ItemActivityTagDto tag : tags) {
            Boolean customerFlag;
            Boolean mallFlag;
            if (!set.add(tag.getActivityId()) || !(mallFlag = this.validateTargetMall(tag.getActivityId(), itemActivityTagQueryReqDto.getSrcType())).booleanValue() || !(customerFlag = this.validateTargetCustomer(tag.getActivityId(), itemActivityTagQueryReqDto.getCustomerId(), customerInfo)).booleanValue()) continue;
            newTags.add(tag);
        }
        tags = newTags;
        Map<Integer, List<ItemActivityTagDto>> tagMap = tags.stream().collect(Collectors.groupingBy(ItemActivityTagDto::getDimension));
        List<Object> coupons = Lists.newArrayList();
        ArrayList couponList = Lists.newArrayList();
        if (tagMap.containsKey(ActivityDimensionEnum.COUPON.getKey())) {
            coupons = this.getCouponList(this.getCurrentCustomerOrgId(itemActivityTagQueryReqDto.getCustomerId()), tagMap.get(ActivityDimensionEnum.COUPON.getKey()));
        }
        for (CouponExtRespDto coupon : coupons) {
            SimpleCouponRespDto couponRespDto = new SimpleCouponRespDto();
            couponRespDto.setCouponId(coupon.getId());
            couponRespDto.setActivityId(coupon.getActivityId());
            couponRespDto.setCouponTemplateId(coupon.getCouponTemplate().getId());
            couponRespDto.setCouponCategory(coupon.getCouponTemplate().getCouponCategory());
            couponRespDto.setActivityTag(coupon.getCouponTemplate().getActivityTag());
            couponList.add(couponRespDto);
        }
        promotionCouponRespDto.setCouponList((List)couponList);
        List<Object> activityIds = Lists.newArrayList();
        ArrayList activityRespDtos = Lists.newArrayList();
        if (tagMap.containsKey(ActivityDimensionEnum.ORDER.getKey())) {
            activityIds = tagMap.get(ActivityDimensionEnum.ORDER.getKey()).stream().map(ItemActivityTagDto::getActivityId).distinct().collect(Collectors.toList());
            activityEo = new ActivityEo();
            sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.in((String)"id", (Object)activityIds));
            activityEo.setSqlFilters((List)sqlFilters);
            logger.info("\u67e5\u8be2\u6d3b\u52a8\u6570\u636e\u53c2\u6570:{}", (Object)activityEo);
            eos = this.activityDas.select((BaseEo)activityEo);
            logger.info("\u67e5\u8be2\u6d3b\u52a8\u6570\u636e\u7ed3\u679c:{}", (Object)eos);
            activityMap = eos.stream().collect(Collectors.toMap(BaseEo::getId, e -> e, (e1, e2) -> e1));
            for (ItemActivityTagDto itemActivityTagDto : tagMap.get(ActivityDimensionEnum.ORDER.getKey())) {
                if (!activityMap.containsKey(itemActivityTagDto.getActivityId())) continue;
                eo = activityMap.get(itemActivityTagDto.getActivityId());
                activityIds.add(itemActivityTagDto.getActivityId());
                activityRespDto = new ActivityRespDto();
                activityRespDto.setId(itemActivityTagDto.getActivityId());
                activityRespDto.setActivityTemplateId(eo.getActivityTemplateId());
                activityRespDtos.add(activityRespDto);
            }
        }
        if (tagMap.containsKey(ActivityDimensionEnum.ITEM.getKey())) {
            activityIds = tagMap.get(ActivityDimensionEnum.ITEM.getKey()).stream().map(ItemActivityTagDto::getActivityId).distinct().collect(Collectors.toList());
            activityEo = new ActivityEo();
            sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.in((String)"id", (Object)activityIds));
            activityEo.setSqlFilters((List)sqlFilters);
            logger.info("\u5546\u54c1\u7ef4\u5ea6\uff0c\u67e5\u8be2\u6d3b\u52a8\u6570\u636e\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)activityEo));
            eos = this.activityDas.select((BaseEo)activityEo);
            logger.info("\u5546\u54c1\u7ef4\u5ea6\uff0c\u67e5\u8be2\u6d3b\u52a8\u6570\u636e\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)eos));
            activityMap = eos.stream().filter(e -> Objects.equals(ActivityType.TIME_DISCOUNT_TOB_ACTIVITY.getId(), e.getActivityTemplateId())).collect(Collectors.toMap(BaseEo::getId, e -> e, (e1, e2) -> e1));
            for (ItemActivityTagDto itemActivityTagDto : tagMap.get(ActivityDimensionEnum.ITEM.getKey())) {
                if (!activityMap.containsKey(itemActivityTagDto.getActivityId())) continue;
                eo = activityMap.get(itemActivityTagDto.getActivityId());
                activityIds.add(itemActivityTagDto.getActivityId());
                activityRespDto = new ActivityRespDto();
                activityRespDto.setId(itemActivityTagDto.getActivityId());
                activityRespDto.setActivityTemplateId(eo.getActivityTemplateId());
                activityRespDtos.add(activityRespDto);
            }
        }
        promotionCouponRespDto.setPromotionActivityIds((List)activityIds);
        promotionCouponRespDto.setActivityRespDtos((List)activityRespDtos);
        return promotionCouponRespDto;
    }

    @Override
    public Long getCurrentCustomerOrgId(Long customerId) {
        List customerList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds((List)Lists.newArrayList((Object[])new Long[]{customerId})));
        return ((CustomerRespDto)customerList.get(0)).getOrgInfoId();
    }

    private Map<Integer, List<ItemActivityTagDto>> queryActivityTags(List<ItemVo> itemVos, Boolean activityFlag, Long userId, Integer srcType) {
        ArrayList itemIds = Lists.newArrayList();
        ArrayList shopIds = Lists.newArrayList();
        ArrayList shopItems = Lists.newArrayList();
        for (ItemVo itemVo : itemVos) {
            itemIds.add(Long.valueOf(itemVo.getItemId()));
            shopIds.add(Long.valueOf(itemVo.getShopId()));
            shopItems.add(itemVo.getShopId() + itemVo.getItemId());
        }
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setPreheatStartTime(new Date());
        queryReqDto.setItemIdList((List)itemIds);
        queryReqDto.setShopIdList((List)shopIds);
        queryReqDto.setDimensionList((List)Lists.newArrayList((Object[])new Integer[]{ActivityDimensionEnum.ORDER.getKey(), ActivityDimensionEnum.COUPON.getKey(), ActivityDimensionEnum.ITEM.getKey()}));
        ArrayList tags = this.itemActivityTagService.queryList(queryReqDto);
        logger.info("queryActivityTags,\u6807\u7b7e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(tags));
        if (activityFlag.booleanValue()) {
            HashSet<Long> set = new HashSet<Long>();
            ArrayList newTags = Lists.newArrayList();
            CustomerRespDto customerInfo = (CustomerRespDto)this.customerQueryApi.queryById(userId).getData();
            for (ItemActivityTagDto tag2 : tags) {
                Boolean customerFlag;
                Boolean mallFlag;
                if (!set.add(tag2.getActivityId()) || !(mallFlag = this.validateTargetMall(tag2.getActivityId(), srcType)).booleanValue() || !(customerFlag = this.validateTargetCustomer(tag2.getActivityId(), userId, customerInfo)).booleanValue()) continue;
                newTags.add(tag2);
            }
            tags = newTags;
        }
        return tags.stream().filter(tag -> shopItems.contains(tag.getShopId() + tag.getItemId().toString())).collect(Collectors.groupingBy(ItemActivityTagDto::getDimension));
    }

    @Override
    public Boolean validateTargetCustomer(Long activityId, Long customerId, CustomerRespDto customerInfo) {
        String targetCustomer = (String)this.commonCacheService.getCache(SeckillKeyUtil.getCacheKey("activity_target_customer", activityId), String.class);
        logger.info("\u83b7\u53d6\u5230\u6d3b\u52a8\u7f13\u5b58:{}", (Object)targetCustomer);
        TargetCustomerSimpleDto targetCustomerInfoDto = (TargetCustomerSimpleDto)JSON.parseObject((String)targetCustomer, TargetCustomerSimpleDto.class);
        if (Objects.isNull(targetCustomerInfoDto)) {
            return true;
        }
        TargetCustomerType populationType = TargetCustomerType.getByType((Integer)targetCustomerInfoDto.getType());
        if (null == populationType) {
            populationType = TargetCustomerType.ALL;
        }
        switch (populationType) {
            case ALL: {
                return true;
            }
            case CATEGORY: {
                return this.category(targetCustomerInfoDto, customerInfo);
            }
            case CROWD: {
                return this.crowd(customerId, targetCustomerInfoDto);
            }
        }
        return true;
    }

    @Override
    public Boolean validateTargetMall(Long activityId, Integer srcType) {
        srcType = SrcTypeUtil.getCurrSrcType();
        logger.info("\u4ece\u8bf7\u6c42\u5934\u83b7\u53d6\u5230\u5f53\u524d\u6765\u6e90\uff1a{}", (Object)srcType);
        String targetMall = (String)this.commonCacheService.getCache(SeckillKeyUtil.getCacheKey("activity_target_mall", activityId), String.class);
        List mallTypes = JSON.parseArray((String)targetMall, Integer.class);
        logger.info("validateTargetMall\uff0c\u5546\u57ce\u7c7b\u578b\uff1a{}", (Object)JSON.toJSONString((Object)targetMall));
        if (CollectionUtils.isNotEmpty((Collection)mallTypes)) {
            if (mallTypes.size() == 1 && ((Integer)mallTypes.get(0)).equals(TargetMallType.ALL.getType())) {
                return true;
            }
            return mallTypes.contains(srcType);
        }
        return true;
    }

    private Boolean category(TargetCustomerSimpleDto value, CustomerRespDto customerInfo) {
        if (Objects.isNull(value)) {
            return true;
        }
        if (Objects.nonNull(customerInfo)) {
            Long customerTypeId = customerInfo.getCustomerTypeId();
            List regionCodeList = customerInfo.getRegionCodeList();
            List customerTypeIds = value.getCustomerTypeIds();
            List customerAreaCodes = value.getCustomerAreaCodes();
            List subAreaCodes = value.getSubAreaCodes();
            List blackCustomerIds = value.getBlackCustomerIds();
            if (CollectionUtils.isEmpty((Collection)subAreaCodes)) {
                subAreaCodes = customerAreaCodes;
            }
            if (!CollectionUtils.isEmpty((Collection)customerTypeIds) && !customerTypeIds.contains(customerTypeId)) {
                return false;
            }
            if (!CollectionUtils.isEmpty((Collection)subAreaCodes)) {
                if (CollectionUtils.isEmpty((Collection)regionCodeList)) {
                    return false;
                }
                List finalSubAreaCodes = subAreaCodes;
                if (!regionCodeList.stream().anyMatch(e -> finalSubAreaCodes.contains(e))) {
                    return false;
                }
            }
            if (!CollectionUtils.isEmpty((Collection)blackCustomerIds) && blackCustomerIds.contains(customerInfo.getId())) {
                return false;
            }
        }
        return true;
    }

    private Boolean crowd(Long userId, TargetCustomerSimpleDto value) {
        if (Objects.isNull(value) || CollectionUtils.isEmpty((Collection)value.getCustomerIds())) {
            return true;
        }
        if (value.getCustomerIds().contains(userId)) {
            return true;
        }
        return false;
    }

    private List<PreviewCouponRespDto> handleCoupon(EngineParams engineParams, List<CouponExtRespDto> coupons, List<UnuesdActivityDto> unusedActivityDtos) {
        ArrayList couponList = Lists.newArrayList();
        logger.info("userId={}\uff0c\u9884\u89c8\u7684\u4f18\u60e0\u5238\u6570\u91cf={}", (Object)engineParams.getUserId(), (Object)coupons.size());
        if (CollectionUtils.isEmpty(coupons)) {
            return couponList;
        }
        for (CouponExtRespDto coupon : coupons) {
            UnuesdActivityDto couponActivityDto;
            int status = 0;
            PreviewCouponRespDto couponRespDto = new PreviewCouponRespDto();
            CubeBeanUtils.copyProperties((Object)couponRespDto, (Object)coupon, (String[])new String[0]);
            couponRespDto.setCouponCategory(coupon.getCouponTemplate().getCouponCategory());
            couponRespDto.setActivityTag(coupon.getCouponTemplate().getActivityTag());
            EngineParams result = this.preview(engineParams, coupon.getActivityId(), coupon.getId());
            if (result.getActivityIds().contains(coupon.getActivityId()) && unusedActivityDtos.contains(couponActivityDto = new UnuesdActivityDto(coupon.getActivityId(), coupon.getId()))) {
                status = 1;
            }
            if (null != result.getActivityShopsMapping()) {
                couponRespDto.setShopList((List)result.getActivityShopsMapping().get(coupon.getActivityId().toString()));
            }
            if (status == 0) {
                couponRespDto.setUnableReason(this.getReason(coupon.getActivityId(), result));
            }
            couponRespDto.setStatus(Integer.valueOf(status));
            couponList.add(couponRespDto);
        }
        return couponList;
    }

    private List<CouponExtRespDto> getCouponList(Long userId, List<ItemActivityTagDto> tags) {
        Criteria criteria = new Criteria();
        String currentStr = DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)new Date());
        ArrayList sqlFilterList = Lists.newArrayList();
        sqlFilterList.add(SqlFilter.eq((String)"user_id", (Object)userId));
        sqlFilterList.add(SqlFilter.eq((String)"coupon_status", (Object)CouponStatusEnum.CREATE.getStatus()));
        sqlFilterList.add(SqlFilter.le((String)"effective_time", (Object)currentStr));
        sqlFilterList.add(SqlFilter.gt((String)"invalid_time", (Object)currentStr));
        criteria.setFilters((List)sqlFilterList);
        PageInfo<CouponExtRespDto> pageInfo = this.couponExtQueryService.queryByPage(criteria, (Integer)1, (Integer)1000);
        logger.info("\u7528\u6237userId={},\u67e5\u8be2\u5230\u5df2\u9886\u53d6\u53ef\u7528\u4f18\u60e0\u5238\u6570\u91cf\uff1a{}", (Object)userId, (Object)pageInfo.getList().size());
        return pageInfo.getList().stream().filter(coupon -> {
            boolean enable = true;
            if (tags.stream().noneMatch(tag -> tag.getActivityId().equals(coupon.getActivityId()))) {
                enable = false;
            }
            Integer category = coupon.getCouponTemplate().getCouponCategory();
            if (!CouponCategoryEnum.DISCOUNT.getCategory().equals(category) && !CouponCategoryEnum.QUOTA_CASH.getCategory().equals(category)) {
                enable = false;
            }
            return enable;
        }).collect(Collectors.toList());
    }

    private List<PromotionActivityRespDto> handleActivity(EngineParams engineParams, List<Long> activityIds, List<UnuesdActivityDto> unusedActivityDtos, List<ExcActivityRespDto> excActivityList) {
        ArrayList activityList = Lists.newArrayList();
        List<ActivityRespDto> activityRespDtos = this.activityService.queryByIds(activityIds);
        logger.info("activityRespDtos:{},engineParams:{},activityIds:{},unusedActivityDtos:{},excActivityList:{}", new Object[]{activityRespDtos, engineParams, activityIds, unusedActivityDtos, excActivityList});
        logger.info("\u9884\u89c8\u4fc3\u9500\u6d3b\u52a8userId={}, \u6570\u91cf{}", (Object)engineParams.getUserId(), (Object)activityRespDtos.size());
        for (ActivityRespDto activity : activityRespDtos) {
            ExcActivityRespDto excActivityRespDto2;
            UnuesdActivityDto unuesdActivityDto;
            if (Objects.equals(activity.getActivityTemplateId(), BizActivityType.SECKILL_TOB_ACTIVITY.getId())) {
                logger.info("\u8df3\u8fc7\u62a2\u8d2d\u6d3b\u52a8\uff1a{}", (Object)JSON.toJSONString((Object)activity));
                continue;
            }
            int status = 0;
            if (activity.getActivityTemplateId().equals(ActivityType.EXCHANGE_ACTIVITY.getId())) {
                engineParams.getExtendsAttribute().put("exchangeItemAddMode", 0);
                engineParams.getExtendsAttribute().put("filterExcItem", true);
            }
            PromotionActivityRespDto activityRespDto = new PromotionActivityRespDto();
            CubeBeanUtils.copyProperties((Object)activityRespDto, (Object)activity, (String[])new String[0]);
            engineParams.setHandleActivityFlag(Boolean.valueOf(true));
            EngineParams result = this.preview(engineParams, activity.getId(), null);
            logger.info("preview:{},result:{}", (Object)activity.getId(), (Object)result);
            if (!result.getHandleActivityFlag().booleanValue()) continue;
            if (result.getActivityIds().contains(activity.getId()) && unusedActivityDtos.contains(unuesdActivityDto = new UnuesdActivityDto(activity.getId(), null))) {
                status = 1;
                activityRespDto.setShopSkuList((List)result.getActivitySkusMapping().get(activity.getId().toString()));
            }
            if (null != result.getActivityShopsMapping()) {
                activityRespDto.setShopList((List)result.getActivityShopsMapping().get(activity.getId().toString()));
            }
            if (status == 0) {
                activityRespDto.setUnableReason(this.getReason(activity.getId(), result));
            }
            activityRespDto.setStatus(Integer.valueOf(status));
            activityRespDto.setActivityId(activity.getId());
            activityRespDto.setActivityTemplateId(activity.getActivityTemplateId());
            activityList.add(activityRespDto);
            logger.info("activityList:{}", (Object)activityList);
            if (status != 1 || !activity.getActivityTemplateId().equals(ActivityType.EXCHANGE_ACTIVITY.getId()) || !excActivityList.stream().noneMatch(excActivityRespDto -> excActivityRespDto.getActivityId().equals(activity.getId())) || null == (excActivityRespDto2 = this.assembleExcActivity(result, activity.getId()))) continue;
            excActivityList.add(excActivityRespDto2);
        }
        return activityList;
    }

    private ExcActivityRespDto assembleExcActivity(EngineParams result, Long activityId) {
        if (CollectionUtils.isNotEmpty((Collection)result.getExcItems())) {
            Integer itemLimit = (Integer)result.getExtendsAttribute().get("exchangeItemLimit");
            Map skuLimitMap = result.getExtendsAttribute().getOrDefault("limitQuantitySingle", new HashMap());
            ExcActivityRespDto excActivityRespDto = new ExcActivityRespDto();
            excActivityRespDto.setActivityId(activityId);
            excActivityRespDto.setItemLimit(itemLimit);
            List excItems = result.getExcItems().stream().map(itemVo -> {
                ExcItemRespDto excItem = new ExcItemRespDto();
                excItem.setItemId(Long.valueOf(itemVo.getItemId()));
                excItem.setShopId(Long.valueOf(itemVo.getShopId()));
                excItem.setSkuId(Long.valueOf(itemVo.getSkuId()));
                String key = itemVo.getShopId() + itemVo.getSkuId();
                if (skuLimitMap.containsKey(key)) {
                    excItem.setExchangeNum(Long.valueOf(((Integer)skuLimitMap.get(key)).longValue()));
                }
                excItem.setPrice(itemVo.getPrice());
                return excItem;
            }).collect(Collectors.toList());
            excActivityRespDto.setExcItems(excItems);
            return excActivityRespDto;
        }
        return null;
    }

    private EngineParams preview(EngineParams engineParams, Long activityId, Long couponId) {
        EngineParams params = SerializableCopyUtil.copy(engineParams);
        if (null == params.getActivityIds()) {
            params.setActivityIds((List)Lists.newArrayList());
        }
        if (null != couponId) {
            ActivityCoupon activityCoupon = new ActivityCoupon();
            activityCoupon.setCouponIds((List)Lists.newArrayList((Object[])new Long[]{couponId}));
            activityCoupon.setActivityId(activityId);
            params.getActivityCouponList().add(activityCoupon);
        }
        if (null != activityId) {
            params.getActivityIds().add(activityId);
        }
        return (EngineParams)this.engineApi.execute("REVIEW_ACTIVITY", params).getData();
    }

    private String getReason(Long activityId, EngineParams result) {
        String reason = "\u672a\u6ee1\u8db3\u4f7f\u7528\u6761\u4ef6";
        if (result.getActivityReasonMap().containsKey(activityId.toString())) {
            reason = (String)result.getActivityReasonMap().get(activityId.toString());
        }
        return reason;
    }
}

