/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityTemplateCreateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityTemplateQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityTemplateUpdateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConstantsStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityTemplateRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBusinessRuntimeException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityPolicyMappingDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityTemplateDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityPolicyMappingEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityTemplateEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityTemplateServiceImpl
implements IActivityTemplateService {
    @Resource
    private ActivityTemplateDas activityTemplateDas;
    @Autowired
    private ActivityPolicyMappingDas activityPolicyMappingDas;

    @Override
    public ActivityTemplateRespDto queryActivityTemplateDetail(Long id) {
        ActivityTemplateEo activityTemplateEo = this.checkById(id, ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        ActivityTemplateRespDto activityTemplateRespDto = new ActivityTemplateRespDto();
        CubeBeanUtils.copyProperties((Object)activityTemplateRespDto, (Object)activityTemplateEo, (String[])new String[0]);
        return activityTemplateRespDto;
    }

    @Override
    public List<ActivityTemplateRespDto> queryActivityTemplateList(ActivityTemplateQueryReqDto activityTemplateQueryReqDto) {
        ActivityTemplateEo activityTemplateEo = this.fillQuery(activityTemplateQueryReqDto);
        List activityTemplateEoList = this.activityTemplateDas.select((BaseEo)activityTemplateEo);
        ArrayList<ActivityTemplateRespDto> activityTemplateRespDtoList = new ArrayList<ActivityTemplateRespDto>();
        CubeBeanUtils.copyCollection(activityTemplateRespDtoList, (Collection)activityTemplateEoList, ActivityTemplateRespDto.class);
        return activityTemplateRespDtoList;
    }

    @Override
    public PageInfo<ActivityTemplateRespDto> queryActivityTemplatePage(ActivityTemplateQueryReqDto activityTemplateQueryReqDto, Integer pageNum, Integer pageSize) {
        ActivityTemplateEo activityTemplateEo = this.fillQuery(activityTemplateQueryReqDto);
        PageInfo activityTemplateEoPageInfo = this.activityTemplateDas.selectPage((BaseEo)activityTemplateEo, pageNum, pageSize);
        ArrayList activityTemplateRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)activityTemplateEoPageInfo.getList(), activityTemplateRespDtoList, ActivityTemplateRespDto.class);
        activityTemplateEoPageInfo.setList(activityTemplateRespDtoList);
        return activityTemplateEoPageInfo;
    }

    private ActivityTemplateEo fillQuery(ActivityTemplateQueryReqDto activityTemplateQueryReqDto) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        ActivityTemplateEo activityTemplateEo = ActivityTemplateEo.newInstance();
        CubeBeanUtils.copyProperties((Object)activityTemplateEo, (Object)activityTemplateQueryReqDto, (String[])new String[0]);
        this.setQueryTimeConditions(activityTemplateEo, activityTemplateQueryReqDto.getCreateStartTime(), activityTemplateQueryReqDto.getCreateEndTime());
        return activityTemplateEo;
    }

    @Override
    @Transactional
    public Long addActivityTemplate(ActivityTemplateCreateReqDto activityTemplateCreateReqDto) {
        this.checkBase(activityTemplateCreateReqDto.getInstanceId(), activityTemplateCreateReqDto.getTenantId());
        ActivityTemplateEo selectEo = ActivityTemplateEo.newInstance();
        selectEo.setInstanceId(activityTemplateCreateReqDto.getInstanceId());
        selectEo.setTenantId(activityTemplateCreateReqDto.getTenantId());
        selectEo.setTemplateName(activityTemplateCreateReqDto.getTemplateName());
        if (this.activityTemplateDas.selectOne((BaseEo)selectEo) != null) {
            throw new ProBusinessRuntimeException(ProExceptionCode.TEMPLATE_NAME_EXISTS);
        }
        selectEo.setTemplateName(null);
        selectEo.setTemplateCode(activityTemplateCreateReqDto.getTemplateCode());
        if (this.activityTemplateDas.selectOne((BaseEo)selectEo) != null) {
            throw new ProBusinessRuntimeException(ProExceptionCode.TEMPLATE_CODE_EXISTS);
        }
        ActivityTemplateEo activityTemplateEo = BeanCopyUtil.copyProperties(ActivityTemplateEo.class, activityTemplateCreateReqDto, new String[0]);
        activityTemplateEo.setRuleConfig("");
        DtoHelper.dto2Eo((BaseVo)activityTemplateCreateReqDto, (BaseEo)activityTemplateEo);
        activityTemplateEo.setTemplateStatus(activityTemplateCreateReqDto.getTemplateStatusEnum().getKey());
        this.activityTemplateDas.insert((BaseEo)activityTemplateEo);
        this.activityPolicyMappingDas.batchInsert(activityTemplateEo, activityTemplateCreateReqDto.getPolicyIds());
        return activityTemplateEo.getId();
    }

    @Override
    @Transactional
    public void modifyActivityTemplate(Long id, ActivityTemplateUpdateReqDto activityTemplateUpdateReqDto) {
        this.checkBase(activityTemplateUpdateReqDto.getInstanceId(), activityTemplateUpdateReqDto.getTenantId());
        this.checkById(id, activityTemplateUpdateReqDto.getInstanceId(), activityTemplateUpdateReqDto.getTenantId());
        ActivityTemplateEo activityTemplateEo = new ActivityTemplateEo();
        CubeBeanUtils.copyProperties((Object)activityTemplateEo, (Object)activityTemplateUpdateReqDto, (String[])new String[0]);
        activityTemplateEo.setId(id);
        if (null != activityTemplateUpdateReqDto.getTemplateStatusEnum()) {
            activityTemplateEo.setTemplateStatus(activityTemplateUpdateReqDto.getTemplateStatusEnum().getKey());
        }
        if (!CollectionUtils.isEmpty((Collection)activityTemplateUpdateReqDto.getPolicyIds())) {
            ActivityPolicyMappingEo eo = ActivityPolicyMappingEo.newInstance();
            eo.setActivityTemplateId(id);
            this.activityPolicyMappingDas.delete((BaseEo)eo);
            this.activityPolicyMappingDas.batchInsert(activityTemplateEo, activityTemplateUpdateReqDto.getPolicyIds());
        }
        this.activityTemplateDas.updateSelective((BaseEo)activityTemplateEo);
    }

    @Override
    public void deleteActivityTemplate(Long id) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        this.checkById(id, ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        this.activityTemplateDas.logicDeleteById(id);
    }

    @Override
    public void enableActivityTemplate(Long id) {
        RequestDto requestDto = new RequestDto();
        requestDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        requestDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        this.updateActivityTemplateStatus(id, requestDto, ConstantsStatusEnum.ENABLE.getStatus());
    }

    @Override
    public void disableActivityTemplate(Long id) {
        RequestDto requestDto = new RequestDto();
        requestDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        requestDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        this.updateActivityTemplateStatus(id, requestDto, ConstantsStatusEnum.DISABLE.getStatus());
    }

    @Override
    public Integer isExists(Long id) {
        ActivityTemplateEo activityTemplateEo = new ActivityTemplateEo();
        activityTemplateEo.setId(id);
        return this.activityTemplateDas.count((BaseEo)activityTemplateEo);
    }

    private void setQueryTimeConditions(ActivityTemplateEo activityTemplateEo, String startTime, String endTime) {
        activityTemplateEo.setSqlFilters(SqlFilterBuilder.newInstance().buildBetweenSqlFilter("create_time", startTime, endTime).get());
    }

    private void updateActivityTemplateStatus(Long id, RequestDto requestDto, String status) {
        this.checkBase(requestDto.getInstanceId(), requestDto.getTenantId());
        ActivityTemplateEo activityTemplateEo = this.checkById(id, requestDto.getInstanceId(), requestDto.getTenantId());
        if (!status.equals(activityTemplateEo.getTemplateStatus())) {
            activityTemplateEo.setTemplateStatus(status);
            this.activityTemplateDas.updateSelective((BaseEo)activityTemplateEo);
        }
    }

    private void checkBase(Long instanceId, Long tenantId) {
    }

    private ActivityTemplateEo checkById(Long id, Long instanceId, Long tenantId) {
        ActivityTemplateEo activityTemplateEo = (ActivityTemplateEo)this.activityTemplateDas.selectByPrimaryKey(id);
        return activityTemplateEo;
    }
}

