/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopAreaDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopTransportPartnerDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopWarehouseDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.FreightCountRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.fallback.ShopFallBack;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-center-shop-api-query-IShopQueryApi", name="${yundt.cube.center.shop.api.name:yundt-cube-center-shop}", path="/v2/shop", url="${yundt.cube.center.shop.api:}", fallback=ShopFallBack.class)
public interface IShopQueryApi {
    @GetMapping(value={"/seller/{sellerId}"})
    public RestResponse<PageInfo<ShopDto>> queryBySellerId(@PathVariable(value="sellerId") long var1, @RequestParam(name="pageSize", defaultValue="10") int var3, @RequestParam(name="page", defaultValue="1") int var4);

    @GetMapping(value={"/tenant"})
    public RestResponse<PageInfo<ShopDto>> queryByTenantId(@RequestParam(value="tenantId") long var1, @RequestParam(name="pageSize", defaultValue="10") int var3, @RequestParam(name="page", defaultValue="1") int var4);

    @GetMapping(value={"/conditions"})
    public RestResponse<PageInfo<ShopDto>> queryByConditions(@ModelAttribute ShopQueryDto var1, @RequestParam(name="pageSize", defaultValue="10") int var2, @RequestParam(name="page", defaultValue="1") int var3);

    @GetMapping(value={"/{shopId}"})
    public RestResponse<ShopDto> queryById(@PathVariable(value="shopId") long var1, String ... var3);

    @GetMapping(value={"/base/{shopId}"})
    public RestResponse<ShopBaseDto> queryBaseById(@PathVariable(value="shopId") Long var1);

    @GetMapping(value={"/base/ids"})
    public RestResponse<List<ShopBaseDto>> queryBaseListByIds(@NotNull @RequestParam(value="shopIds") Set<Long> var1);

    @GetMapping(value={"/ids"})
    public RestResponse<List<ShopDto>> queryByIds(@NotNull @RequestParam(value="shopIds") Set<Long> var1);

    @GetMapping(value={"/area/list"})
    public RestResponse<List<ShopAreaDto>> queryShopAreas(@ModelAttribute ShopAreaDto var1);

    @GetMapping(value={"/storeShopList"})
    public RestResponse<PageInfo<ShopDto>> queryStoreShopList(@ModelAttribute ShopQueryDto var1, @RequestParam(name="pageSize", defaultValue="10") int var2, @RequestParam(name="page", defaultValue="1") int var3);

    @GetMapping(value={"/freight/count"})
    public RestResponse<FreightCountRespDto> countFreight(@RequestParam(name="addressId") Long var1, @RequestParam(name="shopId") Long var2);

    @GetMapping(value={"/{shopId}/warehouse"})
    public RestResponse<List<ShopWarehouseDto>> queryShopWarehouseByShopId(@PathVariable(value="shopId") Long var1, @RequestParam(value="type", required=false) Integer var2);

    @PostMapping(value={"/shops"})
    public RestResponse<PageInfo<ShopDto>> queryShopByQueryDto(@RequestBody ShopQueryDto var1, @RequestParam(name="pageSize", defaultValue="10") int var2, @RequestParam(name="page", defaultValue="1") int var3);

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u641c\u7d22\u5e97\u94fa\u5217\u8868")
    public RestResponse<List<ShopDto>> queryShopList(@ModelAttribute ShopQueryDto var1);

    @PostMapping(value={"/queryByCodes"})
    public RestResponse<List<ShopDto>> queryShopByCode(@RequestBody ShopQueryReqDto var1);

    @GetMapping(value={"/{shopId}/partners"})
    @ApiOperation(value="\u67e5\u8be2\u5e97\u94fa\u652f\u6301\u7684\u914d\u9001\u65b9\u5217\u8868")
    public RestResponse<List<ShopTransportPartnerDto>> queryShopTransportPartner(@PathVariable(value="shopId") Long var1);

    @GetMapping(value={"/freightTemplate/count/{freightTemplateId}"})
    public RestResponse<Integer> countByFreightTemplateId(@PathVariable(value="freightTemplateId") Long var1);
}

