/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.IDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerAreaDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerBatchReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerBusinessScopeReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerCertificationDeadlineDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.exception.SellerExceptionCode;
import com.dtyunxi.yundt.cube.center.shop.api.exception.ShopExceptionCode;
import com.dtyunxi.yundt.cube.center.shop.biz.constant.ShopConstant;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IAuditDataService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerBusinessScopeService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopService;
import com.dtyunxi.yundt.cube.center.shop.biz.util.BeanCopyUtil;
import com.dtyunxi.yundt.cube.center.shop.dao.das.SellerAreaDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.SellerDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.AuditDataEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerAreaEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerBusinessScopeEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SellerServiceImpl
implements ISellerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    SellerDas sellerDas;
    @Autowired
    ISellerBusinessScopeService sellerBusinessScopeService;
    @Autowired
    IAuditDataService auditDataService;
    @Autowired
    ShopDas shopDas;
    @Resource
    private SellerAreaDas sellerAreaDas;
    @Autowired
    IShopService ishopService;
    @Autowired
    private IContext iContext;
    @Resource
    private IDictApi dictApi;

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public void auditSeller(String status, String result, String auditPerson, Long tenantId, Long id) {
        AuditDataEo auditDataEoForSelect = AuditDataEo.newInstance();
        auditDataEoForSelect.setBusinessType("SELLER");
        auditDataEoForSelect.setId(id);
        auditDataEoForSelect.setTenantId(tenantId);
        AuditDataEo auditDataEo = this.auditDataService.queryAuditData(auditDataEoForSelect);
        if (auditDataEo == null) {
            this.logger.info("\u4e0d\u5b58\u5728\u5f85\u5ba1\u6838\u4fe1\u606f");
            throw new BizException(ShopExceptionCode.AUDITDATA_QUERY_DEFULT.getCode(), ShopExceptionCode.AUDITDATA_QUERY_DEFULT.getMsg());
        }
        auditDataEo.setStatus(status);
        auditDataEo.setAuditPerson(auditPerson);
        auditDataEo.setAuditTime(new Date());
        auditDataEo.setResult(result);
        if ("PASS".equals(status)) {
            SellerReqDto sellerReqDto = (SellerReqDto)JSON.parseObject((String)auditDataEo.getData(), (TypeReference)new TypeReference<SellerReqDto>(){}, (Feature[])new Feature[0]);
            long sellerId = auditDataEo.getBusinessId();
            SellerEo sellerEo = BeanCopyUtil.copyProperties((BaseVo)sellerReqDto, SellerEo.class);
            SellerEo sellerSelect = (SellerEo)this.sellerDas.selectByPrimaryKey(Long.valueOf(sellerId));
            if (sellerSelect != null) {
                sellerEo.setStatus("NORMAL");
                List sellerBusinessScopeDtoList = sellerReqDto.getSellerBusinessScopeReqDtoList();
                SellerBusinessScopeEo sellerBusinessScopeEo = (SellerBusinessScopeEo)BaseEo.newInstance(SellerBusinessScopeEo.class);
                for (SellerBusinessScopeReqDto sellerBusinessScopeReqDto : sellerBusinessScopeDtoList) {
                    DtoHelper.dto2Eo((BaseVo)sellerBusinessScopeReqDto, (BaseEo)sellerBusinessScopeEo);
                    this.sellerBusinessScopeService.modifySellerBusinessScope(sellerBusinessScopeEo);
                }
                this.sellerDas.updateSelective((BaseEo)sellerEo);
            } else {
                this.logger.info("\u6839\u636e\u5ba1\u6838\u4fe1\u606f\u4e2d\u7684data\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u7684\u5546\u6237\u4fe1\u606f");
                throw new BizException(ShopExceptionCode.SELLER_QUERY_DEFULT.getCode(), ShopExceptionCode.SELLER_QUERY_DEFULT.getMsg());
            }
        }
        this.auditDataService.modifyAuditData(auditDataEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public void modifySeller(SellerReqDto sellerReqDto, boolean isNeedAudit) {
        if (sellerReqDto.getId() != null) {
            if (!isNeedAudit) {
                SellerEo sellerEo = (SellerEo)BaseEo.newInstance(SellerEo.class, (Map)sellerReqDto.getExtFields());
                DtoHelper.dto2Eo((BaseVo)sellerReqDto, (BaseEo)sellerEo);
                List sellerBusinessScopeReqDtoList = sellerReqDto.getSellerBusinessScopeReqDtoList();
                ArrayList sellerBusinessScopeEoList = new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)sellerBusinessScopeReqDtoList)) {
                    CubeBeanUtils.copyCollection(sellerBusinessScopeEoList, (Collection)sellerBusinessScopeReqDtoList, SellerBusinessScopeEo.class);
                    this.sellerBusinessScopeService.removeBusinessBySellerId(sellerReqDto.getId());
                }
                for (SellerBusinessScopeEo sellerBusinessScopeEo : sellerBusinessScopeEoList) {
                    this.sellerBusinessScopeService.modifySellerBusinessScope(sellerBusinessScopeEo);
                }
                this.sellerDas.updateSelective((BaseEo)sellerEo);
            } else {
                AuditDataEo queryEo = AuditDataEo.newInstance();
                queryEo.setBusinessId(sellerReqDto.getId());
                queryEo.setBusinessType("SELLER");
                AuditDataEo auditDataEo = this.auditDataService.queryAuditData(queryEo);
                if (null == auditDataEo) {
                    auditDataEo = queryEo;
                    auditDataEo.setInstanceId(sellerReqDto.getInstanceId());
                    auditDataEo.setTenantId(sellerReqDto.getTenantId());
                }
                String jsonString = JSONObject.toJSONString((Object)sellerReqDto);
                auditDataEo.setData(jsonString);
                auditDataEo.setStatus("PENDING");
                if (null == auditDataEo.getId()) {
                    this.auditDataService.saveAuditData(auditDataEo);
                } else {
                    this.auditDataService.modifyAuditData(auditDataEo);
                }
                SellerEo sellerEoNow = (SellerEo)this.sellerDas.selectByPrimaryKey(sellerReqDto.getId());
                if (!"PENDING".equals(sellerEoNow.getStatus())) {
                    sellerEoNow.setStatus("PENDING");
                    this.sellerDas.updateSelective((BaseEo)sellerEoNow);
                }
            }
        } else {
            this.logger.info("\u66f4\u65b0\u5931\u8d25,\u6ca1\u6709\u5bf9\u5e94\u7684\u8981\u4fee\u6539\u4fe1\u606f\u7684id");
            throw new BizException(ShopExceptionCode.SELLER_UPDATE_DEFULT.getCode(), ShopExceptionCode.SELLER_UPDATE_DEFULT.getMsg());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public Long addSeller(SellerReqDto sellerDto, boolean isNeedAudit) {
        SellerEo sellerEo = SellerEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)sellerDto, (BaseEo)sellerEo);
        this.checkSellerName(sellerDto.getName());
        this.sellerDas.insert((BaseEo)sellerEo);
        Long sellerId = sellerEo.getId();
        if (isNeedAudit) {
            sellerEo.setStatus(StringUtils.isNotBlank((String)sellerDto.getStatus()) ? sellerDto.getStatus() : "PENDING");
            this.sellerDas.updateSelective((BaseEo)sellerEo);
            String jsonString = JSONObject.toJSONString((Object)sellerDto);
            AuditDataEo auditDataEo = new AuditDataEo();
            auditDataEo.setBusinessId(sellerId);
            auditDataEo.setData(jsonString);
            String applyCode = "" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMdd") + Math.round((Math.random() + 1.0) * 1000.0);
            auditDataEo.setApplyCode(applyCode);
            auditDataEo.setApplyType(sellerDto.getApplyType());
            auditDataEo.setBusinessType("SELLER");
            auditDataEo.setApplyPerson(StringUtils.isBlank((String)this.iContext.userName()) ? this.iContext.userId() + "" : this.iContext.userName());
            auditDataEo.setStatus(StringUtils.isNotBlank((String)sellerDto.getStatus()) ? sellerDto.getStatus() : "PENDING");
            auditDataEo.setInstanceId(sellerEo.getInstanceId());
            this.auditDataService.saveAuditData(auditDataEo);
        } else {
            List sellerBusinessScopeReqDtoList = sellerDto.getSellerBusinessScopeReqDtoList();
            if (!CollectionUtils.isEmpty((Collection)sellerBusinessScopeReqDtoList)) {
                ArrayList<SellerBusinessScopeEo> sellerBusinessScopeEoList = new ArrayList<SellerBusinessScopeEo>();
                CubeBeanUtils.copyCollection(sellerBusinessScopeEoList, (Collection)sellerBusinessScopeReqDtoList, SellerBusinessScopeEo.class);
                for (SellerBusinessScopeEo sellerBusinessScopeEo : sellerBusinessScopeEoList) {
                    sellerBusinessScopeEo.setSellerId(sellerId);
                    sellerBusinessScopeEo.setInstanceId(sellerEo.getInstanceId());
                }
                this.sellerBusinessScopeService.addSellerBusinessScopeBatch(sellerBusinessScopeEoList);
            }
        }
        if (Objects.nonNull(sellerEo.getIsSwitchMasterData()) && Objects.equals(sellerEo.getIsSwitchMasterData(), 1)) {
            RestResponseHelper.extractData((RestResponse)this.dictApi.removeDict(Long.valueOf(1L), "master_data_org", String.valueOf(sellerEo.getOrganizationId())));
            DictDto dictDto = new DictDto();
            dictDto.setGroupCode("master_data_org");
            dictDto.setCode(String.valueOf(sellerEo.getOrganizationId()));
            dictDto.setValue(sellerEo.getCode());
            dictDto.setStatement(sellerEo.getName());
            dictDto.setStatus(Integer.valueOf(1));
            dictDto.setType("sys");
            dictDto.setTenantId(sellerEo.getTenantId());
            RestResponseHelper.extractData((RestResponse)this.dictApi.saveDict(dictDto));
        }
        return sellerEo.getId();
    }

    @Override
    public SellerEo querySellerById(Long sellerId) {
        return (SellerEo)this.sellerDas.selectByPrimaryKey(sellerId);
    }

    @Override
    public List<SellerEo> queryByInstanceId(Long instanceId) {
        SellerEo sellerEo = SellerEo.newInstance();
        sellerEo.setInstanceId(instanceId);
        return this.sellerDas.select((BaseEo)sellerEo, false);
    }

    @Override
    public List<SellerEo> queryByTenantId(Long tenantId) {
        SellerEo sellerEo = SellerEo.newInstance();
        sellerEo.setTenantId(tenantId);
        return this.sellerDas.select((BaseEo)sellerEo, false);
    }

    @Override
    public PageInfo<SellerEo> queryPageSeller(SellerQueryReqDto sellerQueryReqDto) {
        SellerEo sellerEo = BeanCopyUtil.copyProperties((BaseVo)sellerQueryReqDto, SellerEo.class);
        sellerEo.setOrderByDesc("createTime");
        PageInfo pageSellerEo = this.sellerDas.selectPage((BaseEo)sellerEo, Integer.valueOf(sellerQueryReqDto.getPageNum()), Integer.valueOf(sellerQueryReqDto.getPageSize()));
        return pageSellerEo;
    }

    @Override
    public PageInfo<SellerEo> queryPageSellerByBusinessScope(SellerQueryReqDto sellerQueryReqDto) {
        PageInfo pageSellerEo = this.sellerDas.queryPageSeller(sellerQueryReqDto.getBusinessType(), sellerQueryReqDto.getBusinessId(), sellerQueryReqDto.getName(), sellerQueryReqDto.getStatus(), Integer.valueOf(sellerQueryReqDto.getPageNum()), Integer.valueOf(sellerQueryReqDto.getPageSize()));
        return pageSellerEo;
    }

    @Override
    public List<SellerEo> queryList(SellerQueryReqDto sellerQueryReqDto) {
        SellerEo sellerEo = BeanCopyUtil.copyProperties((BaseVo)sellerQueryReqDto, SellerEo.class);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty((Collection)sellerQueryReqDto.getOrganizationIds())) {
            sqlFilters.add(SqlFilter.in((String)"organizationId", (Object)sellerQueryReqDto.getOrganizationIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)sellerQueryReqDto.getIdList())) {
            sqlFilters.add(SqlFilter.in((String)"id", (Object)sellerQueryReqDto.getIdList()));
        }
        if (StringUtils.isNotBlank((String)sellerQueryReqDto.getName())) {
            sellerEo.setName(null);
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + StringUtils.trim((String)sellerQueryReqDto.getName()) + "%")));
        }
        sellerEo.setSqlFilters(sqlFilters);
        return this.sellerDas.select((BaseEo)sellerEo, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public void removeById(Long id) {
        SellerEo sellerEo = (SellerEo)this.sellerDas.selectByPrimaryKey(id);
        if (null == sellerEo) {
            this.logger.info("\u6839\u636eID\u627e\u4e0d\u5230\u5bf9\u5e94\u5546\u6237");
            throw new BizException(ShopExceptionCode.SELLER_QUERY_DEFULT.getCode(), ShopExceptionCode.SELLER_QUERY_DEFULT.getMsg());
        }
        ShopEo shopEo = ShopEo.newInstance();
        shopEo.setSellerId(id);
        if (this.shopDas.count((BaseEo)shopEo) > 0) {
            this.logger.info("\u8bf7\u5148\u89e3\u7ed1\u5546\u6237\u7ed1\u5b9a\u7684\u5e97\u94fa\u4fe1\u606f");
            throw new BizException(ShopExceptionCode.SELLE_DELETE_DEFULT.getCode(), ShopExceptionCode.SELLE_DELETE_DEFULT.getMsg());
        }
        this.sellerBusinessScopeService.removeBusinessBySellerId(id);
        this.sellerDas.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public void addBatchSeller(@Valid List<SellerBatchReqDto> sellerReqDtos, boolean audit) {
        if (audit) {
            sellerReqDtos.stream().forEach(dto -> {
                SellerReqDto reqDto = new SellerReqDto();
                CubeBeanUtils.copyProperties((Object)reqDto, (Object)dto, (String[])new String[0]);
                this.addSeller(reqDto, audit);
            });
        } else {
            List batchIds = Lists.partition(sellerReqDtos, (int)ShopConstant.BATCHES_SIZE);
            batchIds.stream().forEach(lists -> {
                LinkedList eos = new LinkedList();
                DtoHelper.dtoList2EoList((Collection)lists, eos, SellerEo.class);
                eos.stream().forEach(eo -> eo.setStatus("NORMAL"));
                this.sellerDas.insertBatch(eos);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public List<SellerRespDto> batchAddSeller(@Valid List<SellerBatchReqDto> sellerReqDtos, boolean audit) {
        ArrayList sellerRespDtoList = Lists.newArrayList();
        if (audit) {
            sellerReqDtos.stream().forEach(dto -> {
                SellerReqDto reqDto = new SellerReqDto();
                CubeBeanUtils.copyProperties((Object)reqDto, (Object)dto, (String[])new String[0]);
                Long id = this.addSeller(reqDto, audit);
                SellerRespDto sellerRespDto = new SellerRespDto();
                CubeBeanUtils.copyProperties((Object)sellerRespDto, (Object)dto, (String[])new String[0]);
                sellerRespDto.setId(id);
                sellerRespDtoList.add(sellerRespDto);
            });
        } else {
            List batchIds = Lists.partition(sellerReqDtos, (int)ShopConstant.BATCHES_SIZE);
            batchIds.stream().forEach(lists -> {
                LinkedList eos = new LinkedList();
                DtoHelper.dtoList2EoList((Collection)lists, eos, SellerEo.class);
                eos.forEach(eo -> eo.setStatus("NORMAL"));
                this.sellerDas.insertBatch(eos);
                DtoHelper.eoList2DtoList(eos, (Collection)sellerRespDtoList, SellerRespDto.class);
            });
        }
        return sellerRespDtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public Long addSellerArea(SellerAreaDto sellerAreaDto) {
        SellerAreaEo sellerAreaEo = SellerAreaEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)sellerAreaDto, (BaseEo)sellerAreaEo);
        this.sellerAreaDas.insert((BaseEo)sellerAreaEo);
        return sellerAreaEo.getId();
    }

    @Override
    public List<SellerAreaEo> querySellerAreaList(Long sellerId) {
        SellerAreaEo sellerAreaEo = SellerAreaEo.newInstance();
        sellerAreaEo.setSellerId(sellerId);
        return this.sellerAreaDas.select((BaseEo)sellerAreaEo);
    }

    @Override
    public List<SellerAreaEo> querySellerAreaList(SellerAreaDto sellerAreaDto) {
        SellerAreaEo sellerAreaEo = SellerAreaEo.newInstance();
        CubeBeanUtils.copyProperties((Object)sellerAreaEo, (Object)sellerAreaDto, (String[])new String[0]);
        return this.sellerAreaDas.select((BaseEo)sellerAreaEo);
    }

    @Override
    public Boolean checkSellerName(String sellerName) {
        return this.checkSellerName(sellerName, null);
    }

    @Override
    public Boolean checkSellerName(String sellerName, Long id) {
        if (Strings.isNullOrEmpty((String)sellerName)) {
            throw new BizException(SellerExceptionCode.SELLER_NAME_CAN_NOT_BE_EMPTY.getCode(), SellerExceptionCode.SELLER_NAME_CAN_NOT_BE_EMPTY.getMsg());
        }
        SellerEo sellerEo = new SellerEo();
        sellerEo.setName(sellerName);
        sellerEo.setDr(0);
        List select = this.sellerDas.select((BaseEo)sellerEo);
        if (!CollectionUtils.isEmpty((Collection)select) && !((SellerEo)select.get(0)).getId().equals(id)) {
            return true;
        }
        return false;
    }

    @Override
    public Integer updateState(Long sellerId, String state) {
        SellerEo sellerEo = new SellerEo();
        sellerEo.setId(sellerId);
        sellerEo.setStatus(state);
        int i = this.sellerDas.updateSelective((BaseEo)sellerEo);
        return i;
    }

    @Override
    public SellerEo querySellerByOrganizationId(Long organizationId) {
        Optional sellerEo = this.sellerDas.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dr", (Object)0)).eq((Object)"organization_id", (Object)organizationId)).stream().findFirst();
        return sellerEo.orElse(null);
    }

    @Override
    public SellerEo querySellerByOrganizationId(Long organizationId, Long instant, Long tenantId) {
        Optional sellerEo = this.sellerDas.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"organization_id", (Object)organizationId)).eq((Object)"dr", (Object)0)).eq((Object)"instant_Id", (Object)instant)).eq((Object)"tenant_Id", (Object)tenantId)).stream().findFirst();
        return sellerEo.orElse(null);
    }

    @Override
    public void batchUpdateSellerDeadline(SellerCertificationDeadlineDto sellerCertificationDeadlineDto) {
        this.logger.info("\u6279\u91cf\u4fee\u6539\u5ba2\u6237\u8ba4\u8bc1\u622a\u81f3\u65f6\u95f4ids,{}", (Object)sellerCertificationDeadlineDto.getSellerIds());
        this.logger.info("\u622a\u81f3\u65f6\u95f4,{}", (Object)sellerCertificationDeadlineDto.getSellerDeadline());
        if (CollectionUtils.isEmpty((Collection)sellerCertificationDeadlineDto.getSellerIds())) {
            throw new BizException("-1", "\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.sellerDas.updateSellerDeadline(sellerCertificationDeadlineDto.getSellerIds(), sellerCertificationDeadlineDto.getSellerDeadline());
        this.sellerDas.removeCache(sellerCertificationDeadlineDto.getSellerIds().stream().collect(Collectors.toSet()));
    }
}

