/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.CubeException;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SubStationDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SubStationQueryDto;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISubStationService;
import com.dtyunxi.yundt.cube.center.shop.dao.das.SubStationDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SubStationEo;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SubStationServiceImpl
implements ISubStationService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private SubStationDas subStationDas;

    @Override
    public Long addSubStation(SubStationDto subStationDto) {
        SubStationEo subStationEo = SubStationEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)subStationDto, (BaseEo)subStationEo);
        if (Strings.isNullOrEmpty((String)subStationEo.getCode())) {
            subStationEo.setCode(String.valueOf(this.generateCode()));
        }
        this.subStationDas.insert((BaseEo)subStationEo);
        return subStationEo.getId();
    }

    @Override
    @Transactional(rollbackFor={CubeException.class})
    public void modifySubStation(SubStationDto subStationDto, Long id) throws CubeException {
        SubStationEo subStationEo = (SubStationEo)this.subStationDas.selectByPrimaryKey(id);
        Assert.notNull((Object)subStationEo, (String)"\u6ca1\u6709\u8fd9\u4e2a\u5b50\u7ad9\u5bf9\u8c61");
        SubStationEo eo = SubStationEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)subStationDto, (BaseEo)eo);
        eo.setId(id);
        this.subStationDas.updateSelective((BaseEo)eo);
    }

    @Override
    public SubStationDto queryById(Long id) {
        SubStationEo eo = (SubStationEo)this.subStationDas.selectByPrimaryKey(id);
        SubStationDto dto = new SubStationDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        return dto;
    }

    @Override
    public PageInfo<SubStationDto> queryByConditions(SubStationQueryDto subStationQueryDto, int pageSize, int page) {
        ArrayList<SqlFilter> sqlFilterList;
        SubStationEo eo = SubStationEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)subStationQueryDto, (BaseEo)eo);
        if (eo != null && StringUtils.isNotBlank((CharSequence)eo.getName())) {
            sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.like((String)"name", (Object)("%" + StringUtils.trim((String)eo.getName()) + "%")));
            eo.setSqlFilters(sqlFilterList);
            eo.setName(null);
        }
        if (eo != null && StringUtils.isNotBlank((CharSequence)eo.getAddress())) {
            sqlFilterList = new ArrayList();
            sqlFilterList.add(SqlFilter.like((String)"address", (Object)("%" + StringUtils.trim((String)eo.getAddress()) + "%")));
            eo.setSqlFilters(sqlFilterList);
            eo.setAddress(null);
        }
        eo.setOrderByDesc("createTime");
        PageInfo eos = this.subStationDas.selectPage((BaseEo)eo, Integer.valueOf(page), Integer.valueOf(pageSize), Boolean.valueOf(true));
        ArrayList results = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)eos.getList())) {
            results = new ArrayList(eos.getList().size());
            DtoHelper.eoList2DtoList((Collection)eos.getList(), results, SubStationDto.class);
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)eos, (String[])new String[]{"list", "navigatepageNums"});
            pageInfo.setList(results);
            pageInfo.setNavigatepageNums(eos.getNavigatepageNums());
            return pageInfo;
        }
        return new PageInfo(results);
    }

    private Long generateCode() {
        return IdGenrator.getDistributedId();
    }
}

