/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopTransportPartnerDto;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ITransportPartnerService;
import com.dtyunxi.yundt.cube.center.shop.dao.das.TransportPartnerDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.TransportPartnerEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TransportPartnerServiceImpl
implements ITransportPartnerService {
    @Resource
    private TransportPartnerDas transportPartnerDas;

    @Override
    public void batchAddTransportPartners(ShopDto shopDto, List<ShopTransportPartnerDto> transportPartnerDtoList) {
        ArrayList transportPartnerEoList = Lists.newArrayList();
        DtoHelper.dtoList2EoList(transportPartnerDtoList, (Collection)transportPartnerEoList, TransportPartnerEo.class);
        transportPartnerEoList.forEach(eo -> {
            eo.setSellerId(shopDto.getSellerId());
            eo.setShopId(shopDto.getId());
        });
        this.transportPartnerDas.insertBatch((List)transportPartnerEoList);
    }

    @Override
    public void clear(Long sellerId, Long shopId) {
        TransportPartnerEo transportPartnerEoParam = TransportPartnerEo.newInstance();
        transportPartnerEoParam.setSellerId(sellerId);
        transportPartnerEoParam.setShopId(shopId);
        this.transportPartnerDas.logicDeleteByExample((BaseEo)transportPartnerEoParam);
    }

    @Override
    public List<TransportPartnerEo> list(Long sellerId, Long shopId) {
        TransportPartnerEo transportPartnerEoParam = TransportPartnerEo.newInstance();
        transportPartnerEoParam.setSellerId(sellerId);
        transportPartnerEoParam.setShopId(shopId);
        return this.transportPartnerDas.selectList((BaseEo)transportPartnerEoParam);
    }
}

