/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.util;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.CoordinateDto;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MapDistanceUtil {
    public static void main(String[] args) {
        List coordinateDtoList;
        HashMap<String, String> orderLocation = new HashMap<String, String>();
        orderLocation.put("X", "113.428352");
        orderLocation.put("Y", "23.104535");
        String partitionLocation = "";
        String geo = "[{\"lng\":113.428352,\"lat\":23.104535},{\"lng\":113.426018,\"lat\":23.096996},{\"lng\":113.432842,\"lat\":23.095298},{\"lng\":113.436661,\"lat\":23.102522},{\"lng\":113.428352,\"lat\":23.104535}]\n";
        if (StringUtils.isNotBlank((CharSequence)geo) && !CollectionUtils.isEmpty((Collection)(coordinateDtoList = JSON.parseArray((String)geo, CoordinateDto.class)))) {
            for (int i = 0; i < coordinateDtoList.size(); ++i) {
                CoordinateDto coordinateDto = (CoordinateDto)coordinateDtoList.get(i);
                partitionLocation = i == coordinateDtoList.size() - 1 ? partitionLocation + coordinateDto.getLat() + "_" + coordinateDto.getLng() : partitionLocation + coordinateDto.getLat() + "_" + coordinateDto.getLng() + ",";
            }
        }
        System.out.println(partitionLocation);
        System.out.println(MapDistanceUtil.isInPolygon(orderLocation, partitionLocation));
    }

    public static boolean isInPolygon(Map<String, String> orderLocation, String partitionLocation) {
        String[] strList;
        double p_x = Double.parseDouble(orderLocation.get("X"));
        double p_y = Double.parseDouble(orderLocation.get("Y"));
        Point2D.Double point = new Point2D.Double(p_x, p_y);
        ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
        for (String str : strList = partitionLocation.split(",")) {
            String[] points = str.split("_");
            double polygonPoint_x = Double.parseDouble(points[1]);
            double polygonPoint_y = Double.parseDouble(points[0]);
            Point2D.Double polygonPoint = new Point2D.Double(polygonPoint_x, polygonPoint_y);
            pointList.add(polygonPoint);
        }
        return MapDistanceUtil.IsPtInPoly(point, pointList);
    }

    public static boolean checkWithJdkGeneralPath(Point2D.Double point, List<Point2D.Double> polygon) {
        GeneralPath p = new GeneralPath();
        Point2D.Double first = polygon.get(0);
        p.moveTo(first.x, first.y);
        polygon.remove(0);
        for (Point2D.Double d : polygon) {
            p.lineTo(d.x, d.y);
        }
        p.lineTo(first.x, first.y);
        p.closePath();
        return p.contains(point);
    }

    public static boolean IsPtInPoly(Point2D.Double point, List<Point2D.Double> pts) {
        int N = pts.size();
        boolean boundOrVertex = true;
        int intersectCount = 0;
        double precision = 2.0E-10;
        Point2D.Double p = point;
        Point2D.Double p1 = pts.get(0);
        for (int i = 1; i <= N; ++i) {
            if (p.equals(p1)) {
                return boundOrVertex;
            }
            Point2D.Double p2 = pts.get(i % N);
            if (p.x < Math.min(p1.x, p2.x) || p.x > Math.max(p1.x, p2.x)) {
                p1 = p2;
                continue;
            }
            if (p.x > Math.min(p1.x, p2.x) && p.x < Math.max(p1.x, p2.x)) {
                if (p.y <= Math.max(p1.y, p2.y)) {
                    if (p1.x == p2.x && p.y >= Math.min(p1.y, p2.y)) {
                        return boundOrVertex;
                    }
                    if (p1.y == p2.y) {
                        if (p1.y == p.y) {
                            return boundOrVertex;
                        }
                        ++intersectCount;
                    } else {
                        double xinters = (p.x - p1.x) * (p2.y - p1.y) / (p2.x - p1.x) + p1.y;
                        if (Math.abs(p.y - xinters) < precision) {
                            return boundOrVertex;
                        }
                        if (p.y < xinters) {
                            ++intersectCount;
                        }
                    }
                }
            } else if (p.x == p2.x && p.y <= p2.y) {
                Point2D.Double p3 = pts.get((i + 1) % N);
                intersectCount = p.x >= Math.min(p1.x, p3.x) && p.x <= Math.max(p1.x, p3.x) ? ++intersectCount : (intersectCount += 2);
            }
            p1 = p2;
        }
        return intersectCount % 2 != 0;
    }

    public static double getDistance(double lon1, double lat1, double lon2, double lat2) {
        double R = 6371.393;
        double distance = 0.0;
        double dLat = (lat2 - lat1) * Math.PI / 180.0;
        double dLon = (lon2 - lon1) * Math.PI / 180.0;
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(lat1 * Math.PI / 180.0) * Math.cos(lat2 * Math.PI / 180.0) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        distance = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a)) * R;
        return distance;
    }
}

