/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderAddressReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderModReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderPreviewReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliverysItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.OrderPreviewRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags={"\u4ea4\u6613\u4e2d\u5fc3: \u8ba2\u5355\u670d\u52a1"})
@FeignClient(name="${yundt.cube.center.trade.api.name:yundt-cube-center-trade}", path="/v1/order", url="${yundt.cube.center.trade.api:}")
public interface IOrderApi {
    @PostMapping(value={""})
    @ApiOperation(value="\u6dfb\u52a0\u8ba2\u5355", notes="\u6dfb\u52a0\u8ba2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="order", value="\u8ba2\u5355\u5b9e\u4f53", dataType="OrderReqDto", paramType="body", required=true)})
    public RestResponse<String> addOrder(@Valid @RequestBody OrderReqDto var1);

    @PostMapping(value={"/preview"})
    @ApiOperation(value="\u4e0b\u5355\u524d\u9884\u89c8\u8ba2\u5355", notes="\u4e0b\u5355\u524d\u9884\u89c8\u8ba2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="order", value="\u8ba2\u5355\u5b9e\u4f53", dataType="OrderPreviewReqDto", paramType="body", required=true)})
    public RestResponse<OrderPreviewRespDto> previewOrder(@Valid @RequestBody OrderPreviewReqDto var1);

    @PostMapping(value={"/virtual"})
    @ApiOperation(value="\u6dfb\u52a0\u865a\u62df\u8ba2\u5355", notes="\u6dfb\u52a0\u865a\u62df\u8ba2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="order", value="\u8ba2\u5355\u5b9e\u4f53", dataType="OrderReqDto", paramType="body", required=true)})
    public RestResponse<String> addVirtualOrder(@Valid @RequestBody OrderReqDto var1);

    @PostMapping(value={"/{tradeNo}/cancel"})
    @ApiOperation(value="\u53d6\u6d88\u8ba2\u5355", notes="\u53d6\u6d88\u8ba2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="cancelOrder", value="\u53d6\u6d88\u539f\u56e0", dataType="CancelReqDto", paramType="body", required=true)})
    public RestResponse<Void> cancelOrder(@PathVariable(value="tradeNo") String var1, @Valid @RequestBody CancelReqDto var2);

    @PostMapping(value={"/cancel"})
    @ApiOperation(value="\u53d6\u6d88\u8ba2\u5355", notes="\u53d6\u6d88\u8ba2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="cancelOrder", value="\u53d6\u6d88\u539f\u56e0", dataType="CancelReqDto", paramType="body", required=true)})
    public RestResponse<Void> cancelByOrder(@RequestParam(value="orderNo") String var1, @Valid @RequestBody CancelReqDto var2);

    @PutMapping(value={"/{tradeNo}/confirm"})
    @ApiOperation(value="\u786e\u8ba4\u6536\u8d27", notes="\u786e\u8ba4\u6536\u8d27")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tradeNo", value="\u8ba2\u5355\u7684\u4ea4\u6613\u53f7", dataType="string", paramType="path", required=true)})
    public RestResponse<Void> confirmOrder(@PathVariable(value="tradeNo") String var1);

    @PutMapping(value={"/{tradeNo}/address"})
    @ApiOperation(value="\u4fee\u6539\u8ba2\u5355\u7684\u6536\u8d27\u5730\u5740", notes="\u4fee\u6539\u8ba2\u5355\u7684\u6536\u8d27\u5730\u5740")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tradeNo", value="\u8ba2\u5355\u7684\u4ea4\u6613\u53f7", dataType="string", paramType="path", required=true), @ApiImplicitParam(name="deliveryAddress", value="\u6536\u8d27\u5730\u5740", dataType="OrderAddressReqDto", paramType="body", required=true)})
    public RestResponse<Void> modifyOrderAddress(@PathVariable(value="tradeNo") String var1, @Valid @RequestBody OrderAddressReqDto var2);

    @PutMapping(value={"/{tradeNo}/status/{status}"})
    @ApiOperation(value="\u4fee\u6539\u8ba2\u5355\u7684\u4e1a\u52a1\u72b6\u6001", notes="\u4fee\u6539\u8ba2\u5355\u7684\u4e1a\u52a1\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tradeNo", value="\u8ba2\u5355\u7684\u4ea4\u6613\u53f7", dataType="string", paramType="path", required=true), @ApiImplicitParam(name="status", value="\u8ba2\u5355\u72b6\u6001", dataType="string", paramType="path", required=true)})
    public RestResponse<Void> modifyOrderBizStatus(@PathVariable(value="tradeNo") String var1, @PathVariable(value="status") String var2);

    @PutMapping(value={"/{tradeNo}"})
    @ApiOperation(value="\u4fee\u6539\u8ba2\u5355\u4fe1\u606f", notes="\u8be5\u63a5\u53e3\u652f\u6301\u4fee\u6539\u8ba2\u5355\u7684\u4e1a\u52a1\u72b6\u6001\uff0c\u4e1a\u52a1\u7c7b\u578b\u7b49")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tradeNo", value="\u8ba2\u5355\u4ea4\u6613\u53f7", dataType="string", paramType="path", required=true), @ApiImplicitParam(name="order", value="\u8ba2\u5355\u7684\u4fe1\u606f", dataType="OrderModReqDto", paramType="body", required=true)})
    public RestResponse<Void> modifyOrder(@PathVariable(value="tradeNo") String var1, @RequestBody OrderModReqDto var2);

    @PutMapping(value={"/order-trade-status"})
    @ApiOperation(value="\u4fee\u6539\u8ba2\u5355\u7684\u4e1a\u52a1\u72b6\u6001", notes="\u4fee\u6539\u8ba2\u5355\u7684\u4e1a\u52a1\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tradeNo", value="\u8ba2\u5355\u7684\u4ea4\u6613\u53f7", dataType="string", paramType="query", required=false), @ApiImplicitParam(name="orderNo", value="\u8ba2\u5355\u53f7", dataType="string", paramType="query", required=false), @ApiImplicitParam(name="status", value="\u8ba2\u5355\u72b6\u6001", dataType="string", paramType="query", required=true)})
    public RestResponse<Void> modifyOrderTradeStatus(@RequestParam(name="tradeNo", required=false) String var1, @RequestParam(name="orderNo", required=false) String var2, @RequestParam(value="status") String var3);

    @PutMapping(value={"/{orderNo}/order-status/{status}"})
    @ApiOperation(value="\u4fee\u6539\u8ba2\u5355\u7684\u72b6\u6001", notes="\u4fee\u6539\u8ba2\u5355\u7684\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderNo", value="\u8ba2\u5355\u53f7", dataType="string", paramType="path", required=true), @ApiImplicitParam(name="status", value="\u8ba2\u5355\u72b6\u6001", dataType="string", paramType="path", required=true)})
    public RestResponse<Void> modifyOrderStatus(@PathVariable(value="orderNo") String var1, @PathVariable(value="status") String var2);

    @PutMapping(value={"/submit"})
    @ApiOperation(value="\u4fdd\u5b58\u5230\u63d0\u4ea4\u8ba2\u5355", notes="\u4fdd\u5b58\u5230\u63d0\u4ea4\u8ba2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="order", value="\u8ba2\u5355\u5b9e\u4f53", dataType="OrderReqDto", paramType="body", required=true)})
    public RestResponse<String> submitOrder(@RequestBody OrderReqDto var1);

    @GetMapping(value={"/query-delivery"})
    @ApiOperation(value="\u67e5\u8be2\u8bb0\u5f55")
    public RestResponse<List<DeliverysItemRespDto>> queryByDeliveryNoAndSkuSerial(@RequestParam(name="tradeNo") String var1);
}

