/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.apiimpl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.IAfterSalesApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AuditRecordReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ExchangeReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnModReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnReqDto;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.ConfirmReceiveBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.ConfirmRefundBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.ReplenishBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.UserConfirmReturnBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.ReturnFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.ReturnRefundFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAfterSalesService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ExchangeEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IReturnRefundActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.CancelReturnBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.ReturnAuditBBCBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.ReturnCreateBo;
import com.dtyunxi.yundt.cube.connector.comm.dto.request.AfterSaleCancelReqDto;
import com.dtyunxi.yundt.cube.connector.comm.dto.response.AfterSaleCancelRespDto;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="afterSalesApiImpl")
public class AfterSalesApiImpl
implements IAfterSalesApi {
    private static Logger logger = LoggerFactory.getLogger(AfterSalesApiImpl.class);
    @Autowired
    IAfterSalesService afterSalesService;
    @Autowired
    IPayService payService;
    @Resource
    private ReturnRefundFlowAction returnRefundFlowAction;
    @CubeResource
    private IReturnRefundActionExtPt returnRefundActionExtPt;
    @Resource
    private ReturnFlowAction returnFlowAction;

    public RestResponse<Map> addExchange(String orderTradeNo, ExchangeReqDto exchangeReqDto) {
        return new RestResponse();
    }

    public RestResponse updateIsRefund(String returnNo, Integer isRefund) {
        this.afterSalesService.updateIsRefund(returnNo, isRefund);
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifyReturn(String tradeNo, ReturnModReqDto order) {
        order.setTradeNo(tradeNo);
        Assert.notNull((Object)order.getTenantId(), "\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        this.afterSalesService.modifyReturn(tradeNo, order);
        return new RestResponse();
    }

    public RestResponse<Map> addReturn(String orderTradeNo, ReturnReqDto returnReqDto) {
        ReturnCreateBo returnCreateBo = new ReturnCreateBo();
        returnReqDto.setOrderTradeNo(orderTradeNo);
        returnCreateBo.setReturnReqDto(returnReqDto);
        returnCreateBo.setStartFlowParam(this.returnRefundActionExtPt.getFlowDefId(), this.returnRefundActionExtPt.getFlowDefName());
        returnCreateBo = this.returnRefundFlowAction.doReturn(returnCreateBo);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("returnNo", returnCreateBo.getReturnEo().getReturnNo());
        return new RestResponse(resultMap);
    }

    public RestResponse<Map> addVirtualReturn(String orderTradeNo, ReturnReqDto returnReqDto) {
        return new RestResponse();
    }

    public RestResponse<String> auditReturn(String bizTradeNo, AuditRecordReqDto auditRecordReqDto) {
        ReturnAuditBBCBo returnAuditBBCBo = new ReturnAuditBBCBo();
        returnAuditBBCBo.setReturnAuditReqDto(auditRecordReqDto);
        returnAuditBBCBo.setDriveFlowParam(this.returnRefundActionExtPt.getFlowDefId(), this.returnRefundActionExtPt.getFlowDefName(), bizTradeNo);
        this.returnFlowAction.returnAuditResult(returnAuditBBCBo);
        return new RestResponse();
    }

    public RestResponse<String> auditExchange(String bizTradeNo, AuditRecordReqDto auditRecordReqDto) {
        return new RestResponse();
    }

    public RestResponse<String> addAuditRecordByReturn(String tradeNo, AuditRecordReqDto auditRecordReqDto) {
        ReplenishBo replenishBo = new ReplenishBo();
        replenishBo.setAuditRecordReqDto(auditRecordReqDto);
        replenishBo.setDriveFlowParam(this.returnRefundActionExtPt.getFlowDefId(), this.returnRefundActionExtPt.getFlowDefName(), tradeNo);
        ReplenishBo replenish = this.returnFlowAction.replenish(replenishBo);
        return new RestResponse((Object)replenish.getReplenishResult());
    }

    public RestResponse<String> addAuditRecordByExchange(String tradeNo, AuditRecordReqDto auditRecordReqDto) {
        return new RestResponse(null);
    }

    public RestResponse<String> confirmReturnDelivery(String tradeNo, ReturnReqDto returnReqDto) {
        returnReqDto.setTradeNo(tradeNo);
        ConfirmReceiveBo confirmReceiveBo = new ConfirmReceiveBo();
        confirmReceiveBo.setReturnReqDto(returnReqDto);
        confirmReceiveBo.setDriveFlowParam(this.returnRefundActionExtPt.getFlowDefId(), this.returnRefundActionExtPt.getFlowDefName(), tradeNo);
        this.returnFlowAction.confirmReceive(confirmReceiveBo);
        return new RestResponse();
    }

    public RestResponse<String> confirmExchangeDelivery(String tradeNo, ExchangeReqDto exchangeReqDto) {
        return new RestResponse();
    }

    public RestResponse<Void> cancelByReturn(String tradeNo, CancelReqDto cancelReqDto) {
        CancelReturnBo cancelReturnBo = new CancelReturnBo();
        cancelReqDto.setTradeNo(tradeNo);
        cancelReturnBo.setCancelReqDto(cancelReqDto);
        cancelReturnBo.setDriveFlowParam(this.returnRefundActionExtPt.getFlowDefId(), this.returnRefundActionExtPt.getFlowDefName(), tradeNo);
        this.returnFlowAction.cancelReturnFinishAction(cancelReturnBo);
        return new RestResponse();
    }

    public RestResponse<Void> cancelByExchange(String tradeNo, CancelReqDto cancelReqDto) {
        return new RestResponse();
    }

    public RestResponse<Void> modifyReturnBizStatus(String tradeNo, String bizStatus) {
        this.afterSalesService.modifyReturnBizStatus(tradeNo, bizStatus);
        return new RestResponse();
    }

    public RestResponse<Void> modifyReturnExpress(String tradeNo, ReturnReqDto returnReqDto) {
        ReturnEo returnEo = new ReturnEo();
        returnEo.setReturnExpressCompany(returnReqDto.getReturnExpressCompany());
        returnEo.setReturnExpressDetail(returnReqDto.getReturnExpressDetail());
        returnEo.setReturnExpressSerial(returnReqDto.getReturnExpressSerial());
        this.afterSalesService.modifyReturn(tradeNo, returnEo);
        return new RestResponse();
    }

    public RestResponse<Void> confirmReturnAction(String tradeNo, ReturnReqDto returnReqDto) {
        UserConfirmReturnBo userConfirmReturnBo = new UserConfirmReturnBo();
        userConfirmReturnBo.setReturnReqDto(returnReqDto);
        returnReqDto.setTradeNo(tradeNo);
        userConfirmReturnBo.setDriveFlowParam(this.returnRefundActionExtPt.getFlowDefId(), this.returnRefundActionExtPt.getFlowDefName(), tradeNo);
        this.returnFlowAction.userConfirmReturn(userConfirmReturnBo);
        return new RestResponse();
    }

    public RestResponse<Void> modifyExchangeExpress(String tradeNo, ExchangeReqDto exchangeReqDto) {
        ExchangeEo exchangeEo = new ExchangeEo();
        this.afterSalesService.modifyExchange(tradeNo, exchangeEo);
        return new RestResponse();
    }

    public RestResponse<Void> getConfirmRefundVerifyCode(String tradeNo, ReturnReqDto returnReqDto) {
        ConfirmRefundBo confirmRefundBo = new ConfirmRefundBo();
        confirmRefundBo.setReturnReqDto(returnReqDto);
        returnReqDto.setTradeNo(tradeNo);
        return this.returnFlowAction.getConfirmRefundVerifyCode(confirmRefundBo);
    }

    public RestResponse<String> confirmReturnRefund(String tradeNo, ReturnReqDto returnReqDto) {
        ConfirmRefundBo confirmRefundBo = new ConfirmRefundBo();
        confirmRefundBo.setReturnReqDto(returnReqDto);
        returnReqDto.setTradeNo(tradeNo);
        confirmRefundBo.setDriveFlowParam(this.returnRefundActionExtPt.getFlowDefId(), this.returnRefundActionExtPt.getFlowDefName(), tradeNo);
        this.returnFlowAction.confirmRefundAction(confirmRefundBo);
        return new RestResponse((Object)confirmRefundBo.getConfirmResult());
    }

    public RestResponse<String> confirmReturnRefundOmnichannel(String tradeNo, ReturnReqDto returnReqDto) {
        ConfirmRefundBo confirmRefundBo = new ConfirmRefundBo();
        confirmRefundBo.setReturnReqDto(returnReqDto);
        returnReqDto.setTradeNo(tradeNo);
        this.returnFlowAction.confirmRefundActionOmnichannel(confirmRefundBo);
        return RestResponse.SUCCEED;
    }

    public RestResponse<Void> rejectRefund(ReturnReqDto returnReqDto) {
        return this.returnFlowAction.rejectRefund(returnReqDto);
    }

    public RestResponse<Void> auditInspectGoods(ReturnReqDto returnReqDto) {
        this.returnFlowAction.auditInspectGoods(returnReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<AfterSaleCancelRespDto> cancelOmniReturn(AfterSaleCancelReqDto afterSaleCancelReqDto) {
        if (null == afterSaleCancelReqDto) {
            throw new BizException("\u53d6\u6d88\u552e\u540e\u5355\u5165\u53c2\u4e3a\u7a7a");
        }
        logger.info("cancelOmniReturn params:{}", (Object)JSONObject.toJSONString((Object)afterSaleCancelReqDto));
        if (StringUtils.isEmpty((Object)afterSaleCancelReqDto.getThirdReturnNo())) {
            throw new BizException("\u7b2c\u4e09\u65b9\u552e\u540e\u5355\u53f7\u4e3a\u7a7a");
        }
        return new RestResponse((Object)this.afterSalesService.cancelOmniReturn(afterSaleCancelReqDto));
    }

    public RestResponse<Map> addAfterSale(ReturnReqDto returnReqDto) {
        ReturnCreateBo returnCreateBo = new ReturnCreateBo();
        returnCreateBo.setFlag(Boolean.valueOf(true));
        returnCreateBo.setReturnReqDto(returnReqDto);
        returnCreateBo.setStartFlowParam(this.returnRefundActionExtPt.getFlowDefId(), this.returnRefundActionExtPt.getFlowDefName());
        returnCreateBo = this.returnRefundFlowAction.doReturn(returnCreateBo);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("returnNo", returnCreateBo.getReturnEo().getReturnNo());
        return new RestResponse(resultMap);
    }

    public RestResponse<Map> addAfterSaleApply(ReturnReqDto returnReqDto) {
        ReturnCreateBo returnCreateBo = new ReturnCreateBo();
        returnCreateBo.setUncertainlyItemFlag(Boolean.valueOf(true));
        returnCreateBo.setReturnReqDto(returnReqDto);
        returnCreateBo.setStartFlowParam(this.returnRefundActionExtPt.getFlowDefId(), this.returnRefundActionExtPt.getFlowDefName());
        returnCreateBo = this.returnRefundFlowAction.doReturn(returnCreateBo);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("returnNo", returnCreateBo.getReturnEo().getReturnNo());
        resultMap.put("autoCSAudit", returnCreateBo.getAutoCSAudit());
        return new RestResponse(resultMap);
    }

    public RestResponse<Void> modifyItemOrigPriceById(Long id, BigDecimal itemOrigPrice) {
        this.afterSalesService.modifyItemOrigPriceById(id, itemOrigPrice);
        return RestResponse.VOID;
    }
}

