/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.apiimpl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.IDeliveryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliverMergeTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryAssignReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryRedistributeReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliverySplitReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryStoreReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DistributeSapReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DistributeWmsReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.GenerateOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderDeliveryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.dada.DaDaMessageReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.dada.DaDaOrderCallbackReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.dada.DadaCancelOrderDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.delivery.DeliveryAddReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.delivery.DeliveryBasicReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.delivery.DeliveryPackageAddReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.delivery.DeliveryPackageReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.sf.CancelOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.sf.SfCreateOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.DeliveryMergeReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.dada.DaDaMessageRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.BaseFlowDef;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.DadaDeliveryBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.DeliveryAssignBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderDeliveryConfirmBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.RecDeliveryStoreBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.RedistributePartnerDeliveryStoreBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.RejectDeliveryStoreBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.UnDeliveryStoreBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.DeliveryFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.DeliveryRecordFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.GenerateDeliveryFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.scheduler.task.AutoMergeDeliveryOrderTask;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryMergeService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryRouterService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliverySellerService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliverySplitService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ISfShippingChannelService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.DaDaSignUtils;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IDeliveryRecordActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IOrderDeliveryCreateActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.DeliveryStoreBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.GenerateDeliveryBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderDeliveryStatusBo;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service(value="deliveryApiImpl")
public class DeliveryApiImpl
implements IDeliveryApi {
    private static Logger logger = LoggerFactory.getLogger(IDeliveryApi.class);
    @Autowired
    private ISfShippingChannelService sfShippingChannelService;
    @Autowired
    private IDeliveryService deliveryService;
    @Resource
    private DeliveryRecordFlowAction deliveryRecordFlowAction;
    @CubeResource
    private IDeliveryRecordActionExtPt deliveryRecordActionExtPt;
    @Resource
    private DeliveryFlowAction deliveryFlowAction;
    @CubeResource
    IOrderDeliveryCreateActionExtPt orderDeliveryCreateActionExtPt;
    @Autowired
    private IDeliverySplitService deliverySplitService;
    @Autowired
    private IDeliveryMergeService deliveryMergeService;
    @Resource
    private IOrderDeliveryService orderDeliveryService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private GenerateDeliveryFlowAction generateDeliveryFlowAction;
    @Resource
    private IDeliveryRouterService deliveryRouterService;
    @Resource
    private AutoMergeDeliveryOrderTask autoMergeDeliveryOrderTask;
    @Resource
    private IDeliverySellerService deliverySellerService;
    @Resource
    private Environment environment;

    public RestResponse<Boolean> receive(DeliveryStoreReqDto deliveryStoreReqDto) {
        RecDeliveryStoreBo recDeliveryStoreBo = new RecDeliveryStoreBo();
        recDeliveryStoreBo.setDeliveryStoreReqDto(deliveryStoreReqDto);
        recDeliveryStoreBo.setDriveFlowParam(BaseFlowDef.BASE_DELIVERY.getFlowId(), BaseFlowDef.BASE_DELIVERY.getFlowName(), deliveryStoreReqDto.getDeliveryNo());
        return new RestResponse((Object)this.deliveryFlowAction.receive(recDeliveryStoreBo).getSuccess());
    }

    public void handlePartnerNotify(DaDaOrderCallbackReqDto daDaOrderCallbackReqDto) {
        logger.info("\u8fbe\u8fbe\u56de\u8c03\u901a\u77e5\uff1a{}", (Object)JSON.toJSONString((Object)daDaOrderCallbackReqDto));
        boolean valid = DaDaSignUtils.validCallbackSignature(daDaOrderCallbackReqDto);
        if (valid) {
            DadaDeliveryBo dadaDeliveryNotifyBo = new DadaDeliveryBo();
            dadaDeliveryNotifyBo.setDeliveryNo(daDaOrderCallbackReqDto.getOrder_id());
            dadaDeliveryNotifyBo.setDaDaOrderCallbackReqDto(daDaOrderCallbackReqDto);
            dadaDeliveryNotifyBo.setDriveFlowParam(BaseFlowDef.BASE_DELIVERY.getFlowId(), BaseFlowDef.BASE_DELIVERY.getFlowName(), daDaOrderCallbackReqDto.getOrder_id());
            this.deliveryFlowAction.handleDadaNotify(dadaDeliveryNotifyBo);
        }
    }

    public DaDaMessageRespDto handlePartnerMessage(DaDaMessageReqDto daDaMessageReqDto) {
        logger.info("\u8fbe\u8fbe\u6d88\u606f\u901a\u77e5\uff1a{}", (Object)JSON.toJSONString((Object)daDaMessageReqDto));
        DadaDeliveryBo dadaDeliveryMessageBo = new DadaDeliveryBo();
        dadaDeliveryMessageBo.setDaDaMessageReqDto(daDaMessageReqDto);
        DadaCancelOrderDto dadaCancelOrderDto = null;
        if (StringUtils.isNotBlank((CharSequence)daDaMessageReqDto.getMessageBody())) {
            if (1 == daDaMessageReqDto.getMessageType()) {
                dadaCancelOrderDto = (DadaCancelOrderDto)JSON.parseObject((String)daDaMessageReqDto.getMessageBody(), DadaCancelOrderDto.class);
            }
            if (dadaCancelOrderDto != null) {
                if (daDaMessageReqDto.getCreateTime() != null) {
                    dadaCancelOrderDto.setCancelTime(new Date(daDaMessageReqDto.getCreateTime() * 1000));
                }
                dadaDeliveryMessageBo.setDeliveryNo(dadaCancelOrderDto.getOrderId());
                dadaDeliveryMessageBo.setDadaCancelOrderDto(dadaCancelOrderDto);
                dadaDeliveryMessageBo.setDriveFlowParam(BaseFlowDef.BASE_DELIVERY.getFlowId(), BaseFlowDef.BASE_DELIVERY.getFlowName(), dadaCancelOrderDto.getOrderId());
                this.deliveryFlowAction.handleDadaMessage(dadaDeliveryMessageBo);
            }
        }
        return new DaDaMessageRespDto(DaDaMessageRespDto.RESPONSE_SUCCESS_STATUS);
    }

    public RestResponse<Boolean> reject(DeliveryStoreReqDto deliveryStoreReqDto) {
        RejectDeliveryStoreBo rejectDeliveryStoreBo = new RejectDeliveryStoreBo();
        rejectDeliveryStoreBo.setDeliveryStoreReqDto(deliveryStoreReqDto);
        rejectDeliveryStoreBo.setDriveFlowParam(BaseFlowDef.BASE_DELIVERY.getFlowId(), BaseFlowDef.BASE_DELIVERY.getFlowName(), deliveryStoreReqDto.getDeliveryNo());
        return new RestResponse((Object)this.deliveryFlowAction.reject(rejectDeliveryStoreBo).getSuccess());
    }

    public RestResponse<Boolean> deliver(DeliveryStoreReqDto deliveryStoreReqDto) {
        logger.info("\u53d1\u8d27\u5355\u53d1\u8d27\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)deliveryStoreReqDto));
        this.checkDeliverData(deliveryStoreReqDto);
        this.deliveryService.deliverThird(deliveryStoreReqDto);
        DeliveryStoreBo deliveryStoreBo = new DeliveryStoreBo();
        deliveryStoreBo.setDeliveryStoreReqDto(deliveryStoreReqDto);
        deliveryStoreBo.setDriveFlowParam(this.deliveryRecordActionExtPt.getFlowDefId(), this.deliveryRecordActionExtPt.getFlowDefName(), deliveryStoreReqDto.getDeliveryNo());
        Boolean succFlag = this.deliveryRecordFlowAction.deliverGoods(deliveryStoreBo).getSuccFlag();
        return new RestResponse((Object)succFlag);
    }

    private void checkDeliverData(DeliveryStoreReqDto deliveryStoreReqDto) {
        if (ShippingTypeEnum.CLERK.getType().equals(deliveryStoreReqDto.getShippingType()) && CollectionUtils.isEmpty((Collection)deliveryStoreReqDto.getSellers())) {
            throw new BizException("\u5e97\u5458\u914d\u9001\u5e97\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    public RestResponse<Boolean> warehouseDeliver(DeliveryStoreReqDto deliveryStoreReqDto) {
        return new RestResponse((Object)this.deliveryService.deliver(deliveryStoreReqDto, null));
    }

    public RestResponse<Boolean> distributeWms(DistributeWmsReqDto distributeWmsReqDto) {
        return new RestResponse((Object)this.deliveryService.distributeWms(distributeWmsReqDto));
    }

    public RestResponse<Boolean> distributeSap(DistributeSapReqDto distributeSapReqDto) {
        return new RestResponse((Object)this.deliveryService.distributeSap(distributeSapReqDto));
    }

    public RestResponse<Boolean> unableDeliver(DeliveryStoreReqDto deliveryStoreReqDto) {
        UnDeliveryStoreBo unDeliveryStoreBo = new UnDeliveryStoreBo();
        unDeliveryStoreBo.setDeliveryStoreReqDto(deliveryStoreReqDto);
        unDeliveryStoreBo.setDriveFlowParam(BaseFlowDef.BASE_DELIVERY.getFlowId(), BaseFlowDef.BASE_DELIVERY.getFlowName(), deliveryStoreReqDto.getDeliveryNo());
        return new RestResponse((Object)this.deliveryFlowAction.unableDeliver(unDeliveryStoreBo).getSuccess());
    }

    public RestResponse<String> creteSfOrder(SfCreateOrderReqDto sfCreateOrderReqDto) {
        logger.info("\u5f00\u59cb\u521b\u5efa\u987a\u4e30\u5feb\u9012\u5355\u53f7\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)sfCreateOrderReqDto));
        this.checkCreteSfOrderParames(sfCreateOrderReqDto);
        try {
            String expressCode = this.sfShippingChannelService.createOrder(sfCreateOrderReqDto);
            return new RestResponse((Object)expressCode);
        }
        catch (Exception e) {
            logger.error("\u987a\u4e30\u4e0b\u5355\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0ce:{}", new Object[]{sfCreateOrderReqDto.getDeliveryNo(), e.getMessage(), e});
            throw new BizException("\u987a\u4e30\u4e0b\u5355\u5931\u8d25," + e.getMessage());
        }
    }

    public RestResponse<Void> cancelSfOrder(String expressCode, String deliveryNo) {
        CancelOrderReqDto cancelOrderReqDto = new CancelOrderReqDto();
        cancelOrderReqDto.setDeliveryNo(deliveryNo);
        cancelOrderReqDto.setMailNumber(expressCode);
        this.sfShippingChannelService.cancelOrder(cancelOrderReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Boolean> assign(DeliveryAssignReqDto deliveryAssignReqDto) {
        logger.info("\u8def\u7531\u5931\u8d25\uff0c\u8fd0\u8425\u4eba\u5458\u6307\u6d3e\u8ba2\u5355\u53d1\u8d27,DeliveryAssignReqDto:{}", (Object)JSON.toJSONString((Object)deliveryAssignReqDto));
        DeliveryAssignBo deliveryAssignBo = new DeliveryAssignBo();
        deliveryAssignBo.setDeliveryAssignReqDto(deliveryAssignReqDto);
        deliveryAssignBo.setDriveFlowParam(BaseFlowDef.BASE_DELIVERY.getFlowId(), BaseFlowDef.BASE_DELIVERY.getFlowName(), deliveryAssignReqDto.getDeliveryNo());
        this.deliveryFlowAction.assign(deliveryAssignBo);
        return new RestResponse((Object)true);
    }

    public RestResponse<Void> reRouterDelivery(String deliveryNo) {
        OrderDeliveryStatusBo orderDeliveryBo = new OrderDeliveryStatusBo();
        orderDeliveryBo.setDeliveryNo(deliveryNo);
        orderDeliveryBo.setDriveFlowParam(BaseFlowDef.BASE_DELIVERY.getFlowId(), BaseFlowDef.BASE_DELIVERY.getFlowName(), deliveryNo);
        this.deliveryFlowAction.reRouterDelivery(orderDeliveryBo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> forceReRouterDelivery(String deliveryNo) {
        this.deliveryRouterService.forceReRouterDelivery(deliveryNo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> confirm(String deliveryNo) {
        OrderDeliveryConfirmBo orderDeliveryBo = new OrderDeliveryConfirmBo();
        orderDeliveryBo.setDeliveryNo(deliveryNo);
        orderDeliveryBo.setDriveFlowParam(this.orderDeliveryCreateActionExtPt.getFlowDefId(), this.orderDeliveryCreateActionExtPt.getFlowDefName(), deliveryNo);
        this.deliveryFlowAction.confirm(orderDeliveryBo);
        return new RestResponse();
    }

    private void checkCreteSfOrderParames(SfCreateOrderReqDto sfCreateOrderReqDto) {
        if (StringUtils.isEmpty((CharSequence)sfCreateOrderReqDto.getDeliveryNo())) {
            throw new BizException("\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)sfCreateOrderReqDto.getSenderName())) {
            throw new BizException("\u4e0b\u5355\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)sfCreateOrderReqDto.getSenderTel())) {
            throw new BizException("\u4e0b\u5355\u4eba\u8054\u7cfb\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)sfCreateOrderReqDto.getSenderAddress())) {
            throw new BizException("\u53d1\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)sfCreateOrderReqDto.getReceiverName())) {
            throw new BizException("\u6536\u8d27\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)sfCreateOrderReqDto.getReceiverTel())) {
            throw new BizException("\u6536\u8d27\u4eba\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)sfCreateOrderReqDto.getReceiverAddress())) {
            throw new BizException("\u6536\u8d27\u4eba\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    public RestResponse<Void> manualSplit(DeliverySplitReqDto deliverySplitReqDto) {
        if (StringUtils.isEmpty((CharSequence)deliverySplitReqDto.getDeliveryNo())) {
            throw new BizException("\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)deliverySplitReqDto.getChilds())) {
            throw new BizException("\u62c6\u5206\u53d1\u8d27\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (deliverySplitReqDto.getChilds().size() == 1) {
            throw new BizException("\u62c6\u5206\u53d1\u8d27\u5355\u5b50\u53d1\u8d27\u5355\u6570\u91cf\u4e0d\u6b63\u786e\uff01");
        }
        this.deliverySplitService.manualSplit(deliverySplitReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> autoSplit(DeliverySplitReqDto deliverySplitReqDto) {
        if (StringUtils.isEmpty((CharSequence)deliverySplitReqDto.getDeliveryNo())) {
            throw new BizException("\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)deliverySplitReqDto.getChilds())) {
            throw new BizException("\u62c6\u5206\u53d1\u8d27\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.deliverySplitService.manualSplit(deliverySplitReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> manualMerge(DeliveryMergeReqDto deliveryMergeReqDto) {
        if (CollectionUtils.isEmpty((Collection)deliveryMergeReqDto.getDeliverNos())) {
            throw new BizException("\u5408\u5e76\u7684\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (deliveryMergeReqDto.getDeliverNos().size() < 1 || deliveryMergeReqDto.getDeliverNos().size() == 1) {
            throw new BizException("\u4e0d\u5b58\u5728\u8981\u5408\u5e76\u7684\u53d1\u8d27\u5355\uff01");
        }
        deliveryMergeReqDto.setMergeType(DeliverMergeTypeEnum.MANUAL.getType());
        this.deliveryMergeService.manualMerge(deliveryMergeReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> autoMerge() {
        logger.info("\u624b\u52a8\u51fa\u53d1\u7cfb\u7edf\u81ea\u52a8\u5408\u5e76\u53d1\u8d27\u5355\u2026\u2026");
        this.autoMergeDeliveryOrderTask.handleAutoMerge();
        return RestResponse.VOID;
    }

    public RestResponse<String> updateExpressCode(OrderDeliveryReqDto orderDeliveryReqDto) {
        if (null == orderDeliveryReqDto) {
            throw new BizException("\u7269\u6d41\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderDeliveryReqDto.getDeliveryNo()) {
            throw new BizException("\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrderDeliveryEo orderDeliveryEo = OrderDeliveryEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)orderDeliveryReqDto, (BaseEo)orderDeliveryEo);
        return new RestResponse((Object)this.deliveryService.updateExpressCode(orderDeliveryEo));
    }

    public RestResponse<Void> cancelDelivery(String deliveryNo) {
        if (StringUtils.isBlank((CharSequence)deliveryNo)) {
            throw new BizException("\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.orderDeliveryService.cancelDelivery(deliveryNo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> cancelPartnerOrder(String deliveryNo) {
        DadaDeliveryBo dadaDeliveryBo = new DadaDeliveryBo();
        dadaDeliveryBo.setDeliveryNo(deliveryNo);
        dadaDeliveryBo.setDriveFlowParam(BaseFlowDef.BASE_DELIVERY.getFlowId(), BaseFlowDef.BASE_DELIVERY.getFlowName(), deliveryNo);
        this.deliveryFlowAction.cancelDadaOrder(dadaDeliveryBo);
        return new RestResponse();
    }

    public RestResponse<Void> abnormalConfirm(String deliveryNo) {
        DadaDeliveryBo dadaDeliveryBo = new DadaDeliveryBo();
        dadaDeliveryBo.setDeliveryNo(deliveryNo);
        dadaDeliveryBo.setDriveFlowParam(BaseFlowDef.BASE_DELIVERY.getFlowId(), BaseFlowDef.BASE_DELIVERY.getFlowName(), deliveryNo);
        this.deliveryFlowAction.confirmDadaOrderAbnormal(dadaDeliveryBo);
        return new RestResponse();
    }

    public RestResponse<String> redistribute(DeliveryRedistributeReqDto deliveryRedistributeReqDto) {
        RedistributePartnerDeliveryStoreBo redistributePartnerDeliveryStoreBo = new RedistributePartnerDeliveryStoreBo();
        redistributePartnerDeliveryStoreBo.setDeliveryNo(deliveryRedistributeReqDto.getDeliveryNo());
        redistributePartnerDeliveryStoreBo.setDeliveryRedistributeReqDto(deliveryRedistributeReqDto);
        redistributePartnerDeliveryStoreBo.setDriveFlowParam(BaseFlowDef.BASE_DELIVERY.getFlowId(), BaseFlowDef.BASE_DELIVERY.getFlowName(), deliveryRedistributeReqDto.getDeliveryNo());
        this.deliveryFlowAction.redistribute(redistributePartnerDeliveryStoreBo);
        return new RestResponse(null);
    }

    public RestResponse<Void> generateDeliveryByOrder(GenerateOrderReqDto generateOrderReqDto) {
        logger.info("\u6839\u636e\u5168\u6e20\u9053\u8ba2\u5355\u751f\u6210\u53d1\u8d27\u5355\uff0c\u5165\u53c2\uff1agenerateOrderReqDto{}", (Object)JSON.toJSONString((Object)generateOrderReqDto));
        generateOrderReqDto.getOrderNos().forEach(orderNo -> {
            if (YesNoEnum.YES.getValue().equals(generateOrderReqDto.getIfSync())) {
                logger.info("\u5f00\u59cb\u540c\u6b65\u751f\u6210\u53d1\u8d27\u5355\u2026\u2026");
                GenerateDeliveryBo generateDeliveryBo = new GenerateDeliveryBo();
                generateDeliveryBo.setOrderNo(orderNo);
                generateDeliveryBo.setStartFlowParam(this.orderDeliveryCreateActionExtPt.getFlowDefId(), this.orderDeliveryCreateActionExtPt.getFlowDefName());
                this.generateDeliveryFlowAction.create(generateDeliveryBo);
                logger.info("\u540c\u6b65\u751f\u6210\u53d1\u8d27\u5355\u5b8c\u6bd5\u3002");
            } else {
                this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("${GENERATE_DELIVERY_TOPIC:GENERATE_DELIVERY_TOPIC}"), this.environment.resolvePlaceholders("GENERATE_DELIVERY_TAG"), (Object)generateOrderReqDto);
                logger.info("\u5f02\u6b65\u751f\u6210\u53d1\u8d27\u5355\uff0c\u53d1\u9001\u5168\u6e20\u9053\u8ba2\u5355\u751f\u6210\u53d1\u8d27\u5355MQ\u6307\u4ee4\u5b8c\u6bd5\u3002");
            }
        });
        return RestResponse.VOID;
    }

    public RestResponse<Void> addDelivery(DeliveryAddReqDto deliveryAddReqDto) {
        DeliveryBasicReqDto delivery = deliveryAddReqDto.getDelivery();
        String deliveryNo = delivery.getDeliveryNo();
        if (StringUtils.isEmpty((CharSequence)deliveryNo)) {
            throw new BizException("\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.deliveryService.addDelivery(deliveryAddReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> addDeliveryPackage(DeliveryPackageAddReqDto deliveryPackageAddReqDto) {
        DeliveryPackageReqDto packageDto = deliveryPackageAddReqDto.getPackageReqDto();
        String packageSerial = packageDto.getPackageSerial();
        if (StringUtils.isEmpty((CharSequence)packageSerial)) {
            throw new BizException("\u5305\u88f9\u552f\u4e00\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)packageDto.getDeliveryNo())) {
            throw new BizException("\u5305\u88f9\u6240\u5c5e\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.deliveryService.addDeliveryPackage(deliveryPackageAddReqDto);
        return null;
    }

    public RestResponse<Void> confirmDelivery(Long deliveryId) {
        this.deliveryService.confirmDelivery(deliveryId);
        return new RestResponse();
    }
}

