/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.apiimpl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryRouteOptEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.IOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ActivityConstant;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderAddressReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderModReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderPreviewReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderStockBatchDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.RemarkOrderTagsReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoJoinReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliverysItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.OrderPreviewRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.CreateOrderFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.OrderFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IHelpService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryInfoService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IScheduleService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IContextService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IExtlOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IOrderCreateActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.CancelOrderBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderCreateBo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PreviewActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.BizActivityType;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;

@Service(value="orderApiImpl")
public class OrderApiImpl
implements IOrderApi {
    private static final Logger logger = LoggerFactory.getLogger(OrderApiImpl.class);
    @Resource
    private IOrderService orderService;
    @Resource
    private IScheduleService scheduleService;
    @Resource
    private IOrderDeliveryService iOrderDeliveryService;
    @Resource
    private IExtlOrderActivityService extlOrderActivityService;
    @Resource
    private OrderFlowAction orderFlowAction;
    @Resource
    private IHelpService helpService;
    @Autowired
    private CreateOrderFlowAction createOrderFlowAction;
    @CubeResource
    private IOrderCreateActionExtPt orderCreateActionExtPt;
    @Resource
    private IContextService contextService;
    @Resource
    private IOrderDeliveryInfoService orderDeliveryInfoService;
    @Resource
    private IDeliveryService deliveryService;
    @Autowired
    private IContext context;
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderApiImpl.class);
    @Value(value="${dtyunxi.cube.center.trade.def_flow_id:1250044908581091677}")
    private long flowDefId4normal;

    public RestResponse<String> addOrder(OrderReqDto orderReq) {
        return new RestResponse((Object)((OrderRespDto)this.addOrderReturnEo(orderReq).getData()).getOrderNo());
    }

    public RestResponse<OrderRespDto> addOrderReturnEo(OrderReqDto orderReq) {
        this.contextService.getAndSetInstanceInfo(orderReq.getInstanceId());
        OrderCreateBo orderCreateBo = new OrderCreateBo();
        orderCreateBo.setOrderReqDto(orderReq);
        if (orderReq.getFlowDefId() != null && orderReq.getFlowType() != null) {
            orderCreateBo.setStartFlowParam(orderReq.getFlowDefId(), orderReq.getFlowType());
        } else {
            orderCreateBo.setStartFlowParam(this.orderCreateActionExtPt.getFlowDefId(), this.orderCreateActionExtPt.getFlowDefName());
        }
        try {
            OrderCreateBo order = this.createOrderFlowAction.createOrder(orderCreateBo);
            OrderRespDto orderRespDto = new OrderRespDto();
            BeanUtils.copyProperties((Object)order.getOrderEo(), (Object)orderRespDto);
            return new RestResponse((Object)orderRespDto);
        }
        catch (Exception e) {
            this.createOrderFlowAction.checkAndRollBackErrorOrder(orderCreateBo);
            throw e;
        }
    }

    private void addPointDeduct(OrderPreviewReqDto order) {
        List<OrderActivityInfoReqDto> list;
        if (CollectionUtils.isEmpty((Collection)order.getOrderItems())) {
            return;
        }
        if (((TradeItemReqDto)order.getOrderItems().get(0)).getBusType() == ItemBusTypeEnum.INTEGRAL.getType()) {
            return;
        }
        if (order.getActivity() == null) {
            OrderActivityInfoJoinReqDto orderActivityInfoJoinReqDto = new OrderActivityInfoJoinReqDto();
            order.setActivity(orderActivityInfoJoinReqDto);
        }
        if (CollectionUtils.isEmpty((Collection)order.getActivity().getActivityList())) {
            list = new ArrayList();
            OrderActivityInfoReqDto orderActivityInfoReqDto = new OrderActivityInfoReqDto();
            orderActivityInfoReqDto.setType(ActivityConstant.POINT_DEDUCT);
            orderActivityInfoReqDto.setActivityId(Long.valueOf(BizActivityType.POINT_DEDUCT_ACTIVITY.getId()));
            list.add(orderActivityInfoReqDto);
            order.getActivity().setActivityList(list);
            order.getActivity().setUserCheckPointDeduction(false);
        } else if (order.getActivity().getActivityList().stream().filter(o -> o.getActivityId() != null && o.getActivityId().equals(BizActivityType.POINT_DEDUCT_ACTIVITY.getId())).count() <= 0L) {
            list = order.getActivity().getActivityList();
            OrderActivityInfoReqDto orderActivityInfoReqDto = new OrderActivityInfoReqDto();
            orderActivityInfoReqDto.setType(ActivityConstant.POINT_DEDUCT);
            orderActivityInfoReqDto.setActivityId(Long.valueOf(BizActivityType.POINT_DEDUCT_ACTIVITY.getId()));
            list.add(orderActivityInfoReqDto);
            order.getActivity().setUserCheckPointDeduction(false);
        } else {
            order.getActivity().setUserCheckPointDeduction(true);
        }
    }

    public RestResponse<OrderPreviewRespDto> previewOrder(@Valid OrderPreviewReqDto order) {
        order.setNoExchangeException(true);
        if (StringUtils.isEmpty((CharSequence)order.getCustomerId())) {
            Long memberId = this.extlOrderActivityService.getMemberId(Long.valueOf(order.getUserId()));
            order.setMemberId(memberId);
            this.addPointDeduct(order);
        }
        OrderPreviewRespDto orderPreviewRespDto = this.orderService.countAndPreviewOrderAmount(order);
        if (Objects.nonNull(order.getCustomerId())) {
            orderPreviewRespDto.setCustomerId(Long.valueOf(order.getCustomerId()));
            orderPreviewRespDto.setGiftInfoRespDto(this.helpService.doAction(orderPreviewRespDto));
            LOGGER.info("\u8ba1\u7b97\u7ed3\u679c\u4e3a" + JSON.toJSONString((Object)orderPreviewRespDto));
        }
        PreviewActivityRespDto previewResult = this.extlOrderActivityService.previewActivity(order);
        orderPreviewRespDto.setPreviewResult(previewResult);
        return new RestResponse((Object)orderPreviewRespDto);
    }

    public RestResponse<OrderPreviewRespDto> previewSeckillOrder(@Valid OrderPreviewReqDto order) {
        OrderPreviewRespDto orderPreviewRespDto = this.orderService.countAndPreviewSeckillOrderAmount(order);
        orderPreviewRespDto.setCustomerId(Long.valueOf(order.getCustomerId()));
        orderPreviewRespDto.setGiftInfoRespDto(this.helpService.doAction(orderPreviewRespDto));
        LOGGER.info("\u8ba1\u7b97\u7ed3\u679c\u4e3a" + JSON.toJSONString((Object)orderPreviewRespDto));
        return new RestResponse((Object)orderPreviewRespDto);
    }

    public RestResponse<String> addVirtualOrder(@Valid OrderReqDto orderReq) {
        return new RestResponse();
    }

    public RestResponse<Long> addStockBatch(OrderStockBatchDto order) {
        Long orderId = this.orderService.addStockBatch(order);
        return new RestResponse((Object)orderId);
    }

    public RestResponse<Void> logicDeleteOrder(@PathVariable(value="orderId") Long orderId) {
        this.orderService.logicDeleteOrder(orderId);
        return new RestResponse();
    }

    public RestResponse<Void> cancelOrder(String tradeNo, @Valid CancelReqDto cancelReq) {
        OrderEo orderEo = this.orderService.getByOrderNo(tradeNo);
        Assert.notNull((Object)orderEo, TradeExceptionCode.ORDER_NO_EXIT);
        String orderStatus = orderEo.getOrderStatus();
        if ("WAIT_AUDIT".equals(orderStatus)) {
            this.doCancelOrder(tradeNo, cancelReq);
        } else if ("WAIT_DELIVERY".equals(orderStatus)) {
            this.doCancelOrder4MultiScene(tradeNo, cancelReq);
        }
        return this.doCancelOrder(tradeNo, cancelReq);
    }

    public RestResponse<Void> closeOrder(String tradeNo) {
        OrderEo orderEo = this.orderService.getByOrderNo(tradeNo);
        Assert.notNull((Object)orderEo, TradeExceptionCode.ORDER_NO_EXIT);
        return this.doCloseOrder(tradeNo);
    }

    private void doCancelOrder4MultiScene(String orderNo, CancelReqDto cancelReq) {
        Map<Integer, List<OrderDeliveryEo>> sceneMap = this.orderDeliveryInfoService.querySceneNum(orderNo);
        if (MapUtils.isEmpty(sceneMap) || sceneMap.containsKey(-1)) {
            throw new BizException("\u67e5\u8be2\u53d1\u8d27\u5355\u573a\u666f\u5931\u8d25");
        }
        boolean flagMiddleGround = false;
        block0: for (Map.Entry<Integer, List<OrderDeliveryEo>> entry : sceneMap.entrySet()) {
            List<OrderDeliveryEo> orderDeliveryEos = entry.getValue();
            for (OrderDeliveryEo orderDeliveryEo : orderDeliveryEos) {
                if (YesNoEnum.YES.getValue() != orderDeliveryEo.getIfAgreement()) continue;
                flagMiddleGround = true;
                continue block0;
            }
        }
        if (flagMiddleGround) {
            this.cancelOrder4MultiSceneByMiddleGround(orderNo, cancelReq, sceneMap);
        } else if (!flagMiddleGround) {
            this.cancelOrder4MultiSceneByDownStream(orderNo, cancelReq, sceneMap);
        }
    }

    private void cancelOrder4MultiSceneByMiddleGround(String orderNo, CancelReqDto cancelReq, Map<Integer, List<OrderDeliveryEo>> sceneMap) {
        int scene = 0;
        List<OrderDeliveryEo> orderDeliveryEos = new ArrayList<OrderDeliveryEo>();
        for (Map.Entry<Integer, List<OrderDeliveryEo>> entry : sceneMap.entrySet()) {
            scene = entry.getKey();
            orderDeliveryEos = entry.getValue();
        }
        for (OrderDeliveryEo orderDeliveryEo : orderDeliveryEos) {
            if (!DeliveryStatusEnum.INIT.getStatus().equals(orderDeliveryEo.getDeliveryStatus())) continue;
            throw new BizException("\u53d1\u8d27\u5355\u72b6\u6001\u3010\u5df2\u63a5\u5355\u3011\uff0c\u4e0d\u652f\u6301\u53d6\u6d88");
        }
        this.handleScene123(orderNo, cancelReq, scene, orderDeliveryEos);
    }

    private void handleScene123(String orderNo, CancelReqDto cancelReq, int scene, List<OrderDeliveryEo> orderDeliveryEos) {
        if (scene == 1) {
            this.handleScene1(orderNo, cancelReq);
        } else if (scene == 2) {
            this.handleScene2(orderNo, cancelReq, orderDeliveryEos);
        } else if (scene == 3) {
            this.handleScene3(orderNo, cancelReq);
        }
    }

    private void handleScene2(String orderNo, CancelReqDto cancelReq, List<OrderDeliveryEo> orderDeliveryEos) {
        this.orderService.cancelOrderDelivery(orderNo, orderDeliveryEos);
        this.doCancelOrder(orderNo, cancelReq);
        this.orderService.reCreateDeliveryOrder4Other(orderNo, orderDeliveryEos);
        for (OrderDeliveryEo orderDeliveryEo : orderDeliveryEos) {
            String desc = String.format("\u4fee\u6539\u6536\u8d27\u5730\u5740\uff1a\u5355\u4e2a\u53d1\u8d27\u5355-\u5408\u5e76\u5176\u4ed6\u5355\uff0c\u8ba2\u5355\u53f7\uff1a%s\uff0c\u53d1\u8d27\u5355\u53f7\uff1a%s", orderNo, orderDeliveryEo.getDeliveryNo());
            this.deliveryService.assembleMessage2Inventory(orderDeliveryEo, DeliveryStatusEnum.CANCELED.getStatus(), DeliveryRouteOptEnum.CANCEL.getOptCode(), desc);
        }
    }

    private void doCancelDeliveryOrder(String orderNo) {
        ArrayList<String> orderNos = new ArrayList<String>(1);
        orderNos.add(orderNo);
        this.deliveryService.cancleByOrderNo(orderNos);
    }

    private void handleScene3(String orderNo, CancelReqDto cancelReq) {
        this.doCancelDeliveryOrder(orderNo);
        this.doCancelOrder(orderNo, cancelReq);
    }

    private void handleScene1(String orderNo, CancelReqDto cancelReq) {
        this.doCancelDeliveryOrder(orderNo);
        this.doCancelOrder(orderNo, cancelReq);
    }

    private void cancelOrder4MultiSceneByDownStream(String orderNo, CancelReqDto cancelReq, Map<Integer, List<OrderDeliveryEo>> sceneMap) {
        int scene = 0;
        List<OrderDeliveryEo> orderDeliveryEos = new ArrayList<OrderDeliveryEo>();
        for (Map.Entry<Integer, List<OrderDeliveryEo>> entry : sceneMap.entrySet()) {
            scene = entry.getKey();
            orderDeliveryEos = entry.getValue();
        }
        this.handleScene123(orderNo, cancelReq, scene, orderDeliveryEos);
    }

    private RestResponse<Void> doCancelOrder(String tradeNo, @Valid CancelReqDto cancelReq) {
        CancelOrderBo cancelOrderBo = new CancelOrderBo();
        cancelOrderBo.setCancelReqDto(cancelReq);
        cancelOrderBo.setDriveFlowParam(this.orderCreateActionExtPt.getFlowDefId(), this.orderCreateActionExtPt.getFlowDefName(), tradeNo);
        cancelOrderBo.setToStatus("CANCEL");
        cancelReq.setTradeNo(tradeNo);
        this.orderFlowAction.cancelOrder(cancelOrderBo);
        return new RestResponse();
    }

    private RestResponse<Void> doCloseOrder(String tradeNo) {
        return new RestResponse();
    }

    public RestResponse<Void> cancelByOrder(String orderNo, @Valid CancelReqDto cancelReq) {
        OrderEo orderEo = this.orderService.getByOrderNo(orderNo);
        Assert.notNull((Object)orderEo, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        this.orderService.cancelAndUpdateOrder(orderEo, cancelReq.getCancelType(), cancelReq.getCancelDesc());
        return RestResponse.VOID;
    }

    public RestResponse<Void> confirmOrder(String tradeNo) {
        return new RestResponse();
    }

    public RestResponse<Void> modifyOrderAddress(String tradeNo, OrderAddressReqDto deliveryAddress) {
        this.orderService.modifyOrderAddress(tradeNo, deliveryAddress);
        return new RestResponse();
    }

    public RestResponse<Void> modifyOrderBizStatus(String tradeNo, String status) {
        this.orderService.modifyOrderBizStatus(tradeNo, status);
        return new RestResponse();
    }

    public RestResponse<Void> modifyOrder(String tradeNo, OrderModReqDto order) {
        order.setTradeNo(tradeNo);
        Assert.notNull((Object)order.getTenantId(), "\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        this.orderService.modifyOrder(order);
        return new RestResponse();
    }

    public RestResponse<Void> modifyOrderTradeStatus(String tradeNo, String orderNo, String status) {
        this.orderService.modifyOrderTradeStatus(tradeNo, orderNo, status);
        return new RestResponse();
    }

    public RestResponse<Void> modifyOrderStatus(String orderNo, String status) {
        this.orderService.modifyOrderStatus(null, orderNo, status, null);
        return new RestResponse();
    }

    @Transactional
    public RestResponse<String> submitOrder(OrderReqDto orderReq) {
        OrderCreateBo orderCreateBo = new OrderCreateBo();
        orderCreateBo.setOrderReqDto(orderReq);
        orderCreateBo = this.orderService.updateOrder(orderCreateBo);
        if (orderReq.getFlowDefId() != null && orderReq.getFlowType() != null) {
            orderCreateBo.setDriveFlowParam(orderReq.getFlowDefId(), orderReq.getFlowType(), orderReq.getOrderNo());
        } else {
            orderCreateBo.setDriveFlowParam(this.orderCreateActionExtPt.getFlowDefId(), this.orderCreateActionExtPt.getFlowDefName(), orderReq.getOrderNo());
        }
        OrderCreateBo order = this.createOrderFlowAction.submitOrder(orderCreateBo);
        return new RestResponse((Object)order.getOrderEo().getOrderNo());
    }

    public RestResponse<List<DeliverysItemRespDto>> queryByDeliveryNoAndSkuSerial(String tradeNo) {
        List<DeliveryItemEo> deliveryItemEos = this.iOrderDeliveryService.queryListByDeliveryNo(tradeNo);
        ArrayList objects = new ArrayList();
        DtoHelper.eoList2DtoList(deliveryItemEos, objects, DeliverysItemRespDto.class);
        return new RestResponse(objects);
    }

    public RestResponse<Void> importExcelOrder(String filePath) {
        this.orderService.importExcelOrder(filePath);
        return RestResponse.VOID;
    }

    public RestResponse<Void> batchRemarkOrderTags(RemarkOrderTagsReqDto remarkOrderTagsReqDto) {
        if (remarkOrderTagsReqDto.getRemark() == null && remarkOrderTagsReqDto.getOrderTags() == null) {
            throw new BizException("\u5907\u6ce8\u6216\u8ba2\u5355\u6253\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.orderService.batchRemarkOrderTags(remarkOrderTagsReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> clearTradeItemBatch(String orderNo) {
        this.orderService.clearTradeItemBatch(orderNo);
        return RestResponse.VOID;
    }
}

