/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.apiimpl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.payment.dto.BaseDto;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.VerifyException;
import com.dtyunxi.yundt.cube.center.payment.dto.notify.PayOrderNotifyRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.notify.RefundOrderNotifyRequest;
import com.dtyunxi.yundt.cube.center.trade.api.IPayApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayIntegralOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayMethodReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.RefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.flow.RefundNotifyDto;
import com.dtyunxi.yundt.cube.center.trade.api.flow.Description;
import com.dtyunxi.yundt.cube.center.trade.biz.config.PayConfig;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnRefundAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.RefundNotifyBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.OrderFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.PayNotifyFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.PayRecordFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.RefundFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IContextService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.PayRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IPayNotifyActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IPayRecordActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IRefundActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.PayMethodBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.PayOrderNotifyBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.RefundCreateBo;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="payApiImpl")
public class PayApiImpl
implements IPayApi {
    private static Logger logger = LoggerFactory.getLogger(PayApiImpl.class);
    @Autowired
    private PayConfig payConfig;
    @Autowired
    private PayRecordDas payRecordDas;
    @Autowired
    IPayService payService;
    @Autowired
    ITradeService tradeService;
    @Autowired
    IOrderService orderService;
    @Resource
    private PayNotifyFlowAction payNotifyFlowAction;
    @Resource
    private PayRecordFlowAction payRecordFlowAction;
    @CubeResource
    private IPayNotifyActionExtPt payNotifyActionExtPt;
    @CubeResource
    private IPayRecordActionExtPt payRecordActionExtPt;
    @Resource
    private ReturnRefundAction returnRefundAction;
    @Resource
    private RefundFlowAction refundFlowAction;
    @Value(value="${yundt.cube.center.payment.appvo.apiSecret}")
    public String apiSecret;
    @Resource
    private OrderFlowAction orderFlowAction;
    @CubeResource
    private IRefundActionExtPt refundActionExtPt;
    @Resource
    private IContextService contextService;
    @Resource
    private ILockService lockService;

    public String handleNotify(String tradeNo, String appKey, HttpServletRequest request) {
        logger.info("\u652f\u4ed8\u901a\u77e5\u4ea4\u6613\u53f7{}\u83b7\u53d6\u7684appKey{}", (Object)tradeNo, (Object)appKey);
        if (appKey != null) {
            this.contextService.getAndSetInstanceInfo(Long.valueOf(appKey));
        }
        TreeMap<String, String> paramsMap = new TreeMap<String, String>();
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String paraName = (String)enu.nextElement();
            paramsMap.put(paraName, request.getParameter(paraName));
        }
        PayOrderNotifyRequest notify = new PayOrderNotifyRequest();
        notify.setStoreOrderId(tradeNo);
        notify = (PayOrderNotifyRequest)notify.map2Bean(paramsMap);
        logger.info("\u6536\u5230\u652f\u4ed8\u901a\u77e5{},\u89e3\u6790\u7d50\u679c\u70ba{}", (Object)tradeNo, JSON.toJSON((Object)notify));
        notify.setStoreOrderId(tradeNo);
        this.replyHandleNotify(notify);
        return "SUCCESS";
    }

    @Transactional(rollbackFor={Exception.class})
    public void replyHandleNotify(PayOrderNotifyRequest payOrderNotifyRequest) {
        PayRecordEo payRecordEo = this.payRecordDas.selectByTradeNo(payOrderNotifyRequest.getStoreOrderId());
        if (payRecordEo == null) {
            payRecordEo = this.payRecordDas.selectByOrderNo(payOrderNotifyRequest.getStoreOrderId());
        }
        payRecordEo = this.payRecordDas.lockById(payRecordEo.getId());
        if (PayStatusEnum.FAIL.getName().equals(payRecordEo.getPayStatus()) || PayStatusEnum.SUCCESS.getName().equals(payRecordEo.getPayStatus())) {
            return;
        }
        PayOrderNotifyBo payOrderNotifyBo = new PayOrderNotifyBo();
        payOrderNotifyBo.setPayOrderNotifyRequest(payOrderNotifyRequest);
        payOrderNotifyBo.setDriveFlowParam(this.payNotifyActionExtPt.getFlowDefId(), this.payNotifyActionExtPt.getFlowName(), payOrderNotifyRequest.getStoreOrderId());
        try {
            this.payNotifyFlowAction.handleNotify(payOrderNotifyBo);
        }
        catch (Exception e) {
            payOrderNotifyBo.setDriveFlowParam(this.payNotifyActionExtPt.getFlowDefId(), this.payNotifyActionExtPt.getFlowName(), payOrderNotifyRequest.getStoreOrderId());
            this.payNotifyFlowAction.checkIsRefund(payOrderNotifyBo);
            logger.error("\u652f\u4ed8\u901a\u77e5\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    private void validSign(BaseDto notify) {
        try {
            notify.verifySign(this.payConfig.getApiSecret());
        }
        catch (VerifyException ex) {
            try {
                notify.verifyGlobalSign(this.apiSecret);
            }
            catch (VerifyException e) {
                logger.error("\u7b7e\u540d\u4e0d\u4e00\u81f4", (Throwable)ex);
                throw new BizException(ex.getErrCode(), ex.getErrMsg());
            }
        }
    }

    public String handleRefundNotify(String tradeNo, String appKey, HttpServletRequest request) {
        logger.info("\u9000\u6b3e\u901a\u77e5\u4ea4\u6613\u53f7{}\u83b7\u53d6\u7684appKey{}", (Object)tradeNo, (Object)appKey);
        if (appKey != null) {
            this.contextService.getAndSetInstanceInfo(Long.valueOf(appKey));
        }
        TreeMap<String, String> paramsMap = new TreeMap<String, String>();
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String paraName = (String)enu.nextElement();
            paramsMap.put(paraName, request.getParameter(paraName));
        }
        RefundOrderNotifyRequest notify = new RefundOrderNotifyRequest();
        notify = (RefundOrderNotifyRequest)notify.map2Bean(paramsMap);
        logger.info("\u6536\u5230\u9000\u6b3e\u901a\u77e5{},\u89e3\u6790\u7d50\u679c\u70ba{}", (Object)tradeNo, JSON.toJSON((Object)notify));
        this.validSign((BaseDto)notify);
        RefundNotifyBo refundNotifyBo = new RefundNotifyBo();
        refundNotifyBo.setDriveFlowParam(this.refundActionExtPt.getFlowDefId(), this.refundActionExtPt.getFlowDefName(), tradeNo);
        refundNotifyBo.setRefundNotifyDto(RefundNotifyDto.init((String)tradeNo, (String)notify.getRefundStatus(), (String)notify.getRefundId()));
        this.refundFlowAction.handleRefundNotifyAction(refundNotifyBo);
        return "success";
    }

    public String demoNotify(String tradeNo, HttpServletRequest request) {
        RefundOrderNotifyRequest notify = new RefundOrderNotifyRequest();
        notify = (RefundOrderNotifyRequest)JSON.parseObject((String)"{\"finishTime\":\"2020-09-15 17:45:45\",\"partnerOrderId\":\"50300405542020091502709674168\",\"sign\":\"9E791D57B129129DFC17BE9A17C0FD17\",\"refundStatus\":\"S\",\"userId\":\"1240282584225877043\",\"globalSign\":\"40E1CAC75DB961458D7A74A7B5674B66\",\"instanceId\":-1,\"payTypeId\":\"101\",\"storeRefundId\":\"2020091517404402306090603\",\"tenantId\":-1,\"refundId\":\"20200915174044010048\",\"tradeId\":\"20200915174009000047\",\"refundAmt\":\"0.1000\"}", RefundOrderNotifyRequest.class);
        logger.info("\u6536\u5230\u9000\u6b3e\u901a\u77e5{},\u89e3\u6790\u7d50\u679c\u70ba{}", (Object)tradeNo, JSON.toJSON((Object)notify));
        return this.returnRefundAction.handleRefundNotifyAction(RefundNotifyDto.init((String)tradeNo, (String)notify.getRefundStatus(), (String)notify.getRefundId())).getResult();
    }

    public RestResponse<String> modifyPayMethod(String tradeNo, PayMethodReqDto payMethodReqDto) {
        logger.info("\u63a5\u6536\u5230\u652f\u4ed8\u8bf7\u6c42[{}],\u89e3\u6790\u7ed3\u679c\u4e3a{}", (Object)tradeNo, (Object)JSON.toJSONString((Object)payMethodReqDto));
        if (payMethodReqDto.getOrderNo() == null) {
            payMethodReqDto.setOrderNo(tradeNo);
        }
        if ("ORDER".equals(this.payRecordActionExtPt.getFlowType())) {
            return this.sendOrderPay(payMethodReqDto);
        }
        if ("PAY".equals(this.payRecordActionExtPt.getFlowType())) {
            return this.sendPay(payMethodReqDto);
        }
        throw new BizException("\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u6d41\u7a0b");
    }

    public RestResponse<String> addOfflinePayRecord(PayMethodReqDto payMethodReqDto) {
        logger.info("\u63a5\u6536\u5230\u7ebf\u4e0b\u4f59\u989d\u8d26\u6237\u652f\u4ed8\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)payMethodReqDto));
        if (StringUtils.isBlank((String)payMethodReqDto.getOrderNo())) {
            throw new BizException("\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Mutex lock = this.lockService.lock(this.getClass().getSimpleName(), payMethodReqDto.getOrderNo(), 1500, 1500, TimeUnit.MILLISECONDS);
        String payNo = null;
        try {
            payMethodReqDto.setTradeNo(payMethodReqDto.getOrderNo());
            payMethodReqDto.setDeviceType("APP");
            payMethodReqDto.setFlowDefId(Long.valueOf(0L));
            payMethodReqDto.setPayFlowName("PAY_TOB");
            payMethodReqDto.setPayMethod("OFFLINE_AMOUNT_PAY");
            PayMethodBo payMethodBo = this.payOrderToB(payMethodReqDto);
            payNo = payMethodBo.getPayRecordEo().getPayNo();
        }
        catch (Exception e) {
            logger.error("\u7ebf\u4e0b\u4f59\u989d\u8d26\u6237\u652f\u4ed8\u5f02\u5e38\uff1a{}", (Throwable)e);
            throw new BizException(e.getMessage());
        }
        finally {
            this.lockService.unlock(lock);
        }
        return new RestResponse((Object)payNo);
    }

    @Description(value="\u7531\u8ba2\u5355\u6d41\u7a0b\u53d1\u8d77\u7684\u652f\u4ed8")
    private RestResponse sendOrderPay(PayMethodReqDto payMethodReqDto) {
        PayMethodBo payMethodBo = new PayMethodBo();
        if (payMethodReqDto.getFlowDefId() != null && payMethodReqDto.getPayFlowName() != null) {
            payMethodBo.setDriveFlowParam(payMethodReqDto.getFlowDefId(), payMethodReqDto.getPayFlowName(), payMethodReqDto.getOrderNo());
        } else {
            payMethodBo.setDriveFlowParam(this.payRecordActionExtPt.getFlowDefId(), this.payRecordActionExtPt.getFlowName(), payMethodReqDto.getOrderNo());
        }
        payMethodBo.setPayMethodReqDto(payMethodReqDto);
        payMethodBo.setPayType(payMethodReqDto.getPayType());
        payMethodBo = this.orderFlowAction.createPay(payMethodBo);
        return new RestResponse((Object)payMethodBo.getPayRecordEo().getPayNo());
    }

    @Description(value="\u7531\u652f\u4ed8\u6d41\u7a0b\u53d1\u8d77\u7684\u652f\u4ed8")
    private RestResponse sendPay(PayMethodReqDto payMethodReqDto) {
        PayMethodBo payMethodBo = this.payOrderToB(payMethodReqDto);
        return new RestResponse((Object)payMethodBo.getPayRecordEo().getPayNo());
    }

    private PayMethodBo payOrderToB(PayMethodReqDto payMethodReqDto) {
        PayMethodBo payMethodBo = new PayMethodBo();
        if (payMethodReqDto.getFlowDefId() != null && payMethodReqDto.getPayFlowName() != null) {
            payMethodBo.setStartFlowParam(payMethodReqDto.getFlowDefId(), payMethodReqDto.getPayFlowName());
        } else {
            payMethodBo.setStartFlowParam(this.payRecordActionExtPt.getFlowDefId(), this.payRecordActionExtPt.getFlowName());
        }
        payMethodBo.setPayMethodReqDto(payMethodReqDto);
        payMethodBo.setPayType(payMethodReqDto.getPayType());
        payMethodBo = this.payRecordFlowAction.create(payMethodBo);
        return payMethodBo;
    }

    public RestResponse<String> addRefund(RefundReqDto refundReqDto) {
        RefundCreateBo refundCreateBo = new RefundCreateBo();
        refundCreateBo.setRefundReqDto(refundReqDto);
        refundCreateBo.setDriveFlowParam(this.refundActionExtPt.getFlowDefId(), this.refundActionExtPt.getFlowDefName(), refundReqDto.getReturnNo());
        return new RestResponse((Object)this.refundFlowAction.doRefundAction(refundCreateBo).getDoRefundResult());
    }

    public RestResponse<Void> payIntegralOrder(String tradeNo, PayIntegralOrderReqDto payIntegralOrderReqDto) {
        return new RestResponse();
    }

    public RestResponse modifyPayMethod(PayMethodReqDto payMethodReqDto) {
        if (payMethodReqDto.getOrderNo() == null) {
            payMethodReqDto.setOrderNo(payMethodReqDto.getTradeNo());
        }
        PayMethodBo payMethodBo = new PayMethodBo();
        payMethodBo.setStartFlowParam(payMethodReqDto.getFlowDefId(), payMethodReqDto.getPayFlowName());
        payMethodBo.setPayMethodReqDto(payMethodReqDto);
        payMethodBo = this.payRecordFlowAction.create(payMethodBo);
        return new RestResponse((Object)payMethodBo.getSendPayResult());
    }
}

