/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.apiimpl.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliverysReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ShippingReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.CancelPartnerDeliveryReasonRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryLogisticRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryRejectReasonRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IDeliveryQueryApi;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryService;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deliveryQueryApiImpl")
public class DeliveryQueryApiImpl
implements IDeliveryQueryApi {
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IDeliveryItemService deliveryItemService;

    public RestResponse<PageInfo<DeliveryRespDto>> queryByPage(DeliverysReqDto deliverysReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.deliveryService.queryByPage(deliverysReqDto, pageNum, pageSize));
    }

    public RestResponse<DeliveryRespDto> detail(String deliveryNo) {
        return new RestResponse((Object)this.deliveryService.getDetailByDeliveryNo(deliveryNo));
    }

    public RestResponse<List<DeliveryRejectReasonRespDto>> listRejectReasons() {
        return new RestResponse(this.deliveryService.listRejectReasons());
    }

    public RestResponse<List<DeliveryLogisticRespDto>> listDeliveryLogistics(String shippingCompanyCode, String expressCode) {
        ShippingReqDto shippingReqDto = new ShippingReqDto();
        shippingReqDto.setShippingNo(shippingCompanyCode);
        shippingReqDto.setShippingCode(expressCode);
        return new RestResponse(this.deliveryService.listDeliveryLogistics(shippingReqDto));
    }

    public RestResponse<List<CancelPartnerDeliveryReasonRespDto>> queryCancelReasonList(Integer shippingCompanyCode) {
        return new RestResponse(this.deliveryService.listCancelReason(shippingCompanyCode));
    }

    public RestResponse<PageInfo<DeliveryItemRespDto>> queryItemDetailPage(DeliveryItemReqDto deliveryItemReqDto) {
        return new RestResponse(this.deliveryItemService.queryItemDetailPage(deliveryItemReqDto));
    }
}

