/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingCompanyEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ShippingReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryLogisticRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.LogisticsTrackRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderDeliveryQueryApi;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.CreateDeliveryOrderFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PackageItemEo;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orderDeliveryQueryApiImpl")
public class OrderDeliveryQueryApiImpl
implements IOrderDeliveryQueryApi {
    @Resource
    private CreateDeliveryOrderFlowAction createDeliveryOrderFlowAction;
    @Resource
    private IOrderDeliveryService orderDeliveryService;
    @Autowired
    private IDeliveryService deliveryService;

    public RestResponse<PageInfo<OrderDeliveryRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.orderDeliveryService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<PageInfo<OrderDeliveryRespDto>> queryByPageOnPost(OrderDeliveryEo orderDeliveryEo, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.orderDeliveryService.queryByPage(JSON.toJSONString((Object)orderDeliveryEo), pageNum, pageSize));
    }

    public RestResponse<OrderDeliveryDetailRespDto> queryDetail(String tradeNo) {
        return new RestResponse((Object)this.orderDeliveryService.queryDetail(tradeNo));
    }

    public RestResponse<Integer> count(String filter) {
        return new RestResponse((Object)this.orderDeliveryService.count(filter));
    }

    public RestResponse<Integer> sumItemSkuSerial(String filter) {
        return new RestResponse((Object)this.orderDeliveryService.sumItemSkuSerial(filter));
    }

    public RestResponse<Set<String>> queryDeliveryItemSupplierSerialNoReply(String filter) {
        return new RestResponse(this.orderDeliveryService.queryDeliveryItemSupplierSerialNoReply(filter));
    }

    public RestResponse<Set<String>> queryDeliveryItemSkuSerialNoReply(String filter) {
        return new RestResponse(this.orderDeliveryService.queryDeliveryItemSkuSerialNoReply(filter));
    }

    public RestResponse<Set<String>> queryDeliveryDelivererIdNoReply(String filter) {
        return new RestResponse(this.orderDeliveryService.queryDeliveryDelivererIdNoReply(filter));
    }

    public RestResponse<LogisticsTrackRespDto> queryLogisticsTrack(String tradeNo) {
        LogisticsTrackRespDto logisticsTrackRespDto = new LogisticsTrackRespDto();
        logisticsTrackRespDto.setTradeNo(tradeNo);
        List<PackageItemEo> packageItemEoList = this.orderDeliveryService.getPackItemByDeliveryNo(tradeNo);
        if (CollectionUtils.isNotEmpty(packageItemEoList)) {
            OrderDeliveryRespDto orderDeliveryRespDto;
            PackageItemEo packageItemEo = packageItemEoList.get(0);
            String shippingCompany = packageItemEo.getShippingCompany();
            String shippingCompanyCode = packageItemEo.getShippingCompanyCode();
            String shippingSerial = packageItemEo.getShippingSerial();
            logisticsTrackRespDto.setShippingCompany(shippingCompany);
            logisticsTrackRespDto.setShippingSerial(shippingSerial);
            logisticsTrackRespDto.setShippingCompanyCode(shippingCompanyCode);
            ShippingReqDto shippingReqDto = new ShippingReqDto();
            shippingReqDto.setShippingNo(shippingCompanyCode);
            shippingReqDto.setShippingCode(shippingSerial);
            if (ShippingCompanyEnum.SF.getCode().equals(shippingCompanyCode) && null != (orderDeliveryRespDto = this.orderDeliveryService.queryOrderByTradeNo(tradeNo))) {
                String deliveryMobile = StringUtils.isBlank((CharSequence)orderDeliveryRespDto.getDeliveryMobile()) ? "" : orderDeliveryRespDto.getDeliveryMobile();
                String customerName = this.getCardTailNum(deliveryMobile);
                shippingReqDto.setCustomerName(customerName);
            }
            List<DeliveryLogisticRespDto> deliveryLogisticList = this.deliveryService.listDeliveryLogistics(shippingReqDto);
            logisticsTrackRespDto.setDeliveryLogisticList(deliveryLogisticList);
        }
        return new RestResponse((Object)logisticsTrackRespDto);
    }

    public RestResponse<PageInfo<OrderDeliveryDetailRespDto>> queryDetailByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.orderDeliveryService.queryDetailByPage(filter, pageNum, pageSize));
    }

    public RestResponse<OrderDeliveryRespDto> queryOrderByDeliveryNo(String deliveryNo) {
        return new RestResponse((Object)this.orderDeliveryService.queryOrderByDeliveryNo(deliveryNo));
    }

    public RestResponse<List<DeliveryItemRespDto>> queryDeliveryItemForCanService(String deliveryNo, String customerId) {
        return new RestResponse(this.orderDeliveryService.queryDeliveryItemForCanService(deliveryNo, customerId));
    }

    public RestResponse<Map<String, Boolean>> queryCanServiceFlag(String orderNos, String deliveryNos) {
        return new RestResponse(this.orderDeliveryService.queryCanServiceFlag(orderNos, deliveryNos));
    }

    public RestResponse<Map<String, Boolean>> queryCanServiceFlagOnPost(List<String> orderNoList, String deliveryNos) {
        return new RestResponse(this.orderDeliveryService.queryCanServiceFlag(StringUtils.join(orderNoList, (String)","), deliveryNos));
    }

    private String getCardTailNum(String cardNum) {
        StringBuffer tailNum = new StringBuffer();
        if (cardNum != null) {
            int len = cardNum.length();
            for (int i = len - 1; i >= len - 4; --i) {
                tailNum.append(cardNum.charAt(i));
            }
            tailNum.reverse();
        }
        return tailNum.toString();
    }
}

