/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.apiimpl.query;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.TradeTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PayRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IPayQueryApi;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeService;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayRecordEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payQueryApiImpl")
public class PayApiQueryImpl
implements IPayQueryApi {
    private static Logger logger = LoggerFactory.getLogger(PayApiQueryImpl.class);
    @Autowired
    IPayService payService;
    @Autowired
    ITradeService tradeService;

    public RestResponse<PayRecordRespDto> queryPayRecordByTradeNo(String tradeNo) {
        PayRecordRespDto payRecordRepDto = new PayRecordRespDto();
        PayRecordEo payRecordEo = this.payService.queryPayRecordByTradeNo(tradeNo);
        DtoHelper.eo2Dto((BaseEo)payRecordEo, (BaseVo)payRecordRepDto);
        return new RestResponse((Object)payRecordRepDto);
    }

    public RestResponse<PageInfo<PayRecordRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PageInfo<PayRecordEo> pageInfo = this.payService.queryByPage(filter, pageNum, pageSize);
        ArrayList payRecordRepDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), payRecordRepDtoList, PayRecordRespDto.class);
        pageInfo.setList(payRecordRepDtoList);
        return new RestResponse(pageInfo);
    }

    public RestResponse<PageInfo<PayRecordRespDto>> queryPayByPage(String filter, Integer pageNum, Integer pageSize) {
        PageInfo<PayRecordEo> pageInfo = this.payService.queryPayByPage(filter, pageNum, pageSize);
        ArrayList payRecordRepDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), payRecordRepDtoList, PayRecordRespDto.class);
        pageInfo.setList(payRecordRepDtoList);
        return new RestResponse(pageInfo);
    }

    public RestResponse<List<PayRecordRespDto>> queryPayRecordByOrderNo(String orderNo, String filter) {
        Set<String> tradeNos = this.tradeService.getChildrenTradeNosByType(orderNo, TradeTypeEnum.PAY.getCode());
        return new RestResponse(this.payService.queryList(tradeNos, filter));
    }
}

