/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.action;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.cube.enhance.flow.ActionResult;
import com.dtyunxi.cube.enhance.flow.IFlowEntity;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ActivityConstant;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReceiptReq;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderSplitReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.action.IOrderAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.ActivityNotifyResult;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderPayResult;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderPayedEvent;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.PayNotifyResultOutput;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.PayNotifyResultOutput2;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.enums.ActivityTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.OrderCloseProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.ActivityGroupOperateOrderMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.OrderCloseMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderCouponService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IExtlOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.bo.CountResultRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.util.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.engine.TradeEngine;
import com.dtyunxi.yundt.cube.center.trade.engine.TradeEngineUtil;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.OrderDeliveryExtReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.DeliveryOrderRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.ICouponApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@ActionNodeComponent
@Deprecated
public class OrderAction
implements IOrderAction {
    private Logger logger = LoggerFactory.getLogger(OrderAction.class);
    @Resource
    private IOrderService orderService;
    @Resource
    private OrderDas orderDas;
    @Autowired
    private IOrderCouponService orderCouponService;
    @Autowired
    private IPayService payService;
    @Resource
    private IExtlOrderActivityService extlOrderActivityService;
    @Resource
    private IOrderActivityService orderActivityService;
    @Resource
    private OrderCloseProducer orderCloseProducer;
    @Resource
    private ICouponApi couponApi;
    private final String CLASS_FULL_NAME = this.getClass().getCanonicalName();

    @Override
    @ActionNode(entity=OrderEo.class, name="\u53d6\u6d88\u8ba2\u5355")
    public OrderEo cancelOrder(CancelReqDto cancelReq) {
        String curActionNode = this.CLASS_FULL_NAME + "#cancelOrder";
        OrderEo orderEo = this.orderDas.lockByOrderNo(cancelReq.getTradeNo());
        TradeEngine.validate((IFlowEntity)orderEo, curActionNode);
        OrderReqDto orderBo = this.orderActivityService.getActivityOrder(cancelReq.getTradeNo());
        if (orderBo.getActivity() != null && CollectionUtils.isNotEmpty((Collection)orderBo.getActivity().getActivityList())) {
            orderBo.getActivity().getActivityList().stream().forEach(activity -> {
                if (ActivityConstant.COUPON_ACTIVITY.equals(activity.getType()) && CollectionUtils.isNotEmpty((Collection)activity.getActivityItemIds())) {
                    List<Long> couponIds = activity.getActivityItemIds().stream().map(Long::valueOf).collect(Collectors.toList());
                    this.orderCouponService.releaseCoupon(orderEo, couponIds);
                }
            });
        }
        orderEo.setId(orderEo.getId());
        orderEo.setId(orderEo.getId());
        orderEo.setCancelDesc(cancelReq.getCancelDesc());
        orderEo.setCancelTime(new Date());
        orderEo.setCancelType(cancelReq.getCancelType());
        this.orderService.refundCancelOrder(orderEo, cancelReq);
        TradeEngine.setFlowStatus(orderEo, "succ", curActionNode);
        this.orderDas.updateSelective((BaseEo)orderEo);
        return orderEo;
    }

    @Override
    @ActionNode(entity=OrderEo.class, name="\u4e0b\u5355")
    @Transactional
    public String createOrder(OrderReqDto orderReq) {
        boolean notSecondKillReq;
        String curActionNode = this.CLASS_FULL_NAME + "#createOrder";
        if (StringUtils.isEmpty((Object)orderReq.getShippingType())) {
            orderReq.setShippingType("express");
        }
        if (orderReq.getCloseTime() != null && orderReq.getCloseTime().before(new Date())) {
            throw new BizException(TradeExceptionCode.CLOSETIME_ILLEGAL.getCode(), TradeExceptionCode.CLOSETIME_ILLEGAL.getMsg());
        }
        String tradeNo = TradeUtil.generateTradeNo();
        orderReq.setTradeNo(tradeNo);
        OrderReqDto orderBo = orderReq;
        boolean bl = notSecondKillReq = !"SKILL_ORDER".equals(orderReq.getFlowType());
        if (notSecondKillReq) {
            if (orderBo.getActivity() != null && CollectionUtils.isNotEmpty((Collection)orderBo.getActivity().getActivityList())) {
                CountResultRespDto countResultRespDto = this.extlOrderActivityService.countActivityOrderAmount(orderBo);
                if (countResultRespDto.getCountOrderReq() != null) {
                    orderBo = countResultRespDto.getCountOrderReq();
                }
            } else {
                orderBo = this.orderService.countOrderAmount(orderReq);
            }
        }
        ArrayList orderCreateRespDtoList = new ArrayList();
        if (this.orderService.isSplitOrder(orderBo).booleanValue()) {
            OrderSplitReqDto orderSplitReqDto = this.orderService.splitOrderAndCountFreight(orderBo);
            orderBo.setIsSplit(Integer.valueOf(1));
            Object createRespDto2 = null;
            orderCreateRespDtoList.add(createRespDto2);
            for (OrderReqDto childrenOrder : orderSplitReqDto.getChildrenOrderList()) {
                childrenOrder = this.orderService.countOrderAmount(childrenOrder);
                childrenOrder.setTradeNo(TradeUtil.generateTradeNo(orderBo.getTradeNo()));
                childrenOrder.setParentOrderNo(orderBo.getTradeNo());
                childrenOrder.setActivity(null);
                childrenOrder.setDiscountAmount(childrenOrder.getTotalAmount().subtract(childrenOrder.getPayAmount()));
                Object childCreateRespDto = null;
                orderCreateRespDtoList.add(childCreateRespDto);
            }
        } else {
            OrderReqDto orderReqDto = this.orderService.countFreight(orderBo);
            Object createRespDto3 = null;
            orderCreateRespDtoList.add(createRespDto3);
        }
        if (CollectionUtils.isNotEmpty(orderCreateRespDtoList)) {
            orderCreateRespDtoList.forEach(createRespDto -> {
                OrderCloseMessageVo messageVo = new OrderCloseMessageVo(createRespDto.getOrderNo(), null, orderReq.getCloseTime(), orderReq.getTenantId(), orderReq.getInstanceId());
                this.orderCloseProducer.sendOrderCloseMsg(messageVo);
            });
        }
        return orderBo.getTradeNo();
    }

    @Override
    @ActionNode(entity=OrderEo.class, name="\u8ba2\u5355\u652f\u4ed8", results={@ActionResult(code="AUDIT", desc="\u5ba1\u6838\u8ba2\u5355"), @ActionResult(code="SUCCESS", desc="\u4e0d\u5ba1\u6838\u8ba2\u5355"), @ActionResult(code="succ", desc="\u6210\u529f")})
    @Transactional
    public OrderPayResult payOrder(OrderPayedEvent payedEvent) {
        String curActionNode = this.CLASS_FULL_NAME + "#payOrder";
        String orderNo = payedEvent.getOrderNo();
        OrderEo orderEo = this.orderDas.lockByOrderNo(orderNo);
        this.logger.info("\u8ba2\u5355\u53f7{},\u652f\u4ed8\u6210\u529f", (Object)payedEvent.getOrderNo());
        if (orderEo == null || orderEo.getAuditType().equals(0)) {
            this.logger.info("\u8ba2\u5355\u53f7{},\u8d70\u8f6c\u6362\u5668", (Object)payedEvent.getOrderNo());
            orderEo = TradeEngine.setFlowStatus(orderEo, "SUCCESS", curActionNode);
            TradeEngineUtil.setFlowCurrentActionResult("SUCCESS");
        } else {
            this.logger.info("\u8ba2\u5355\u53f7{},\u8d70\u5ba1\u6838\u8ba2\u5355", (Object)payedEvent.getOrderNo());
            orderEo = TradeEngine.setFlowStatus(orderEo, "AUDIT", curActionNode);
            TradeEngineUtil.setFlowCurrentActionResult("AUDIT");
        }
        TradeEngineUtil.setFlowDefId(orderEo.getFlowDefId());
        orderEo.setUpdateTime(new Date());
        orderEo.setPayTime(payedEvent.getFinishTime());
        this.orderDas.updateSelective((BaseEo)orderEo);
        OrderPayResult result = new OrderPayResult().setPayResult("SUCC").setOrderEo(orderEo);
        return result;
    }

    @Override
    @ActionNode(entity=OrderEo.class, name="\u6d3b\u52a8\u53c2\u4e0e\u6210\u529f", results={@ActionResult(code="default", desc="\u9ed8\u8ba4"), @ActionResult(code="group_activity", desc="\u62fc\u56e2\u6d3b\u52a8")})
    @Transactional
    public void joinActivityAction(OrderEo orderEo) {
        String curActionNode = this.CLASS_FULL_NAME + "#joinActivityAction";
        this.logger.info("\u8ba2\u5355\u53f7{}\u8fdb\u5165\u53c2\u4e0e\u6d3b\u52a8", (Object)orderEo.getOrderNo());
        if (orderEo == null) {
            throw new BizException("\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TradeEngine.validate((IFlowEntity)orderEo, curActionNode);
        OrderReqDto orderBo = this.orderActivityService.getActivityOrder(orderEo.getOrderNo());
        this.extlOrderActivityService.successJoinActivity(orderEo, orderBo);
        String bizResult = null;
        if (orderBo.getActivity() != null && CollectionUtils.isNotEmpty((Collection)orderBo.getActivity().getActivityList())) {
            for (OrderActivityInfoReqDto orderActivityInfoReqDto : orderBo.getActivity().getActivityList()) {
                ActivityTypeEnum activityTypeEnum = ActivityTypeEnum.getByValue(orderActivityInfoReqDto.getType());
                if (!ActivityTypeEnum.GROUP_ACTIVITY.equals((Object)activityTypeEnum)) continue;
                bizResult = "group_activity";
                break;
            }
        }
        if (bizResult == null) {
            bizResult = "default";
        }
        TradeEngine.setFlowStatus(orderEo, bizResult, curActionNode);
        this.orderDas.updateSelective((BaseEo)orderEo);
        this.logger.info("\u8ba2\u5355\u53f7{}\u8fdb\u5165\u6d3b\u52a8\u4fee\u6539\u540e\u7684\u72b6\u6001{}", (Object)orderEo.getOrderNo(), (Object)orderEo.getOrderTradeStatus());
    }

    @Override
    @ActionNode(entity=OrderEo.class, name="\u62fc\u56e2\u7ed3\u679c\u56de\u8c03\u5904\u7406", results={@ActionResult(code="CANCEL", desc="\u62fc\u56e2\u53d6\u6d88"), @ActionResult(code="SUCCESS", desc="\u62fc\u56e2\u6210\u529f")})
    @Transactional(rollbackFor={Exception.class})
    public ActivityNotifyResult groupActivityResultNotify(ActivityGroupOperateOrderMessageVo message) {
        String curActionNode = this.CLASS_FULL_NAME + "#groupActivityResultNotify";
        List<String> orderNos = message.getOrderNos();
        try {
            List<OrderEo> list = this.getOrderWithOrderNos(orderNos);
            list.forEach(order -> {
                this.logger.info("\u6d3b\u52a8\u786e\u8ba4\u53d1\u8d27\u8ba2\u5355\u53f7\uff1a{}", (Object)order.getOrderNo());
                if (order.getFlowDefId() != null) {
                    try {
                        TradeEngine.validate((IFlowEntity)order, curActionNode);
                        TradeEngineUtil.setFlowCurrentActionResult("SUCCESS");
                        order = TradeEngine.setFlowStatus(order, "SUCCESS", curActionNode);
                        this.orderDas.updateSelective((BaseEo)order);
                    }
                    catch (Exception e) {
                        this.logger.info("\u6d3b\u52a8\u8ba2\u5355\u53f7{}\u72b6\u6001\u4e0d\u5bf9\uff0c\u76f4\u63a5\u8fc7\u6ee4,\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{order.getOrderNo(), e.getMessage(), e});
                    }
                }
            });
            return new ActivityNotifyResult().setResult("SUCCESS").setOrderNos(orderNos);
        }
        catch (Exception e) {
            this.logger.error("\u8ba2\u5355\u64cd\u4f5c\u6267\u884c\u53d1\u751f\u9519\u8bef", (Throwable)e);
            throw e;
        }
    }

    private List<OrderEo> getOrderWithOrderNos(List<String> orderNos) {
        OrderEo selectParam = new OrderEo();
        selectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("order_no", orderNos).get());
        return this.orderDas.select((BaseEo)selectParam);
    }

    @Override
    @ActionNode(entity=OrderEo.class, name="\u8ba2\u5355\u53d1\u8d27")
    public DeliveryOrderRespDto deliverOrder(OrderDeliveryExtReqDto orderDeliveryReq) {
        String orderNo = orderDeliveryReq.getTradeNo();
        DeliveryOrderRespDto deliveryOrderRespDto = new DeliveryOrderRespDto();
        if (orderDeliveryReq.getParentCombineDelivery() == null) {
            this.logger.info("\u53d1\u8d27\u8ba2\u5355\u53f7{}", (Object)orderNo);
            OrderEo orderEo = this.orderDas.lockByOrderNo(orderNo);
            orderEo.setDeliveryTime(new Date());
            if (orderDeliveryReq.getOrderTradeStatus() == null) {
                orderEo.setOrderTradeStatus("DELIVERY");
            } else {
                orderEo.setOrderTradeStatus(orderDeliveryReq.getOrderTradeStatus());
            }
            orderEo.setDeliveryInfo(orderDeliveryReq.getDeliveryInfo());
            orderEo.setUpdateTime(null);
            this.orderDas.updateSelective((BaseEo)orderEo);
            deliveryOrderRespDto.setTradeNo(orderNo);
            return deliveryOrderRespDto;
        }
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301");
    }

    @Override
    @ActionNode(entity=OrderEo.class, name="\u8ba2\u5355\u7b7e\u6536")
    public String receiptOrder(OrderReceiptReq orderReceiptReq) {
        String curActionNode = this.CLASS_FULL_NAME + "#receiptOrder";
        String orderNo = orderReceiptReq.getOrderNo();
        OrderEo orderEo = this.orderDas.lockByOrderNo(orderNo);
        TradeEngine.validate((IFlowEntity)orderEo, curActionNode);
        orderEo = TradeEngine.setFlowStatus(orderEo, "succ", curActionNode);
        orderEo.setReceiveTime(new Date());
        this.orderDas.update((BaseEo)orderEo);
        return "SUCC";
    }

    public OrderAction setOrderService(IOrderService orderService) {
        this.orderService = orderService;
        return this;
    }

    public OrderAction setOrderDas(OrderDas orderDas) {
        this.orderDas = orderDas;
        return this;
    }

    @Override
    @ActionNode(entity=OrderEo.class, name="\u5b8c\u6210\u652f\u4ed8-\u4f20\u9012\u8ba2\u5355\u53f7\u4ece\u5e93\u67e5\u8ba2\u5355\u5355\u636e\u66f4\u65b0\u8ba2\u5355\u72b6\u6001")
    public void finishPay(PayNotifyResultOutput payNotifyResultOutput) {
        String curNodeCode = "com.dtyunxi.yundt.cube.center.trade.biz.flow.action.OrderAction#finishPay";
        OrderEo eo = this.orderDas.findByOrderNo(payNotifyResultOutput.getOrderNo());
        this.doFinishPay(curNodeCode, eo, payNotifyResultOutput.getBizResult());
    }

    @Override
    @ActionNode(entity=OrderEo.class, name="\u5b8c\u6210\u652f\u4ed8-\u76f4\u4f20\u8ba2\u5355\u5355\u636e\u5b9e\u4f53\u66f4\u65b0\u8ba2\u5355\u72b6\u6001")
    public void finishPay2(PayNotifyResultOutput2 payNotifyResultOutput) {
        String curNodeCode = "com.dtyunxi.yundt.cube.center.trade.biz.flow.action.OrderAction#finishPay2";
        OrderEo eo = payNotifyResultOutput.getOrderEo();
        this.doFinishPay(curNodeCode, eo, PayStatusEnum.SUCCESS.getCode().compareTo(payNotifyResultOutput.getPayStatusEnum().getCode()) == 0 ? "succ" : "fail");
    }

    private void doFinishPay(String curNodeCode, OrderEo eo, String bizResult) {
        TradeEngine.validate((IFlowEntity)eo, curNodeCode);
        eo = TradeEngine.setFlowStatus(eo, bizResult, curNodeCode);
        this.orderDas.update((BaseEo)eo);
        OrderEo finalEo = eo;
    }
}

