/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.cube.enhance.flow.ActionResult;
import com.dtyunxi.cube.enhance.flow.IFlowEntity;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.AuditRecordStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayResultEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundResultEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ReturnTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.SaleChannelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AfterSalesItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AuditRecordReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.RefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.flow.RefundNotifyDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.flow.DoReturnResultRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.flow.RefundNotifyRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.flow.ReturnActionDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.config.TradeFlowConfig;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.producer.MarketOrderTradeStatusProducer;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IAfterSalesService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.AuditRecordDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefTradeItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.RefundDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.ReturnItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.AuditRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.PayRecordEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefTradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.RefundEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.ReturnItemEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeItemEo;
import com.dtyunxi.yundt.cube.center.trade.engine.TradeEngine;
import com.dtyunxi.yundt.cube.center.trade.engine.TradeEngineUtil;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ActionNodeComponent
@RefreshScope
@Deprecated
public class ReturnRefundAction {
    private static Logger logger = LoggerFactory.getLogger(ReturnRefundAction.class);
    @Autowired
    IAfterSalesService afterSalesService;
    @Autowired
    ITradeItemService tradeItemService;
    @Autowired
    RefTradeItemDas refTradeItemDas;
    @Autowired
    IOrderService orderService;
    @Autowired
    ReturnItemDas returnItemDas;
    @Autowired
    AuditRecordDas auditRecordDas;
    @Autowired
    ReturnDas returnDas;
    @Autowired
    IPayService payService;
    @Autowired
    RefundDas refundDas;
    @Autowired
    private TradeFlowConfig tradeFlowConfig;
    @Autowired
    private MarketOrderTradeStatusProducer marketOrderTradeStatusProducer;
    private final String CLASS_FULL_NAME = "com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnRefundAction";

    private void copyRedundancyAttribute(ReturnEo returnEo, OrderEo orderEo) {
        returnEo.setOrderTradeNo(orderEo.getTradeNo());
        returnEo.setBizStatus(ReturnStatusEnum.INIT.getName());
        returnEo.setDeviceType(orderEo.getDeviceType());
        returnEo.setSellerSrc(orderEo.getSellerSrc());
        returnEo.setSellerId(orderEo.getSellerId());
        returnEo.setShopType(orderEo.getShopType());
        returnEo.setShopId(orderEo.getShopId());
        returnEo.setUserSrc(orderEo.getUserSrc());
        returnEo.setUserId(orderEo.getUserId());
        returnEo.setSaleChannel(orderEo.getSaleChannel());
        returnEo.setMktChannel(orderEo.getMktChannel());
    }

    @ActionNode(entity=ReturnEo.class, name="\u53d1\u8d77\u552e\u540e", results={@ActionResult(code="default", desc="\u9ed8\u8ba4")})
    @Transactional(rollbackFor={Exception.class})
    public DoReturnResultRespDto doReturnAction(ReturnReqDto returnReqDto) {
        if (returnReqDto.getReturnType().equals(RefundTypeEnum.RETURN_BASE.getName())) {
            TradeEngineUtil.setFlowDefId(1001L);
        } else {
            TradeEngineUtil.setFlowDefId(this.tradeFlowConfig.getReverseId());
        }
        returnReqDto.setTradeNo(TradeUtil.generateTradeNo(returnReqDto.getOrderTradeNo()));
        returnReqDto = this.afterSalesService.countReturn(returnReqDto);
        String curActionNode = "com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnRefundAction#doReturnAction";
        if (ReturnTypeEnum.getByName((String)returnReqDto.getReturnType()) == null) {
            throw new BizException(TradeExceptionCode.RETURN_TYPE_ERROR.getCode(), TradeExceptionCode.RETURN_TYPE_ERROR.getMsg());
        }
        List afterSalesItems = returnReqDto.getAfterSalesItems();
        OrderEo orderEo = this.orderService.getByOrderNo(returnReqDto.getOrderTradeNo());
        ReturnEo returnEo = new ReturnEo();
        CubeBeanUtils.copyProperties((Object)returnEo, (Object)returnReqDto, (String[])new String[0]);
        returnEo.setTradeNo(returnReqDto.getTradeNo());
        returnEo.setReturnNo(returnReqDto.getTradeNo());
        this.copyRedundancyAttribute(returnEo, orderEo);
        returnEo.setOrganizationId(orderEo.getOrganizationId());
        returnEo.setOrganizationName(orderEo.getOrganizationName());
        returnEo = this.afterSalesService.saveInitReturn4Flow(returnEo, curActionNode, "default");
        for (AfterSalesItemReqDto afterSalesItemReqDto : afterSalesItems) {
            TradeItemEo tradeItemEo = this.tradeItemService.queryByTradeNoAndTradeItemNo(returnReqDto.getOrderTradeNo(), afterSalesItemReqDto.getTradeItemNo());
            ReturnItemEo returnItemEo = new ReturnItemEo();
            BeanUtils.copyProperties((Object)tradeItemEo, (Object)returnItemEo);
            returnItemEo.setId(null);
            returnItemEo.setItemId(tradeItemEo.getItemSerial());
            returnItemEo.setBrandId(tradeItemEo.getBrandSerial());
            returnItemEo.setSkuSerial(tradeItemEo.getSkuSerial());
            returnItemEo.setReturnNo(returnEo.getReturnNo());
            returnItemEo.setRefundAmount(tradeItemEo.getItemPrice());
            this.returnItemDas.insert((BaseEo)returnItemEo);
        }
        AuditRecordEo auditRecordEo = new AuditRecordEo();
        CubeBeanUtils.copyProperties((Object)auditRecordEo, (Object)returnReqDto.getAuditRecordReqDto(), (String[])new String[0]);
        auditRecordEo.setInstanceId(returnEo.getInstanceId());
        auditRecordEo.setTenantId(returnEo.getTenantId());
        auditRecordEo.setAuditRecordNo(TradeUtil.generateTradeNo(returnReqDto.getOrderTradeNo()));
        auditRecordEo.setBizTradeNo(returnReqDto.getTradeNo());
        if (ReturnTypeEnum.REFUND_ONLY.getName().equals(returnReqDto.getReturnType())) {
            auditRecordEo.setReqType("REFUND");
        } else {
            auditRecordEo.setReqType("RETURN");
        }
        this.afterSalesService.saveInitAuditRecord(auditRecordEo);
        return DoReturnResultRespDto.init((String)"default", (String)returnReqDto.getOrderTradeNo(), (String)auditRecordEo.getAuditRecordNo());
    }

    @Transactional(rollbackFor={Exception.class})
    @ActionNode(entity=ReturnEo.class, name="\u7b49\u5f85\u5ba1\u6838\u7ed3\u679c", results={@ActionResult(code="pass", desc="\u5ba1\u6838\u901a\u8fc7"), @ActionResult(code="reject", desc="\u5ba1\u6838\u62d2\u7edd"), @ActionResult(code="replenish", desc="\u5f85\u8865\u5145\u8d44\u6599"), @ActionResult(code="cancel", desc="\u53d6\u6d88"), @ActionResult(code="default", desc="\u9ed8\u8ba4")})
    public ReturnActionDto returnAuditResultAction(AuditRecordReqDto auditResult) {
        ReturnEo returnEo = this.returnDas.selectByTradeNo(auditResult.getBizTradeNo());
        TradeEngineUtil.setFlowDefId(returnEo.getFlowDefId());
        String curActionNode = "com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnRefundAction#returnAuditResultAction";
        AuditRecordEo selectAuditRecordEo = new AuditRecordEo();
        selectAuditRecordEo.setBizTradeNo(auditResult.getBizTradeNo());
        selectAuditRecordEo.setAuditStatus(AuditRecordStatusEnum.AUDITING.getName());
        List auditRecordEoList = this.auditRecordDas.select((BaseEo)selectAuditRecordEo);
        String auditRecordNo = Optional.ofNullable(auditRecordEoList).map(list -> ((AuditRecordEo)list.stream().findFirst().get()).getAuditRecordNo()).orElseThrow(() -> new BizException(TradeExceptionCode.AUDIT_RECORD_NOT_EXIST.getCode(), TradeExceptionCode.AUDIT_RECORD_NOT_EXIST.getMsg()));
        TradeEngine.validate((IFlowEntity)returnEo, curActionNode);
        TradeEngine.setFlowStatus(returnEo, auditResult.getAuditStatus().toLowerCase(), curActionNode);
        if (auditResult.getSellerRefundAmount() != null) {
            returnEo.setRefundAmount(auditResult.getSellerRefundAmount());
            returnEo.setRefundAmount(auditResult.getSellerRefundAmount());
        }
        this.afterSalesService.modifyReturn(auditResult.getBizTradeNo(), returnEo);
        AuditRecordEo auditRecordEo = new AuditRecordEo();
        auditRecordEo.setHandleType(auditResult.getHandleType());
        auditRecordEo.setHandleDesc(auditResult.getHandleDesc());
        auditRecordEo.setSellerRemark(auditResult.getSellerRemark());
        AuditRecordStatusEnum auditRecordStatusEnum = AuditRecordStatusEnum.getByName((String)auditResult.getAuditStatus());
        String bizResult = "default";
        if (auditRecordStatusEnum != null) {
            auditRecordEo.setAuditStatus(auditRecordStatusEnum.getName());
            bizResult = auditRecordStatusEnum.getName().toLowerCase();
        }
        this.afterSalesService.modifyAuditRecord(auditRecordNo, auditRecordEo);
        if (auditResult.getHandleType() == null || "0".equals(auditResult.getHandleType())) {
            return ReturnActionDto.init((String)bizResult, (String)returnEo.getReturnNo(), (String)returnEo.getOrderTradeNo(), (String)auditResult.getHandleType(), (String)auditResult.getHandleDesc());
        }
        return ReturnActionDto.init((String)"cancel", (String)returnEo.getReturnNo(), (String)returnEo.getOrderTradeNo(), (String)auditResult.getHandleType(), (String)auditResult.getHandleDesc());
    }

    @ActionNode(entity=ReturnEo.class, name="\u8865\u5145\u8d44\u6599", results={@ActionResult(code="default", desc="\u9ed8\u8ba4")})
    @Transactional(rollbackFor={Exception.class})
    public String replenish(AuditRecordReqDto auditRecordReqDto) {
        String curActionNode = "com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnRefundAction#replenish";
        AuditRecordEo auditRecordEo = new AuditRecordEo();
        this.auditRecordDas.selectByTradeNo(auditRecordReqDto.getBizTradeNo());
        CubeBeanUtils.copyProperties((Object)auditRecordEo, (Object)auditRecordReqDto, (String[])new String[0]);
        auditRecordEo.setAuditRecordNo(TradeUtil.generateTradeNo(auditRecordReqDto.getBizTradeNo()));
        this.afterSalesService.saveInitAuditRecord(auditRecordEo);
        auditRecordReqDto.setAuditRecordNo(auditRecordEo.getAuditRecordNo());
        this.afterSalesService.modifyReturnStatus4Flow(auditRecordReqDto.getBizTradeNo(), curActionNode, "default");
        return "default";
    }

    @Transactional(rollbackFor={Exception.class})
    @ActionNode(entity=ReturnEo.class, name="\u7528\u6237\u786e\u8ba4\u9000\u8d27", results={@ActionResult(code="receive", desc="\u5df2\u63a5\u6536"), @ActionResult(code="cancel", desc="\u53d6\u6d88")})
    public ReturnActionDto userConfirmReturnAction(ReturnReqDto returnReqDto) {
        if (ReturnTypeEnum.RETURN_BASE.getName().equals(returnReqDto.getReturnType())) {
            throw new BizException("\u552e\u540e\u5355\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        if (returnReqDto.getTradeNo() == null) {
            returnReqDto.setTradeNo(returnReqDto.getOrderTradeNo());
        }
        String curActionNode = "com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnRefundAction#userConfirmReturnAction";
        if (StringUtils.isNotBlank((CharSequence)returnReqDto.getReturnExpressCompany()) || StringUtils.isNotBlank((CharSequence)returnReqDto.getReturnExpressSerial())) {
            ReturnEo eo = new ReturnEo();
            eo.setReturnExpressCompany(returnReqDto.getReturnExpressCompany());
            eo.setReturnExpressSerial(returnReqDto.getReturnExpressSerial());
            this.afterSalesService.modifyReturn(returnReqDto.getOrderTradeNo(), eo);
        }
        if (returnReqDto.getCancelType() == null || "0".equals(returnReqDto.getCancelType())) {
            this.afterSalesService.modifyReturnStatus4Flow(returnReqDto.getTradeNo(), curActionNode, "receive");
            return ReturnActionDto.init((String)"receive", (String)returnReqDto.getTradeNo(), (String)returnReqDto.getOrderTradeNo(), (String)returnReqDto.getCancelType(), (String)returnReqDto.getCancelDesc());
        }
        this.afterSalesService.modifyReturnStatus4Flow(returnReqDto.getTradeNo(), curActionNode, "cancel");
        return ReturnActionDto.init((String)"cancel", (String)returnReqDto.getTradeNo(), (String)returnReqDto.getOrderTradeNo(), (String)returnReqDto.getCancelType(), (String)returnReqDto.getCancelDesc());
    }

    @Transactional(rollbackFor={Exception.class})
    @ActionNode(entity=ReturnEo.class, name="\u5df2\u63a5\u6536\u9000\u56de\u7269\u54c1", results={@ActionResult(code="default", desc="\u9ed8\u8ba4"), @ActionResult(code="cancel", desc="\u53d6\u6d88")})
    public ReturnActionDto confirmReturnDeliveryAction(ReturnReqDto returnReqDto) {
        String curActionNode = "com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnRefundAction#confirmReturnDeliveryAction";
        if (returnReqDto.getSellerRefundAmount() != null) {
            ReturnEo eo = new ReturnEo();
            eo.setRefundAmount(returnReqDto.getSellerRefundAmount());
            eo.setCancelDesc(returnReqDto.getCancelDesc());
            eo.setCancelTime(returnReqDto.getCancelTime());
            eo.setCancelType(returnReqDto.getCancelType());
            this.afterSalesService.modifyReturn(returnReqDto.getOrderTradeNo(), eo);
        }
        if (returnReqDto.getCancelType() == null || "0".equals(returnReqDto.getCancelType())) {
            this.afterSalesService.modifyReturnStatus4Flow(returnReqDto.getTradeNo(), curActionNode, "default");
            return ReturnActionDto.init((String)"default", (String)returnReqDto.getTradeNo(), (String)returnReqDto.getOrderTradeNo(), (String)returnReqDto.getCancelType(), (String)returnReqDto.getCancelDesc());
        }
        this.afterSalesService.modifyReturnStatus4Flow(returnReqDto.getTradeNo(), curActionNode, "cancel");
        return ReturnActionDto.init((String)"cancel", (String)returnReqDto.getOrderTradeNo(), (String)returnReqDto.getOrderTradeNo(), (String)returnReqDto.getCancelType(), (String)returnReqDto.getCancelDesc());
    }

    @Transactional(rollbackFor={Exception.class})
    @ActionNode(entity=ReturnEo.class, name="\u786e\u8ba4\u9000\u6b3e", results={@ActionResult(code="default", desc="\u9ed8\u8ba4"), @ActionResult(code="cancel", desc="\u53d6\u6d88")})
    public ReturnActionDto confirmRefundAction(ReturnReqDto returnReqDto) {
        String curActionNode = "com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnRefundAction#confirmRefundAction";
        if (returnReqDto.getSellerRefundAmount() != null) {
            ReturnEo eo = ReturnEo.newInstance();
            eo.setRefundAmount(returnReqDto.getSellerRefundAmount());
            HashMap map = Maps.newHashMap();
            map.put("refundAmountDetail", returnReqDto.getSellerRefundAmount());
            if (null != returnReqDto.getReturnFreightAmount()) {
                map.put("returnFreightAmount", returnReqDto.getReturnFreightAmount().setScale(2));
            }
            eo.setRefundAmountDetail(JSON.toJSONString((Object)map));
            this.afterSalesService.modifyReturn(returnReqDto.getTradeNo(), eo);
        }
        if (returnReqDto.getCancelType() == null || "0".equals(returnReqDto.getCancelType())) {
            this.afterSalesService.modifyReturnStatus4Flow(returnReqDto.getTradeNo(), curActionNode, "default");
            RefundReqDto refundReqDto = new RefundReqDto();
            refundReqDto.setReturnNo(returnReqDto.getTradeNo());
            refundReqDto.setRefundTotalAmount(returnReqDto.getSellerRefundAmount());
            this.doRefundAction(refundReqDto);
            return ReturnActionDto.init((String)"default", (String)returnReqDto.getTradeNo(), (String)returnReqDto.getOrderTradeNo(), (String)returnReqDto.getCancelType(), (String)returnReqDto.getCancelDesc());
        }
        this.afterSalesService.modifyReturnStatus4Flow(returnReqDto.getTradeNo(), curActionNode, "cancel");
        return ReturnActionDto.init((String)"cancel", (String)returnReqDto.getTradeNo(), (String)returnReqDto.getOrderTradeNo(), (String)returnReqDto.getCancelType(), (String)returnReqDto.getCancelDesc());
    }

    @ActionNode(entity=RefundEo.class, name="\u53d1\u8d77\u9000\u6b3e", results={@ActionResult(code="success", desc="\u6210\u529f"), @ActionResult(code="fail", desc="\u5931\u8d25")})
    @Transactional(rollbackFor={Exception.class})
    public RefundNotifyRespDto doRefundAction(RefundReqDto refundReqDto) {
        ReturnEo returnEo = this.returnDas.selectByTradeNo(refundReqDto.getReturnNo());
        Long flowDefId = null;
        flowDefId = returnEo != null ? returnEo.getFlowDefId() : this.tradeFlowConfig.getReverseId();
        TradeEngineUtil.setFlowDefId(flowDefId);
        String curActionNode = "com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnRefundAction#doRefundAction";
        RefundEo refundEo = new RefundEo();
        CubeBeanUtils.copyProperties((Object)refundEo, (Object)refundReqDto, (String[])new String[0]);
        if (SaleChannelEnum.SALECHANNEL_ZYSC.getCode().equals(returnEo.getSaleChannel())) {
            List<PayRecordEo> payRecordEos = this.payService.getPayRecordSuccessByOrderNo(returnEo.getOrderTradeNo());
            if (CollectionUtils.isEmpty(payRecordEos)) {
                throw new BizException("\u627e\u4e0d\u5230\u6210\u529f\u652f\u4ed8\u8bb0\u5f55");
            }
            PayRecordEo payRecordEo = payRecordEos.get(0);
            if (StringUtils.isNotEmpty((CharSequence)payRecordEo.getParentPayNo()) && !payRecordEo.getParentPayNo().equals("0")) {
                payRecordEo = this.payService.getPayRecordByTradeNo(payRecordEo.getParentPayNo());
            }
            refundEo.setPayMethod(payRecordEo.getPayMethod());
            Optional.ofNullable(payRecordEo).map(p -> {
                if (!(p.getPayStatus().equals(PayStatusEnum.SUCCESS.getName()) || p.getPayStatus().equals(PayStatusEnum.SUCCESS.getMsg()) || p.getPayStatus().equals(PayStatusEnum.SUCCESS.getCode()))) {
                    throw new BizException(TradeExceptionCode.PAY_RECORD_STATUS_ERROR.getCode(), TradeExceptionCode.PAY_RECORD_STATUS_ERROR.getMsg());
                }
                return p;
            }).orElseThrow(() -> new BizException(TradeExceptionCode.PAY_RECORD_NOT_EXIST.getCode(), TradeExceptionCode.PAY_RECORD_NOT_EXIST.getMsg()));
            refundEo.setRefundTime(new Date());
            refundEo.setReturnNo(returnEo.getReturnNo());
            refundEo.setRefundNo(TradeUtil.generateTradeNo(refundReqDto.getReturnNo()));
            refundEo.setTradeNo(refundEo.getRefundNo());
            refundEo.setPayNo(payRecordEo.getPayNo());
            refundEo.setRefundItemAmount(refundReqDto.getRefundTotalAmount());
            refundEo.setInstanceId(payRecordEo.getInstanceId());
            refundEo.setTenantId(payRecordEo.getTenantId());
            refundEo.setCreateTime(new Date());
            refundEo.setRefundPaymentType("1");
            refundEo.setRefundTotalAmount(refundReqDto.getRefundTotalAmount());
            refundEo.setRefundFreightAmount(BigDecimal.ZERO);
            refundEo.setDiscountRefundAmount(BigDecimal.ZERO);
            refundEo = this.payService.saveInitRefund4Flow(refundEo, curActionNode, "success", flowDefId);
            PayRefundReqDto payRefundReqDto = new PayRefundReqDto();
            payRefundReqDto.setTradeNo(refundEo.getTradeNo());
            payRefundReqDto.setPayNo(refundEo.getPayNo());
            payRefundReqDto.setInstanceId(payRecordEo.getInstanceId());
            payRefundReqDto.setTenantId(payRecordEo.getTenantId());
            payRefundReqDto.setExtlPaySerial(payRecordEo.getExtlPaySerial());
            payRefundReqDto.setAmount(refundEo.getRefundTotalAmount());
            payRefundReqDto.setUserId(payRecordEo.getUserId());
            String extension = payRecordEo.getExtension();
            if (StringUtils.isNotEmpty((CharSequence)extension)) {
                JSONObject json = JSON.parseObject((String)extension);
                payRefundReqDto.setStoreId(json.getString("storeId"));
                payRefundReqDto.setAppId(json.getString("appId"));
                payRefundReqDto.setAppName(json.getString("appName"));
            }
            RefundResponse refundResponse = this.payService.doRefund4Flow(payRefundReqDto, curActionNode);
            if (RefundStatusEnum.FAIL.getName().equals(refundResponse.getResult()) || PayResultEnum.ERROR.getName().equals(refundResponse.getResult())) {
                TradeEngine.setFlowStatus(refundEo, refundResponse.getResult().toLowerCase(), curActionNode);
                this.refundDas.updateSelective((BaseEo)refundEo);
                return RefundNotifyRespDto.init((String)"fail", (String)refundReqDto.getTradeNo(), (String)refundReqDto.getExtlRefundSerail());
            }
            return RefundNotifyRespDto.init((String)"success", (String)refundReqDto.getTradeNo(), (String)refundReqDto.getExtlRefundSerail());
        }
        return null;
    }

    @ActionNode(entity=RefundEo.class, name="\u7b49\u5f85\u9000\u6b3e\u7ed3\u679c", results={@ActionResult(code="success", desc="\u9000\u6b3e\u6210\u529f"), @ActionResult(code="fail", desc="\u9000\u6b3e\u5931\u8d25")})
    @Transactional(rollbackFor={Exception.class})
    public RefundNotifyRespDto handleRefundNotifyAction(RefundNotifyDto refundNotifyDto) {
        RefundEo refundEo = this.refundDas.selectByTradeNo(refundNotifyDto.getTradeNo());
        TradeEngineUtil.setFlowDefId(refundEo.getFlowDefId());
        String curActionNode = "com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnRefundAction#handleRefundNotifyAction";
        switch (RefundResultEnum.getByName((String)refundNotifyDto.getRefundStatus())) {
            case S: {
                RefundNotifyRespDto refundNotifyRespDto = RefundNotifyRespDto.init((String)refundNotifyDto.getTradeNo(), (String)RefundStatusEnum.SUCCESS.getName().toLowerCase(), (String)refundNotifyDto.getExtlRefundId());
                refundEo.setExtlRefundSerail(refundNotifyRespDto.getExtlRefundId());
                TradeEngine.validate((IFlowEntity)refundEo, curActionNode);
                TradeEngine.setFlowStatus(refundEo, "success", curActionNode);
                this.refundDas.updateSelective((BaseEo)refundEo);
                this.marketOrderTradeStatusProducer.sendOrderReturnSuccessMessageToMarket(refundEo.getReturnNo());
                return RefundNotifyRespDto.init((String)refundNotifyDto.getTradeNo(), (String)refundEo.getReturnNo(), (String)refundNotifyDto.getExtlRefundId(), (String)RefundStatusEnum.SUCCESS.getName().toLowerCase());
            }
        }
        TradeEngine.validate((IFlowEntity)refundEo, curActionNode);
        TradeEngine.setFlowStatus(refundEo, "fail", curActionNode);
        this.refundDas.updateSelective((BaseEo)refundEo);
        return RefundNotifyRespDto.init((String)refundNotifyDto.getTradeNo(), (String)refundEo.getReturnNo(), (String)refundNotifyDto.getExtlRefundId(), (String)RefundStatusEnum.FAIL.getName().toLowerCase());
    }

    @ActionNode(entity=ReturnEo.class, name="\u5df2\u9000\u8d27\u9000\u6b3e", results={@ActionResult(code="default", desc="\u9ed8\u8ba4")})
    @Transactional(rollbackFor={Exception.class})
    public String returnRefundedFinishAction(String orderNo) {
        String curActionNode = "com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnRefundAction#returnRefundedFinishAction";
        this.afterSalesService.modifyReturnStatus4Flow(orderNo, curActionNode, "default");
        ReturnDetailRespDto returnDetailRespDto = this.afterSalesService.queryReturnDetail(orderNo, "{}");
        List<TradeItemEo> tradeItemEoList = this.tradeItemService.queryByTradeNo(returnDetailRespDto.getOrderTradeNo());
        if (CollectionUtils.isEmpty(tradeItemEoList)) {
            logger.error("ReturnRefundedFinishAction.tradeItemEoList is null...rootTrade={}", (Object)orderNo);
            return "default";
        }
        ReturnEo returnEo = ReturnEo.newInstance();
        returnEo.setOrderTradeNo(returnDetailRespDto.getOrderTradeNo());
        returnEo.setReturnStatus(ReturnStatusEnum.FINISH.getName());
        List returnEoList = this.returnDas.select((BaseEo)returnEo);
        if (CollectionUtils.isNotEmpty((Collection)returnEoList)) {
            ArrayList tradeNoList = new ArrayList(returnEoList.size());
            returnEoList.forEach(e -> tradeNoList.add(e.getTradeNo()));
            RefTradeItemEo refTradeItemEo = new RefTradeItemEo();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"trade_no", tradeNoList));
            refTradeItemEo.setSqlFilters(sqlFilterList);
            List refTradeItemEoList = this.refTradeItemDas.select((BaseEo)refTradeItemEo);
            if (CollectionUtils.isNotEmpty((Collection)refTradeItemEoList)) {
                HashMap refTradeItemEoMap = Maps.newHashMap();
                for (RefTradeItemEo refTradeItem : refTradeItemEoList) {
                    refTradeItemEoMap.merge(refTradeItem.getSkuSerial(), refTradeItem.getItemNum(), (oldVal, newVal) -> oldVal + newVal);
                }
                for (TradeItemEo tradeItemEo : tradeItemEoList) {
                    if (null != refTradeItemEoMap.get(tradeItemEo.getSkuSerial()) && ((Integer)refTradeItemEoMap.get(tradeItemEo.getSkuSerial())).equals(tradeItemEo.getItemNum())) continue;
                    logger.error("ReturnRefundedFinishAction.refTradeItemEoList.compare...refTradeItemEoList={}, tradeItemEoList={}", (Object)JSON.toJSONString((Object)refTradeItemEoList), (Object)JSON.toJSONString(tradeItemEoList));
                    return "default";
                }
                this.orderService.modifyOrderTradeStatus(returnDetailRespDto.getOrderTradeNo(), null, "COMPLETE");
            }
        }
        return "default";
    }

    @ActionNode(entity=ReturnEo.class, name="\u53d6\u6d88\u9000\u8d27\u5b8c\u6210", results={@ActionResult(code="default", desc="\u9ed8\u8ba4")})
    @Transactional(rollbackFor={Exception.class})
    public String cancelReturnFinishAction(CancelReqDto cancelReqDto) {
        String curActionNode = "com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnRefundAction#cancelReturnFinishAction";
        ReturnEo returnEo = this.returnDas.selectByTradeNo(cancelReqDto.getTradeNo());
        TradeEngineUtil.setFlowDefId(returnEo.getFlowDefId());
        returnEo.setCancelType(cancelReqDto.getCancelType());
        returnEo.setCancelDesc(cancelReqDto.getCancelDesc());
        returnEo.setCancelTime(new Date());
        TradeEngine.validate((IFlowEntity)returnEo, curActionNode);
        TradeEngine.setFlowStatus(returnEo, "default", curActionNode);
        this.returnDas.updateSelective((BaseEo)returnEo);
        return "default";
    }

    @ActionNode(entity=ReturnEo.class, name="\u62d2\u7edd\u9000\u8d27\u9000\u6b3e", results={@ActionResult(code="default", desc="\u9ed8\u8ba4")})
    @Transactional(rollbackFor={Exception.class})
    public String returnFinishAction(String orderNo) {
        String curActionNode = "com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnRefundAction#returnFinishAction";
        this.afterSalesService.modifyReturnStatus4Flow(orderNo, curActionNode, "default");
        return "default";
    }
}

