/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image;

import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.ext.FlowSchemeData;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.SingleFlowImage;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.Edge;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.ImageFlow;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.ImageNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupFlowImage {
    protected static Logger logger = LoggerFactory.getLogger(GroupFlowImage.class);
    private static String tempPath = System.getProperty("java.io.tmpdir") + File.separator;
    private Map<String, ImageFlow> imageFlowMap = new HashMap<String, ImageFlow>();
    FlowSchemeData flowSchemeData;

    public FlowSchemeData getFlowSchemeData() {
        return this.flowSchemeData;
    }

    public GroupFlowImage(FlowSchemeData flowSchemeData) {
        this.flowSchemeData = flowSchemeData;
    }

    public void addImageFlow(ImageFlow imageFlow) {
        this.imageFlowMap.put(imageFlow.fetchFlowCode(), imageFlow);
    }

    public Document createXml() {
        ArrayList<SingleFlowImage> singleFlowImages = new ArrayList<SingleFlowImage>();
        for (ImageFlow imageFlow : this.imageFlowMap.values()) {
            SingleFlowImage singleFlowImage = new SingleFlowImage(this.flowSchemeData);
            for (ImageNode imageNode : imageFlow.getNodes()) {
                singleFlowImage.addNode(imageNode);
            }
            for (Edge edge : imageFlow.getEdges()) {
                singleFlowImage.addEdge(edge);
            }
            singleFlowImage.setFlowStatusAdapter(imageFlow.getFlowStatusAdapter());
            singleFlowImage.setFlowName(imageFlow.getFlowName());
            singleFlowImage.setStartNode(imageFlow.fetchStartLinkNode());
            singleFlowImages.add(singleFlowImage);
        }
        try {
            Document document = DocumentHelper.createDocument();
            Element file = document.addElement("file");
            Element flows = file.addElement("flows");
            flows.addAttribute("flowId", this.flowSchemeData.getFlowSchemeId().toString());
            for (SingleFlowImage singleFlowImage : singleFlowImages) {
                singleFlowImage.parseFlowElement(flows);
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            try {
                File f = new File(this.flowSchemeData.getFlowSchemeId().toString() + ".xml");
                XMLWriter write = new XMLWriter((OutputStream)new FileOutputStream(f), format);
                write.write(document);
                write.flush();
                write.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            logger.info("\u8f6c\u6362\u7684xml\u4e3a={}", (Object)document.asXML());
            return document;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u751f\u6210book1.xml\u5931\u8d25");
            return null;
        }
    }
}

