/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.ext.FlowSchemeData;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.Edge;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.EdgesOutLine;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.ImageNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleFlowImage {
    protected static Logger logger = LoggerFactory.getLogger(SingleFlowImage.class);
    private String flowName;
    private String flowStatusAdapter;
    private List<ImageNode> actionNodeList = new ArrayList<ImageNode>();
    private List<ImageNode> statusNodeList = new ArrayList<ImageNode>();
    private Map<String, ImageNode> idMap = new HashMap<String, ImageNode>();
    private Map<String, ImageNode> actionNodeMap = new HashMap<String, ImageNode>();
    private Map<String, ImageNode> statusNodeMap = new HashMap<String, ImageNode>();
    private Map<String, ImageNode> subFlowNodeMap = new HashMap<String, ImageNode>();
    private List<Edge> edgeList = new ArrayList<Edge>();
    private ImageNode startNode;
    private FlowSchemeData flowSchemeData;

    public SingleFlowImage(FlowSchemeData flowSchemeData) {
        this.flowSchemeData = flowSchemeData;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public String getFlowStatusAdapter() {
        return this.flowStatusAdapter;
    }

    public void setFlowStatusAdapter(String flowStatusAdapter) {
        this.flowStatusAdapter = flowStatusAdapter;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public List<ImageNode> getActionNodeList() {
        return this.actionNodeList;
    }

    public List<ImageNode> getStatusNodeList() {
        return this.statusNodeList;
    }

    public void addNode(ImageNode imageNode) {
        if (imageNode.getType().equals("task-node")) {
            this.actionNodeList.add(imageNode);
            this.actionNodeMap.put(imageNode.getLabel(), imageNode);
        }
        if (imageNode.getType().equals("ellipse-node")) {
            this.statusNodeList.add(imageNode);
            this.statusNodeMap.put(imageNode.getLabel(), imageNode);
        }
        this.idMap.put(imageNode.getId(), imageNode);
    }

    public void addEdge(Edge edge) {
        this.edgeList.add(edge);
    }

    public List<EdgesOutLine> getEdgeOutList(String id) {
        List edges = this.edgeList.stream().filter(edge -> edge.getSource().contains(id)).collect(Collectors.toList());
        return edges.stream().map(edge -> {
            EdgesOutLine edgesOutLine = new EdgesOutLine();
            ImageNode imageNode = this.idMap.get(edge.getTarget());
            edgesOutLine.setLabel(edge.getLabel());
            edgesOutLine.setCode(edge.getCode());
            edgesOutLine.setNoteName(imageNode.getLabel());
            return edgesOutLine;
        }).collect(Collectors.toList());
    }

    public void setStartNode(ImageNode imageNode) {
        this.startNode = imageNode;
    }

    public ImageNode getStartNode() {
        return this.startNode;
    }

    public void preHandle() {
        for (ImageNode imageNode : this.actionNodeList) {
            if (!imageNode.isSubFlowNode().booleanValue()) continue;
            this.subFlowNodeMap.put(imageNode.getLabel(), imageNode);
        }
    }

    public Element parseFlowElement(Element flowsElement) {
        this.preHandle();
        try {
            Element next;
            List<EdgesOutLine> edgeOutList;
            Element flowElement = flowsElement.addElement("flow");
            flowElement.addAttribute("name", this.flowName);
            if (this.startNode == null) {
                throw new BizException("\u5f00\u59cb\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            flowElement.addAttribute("start", this.startNode.getLabel());
            flowElement.addAttribute("flowStatusAdapter", this.flowStatusAdapter);
            for (ImageNode statusNode : this.statusNodeList) {
                Element status = flowElement.addElement("status");
                status.addAttribute("name", statusNode.getLabel());
                status.addAttribute("bizStatus", statusNode.parseToBizStatus());
                edgeOutList = this.getEdgeOutList(statusNode.getId());
                for (EdgesOutLine edgesOL : edgeOutList) {
                    next = status.addElement("next");
                    next.addAttribute("action", edgesOL.getNoteName());
                }
            }
            for (ImageNode imageNode : this.actionNodeList) {
                if (imageNode.isSubFlowNode().booleanValue()) continue;
                Element action = flowElement.addElement("action");
                action.addAttribute("name", imageNode.getLabel());
                action.addAttribute("beanMethod", imageNode.getCode());
                edgeOutList = this.getEdgeOutList(imageNode.getId());
                for (EdgesOutLine edgesOL : edgeOutList) {
                    if (edgesOL.getLabel().contains("=")) {
                        String[] split = edgesOL.getLabel().split("=");
                        action.addAttribute("nextForProperty", split[0]);
                    }
                    if (this.actionNodeMap.get(edgesOL.getNoteName()) != null) {
                        ImageNode subFlowNode = this.subFlowNodeMap.get(edgesOL.getNoteName());
                        if (subFlowNode == null) {
                            Element next2 = action.addElement("next");
                            next2.addAttribute("action", edgesOL.getNoteName());
                            next2.addAttribute("for", edgesOL.getCode());
                        } else {
                            String[] subFlowList = subFlowNode.getCode().split("_");
                            String[] entityNameList = subFlowNode.getLabel().split(":");
                            Element next3 = action.addElement("next");
                            next3.addAttribute("for", edgesOL.getCode());
                            next3.addAttribute("flowName", this.flowSchemeData.getByEntityName(entityNameList[0]).getFlowName());
                            next3.addAttribute("flowAction", entityNameList[1]);
                            if (subFlowList.length >= 3 && StringUtils.isNotEmpty((CharSequence)subFlowList[1])) {
                                next3.addAttribute("flowNoField", subFlowList[1]);
                            }
                        }
                    }
                    if (this.statusNodeMap.get(edgesOL.getNoteName()) == null) continue;
                    next = action.addElement("to_status");
                    next.addAttribute("status", edgesOL.getNoteName());
                    next.addAttribute("for", edgesOL.getCode());
                }
            }
            return flowElement;
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790{}\u6d41\u7a0b\u51fa\u932f", (Object)this.flowName);
            throw e;
        }
    }
}

