/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.FlowStatusAdapter;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlow;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowEngine;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.exception.FlowException;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.layout.MyLayoutParse;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.parse.CreateImageFlowForMpc;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.Edge;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.EdgesOutLine;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.EndPoint;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.ImageFlow;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.ImageNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.MargeImageFlow;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.StartPoint;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.StatusTypeList;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.ActionNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowActionNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.ForActionNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.StatusNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.ToStatusNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleFlowImageParse {
    private Long flowId;
    private String flowName;
    private ImageFlow imageFlow;
    private IFlow flow;
    private IFlowEngine flowEngine;
    private Logger logger = LoggerFactory.getLogger(CreateImageFlowForMpc.class);

    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public SingleFlowImageParse(IFlow flow, Long flowId, String flowName, IFlowEngine flowEngine) {
        this.flowId = flowId;
        this.flowName = flowName;
        this.flow = flow;
        this.flowEngine = flowEngine;
    }

    public Long getFlowId() {
        return this.flowId;
    }

    public ImageFlow getImageFlow() {
        return this.imageFlow;
    }

    public IFlow getFlow() {
        return this.flow;
    }

    private void parseFlow(MargeImageFlow margeImageFlow, IFlow flow, Map<String, StartPoint> pointMap) {
        ImageFlow imageFlow = margeImageFlow.getByName(flow.getFlowName());
        FlowNode flowNode = flow.getFlowNode();
        ActionNode startActionNote = flowNode.getStartActionNote();
        ActionNode startNode = new ActionNode();
        startNode.setName("\u5f00\u59cb");
        ImageNode start = this.createTaskNode(flow, pointMap, startNode, true, imageFlow.getActionColor());
        imageFlow.getNodes().add(start);
        ImageNode startTaskNode = null;
        try {
            startTaskNode = this.createTaskNode(flow, pointMap, startActionNote, false, imageFlow.getActionColor());
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efa\u8282\u70b9\u5931\u8d25", (Throwable)e);
            throw e;
        }
        Edge edge = this.createEdge(start, startTaskNode, "start", null);
        imageFlow.getEdges().add(edge);
        imageFlow.getNodes().add(startTaskNode);
        this.parseNextAction(pointMap, startTaskNode, startActionNote, margeImageFlow, flow);
    }

    public void parseNoPoint() {
        MargeImageFlow margeImageFlow = new MargeImageFlow();
        this.parseFlow(margeImageFlow, this.flow, null);
        this.imageFlow = margeImageFlow.margeImageFlow();
    }

    public void parsePoint() {
        this.parseNoPoint();
        MargeImageFlow margeImageFlow = new MargeImageFlow();
        Map<String, StartPoint> pointMap = MyLayoutParse.getPointMap(this.imageFlow);
        this.parseFlow(margeImageFlow, this.flow, pointMap);
        this.imageFlow = margeImageFlow.margeImageFlow();
        this.imageFlow.setFlowId(this.flowId);
        this.imageFlow.setFlowName(this.flowName);
    }

    public void parseNextAction(Map<String, StartPoint> pointMap, ImageNode beforeNode, ActionNode beforeActionNote, MargeImageFlow margeImageFlow, IFlow flow) {
        block20: {
            Edge edge;
            block19: {
                if (beforeActionNote instanceof FlowActionNode) {
                    return;
                }
                if (beforeActionNote == null) {
                    throw new BizException("\u524d\u7f6e\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (beforeActionNote.getName() == null) {
                    throw new BizException("\u524d\u7f6e\u8282\u70b9\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
                }
                this.logger.info("\u6d41\u7a0b{}\uff0c\u89e3\u6790\u8282\u70b9{}", (Object)flow.getFlowName(), (Object)beforeActionNote.getName());
                if (!(beforeActionNote instanceof StatusNode)) break block19;
                StatusNode statusNode = (StatusNode)beforeActionNote;
                if (!CollectionUtils.isNotEmpty(statusNode.getForActionNoteList())) break block20;
                int i = 0;
                for (ActionNode actionNode : beforeActionNote.getNextActionNoteList()) {
                    ImageFlow imageFlow = margeImageFlow.getByName(flow.getFlowName());
                    ImageNode imageNode = null;
                    imageNode = pointMap != null ? imageFlow.queryByName(actionNode.getName()) : imageFlow.queryByName(flow.getFlowName() + "#" + actionNode.getName());
                    ActionNode nextActionNote = actionNode;
                    if (imageNode == null) {
                        imageNode = this.createTaskNode(flow, pointMap, nextActionNote, false, imageFlow.getActionColor());
                        imageFlow.getNodes().add(imageNode);
                        this.parseNextAction(pointMap, imageNode, nextActionNote, margeImageFlow, flow);
                    }
                    Edge edge2 = this.createEdge(beforeNode, imageNode, null, null);
                    imageFlow.getEdges().add(edge2);
                    ++i;
                }
                break block20;
            }
            if (flow.getFlowStatusAdapter() != null && CollectionUtils.isNotEmpty(beforeActionNote.getNextStatusList())) {
                for (ToStatusNode toStatusNode : beforeActionNote.getNextStatusList()) {
                    ImageFlow imageFlow = margeImageFlow.getByName(flow.getFlowName());
                    ImageNode statusNode = null;
                    statusNode = pointMap != null ? imageFlow.queryByName(toStatusNode.getStatusName()) : imageFlow.queryByName(flow.getFlowName() + "#" + toStatusNode.getStatusName());
                    StatusNode actionStatusNode = beforeActionNote.getNextStatusNodeByName(toStatusNode.getStatusName());
                    if (actionStatusNode == null) {
                        throw new BizException("actionStatusName\u4e3a\u7a7a");
                    }
                    if (statusNode == null) {
                        statusNode = this.createStatusNode(flow, pointMap, actionStatusNode, imageFlow.getStatusColor());
                        imageFlow.getNodes().add(statusNode);
                    }
                    edge = this.createEdge(beforeNode, statusNode, toStatusNode.getForName(), beforeActionNote.getNextForProperty());
                    imageFlow.getEdges().add(edge);
                    if (statusNode.getIfInit().booleanValue()) continue;
                    this.parseNextAction(pointMap, statusNode, actionStatusNode, margeImageFlow, flow);
                    statusNode.setIfInit(true);
                }
            }
            if (CollectionUtils.isNotEmpty(beforeActionNote.getForActionNoteList())) {
                for (ForActionNode forActionNode : beforeActionNote.getForActionNoteList()) {
                    ActionNode nextActionNote = beforeActionNote.getNextActionByName(forActionNode.getActionName());
                    if (nextActionNote == null) {
                        nextActionNote = beforeActionNote.getNextActionByName(forActionNode.getFlowAction());
                    } else if (nextActionNote == null) {
                        this.logger.error("\u6d41\u7a0b{}\uff0c\u524d\u7f6e\u8282\u70b9{}\uff0c\u540e\u7f6e\u8282\u70b9{},\u67e5\u8be2\u4e0d\u5230\u4e0b\u4e00\u4e2a\u8282\u70b9", new Object[]{flow.getFlowNode().getName(), beforeActionNote.getName(), forActionNode.getForName()});
                        throw new FlowException("\u521b\u5efa\u4efb\u52a1\u8282\u70b9\u5931\u8d25");
                    }
                    ImageFlow imageFlow = margeImageFlow.getByName(flow.getFlowName());
                    ImageNode imageNode = imageFlow.queryByName(forActionNode.getActionName());
                    if (imageNode == null) {
                        try {
                            imageNode = this.createTaskNode(flow, pointMap, nextActionNote, false, imageFlow.getActionColor());
                            imageFlow.getNodes().add(imageNode);
                        }
                        catch (Exception e) {
                            this.logger.error("\u6d41\u7a0b{}\uff0c\u524d\u7f6e\u8282\u70b9{}\uff0c\u540e\u7f6e\u8282\u70b9{},{}", new Object[]{flow.getFlowNode().getName(), beforeActionNote.getName(), forActionNode.getForName(), e});
                            throw new FlowException("\u521b\u5efa\u4efb\u52a1\u8282\u70b9\u5931\u8d25");
                        }
                    }
                    edge = this.createEdge(beforeNode, imageNode, forActionNode.getForName(), beforeActionNote.getNextForProperty());
                    imageFlow.getEdges().add(edge);
                    try {
                        if (imageNode.getIfInit().booleanValue()) continue;
                        this.parseNextAction(pointMap, imageNode, nextActionNote, margeImageFlow, flow);
                        imageNode.setIfInit(true);
                    }
                    catch (Exception e) {
                        this.logger.error("\u6d41\u7a0b{}\uff0c\u524d\u7f6e\u8282\u70b9{}\uff0c\u540e\u7f6e\u8282\u70b9{},{}", new Object[]{flow.getFlowNode().getName(), beforeActionNote.getName(), forActionNode.getName(), e});
                        this.logger.error("\u521b\u5efa\u5931\u8d25", (Throwable)e);
                        throw new FlowException("\u521b\u5efa\u4efb\u52a1\u4e0b\u4e00\u4e2a\u8282\u70b9\u5931\u8d25");
                    }
                }
            }
        }
    }

    public Edge createEdge(ImageNode sourceNode, ImageNode targetNode, String forName, String forType) {
        if (sourceNode.getId().equals(targetNode.getId())) {
            System.out.println("\u76f8\u540c");
        }
        Edge edge = new Edge();
        edge.setSourceAnchor(0);
        edge.setTargetAnchor(1);
        edge.setCode(forName);
        if (StringUtils.isNotEmpty((CharSequence)forType)) {
            edge.setLabel(forType + "=" + forName);
        } else {
            edge.setLabel(forName);
        }
        edge.setType("flow-polyline-round");
        StartPoint startPoint = new StartPoint();
        if (sourceNode.getY() != null && sourceNode.getX() != null) {
            startPoint.setX(sourceNode.getX() + 0.25);
            startPoint.setY(sourceNode.getY());
        }
        startPoint.setIndex(0);
        edge.setSource(sourceNode.getId());
        edge.setTarget(targetNode.getId());
        edge.setId(edge.getSource() + "_to_" + edge.getTarget());
        edge.setStartPoint(startPoint);
        EndPoint endPoint = new EndPoint();
        if (targetNode.getY() != null && targetNode.getX() != null) {
            endPoint.setX(targetNode.getX() - 40.5);
            endPoint.setY(targetNode.getY());
        }
        endPoint.setIndex(1);
        edge.setEndPoint(endPoint);
        edge.setClazz("flow");
        sourceNode.addIndex();
        return edge;
    }

    public ImageNode createStatusNode(IFlow flow, Map<String, StartPoint> pointMap, StatusNode statusNode, String color) {
        String flowName = flow.getFlowName();
        FlowStatusAdapter flowStatusAdapter = flow.getFlowStatusAdapter();
        ImageNode imageNode = new ImageNode();
        imageNode.setGroupName(flowStatusAdapter.getGroupName());
        imageNode.setGroup(flowStatusAdapter.getGroup());
        imageNode.setId("status" + String.valueOf(IdGenrator.nextId((long)1L, (long)2L)));
        imageNode.setType("ellipse-node");
        imageNode.setClazz("status");
        imageNode.setColor(color);
        imageNode.setCode(statusNode.getCode());
        imageNode.setLabel(statusNode.getName());
        imageNode.getSize().add(80);
        imageNode.getSize().add(44);
        if (pointMap != null) {
            StartPoint startPoint = pointMap.get(flowName + "#" + statusNode.getName());
            if (startPoint != null) {
                imageNode.setX(pointMap.get(flowName + "#" + statusNode.getName()).getX());
                imageNode.setY(pointMap.get(flowName + "#" + statusNode.getName()).getY());
            }
        } else {
            imageNode.setLabel(flowName + "#" + statusNode.getName());
        }
        imageNode.getAnchorPoints().add(this.createAnchorPoint(1.0, 0.5));
        imageNode.getAnchorPoints().add(this.createAnchorPoint(0.0, 0.5));
        imageNode.getAnchorPoints().add(this.createAnchorPoint(0.5, 0.0));
        imageNode.getAnchorPoints().add(this.createAnchorPoint(0.5, 1.0));
        ArrayList<StatusTypeList> statusTypeList = new ArrayList<StatusTypeList>();
        StatusTypeList statusType = new StatusTypeList();
        statusType.setCode(statusNode.getStatusType());
        statusType.setColor(color);
        statusType.setLabel(statusNode.getStatusType());
        imageNode.setStatusType(statusNode.getStatusType());
        statusTypeList.add(statusType);
        imageNode.setStatusTypeList(statusTypeList);
        for (ActionNode actionNode : statusNode.getNextActionNoteList()) {
            EdgesOutLine edgesOutLine = new EdgesOutLine();
            edgesOutLine.setLabel(actionNode.getName());
            edgesOutLine.setCode(actionNode.getName());
            edgesOutLine.setNoteName(actionNode.getName());
            imageNode.getEdgesOutLine().add(edgesOutLine);
        }
        return imageNode;
    }

    public ImageNode createTaskNode(IFlow flow, Map<String, StartPoint> pointMap, ActionNode actionNote, Boolean isStart, String actionColor) {
        EdgesOutLine edgesOutLine;
        String flowName = flow.getFlowName();
        FlowStatusAdapter flowStatusAdapter = flow.getFlowStatusAdapter();
        ImageNode imageNode = new ImageNode();
        if (isStart.booleanValue()) {
            imageNode.setId("start" + String.valueOf(IdGenrator.nextId((long)1L, (long)2L)));
            imageNode.setType("start-node");
            imageNode.setCode("START");
            imageNode.getSize().add(44);
            imageNode.setGroupName(flowStatusAdapter.getGroupName());
            imageNode.setGroup(flowStatusAdapter.getGroup());
            imageNode.getSize().add(44);
            imageNode.setX(200.0);
            imageNode.setY(200.0);
            ArrayList<Double> anchorPoints = new ArrayList<Double>();
            anchorPoints.add(1.0);
            anchorPoints.add(0.5);
            imageNode.setLabel(actionNote.getName());
            if (pointMap != null && pointMap.get(flowName + "#" + actionNote.getName()) != null) {
                imageNode.setX(pointMap.get(flowName + "#" + actionNote.getName()).getX());
                imageNode.setY(pointMap.get(flowName + "#" + actionNote.getName()).getY());
            } else {
                imageNode.setLabel(flowName + "#" + actionNote.getName());
            }
            imageNode.getAnchorPoints().add(anchorPoints);
        } else {
            imageNode.setId("task" + String.valueOf(IdGenrator.nextId((long)1L, (long)2L)));
            imageNode.setColor(actionColor);
            imageNode.setType("task-node");
            imageNode.setClazz("task");
            if (actionNote != null) {
                if (actionNote instanceof FlowActionNode) {
                    FlowActionNode flowActionNode = (FlowActionNode)actionNote;
                    imageNode.setCode(flowActionNode.getActionCode());
                    IFlow subFlow = this.flowEngine.getFlow(flowActionNode.getFlowName());
                    String groupName = subFlow.getFlowStatusAdapter().getGroupName();
                    imageNode.setLabel(groupName + ":" + flowActionNode.getFlowActionName());
                    if (pointMap != null) {
                        imageNode.setX(pointMap.get(flowName + "#" + imageNode.getLabel()).getX());
                        imageNode.setY(pointMap.get(flowName + "#" + imageNode.getLabel()).getY());
                    } else {
                        imageNode.setLabel(flowName + "#" + imageNode.getLabel());
                    }
                } else {
                    imageNode.setCode(actionNote.getBeanMethod());
                    imageNode.setLabel(actionNote.getName());
                    if (pointMap != null) {
                        imageNode.setX(pointMap.get(flowName + "#" + actionNote.getName()).getX());
                        imageNode.setY(pointMap.get(flowName + "#" + actionNote.getName()).getY());
                    } else {
                        imageNode.setLabel(flowName + "#" + actionNote.getName());
                    }
                }
            } else {
                throw new BizException("actionNote\u4e0d\u80fd\u4e3a\u7a7a");
            }
            imageNode.getSize().add(80);
            imageNode.getSize().add(44);
            imageNode.setGroupName(flowStatusAdapter.getGroupName());
            imageNode.setGroup(flowStatusAdapter.getGroup());
            imageNode.setMax(1);
            imageNode.getAnchorPoints().add(this.createAnchorPoint(1.0, 0.5));
            imageNode.getAnchorPoints().add(this.createAnchorPoint(0.0, 0.5));
            imageNode.getAnchorPoints().add(this.createAnchorPoint(0.5, 0.0));
            imageNode.getAnchorPoints().add(this.createAnchorPoint(0.5, 1.0));
        }
        for (ToStatusNode toStatusNode : actionNote.getNextStatusList()) {
            edgesOutLine = new EdgesOutLine();
            if (StringUtils.isNotEmpty((CharSequence)actionNote.getNextForProperty())) {
                edgesOutLine.setLabel(actionNote.getNextForProperty() + "=" + toStatusNode.getForName());
                edgesOutLine.setNoteName(toStatusNode.getStatusName());
            } else {
                edgesOutLine.setLabel(toStatusNode.getForName());
                edgesOutLine.setNoteName(toStatusNode.getStatusName());
            }
            edgesOutLine.setCode(toStatusNode.getForName());
            imageNode.getEdgesOutLine().add(edgesOutLine);
        }
        for (ForActionNode forActionNode : actionNote.getForActionNoteList()) {
            String groupName;
            IFlow subFlow;
            edgesOutLine = new EdgesOutLine();
            if (StringUtils.isNotEmpty((CharSequence)actionNote.getNextForProperty())) {
                edgesOutLine.setLabel(actionNote.getNextForProperty() + "=" + forActionNode.getForName());
                if (StringUtils.isNotEmpty((CharSequence)forActionNode.getFlowName())) {
                    subFlow = this.flowEngine.getFlow(forActionNode.getFlowName());
                    groupName = subFlow.getFlowStatusAdapter().getGroupName();
                    edgesOutLine.setNoteName(groupName + ":" + forActionNode.getFlowAction());
                } else {
                    edgesOutLine.setNoteName(forActionNode.getActionName());
                }
            } else {
                edgesOutLine.setLabel(forActionNode.getForName());
                if (StringUtils.isNotEmpty((CharSequence)forActionNode.getFlowName())) {
                    subFlow = this.flowEngine.getFlow(forActionNode.getFlowName());
                    groupName = subFlow.getFlowStatusAdapter().getGroupName();
                    edgesOutLine.setNoteName(groupName + ":" + forActionNode.getFlowAction());
                } else {
                    edgesOutLine.setNoteName(forActionNode.getActionName());
                }
            }
            edgesOutLine.setCode(forActionNode.getForName());
            imageNode.getEdgesOutLine().add(edgesOutLine);
        }
        return imageNode;
    }

    List<Double> createAnchorPoint(Double x, Double y) {
        ArrayList<Double> anchorPoints = new ArrayList<Double>();
        anchorPoints.add(x);
        anchorPoints.add(y);
        return anchorPoints;
    }
}

