/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.layout;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.FileUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.layout.LayoutJs;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.ImageFlow;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.ImageNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.StartPoint;
import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyLayoutParse {
    private static Logger logger = LoggerFactory.getLogger(MyLayoutParse.class);
    private static String tempPath = System.getProperty("java.io.tmpdir") + File.separator;
    private static String html = "<!DOCTYPE html>\n<html lang=\"en\">\n\n<head>\n    <meta charset=\"UTF-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <title>D3\u7ed8\u5236\u6d41\u7a0b\u56fe</title>\n    <style>\n        .tooltip {\n            position: absolute;\n            font-size: 12px;\n            text-align: center;\n            background-color: white;\n            border-radius: 3px;\n            box-shadow: rgb(174, 174, 174) 0px 0px 10px;\n            cursor: pointer;\n            display: inline-block;\n            padding:10px;\n        }\n\n        .tooltip>div {\n            padding: 10px;\n        }\n    </style>\n    <svg width=\"960\" height=\"600\"></svg>\n    <script src=\"d3.v5.min.js\"></script>\n    <script src=\"dagre-d3.min.js\"></script>\n    <script>\n        let replaceStr\n        // \u521b\u5efa graph \u5bf9\u8c61\n        let g = new dagreD3.graphlib.Graph();\n        g.setGraph({\n            rankdir: 'LR',\n            align: 'DL',\n            nodesep: 100,\n            edgesep: 100,\n            ranksep: 150,\n            marginx: 100,\n            marginy: 200,\n        });\n        dataset.nodes.forEach(item => {\n            g.setNode(item.id, {\n            //\u8282\u70b9\u6807\u7b7e\n            label: item.label,\n            //\u8282\u70b9\u5f62\u72b6\n            shape: item.shape,\n            //\u8282\u70b9\u6837\u5f0f\n            style: \"fill:#faf;stroke:#faf\",\n            //\u8282\u70b9\u6807\u7b7e\u6837\u5f0f\n            labelStyle: \"fill:#afa\"\n        })\n        })\n        dataset.edges.forEach(item => {\n            g.setEdge(item.source, item.target, {\n            //\u8fb9\u6807\u7b7e\n            label: item.label,\n            //\u8fb9\u6837\u5f0f\n            style: \"fill:#fff;stroke:#afa;stroke-width:2px\",\n            labelStyle: \"fill:#1890ff\",\n            arrowhead: \"vee\",\n            arrowheadStyle: \"fill:#f66\"\n        })\n        })\n        // \u521b\u5efa\u6e32\u67d3\u5668\n        let render = new dagreD3.render();\n\n        // \u9009\u62e9 svg \u5e76\u6dfb\u52a0\u4e00\u4e2ag\u5143\u7d20\u4f5c\u4e3a\u7ed8\u56fe\u5bb9\u5668.\n        let svg = d3.select('svg')\n        let svgGroup = svg.append('g');\n\n        // \u5728\u7ed8\u56fe\u5bb9\u5668\u4e0a\u8fd0\u884c\u6e32\u67d3\u5668\u751f\u6210\u6d41\u7a0b\u56fe.\n        render(svgGroup, g);\n\n        // \u5efa\u7acb\u62d6\u62fd\u7f29\u653e\n        let zoom = d3.zoom()\n            .on(\"zoom\", function () {\n                svgGroup.attr(\"transform\", d3.event.transform);\n            });\n        svg.call(zoom);\n\n        var styleTooltip = function (name) {\n            return \"<p class='name'>\" + name + \"</p>\";\n        };\n\n        //\u521b\u5efa\u63d0\u793a\u6846\n        function createTooltip() {\n            return d3.select('body')\n                .append('div')\n                .classed('tooltip', true)\n                .style('opacity', 0)\n                .style('display', 'none');\n        };\n        let tooltip = createTooltip();\n        //tooltip\u663e\u793a\n        function tipVisible(textContent) {\n            tooltip.transition()\n                .duration(400)\n                .style('opacity', 0.9)\n                .style('display', 'block');\n            tooltip.html(textContent)\n                .style('left', (d3.event.pageX + 15) + 'px')\n                .style('top', (d3.event.pageY + 15) + 'px');\n        }\n        //tooltip\u9690\u85cf\n        function tipHidden() {\n            tooltip.transition()\n                .duration(400)\n                .style('opacity', 0)\n                .style('display', 'none');\n        }\n\n        //\u9f20\u6807\u60ac\u505c\u663e\u793a\u9690\u85cftooltip\n        svgGroup.selectAll(\"g.node\")\n            .on(\"mouseover\", function (v) {\n                tipVisible(g.node(v).label);\n            })\n            .on(\"mouseout\", function (v) {\n                tipHidden();\n            })\n\n        // Center the graph\n        var xCenterOffset = (svg.attr('width') - g.graph().width) / 2;\n        svgGroup.attr('transform', 'translate(' + xCenterOffset + ', 20)');\n        svg.attr('height', g.graph().height + 40);\n    </script>\n</head>\n\n<body>\n\n</body>\n\n</html>";
    static final String json = "{\n            nodes: [{\n                    id: 0,\n                    label: \"\u6d41\u52a8\u4eba\u5458\",\n                    shape: \"rect\"\n                },\n                {\n                    id: 1,\n                    label: \"\u5b89\u5168\u7b5b\u67e5\",\n                    shape: \"rect\"\n                },\n                {\n                    id: 2,\n                    label: \"\u70ed\u50cf\u4eea\u4eba\u4f53\u6d4b\u6e29\u7b5b\u67e5\",\n                    shape: \"diamond\"\n                },\n                {\n                    id: 3,\n                    label: \"\u4eba\u5de5\u590d\u6d4b\",\n                    shape: \"diamond\"\n                },\n                {\n                    id: 4,\n                    label: \"\u5feb\u901f\u901a\u8fc7\",\n                    shape: \"rect\"\n                },\n                {\n                    id: 5,\n                    label: \"\u7d27\u6025\u5904\u7406\",\n                    shape: \"rect\"\n                }\n            ],\n            edges: [{\n                    source: 0,\n                    target: 1,\n                    label: \"\"\n                },\n                {\n                    source: 1,\n                    target: 2,\n                    label: \"\"\n                },\n                {\n                    source: 2,\n                    target: 4,\n                    label: \"\u6b63\u5e38\"\n                },\n                {\n                    source: 2,\n                    target: 3,\n                    label: \"\u4e0d\u6b63\u5e38\"\n                },\n                {\n                    source: 3,\n                    target: 5,\n                    label: \"\u4e0d\u6b63\u5e38\"\n                },\n                {\n                    source: 3,\n                    target: 4,\n                    label: \"\u6b63\u5e38\"\n                }\n            ]\n        }";

    public static String loadXml(String jsonStr) {
        String read = html;
        String datasetFlag = read.replace("replaceStr", "dataset=" + jsonStr);
        String savePath = tempPath + "myflow1.html";
        FileUtil.write((String)savePath, (String)datasetFlag);
        return savePath;
    }

    public static Map<String, StartPoint> getPointMap(ImageFlow imageFlow) {
        for (ImageNode imageNode : imageFlow.getNodes()) {
            imageNode.setShape("rect");
        }
        return MyLayoutParse.getPointMap(JSON.toJSONString((Object)imageFlow));
    }

    public static Map<String, StartPoint> getPointMap(String json) {
        HashedMap map = new HashedMap();
        String path = MyLayoutParse.loadXml(json);
        FileUtil.write((String)(tempPath + "d3.v5.min.js"), (String)LayoutJs.getD3());
        FileUtil.write((String)(tempPath + "dagre-d3.min.js"), (String)LayoutJs.getDa());
        WebClient webClient = new WebClient(BrowserVersion.CHROME);
        try {
            webClient.getOptions().setCssEnabled(true);
            webClient.getOptions().setJavaScriptEnabled(true);
            webClient.getOptions().setThrowExceptionOnScriptError(false);
            webClient.setAjaxController((AjaxController)new NicelyResynchronizingAjaxController());
            HtmlPage page = (HtmlPage)webClient.getPage(new File(path).toURI().toString());
            webClient.waitForBackgroundJavaScript(10000L);
            String pageAsText = page.asXml();
            FileUtil.write((String)(tempPath + "result.html"), (String)pageAsText);
            DomNodeList list = page.getElementsByTagName("g");
            for (DomElement domElement : list) {
                if (!domElement.getAttribute("class").equals("node")) continue;
                StartPoint startPoint = new StartPoint();
                String transform = domElement.getAttribute("transform");
                if (StringUtils.isNotEmpty((CharSequence)transform)) {
                    int start = transform.lastIndexOf("(");
                    int end = transform.lastIndexOf(")");
                    String substring = transform.substring(start + 1, end);
                    String[] split = substring.split(",");
                    startPoint.setX(Double.valueOf(split[0]));
                    startPoint.setY(Double.valueOf(split[1]));
                    System.out.println(substring);
                }
                String tspan = MyLayoutParse.getByChildrenTagText(domElement, "tspan");
                map.put(tspan, startPoint);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static String getByChildrenTagText(DomElement domElement, String tag) {
        Iterable childElements = domElement.getChildElements();
        for (DomElement next : childElements) {
            if (next.getNodeName().equals(tag)) {
                return next.getTextContent();
            }
            String byChildrenTagText = MyLayoutParse.getByChildrenTagText(next, tag);
            if (byChildrenTagText == null) continue;
            return byChildrenTagText;
        }
        return null;
    }

    public static void main(String[] args) {
        Map<String, StartPoint> pointMap = MyLayoutParse.getPointMap(json);
    }
}

