/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.parse;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.flow.api.IFlowApi;
import com.dtyunxi.yundt.cube.center.flow.api.dto.request.FlwSolutionCreateReqDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.request.FlwSolutionModifyReqDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.request.FlwSolutionQueryReqDto;
import com.dtyunxi.yundt.cube.center.flow.api.dto.response.FlwSolutionRespDto;
import com.dtyunxi.yundt.cube.center.flow.api.query.IFlowQueryApi;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlow;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowEngine;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.SingleFlowImageParse;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.ImageFlow;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="createImageFlowForMpc")
public class CreateImageFlowForMpc {
    private static Logger logger = LoggerFactory.getLogger(CreateImageFlowForMpc.class);
    @Autowired
    private IFlowApi flowApi;
    @Autowired
    private IFlowQueryApi flowQueryApi;

    private List<SingleFlowImageParse> buildImageParse(IFlowEngine iFlowEngine) {
        ArrayList<SingleFlowImageParse> singleFlowImageParses = new ArrayList<SingleFlowImageParse>();
        List<IFlow> flows = iFlowEngine.getFlows();
        for (IFlow flow : flows) {
            SingleFlowImageParse singleFlowImageParse = new SingleFlowImageParse(flow, 0L, flow.getFlowName(), iFlowEngine);
            singleFlowImageParses.add(singleFlowImageParse);
        }
        return singleFlowImageParses;
    }

    public void buildAndUpload(IFlowEngine iFlowEngine) {
        List<SingleFlowImageParse> singleFlowImageParses = this.buildImageParse(iFlowEngine);
        List<ImageFlow> imageFlows = this.createFlowImage(singleFlowImageParses);
        this.uploadToMpc(imageFlows);
    }

    private void uploadToMpc(List<ImageFlow> imageFlows) {
        logger.info("\u6d41\u7a0b\u5546\u57ce\u6d41\u7a0b\u4e2d");
        for (ImageFlow imageFlow : imageFlows) {
            RestResponse pageInfoRestResponse;
            PageInfo pageInfoRestResponseData;
            FlwSolutionQueryReqDto flwSolutionQueryReqDto = new FlwSolutionQueryReqDto();
            flwSolutionQueryReqDto.setName(imageFlow.getFlowName());
            if (imageFlow.getFlowName().equals("PAY")) {
                System.out.println("\u652f\u4ed8\u5355");
            }
            if ((pageInfoRestResponseData = (PageInfo)(pageInfoRestResponse = this.flowQueryApi.queryFlwSolutionByPage(flwSolutionQueryReqDto, Integer.valueOf(1), Integer.valueOf(1000))).getData()) == null || CollectionUtils.isEmpty((Collection)pageInfoRestResponseData.getList())) {
                FlwSolutionCreateReqDto flwSolutionCreateReqDto = new FlwSolutionCreateReqDto();
                flwSolutionCreateReqDto.setStyle(JSON.toJSONString((Object)imageFlow));
                flwSolutionCreateReqDto.setName(imageFlow.getFlowName());
                flwSolutionCreateReqDto.setDocType(imageFlow.getDocType());
                RestResponse restResponse = this.flowApi.createFlwSolution(flwSolutionCreateReqDto);
                if (!"0".equals(restResponse.getResultCode())) {
                    throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
                }
                logger.info("\u521b\u5efa\u5e76\u4e0a\u4f20\u6d41\u7a0b\u4fe1\u606f{}", (Object)imageFlow.getFlowName());
                continue;
            }
            boolean isUpdate = false;
            for (FlwSolutionRespDto flwSolutionRespDto : pageInfoRestResponseData.getList()) {
                if (!flwSolutionRespDto.getName().equals(imageFlow.getFlowName())) continue;
                FlwSolutionModifyReqDto flwSolutionModifyReqDto = new FlwSolutionModifyReqDto();
                flwSolutionModifyReqDto.setId(flwSolutionRespDto.getId());
                flwSolutionModifyReqDto.setName(imageFlow.getFlowName());
                flwSolutionModifyReqDto.setDocType(imageFlow.getDocType());
                flwSolutionModifyReqDto.setFlwNodeLinkDtos(new ArrayList());
                flwSolutionModifyReqDto.setConvertNodeMaps(new ArrayList());
                flwSolutionModifyReqDto.setStyle(JSON.toJSONString((Object)imageFlow));
                RestResponse restResponse = this.flowApi.modifyFlwSolution(flwSolutionModifyReqDto);
                logger.info("\u4fee\u6539\u5e76\u4e0a\u4f20\u6d41\u7a0b\u4fe1\u606f{}", (Object)imageFlow.getFlowName());
                if (!"0".equals(restResponse.getResultCode())) {
                    throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
                }
                isUpdate = true;
            }
            if (isUpdate) continue;
            FlwSolutionRespDto flwSolutionRespDto = (FlwSolutionRespDto)pageInfoRestResponseData.getList().get(0);
            FlwSolutionModifyReqDto flwSolutionModifyReqDto = new FlwSolutionModifyReqDto();
            flwSolutionModifyReqDto.setId(flwSolutionRespDto.getId());
            flwSolutionModifyReqDto.setName(imageFlow.getFlowName());
            flwSolutionModifyReqDto.setDocType(imageFlow.getDocType());
            flwSolutionModifyReqDto.setFlwNodeLinkDtos(new ArrayList());
            flwSolutionModifyReqDto.setConvertNodeMaps(new ArrayList());
            flwSolutionModifyReqDto.setStyle(JSON.toJSONString((Object)imageFlow));
            RestResponse restResponse = this.flowApi.modifyFlwSolution(flwSolutionModifyReqDto);
            if (!"0".equals(restResponse.getResultCode())) {
                throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
            }
            logger.info("\u4fee\u6539\u5e76\u4e0a\u4f20\u6d41\u7a0b\u4fe1\u606f{}", (Object)imageFlow.getFlowName());
        }
    }

    public List<ImageFlow> createFlowImage(List<SingleFlowImageParse> singleFlowImageParses) {
        ArrayList<ImageFlow> imageFlows = new ArrayList<ImageFlow>();
        for (SingleFlowImageParse singleFlowImageParse : singleFlowImageParses) {
            singleFlowImageParse.parsePoint();
            IFlow flow = singleFlowImageParse.getFlow();
            String flowName = flow.getFlowName();
            String docType = singleFlowImageParse.getFlow().getFlowStatusAdapter().getEntityClass().getName();
            String groupName = singleFlowImageParse.getFlow().getFlowStatusAdapter().getGroupName();
            String flowStatusAdapter = singleFlowImageParse.getFlow().getFlowNode().getFlowStatusAdapter();
            ImageFlow imageFlow = singleFlowImageParse.getImageFlow();
            imageFlow.setFlowName(flowName);
            imageFlow.setEntityName(groupName);
            imageFlow.setFlowStatusAdapter(flowStatusAdapter);
            imageFlow.setFlowDefId(Long.parseLong(singleFlowImageParse.getFlow().getFlowNode().getFlowId()));
            imageFlow.setDocType(docType);
            imageFlows.add(imageFlow);
        }
        return imageFlows;
    }
}

