/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.FlowListener;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.FlowStatusAdapter;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.FlowStatusEntity;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlow;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowEngine;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowLockService;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.StatusFlowInstanceInfo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.Task;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.exception.FlowException;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.impl.AbstractBaseActionImpl;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.impl.FlowInstance;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.mq.vo.ExeCommandVo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.ActionNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowActionNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.StatusNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.utils.TradeUtil;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractBaseFlowImpl
extends AbstractBaseActionImpl
implements IFlow {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBaseFlowImpl.class);
    Map<String, ActionNode> actionNodeMap = new HashMap<String, ActionNode>();
    Map<String, ActionNode> driveMethodNodeMap = new HashMap<String, ActionNode>();
    @Autowired
    protected ITradeService tradeService;
    @Resource
    protected ICacheService cacheService;
    protected IFlowEngine flowFactory;
    private ActionNode startActionNote;
    protected FlowNode flowNode;
    protected FlowStatusAdapter flowStatusAdapter;
    protected List<FlowListener> flowListeners;
    protected IFlowLockService flowLockService;
    protected boolean ifClear = false;

    @Override
    public void clear() {
        if (this.ifClear) {
            return;
        }
        this.ifClear = true;
        this.flowNode.clear();
        this.flowNode = null;
        this.startActionNote = null;
        if (!CollectionUtils.isEmpty(this.flowListeners)) {
            this.flowListeners.clear();
        }
        this.flowListeners = null;
        this.actionNodeMap.clear();
    }

    @Override
    public FlowStatusAdapter getFlowStatusAdapter() {
        return this.flowStatusAdapter;
    }

    public void setFlowStatusAdapter(FlowStatusAdapter flowStatusAdapter) {
        this.flowStatusAdapter = flowStatusAdapter;
    }

    @Override
    public void setFlowNode(FlowNode flowNode) {
        this.flowNode = flowNode;
    }

    @Override
    public void drive(FlowInstance flowInstance, ActionNode driveNode) {
        flowInstance.setActionNode(driveNode);
        this.execAction(flowInstance, driveNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drive(String flowNo, String actionName, FlowInstance flowInstance) {
        Mutex mutex = this.flowLockService.lock(flowNo);
        try {
            FlowStatusEntity flowStatusEntity = this.flowStatusAdapter.getFlowStatusEntity(this.getFlowName(), flowNo);
            flowInstance.setFlowNo(flowNo);
            flowInstance.setEntityField(this.flowStatusAdapter.getEntityField());
            flowInstance.setEntityEo(flowStatusEntity.getEntity());
            ActionNode nextActionNote = this.flowNode.getActionNode(actionName);
            flowStatusEntity.validStatus(this.getFlowName(), nextActionNote);
            this.drive(flowInstance, nextActionNote);
        }
        finally {
            this.flowLockService.unlock(mutex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drive(String flowNo, FlowInstance flowInstance) {
        Mutex mutex = this.flowLockService.lock(flowNo);
        try {
            FlowStatusEntity flowStatusEntity = this.flowStatusAdapter.getFlowStatusEntity(this.getFlowName(), flowNo);
            flowInstance.setEntityEo(flowStatusEntity.getEntity());
            flowInstance.setEntityField(this.flowStatusAdapter.getEntityField());
            flowInstance.setFlow(this);
            String exeBeanMethod = flowInstance.getExeBeanMethod();
            ActionNode driveNode = this.driveMethodNodeMap.get(exeBeanMethod);
            if (driveNode == null) {
                throw new BizException("flow[" + this.getFlowName() + "]beanMethod[" + exeBeanMethod + "]\u627e\u4e0d\u5230driveNode,\u8bf7\u68c0\u67e5\u914d\u7f6exml\u914d\u7f6e\u4fe1\u606f");
            }
            flowStatusEntity.validStatus(this.getFlowName(), driveNode);
            this.drive(flowInstance, driveNode);
        }
        finally {
            this.flowLockService.unlock(mutex);
        }
    }

    @Override
    public void rollBack(FlowInstance flowInstance, String rollBackStatus, FlowInstance context) {
    }

    @Override
    public void exeCommand(String flowNo, ExeCommandVo exeCommandVo, FlowInstance context) {
    }

    @Override
    public String getFlowName() {
        return this.flowNode.getName();
    }

    @Override
    public String getFlowDefName() {
        return this.flowNode.getFlowDefName();
    }

    @Override
    public String getFlowId() {
        return this.flowNode.getFlowId();
    }

    @Override
    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    @Override
    public FlowInstance createFlow(String parentNo, FlowInstance instance) {
        instance.setFlow(this);
        instance.setEntityEo(null);
        instance.setEntityField(this.flowStatusAdapter.getEntityField());
        instance.setTenantId(instance.getTenantId());
        instance.setInstanceId(instance.getInstanceId());
        return instance;
    }

    @Override
    public void createStart(FlowInstance flowInstance) {
        this.execAction(flowInstance, this.startActionNote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Boolean isInExe, FlowInstance flowInstance) {
        flowInstance.setFlowNo(TradeUtil.generateTradeNo());
        String flowNo = flowInstance.getFlowNo();
        Mutex mutex = this.flowLockService.lock(flowNo);
        try {
            flowInstance.setFlow(this);
            if (!this.startActionNote.getBeanMethod().equals(flowInstance.getExeBeanMethod()) && !isInExe.booleanValue()) {
                throw new FlowException("flow[" + this.getFlowName() + "]\u5f00\u542f\u6d41\u7a0b\u65b9\u6cd5[" + this.startActionNote.getBeanMethod() + "]\u548c\u6267\u884c\u65b9\u6cd5[" + flowInstance.getExeBeanMethod() + "]\u4e0d\u5bf9");
            }
            flowInstance = this.createFlow(flowNo, flowInstance);
            this.createStart(flowInstance);
        }
        finally {
            this.flowLockService.unlock(mutex);
        }
    }

    private void execActionNode(FlowInstance flowInstance, ActionNode actionNode) {
        flowInstance.setFlow(this);
        ActionNode nextActionNote = actionNode;
        boolean isStart = false;
        if (actionNode == this.startActionNote) {
            isStart = true;
        }
        try {
            while (nextActionNote != null) {
                ActionNode beforeNote = nextActionNote;
                flowInstance.setActionNode(nextActionNote);
                nextActionNote = this.execActionTask(nextActionNote, flowInstance);
                boolean isPreSave = false;
                List<StatusNode> statusNodes = beforeNote.getNextStatusActionName(flowInstance.getExeResult());
                if (!CollectionUtils.isEmpty(statusNodes)) {
                    for (StatusNode statusNode : statusNodes) {
                        statusNode.setFieldValue(flowInstance.getEntityEo());
                    }
                    if (this.flowStatusAdapter.isStatusChangeSave()) {
                        isPreSave = true;
                        this.flowStatusAdapter.save(this.getFlowName(), flowInstance.getEntityEo(), isStart);
                    }
                    StatusFlowInstanceInfo statusFlowInstanceInfo = new StatusFlowInstanceInfo();
                    statusFlowInstanceInfo.setEntityEo(flowInstance.getEntityEo());
                    statusFlowInstanceInfo.setFlowName(this.getFlowName());
                    statusFlowInstanceInfo.setStatusNodes(statusNodes);
                    statusFlowInstanceInfo.setFlowNo(flowInstance.getFlowNo());
                    statusFlowInstanceInfo.setFlowContext(flowInstance);
                    this.flowStatusAdapter.statusChangeListen(statusFlowInstanceInfo, flowInstance.getBeforeInput(), flowInstance.getBeforeOutput());
                }
                if (this.flowStatusAdapter.isActionExecSave() && !isPreSave) {
                    isPreSave = true;
                    this.flowStatusAdapter.save(this.getFlowName(), flowInstance.getEntityEo(), isStart);
                }
                if (flowInstance.getStop().booleanValue()) {
                    if (!CollectionUtils.isEmpty(this.flowListeners)) {
                        for (FlowListener flowListener : this.flowListeners) {
                            flowListener.flowBreak(flowInstance);
                        }
                    }
                    if (!isPreSave) {
                        this.flowStatusAdapter.save(this.getFlowName(), flowInstance.getEntityEo(), isStart);
                    }
                } else {
                    if (!(nextActionNote instanceof FlowActionNode)) continue;
                    FlowActionNode flowActionNode = (FlowActionNode)nextActionNote;
                    IFlow flow = this.flowFactory.getFlow(flowActionNode.getFlowName());
                    if (flowActionNode.getFlowNoFieldName() == null) {
                        FlowInstance childFlowInstance = new FlowInstance();
                        BeanUtils.copyProperties((Object)flowInstance, (Object)childFlowInstance);
                        childFlowInstance.setEntityEo(null);
                        flow.start(true, childFlowInstance);
                    } else {
                        FlowInstance childFlowInstance = new FlowInstance();
                        BeanUtils.copyProperties((Object)flowInstance, (Object)childFlowInstance);
                        childFlowInstance.setEntityEo(null);
                        Object flowNo = flowActionNode.getFieldValue(flowInstance.getBeforeOutput());
                        if (flowNo == null) {
                            throw new BizException("FlowNoField=" + flowActionNode.getFlowNoFieldName() + "\u4e0d\u80fd\u4e3a\u7a7a\u503c");
                        }
                        flow.drive(flowNo.toString(), flowActionNode.getFlowActionName(), childFlowInstance);
                    }
                    if (!isPreSave) {
                        this.flowStatusAdapter.save(this.getFlowName(), flowInstance.getEntityEo(), isStart);
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("\u6267\u884cAction\u51fa\u73b0\u5f02\u5e38");
            if (!CollectionUtils.isEmpty(this.flowListeners)) {
                for (FlowListener flowListener : this.flowListeners) {
                    flowListener.flowException(flowInstance, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void execAction(FlowInstance flowInstance, ActionNode actionNode) {
        this.execActionNode(flowInstance, actionNode);
    }

    private ActionNode execActionTask(ActionNode actionNode, FlowInstance flowInstance) {
        Task task = (Task)actionNode.getBaseAction();
        if (task == null) {
            throw new BizException("\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            logger.info("[{}][{}][{}][{}][exec][start]", new Object[]{this.getFlowName(), flowInstance.getFlowNo(), actionNode.getName(), actionNode.getBeanMethod()});
            long startTime = System.currentTimeMillis();
            if (!CollectionUtils.isEmpty(this.flowListeners)) {
                for (FlowListener flowListener : this.flowListeners) {
                    flowListener.flowStatusBeforeChange(flowInstance);
                }
            }
            ActionNode nextAction = task.execute(flowInstance);
            long endTime = System.currentTimeMillis();
            logger.info("[{}][{}][{}][{}][exec][end({})[{}]]", new Object[]{this.getFlowName(), flowInstance.getFlowNo(), actionNode.getName(), actionNode.getBeanMethod(), endTime - startTime, flowInstance.getExeResult()});
            return nextAction;
        }
        catch (Exception e) {
            logger.error("\u6267\u884caction\u51fa\u73fe\u5f02\u5e38\uff0c\u5f02\u5e38\u8282\u70b9[" + this.getFlowName() + "][" + flowInstance.getFlowNo() + "][" + actionNode.getName() + "]");
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void addActionNote(String noteName, ActionNode actionNode) {
        this.actionNodeMap.put(noteName, actionNode);
        if (!(actionNode instanceof StatusNode) && this.driveMethodNodeMap.get(actionNode.getBeanMethod()) != null) {
            throw new BizException("\u4e0d\u5141\u8bb8[flow][" + this.flowNode.getName() + "][beanMethod][" + actionNode.getBeanMethod() + "]\u540c\u4e00\u4e2a\u6d41\u7a0b\u51fa\u73b0\u4e24\u6b21\u5728drive\u8282\u70b9\u5f53\u4e2d");
        }
        this.driveMethodNodeMap.put(actionNode.getBeanMethod(), actionNode);
    }

    @Override
    public ActionNode getActionNote(String actionNoteName) {
        if (StringUtils.isEmpty((Object)actionNoteName)) {
            actionNoteName = "default";
        }
        return this.actionNodeMap.get(actionNoteName);
    }

    @Override
    public ActionNode getStartActionNote() {
        return this.startActionNote;
    }

    @Override
    public void setStartActionNote(ActionNode startActionNote) {
        this.startActionNote = startActionNote;
    }
}

