/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlow;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowEngine;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.Node;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.Assert;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowEngineImpl
implements IFlowEngine {
    private Map<String, IFlow> enableFlowMap = new HashMap<String, IFlow>();
    @Autowired
    protected ITradeService tradeService;
    private Node rootNode;
    private volatile Integer status = IFlowEngine.INIT;

    @Override
    public void addFlow(String name, IFlow flow) {
        if (flow.getFlowNode() == null) {
            throw new BizException("\u6d41\u7a0b\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.enableFlowMap.put(name, flow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean modifyStatus(Integer mstatus) {
        FlowEngineImpl flowEngineImpl = this;
        synchronized (flowEngineImpl) {
            if (mstatus.equals(IFlowEngine.LOADED)) {
                if (this.status.equals(IFlowEngine.LOAD) || this.status.equals(IFlowEngine.RE_LOADED)) {
                    this.status = mstatus;
                    return true;
                }
                return false;
            }
            if (mstatus.equals(IFlowEngine.LOAD)) {
                if (this.status.equals(IFlowEngine.INIT)) {
                    this.status = mstatus;
                    return true;
                }
                return false;
            }
            if (mstatus.equals(IFlowEngine.RE_LOADED)) {
                if (this.status.equals(IFlowEngine.LOADED)) {
                    this.status = mstatus;
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    @Override
    public Integer getStatus() {
        return this.status;
    }

    @Override
    public void setRootNode(Node node) {
        this.rootNode = node;
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    @Override
    public List<IFlow> getFlows() {
        return this.enableFlowMap.values().stream().collect(Collectors.toList());
    }

    @Override
    public void clear() {
        this.enableFlowMap.values().forEach(flow -> flow.clear());
        this.enableFlowMap.clear();
    }

    @Override
    public int flowSize() {
        return this.enableFlowMap.size();
    }

    @Override
    public IFlow getFlow(String name) {
        Assert.notNull((Object)name, "\u6d41\u7a0b\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        IFlow flow = this.enableFlowMap.get(name);
        Assert.notNull((Object)flow, "\u6d41\u7a0b" + name + "\u627e\u4e0d\u5230\u6fc0\u6d3b\u7248\u672c\u5427");
        return flow;
    }
}

