/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.load;

import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.IFlowEngine;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.IReport;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.parse.CreateImageFlowForMpc;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.load.FlowOrgBeanFactory;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.load.ILoadFlow;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowsNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.refresh.FlowRefreshService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=12345)
public class LoadFlowBean
implements CommandLineRunner {
    private Logger logger = LoggerFactory.getLogger(LoadFlowBean.class);
    @Autowired
    private ILoadFlow loadFlow;
    @Autowired
    private CreateImageFlowForMpc createImageFlowForMpc;
    @Autowired
    private IReport report;
    @Resource
    private FlowRefreshService flowRefreshService;
    @Value(value="${yundt.cube.flow.report}")
    private Integer reportFlag = 0;
    @Value(value="${yundt.cube.flow.read}")
    private Integer readFlag = 0;
    public final Integer NEED_REPORT = 1;
    public final Integer NEED_REPORT_FLOW = 2;
    public final Integer READ_FROM_DATA = 1;
    @Resource
    public IFlowEngine flowEngine;

    public void run(String ... args) throws Exception {
        this.flowEngine.modifyStatus(IFlowEngine.LOAD);
        if (FlowOrgBeanFactory.isLoadFlow()) {
            IFlowEngine iFlowEngine;
            if (this.NEED_REPORT.equals(this.reportFlag) || this.NEED_REPORT_FLOW.equals(this.reportFlag)) {
                this.logger.info("\u6b63\u5728\u4e0a\u62a5\u6d41\u7a0b\u7684\u8282\u70b9");
                iFlowEngine = this.loadFlow.fetchFlowEngineFromXml();
                this.report.reportFlowToMpc((FlowsNode)iFlowEngine.getRootNode(), iFlowEngine);
                this.logger.info("\u6b63\u5728\u4e0a\u62a5\u6d41\u7a0b\u7684\u8282\u70b9");
            }
            if (this.NEED_REPORT_FLOW.equals(this.reportFlag)) {
                this.logger.info("\u6b63\u5728\u4e0a\u62a5\u6d41\u7a0b\u7684\u56fe");
                iFlowEngine = this.loadFlow.bindFlowDefFromXml();
                this.createImageFlowForMpc.buildAndUpload(iFlowEngine);
                this.logger.info("\u6b63\u5728\u4e0a\u62a5\u6d41\u7a0b\u7684\u56fe");
            }
            if (this.READ_FROM_DATA.equals(this.readFlag)) {
                this.loadFlow.bindFlowDefFromXml();
                this.logger.info("\u52a0\u8f7d\u8fdb\u7a0b\u6b63\u5728\u4ecempc\u5237\u65b0\u6d41\u7a0b\u65b9\u6848");
                this.flowRefreshService.refresh();
                this.logger.info("\u52a0\u8f7d\u8fdb\u7a0b\u6b63\u5728\u4ecempc\u5237\u65b0\u6d41\u7a0b\u5b8c\u6bd5");
            } else {
                this.logger.info("\u76f4\u63a5\u4ece\u672c\u5730\u52a0\u8f7d\u6d41\u7a0bxml");
                this.loadFlow.load();
                this.logger.info("\u76f4\u63a5\u4ece\u672c\u5730\u52a0\u8f7d\u6d41\u7a0bxml");
            }
            this.flowEngine.modifyStatus(IFlowEngine.LOADED);
        }
    }
}

