/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.base.parse;

import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.FlowSchemeFactory;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.GroupFlowImage;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.image.style.ImageFlow;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.load.FlowOrgBeanFactory;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.FlowsNode;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.node.Node;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.parse.IParseEngine;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.parse.IParseNote;
import java.net.URL;
import java.util.List;
import javax.annotation.Resource;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XmlParseNote
implements IParseNote {
    private String xmlName;
    @Resource
    private IParseEngine parseEngine;
    @Autowired
    private FlowSchemeFactory flowSchemeFactory;

    public XmlParseNote(String xmlName, IParseEngine parseEngine) {
        this.xmlName = xmlName;
        this.parseEngine = parseEngine;
    }

    public XmlParseNote(IParseEngine parseEngine) {
        this.xmlName = FlowOrgBeanFactory.getLoadXml();
        this.parseEngine = parseEngine;
    }

    public XmlParseNote() {
        this.xmlName = FlowOrgBeanFactory.getLoadXml();
    }

    public String getXmlName() {
        return this.xmlName;
    }

    @Override
    public Node pareNote() {
        Document doc = this.loadXml();
        Element root = doc.getRootElement();
        return this.parseEngine.parse(root, null, this.getXmlName());
    }

    @Override
    public Node pareNote(String fileName) {
        return new XmlParseNote(fileName, this.parseEngine).pareNote();
    }

    @Override
    public Node pareNote(List<ImageFlow> imageFlows) {
        for (ImageFlow imageFlow : imageFlows) {
            boolean refresh = this.flowSchemeFactory.refresh(imageFlow);
            if (refresh) continue;
            return null;
        }
        FlowsNode flowsNode = new FlowsNode();
        List<GroupFlowImage> groupImageList = this.flowSchemeFactory.getGroupImageList();
        for (GroupFlowImage groupFlowImage : groupImageList) {
            Document document = groupFlowImage.createXml();
            FlowsNode root = (FlowsNode)this.parseEngine.parse(document.getRootElement(), null, groupFlowImage.getFlowSchemeData().getFlowSchemeId().toString());
            for (FlowNode flowNode : root.getFlowNodes()) {
                flowsNode.addFlow(flowNode.getName(), flowNode);
            }
        }
        return flowsNode;
    }

    public Document loadXml() {
        Document doc = null;
        SAXReader reader = new SAXReader();
        try {
            URL xmlpath = this.getClass().getClassLoader().getResource(this.getXmlName());
            doc = reader.read(xmlpath);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return doc;
    }
}

